/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql;

import coldfusion.sql.Parameter;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class InParameter
extends Parameter {
    public InParameter(Object v, int st, int sc, String stn, String dvname) {
        this.value = v;
        this.sqltype = st;
        this.scale = sc;
        this.sqltype_name = stn;
        this.dbvarname = dvname;
    }

    @Override
    public void setStatement(Statement stmt, int position) throws SQLException {
        boolean useNamedParameter = false;
        PreparedStatement pstmt = (PreparedStatement)stmt;
        Object cstmt = null;
        if (this.value != null) {
            this.getMappingValues();
        }
        if (this.value == null) {
            pstmt.setNull(position, this.sqltype);
        } else if (this.sqltype == 2005 || this.sqltype == 2009) {
            char[] chrs = ((String)this.value).toCharArray();
            CharArrayReader reader = new CharArrayReader(chrs);
            pstmt.setCharacterStream(position, (Reader)reader, chrs.length);
        } else if (this.sqltype == 2011) {
            char[] chrs = ((String)this.value).toCharArray();
            CharArrayReader reader = new CharArrayReader(chrs);
            pstmt.setNCharacterStream(position, reader, chrs.length);
        } else if (this.sqltype == -15 || this.sqltype == -9 || this.sqltype == -16) {
            pstmt.setNString(position, (String)this.value);
        } else if (this.sqltype == 2004) {
            byte[] b = (byte[])this.value;
            pstmt.setBinaryStream(position, (InputStream)new ByteArrayInputStream(b), b.length);
        } else if (this.sqltype == -1234) {
            pstmt.setObject(position, this.value);
        } else if (this.scale == -1) {
            pstmt.setObject(position, this.value, this.sqltype);
        } else {
            pstmt.setObject(position, this.value, this.sqltype, this.scale);
        }
    }

    @Override
    public String getStatement() {
        StringBuffer b = new StringBuffer();
        b.append("[type='IN', ");
        if (this.value != null) {
            b.append("class='");
            b.append(this.value.getClass().getName());
            b.append("', ");
        }
        b.append("value='");
        if (this.value == null) {
            b.append("null");
        } else {
            b.append(this.value.toString());
        }
        b.append("'");
        if (this.sqltype != -1234) {
            b.append(", sqltype='");
            if (this.sqltype_name != null) {
                b.append(this.sqltype_name);
            } else {
                b.append(this.sqltype);
            }
            b.append("'");
        }
        if (this.scale != -1) {
            b.append(", scale='");
            b.append(this.scale);
            b.append("'");
        }
        b.append("]");
        return b.toString();
    }

    public Object getObject() {
        return this.value;
    }

    public int getSqltype() {
        return this.sqltype;
    }

    public String getSqltypeName() {
        return this.sqltype_name;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof InParameter) {
            return super.equals(obj);
        }
        return false;
    }
}

