/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql;

import coldfusion.log.CFLogs;
import coldfusion.server.ServiceRuntimeException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JNDIUtils {
    public static void close(Context ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable t) {
                CFLogs.SERVER_LOG.warn(t);
            }
        }
    }

    public static Context getContext(Hashtable env) {
        InitialContext ctx;
        try {
            ctx = new InitialContext(env);
        }
        catch (NamingException ne) {
            throw new ServiceRuntimeException(ne);
        }
        return ctx;
    }

    public static Object lookup(String name, Context ctx) throws NamingException {
        Object obj = ctx.lookup(name);
        return obj;
    }

    public static DataSource getJNDIDataSource(String dsn, Context ctx) throws NamingException {
        Object o = JNDIUtils.lookup(dsn, ctx);
        if (o != null && o instanceof DataSource) {
            return (DataSource)o;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unbind(String name, String jndi_dir, Hashtable jndienv) {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext(jndienv);
            ctx.unbind(jndi_dir + name);
            ctx.unbind(jndi_dir + "connect_" + name);
        }
        catch (NamingException ne) {
            try {
                CFLogs.SERVER_LOG.warn("Attempt to remove dsn " + name + " failed", ne);
            }
            catch (Throwable throwable) {
                JNDIUtils.close(ctx);
                throw throwable;
            }
            JNDIUtils.close(ctx);
        }
        JNDIUtils.close(ctx);
    }
}

