/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql;

import coldfusion.sql.ConnectionSource;
import coldfusion.sql.imq.jdbcDriver;
import coldfusion.util.RB;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class JdbcImpl
extends ConnectionSource {
    protected String driver;
    protected String url;
    private boolean createDriver = true;

    public void setDriver(String d) {
        this.driver = d;
        this.createDriver = true;
    }

    public void setUrl(String u) {
        this.url = u;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public void validate() throws SQLException {
        if (this.driver == null || this.driver.length() == 0 || this.url == null || this.url.length() == 0) {
            throw new SQLException(RB.getString(this, "JdbcImpl.1"));
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.getProperties());
    }

    @Override
    public Connection getConnection(String u, String p) throws SQLException {
        this.setUsername(u);
        this.setPassword(p);
        return this.getConnection(this.getProperties());
    }

    private Connection getConnection(Properties props) throws SQLException {
        try {
            jdbcDriver jdbcDrv;
            if (this.createDriver) {
                if (!this.driver.equals("coldfusion.sql.imq.jdbcDriver")) {
                    Class.forName(this.driver).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                this.createDriver = false;
            }
            if (jdbcDriver.class.getName().equalsIgnoreCase(this.driver) && (jdbcDrv = new jdbcDriver()).acceptsURL(this.url)) {
                return jdbcDrv.connect(this.url, props);
            }
            Driver drv = DriverManager.getDriver(this.url);
            if (drv != null) {
                return drv.connect(this.url, props);
            }
            throw new SQLException("No suitable driver");
        }
        catch (Exception ex) {
            throw new SQLException(ex.getMessage());
        }
    }

    @Override
    public void clear() {
        this.driver = null;
        this.url = null;
        super.clear();
    }
}

