/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql;

import coldfusion.runtime.Cast;
import coldfusion.runtime.DatabaseException;
import coldfusion.runtime.OleDateTime;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;

public abstract class Parameter
implements Serializable {
    public static final int UNDEFINED_SQLTYPE = -1234;
    public static final int UNDEFINED_SCALE = -1;
    public static final String UNDEFINED_SQLTYPE_NAME = "__UNDEFINED";
    protected Object value = null;
    protected String sqltype_name = "__UNDEFINED";
    protected int sqltype = -1234;
    protected int scale = -1;
    protected String dbvarname = null;
    private boolean valMapped;

    public abstract void setStatement(Statement var1, int var2) throws SQLException;

    public abstract String getStatement();

    public String getDbVarName() {
        return this.dbvarname;
    }

    public void getMappingValues() throws SQLException {
        if (this.value != null) {
            this.value = Parameter.getMappingValue(this.value, this.sqltype);
        }
        this.valMapped = true;
    }

    public static Object getMappingValue(Object value, int sqltype) throws SQLException {
        return Parameter.getMappingValue(value, sqltype, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object getMappingValue(Object value, int sqltype, String sqlTypeName) throws SQLException {
        try {
            Cast.parseDateInThread.set(false);
            switch (sqltype) {
                case -6: {
                    try {
                        value = Cast._cast(value, Integer.class);
                        int val = (Integer)value;
                        if (val > 255) throw new NumericValueOutOfRangeException(value, "CF_SQL_TINYINT");
                        if (val >= 0) return value;
                        throw new NumericValueOutOfRangeException(value, "CF_SQL_TINYINT");
                    }
                    catch (Exception ex) {
                        if (!(ex instanceof NumericValueOutOfRangeException)) throw new DataTypeMismatchException(value, "CF_SQL_TINYINT");
                        throw (NumericValueOutOfRangeException)ex;
                    }
                }
                case 5: {
                    try {
                        value = Cast._cast(value, Integer.class);
                        return value;
                    }
                    catch (Exception ex) {
                        throw new DataTypeMismatchException(value, "CF_SQL_SMALLINT");
                    }
                }
                case 4: {
                    try {
                        value = Cast._cast(value, Integer.class);
                        return value;
                    }
                    catch (Exception ex) {
                        throw new DataTypeMismatchException(value, "CF_SQL_INTEGER");
                    }
                }
                case -5: {
                    try {
                        value = Cast._cast(value, Long.class);
                        return value;
                    }
                    catch (Exception ex) {
                        throw new DataTypeMismatchException(value, "CF_SQL_BIGINT");
                    }
                }
                case 7: {
                    try {
                        value = Cast._cast(value, Float.class);
                        return value;
                    }
                    catch (Exception ex) {
                        throw new DataTypeMismatchException(value, "CF_SQL_REAL");
                    }
                }
                case 6: 
                case 8: {
                    try {
                        value = Cast._cast(value, Double.class);
                        return value;
                    }
                    catch (Exception ex) {
                        if (sqltype == 6) {
                            throw new DataTypeMismatchException(value, "CF_SQL_FLOAT");
                        }
                        if (sqltype != 8) return value;
                        throw new DataTypeMismatchException(value, "CF_SQL_DOUBLE");
                    }
                }
                case 2: 
                case 3: {
                    try {
                        value = Cast._cast(value, BigDecimal.class);
                        return value;
                    }
                    catch (Exception ex) {
                        if (sqltype == 3) {
                            throw new DataTypeMismatchException(value, "CF_SQL_DECIMAL");
                        }
                        if (sqltype != 2) return value;
                        throw new DataTypeMismatchException(value, "CF_SQL_NUMERIC");
                    }
                }
                case -7: {
                    try {
                        value = Cast._cast(value, Boolean.class);
                        return value;
                    }
                    catch (Exception ex) {
                        throw new DataTypeMismatchException(value, "CF_SQL_BIT");
                    }
                }
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    try {
                        value = Cast._cast(value, String.class);
                        return value;
                    }
                    catch (Exception ex) {
                        if (sqltype == 1) {
                            throw new DataTypeMismatchException(value, "CF_SQL_CHAR");
                        }
                        if (sqltype == 12) {
                            throw new DataTypeMismatchException(value, "CF_SQL_VARCHAR");
                        }
                        if (sqltype != -1) return value;
                        throw new DataTypeMismatchException(value, "CF_SQL_LONGVARCHAR");
                    }
                }
                case -4: 
                case -3: 
                case -2: {
                    if (value instanceof Byte[]) {
                        int len = ((Byte[])value).length;
                        byte[] b = new byte[len];
                        int i = 0;
                        while (true) {
                            if (i >= len) {
                                value = b;
                                return value;
                            }
                            b[i] = ((Byte[])value)[i];
                            ++i;
                        }
                    }
                    if (value instanceof byte[]) {
                        return value;
                    }
                    if (value == null) {
                        Object len = value;
                        return len;
                    }
                    if (sqltype == -2) {
                        throw new DataTypeMismatchException(value, "CF_SQL_BINARY");
                    }
                    if (sqltype == -3) {
                        throw new DataTypeMismatchException(value, "CF_SQL_VARBINARY");
                    }
                    if (sqltype != -4) return value;
                    throw new DataTypeMismatchException(value, "CF_SQL_LONGBINARY");
                }
                case 91: {
                    try {
                        if ("DATETIME".equalsIgnoreCase(sqlTypeName)) {
                            value = new OleDateTime(Cast._Date(value));
                            return value;
                        }
                        java.util.Date dateVal = Cast._Date(value);
                        value = dateVal == null ? null : new Date(Cast._Date(value).getTime());
                        return value;
                    }
                    catch (Exception e) {
                        throw new DataTypeMismatchException(value, "CF_SQL_DATE");
                    }
                }
                case 93: {
                    try {
                        java.util.Date dateVal = Cast._Date(value);
                        value = dateVal == null ? null : new Timestamp(Cast._Date(value).getTime());
                        return value;
                    }
                    catch (Exception e) {
                        throw new DataTypeMismatchException(value, "CF_SQL_TIMESTAMP");
                    }
                }
                case 92: {
                    try {
                        java.util.Date dateVal = Cast._Date(value);
                        value = dateVal == null ? null : new Time(Cast._Date(value).getTime());
                        return value;
                    }
                    catch (Exception e) {
                        throw new DataTypeMismatchException(value, "CF_SQL_TIME");
                    }
                }
                case 2003: {
                    return value;
                }
                case 2004: {
                    return value;
                }
                case 2005: {
                    return value;
                }
                case 2002: {
                    return value;
                }
                case 2006: {
                    return value;
                }
                case 2011: {
                    return value;
                }
                case 2009: {
                    return value;
                }
            }
            return value;
        }
        finally {
            Cast.parseDateInThread.set(true);
        }
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof Parameter) {
            Parameter cParam = (Parameter)obj;
            if (!this.valMapped) {
                try {
                    this.getMappingValues();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (!cParam.valMapped) {
                try {
                    cParam.getMappingValues();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (this.sqltype == cParam.sqltype && this.scale == cParam.scale) {
                if (this.value == null && cParam.value == null) {
                    return true;
                }
                if (this.value == null || cParam.value == null) {
                    return false;
                }
                switch (this.sqltype) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2004: {
                        if (this.value instanceof byte[] && cParam.value instanceof byte[]) {
                            result = Arrays.equals((byte[])this.value, (byte[])cParam.value);
                            break;
                        }
                        if (!(this.value instanceof Byte[]) || !(cParam.value instanceof Byte[])) break;
                        result = Arrays.equals((Object[])((Byte[])this.value), (Object[])((Byte[])cParam.value));
                        break;
                    }
                    default: {
                        result = this.value.equals(cParam.value);
                    }
                }
            }
        }
        return result;
    }

    public int hashCode() {
        if (this.value != null) {
            if (this.value instanceof byte[] || this.value instanceof Byte[]) {
                return 0;
            }
            if (this.sqltype != -1234) {
                try {
                    return this.getHashCodeFromSqlType();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return this.value.hashCode();
        }
        return 0;
    }

    private int getHashCodeFromSqlType() {
        switch (this.sqltype) {
            case 6: {
                return this.getFloatHashCode(this.value);
            }
            case 5: {
                return this.getShortHashCode(this.value);
            }
            case -6: {
                return this.getByteHashCode(this.value);
            }
            case 4: {
                if (this.value instanceof String) {
                    return new Integer(this.value.toString()).hashCode();
                }
                if (this.value instanceof Number) {
                    return new Integer(((Number)this.value).intValue()).hashCode();
                }
                return this.value.hashCode();
            }
            case -5: {
                if (this.value instanceof String) {
                    return new Long(this.value.toString()).hashCode();
                }
                if (this.value instanceof Number) {
                    return new Long(((Number)this.value).longValue()).hashCode();
                }
                return this.value.hashCode();
            }
            case 7: {
                return this.getFloatHashCode(this.value);
            }
            case 8: {
                if (this.value instanceof String) {
                    return new Double(this.value.toString()).hashCode();
                }
                if (this.value instanceof Number) {
                    return new Double(((Number)this.value).doubleValue()).hashCode();
                }
                return this.value.hashCode();
            }
            case 3: {
                return this.getBigDecimalHashCode(this.value);
            }
            case 2: {
                return this.getBigDecimalHashCode(this.value);
            }
        }
        return this.value.hashCode();
    }

    private int getBigDecimalHashCode(Object value) {
        if (value instanceof String) {
            return new BigDecimal(value.toString()).hashCode();
        }
        if (value instanceof Number) {
            return new BigDecimal(((Number)value).doubleValue()).hashCode();
        }
        return value.hashCode();
    }

    private int getFloatHashCode(Object value) {
        if (value instanceof String) {
            return new Float(value.toString()).hashCode();
        }
        if (value instanceof Number) {
            return new Float(((Number)value).floatValue()).hashCode();
        }
        return value.hashCode();
    }

    private int getShortHashCode(Object value) {
        if (value instanceof String) {
            return new Short(value.toString()).hashCode();
        }
        if (value instanceof Number) {
            return new Short(((Number)value).shortValue()).hashCode();
        }
        return value.hashCode();
    }

    private int getByteHashCode(Object value) {
        if (value instanceof String) {
            return new Byte(value.toString()).hashCode();
        }
        if (value instanceof Number) {
            return new Byte(((Number)value).byteValue()).hashCode();
        }
        return value.hashCode();
    }

    public static class NumericValueOutOfRangeException
    extends DatabaseException {
        private static final long serialVersionUID = 1L;
        public Object value;
        public Object sql_type;

        NumericValueOutOfRangeException(Object value, String sql_type) {
            this.value = value;
            this.sql_type = sql_type;
        }
    }

    public static class DataTypeMismatchException
    extends DatabaseException {
        private static final long serialVersionUID = 1L;
        public Object value;
        public String sql_type;

        DataTypeMismatchException(Object value, String sql_type) {
            this.value = value;
            this.sql_type = sql_type;
        }
    }
}

