/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql;

import coldfusion.sql.InOutParameter;
import coldfusion.sql.InParameter;
import coldfusion.sql.OutParameter;
import coldfusion.sql.Parameter;
import coldfusion.sql.QueryTable;
import coldfusion.util.RB;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;

public class ParameterList
implements Cloneable,
Serializable {
    protected ArrayList params = new ArrayList();

    private void resize(int newsize) {
        int size;
        for (int i = size = this.params.size(); i < newsize; ++i) {
            this.params.add(null);
        }
    }

    public void setInParam(Object value, int sqltype, int scale, String sqltype_name, String dbvarname) {
        this.params.add(new InParameter(value, sqltype, scale, sqltype_name, dbvarname));
    }

    public void setInParam(int pos, Object value, int sqltype, int scale, String sqltype_name, String dbvarname) {
        this.resize(pos);
        this.params.set(pos - 1, new InParameter(value, sqltype, scale, sqltype_name, dbvarname));
    }

    public void setInOutParam(Object value, int sqltype, int scale, String sqltype_name, String dbvarname) {
        this.params.add(new InOutParameter(value, sqltype, scale, sqltype_name, dbvarname));
    }

    public void setInOutParam(int pos, Object value, int sqltype, int scale, String sqltype_name, String dbvarname) {
        this.resize(pos);
        this.params.set(pos - 1, new InOutParameter(value, sqltype, scale, sqltype_name, dbvarname));
    }

    public void setOutParam(int sqltype, int scale, String sqltype_name, String dbvarname) {
        this.params.add(new OutParameter(sqltype, scale, sqltype_name, dbvarname));
    }

    public void setOutParam(int pos, int sqltype, int scale, String sqltype_name, String dbvarname) {
        this.resize(pos);
        this.params.set(pos - 1, new OutParameter(sqltype, scale, sqltype_name, dbvarname));
    }

    public void setStatement(Statement stmt) throws SQLException {
        for (int i = 0; i < this.params.size(); ++i) {
            Parameter p = (Parameter)this.params.get(i);
            if (p == null) {
                throw new SQLException(RB.getString(this, "ParameterList.1"));
            }
            p.setStatement(stmt, i + 1);
        }
    }

    public String getStatement(String sql) {
        int index;
        int count = 1;
        while (sql != null && (index = ((String)sql).indexOf("?")) != -1) {
            sql = index == 0 ? " (param " + count + ") " + ((String)sql).substring(1) : (index == ((String)sql).length() - 1 ? ((String)sql).substring(0, index) + " (param " + count + ") " : ((String)sql).substring(0, index) + " (param " + count + ") " + ((String)sql).substring(index + 1));
            ++count;
        }
        return sql;
    }

    public String getWhere() {
        Object where = "";
        for (int i = 0; this.params != null && i < this.params.size(); ++i) {
            Parameter p = (Parameter)this.params.get(i);
            where = p == null ? (String)where + " (param " + (i + 1) + ") = UNDEFINED " : (String)where + " (param " + (i + 1) + ") = " + p.getStatement() + " ";
            if (i >= this.params.size() - 1) continue;
            where = (String)where + ",";
        }
        return where;
    }

    public void clear() {
        this.params.clear();
    }

    public int length() {
        return this.params.size();
    }

    public void setOutParameters(Statement stmt) throws SQLException {
        CallableStatement cstmt = (CallableStatement)stmt;
        int size = this.params.size();
        for (int i = 0; i < size; ++i) {
            Object obj = this.params.get(i);
            if (obj == null) {
                throw new SQLException(RB.getString(this, "ParameterList.1"));
            }
            if (!(obj instanceof OutParameter)) continue;
            Object outval = null;
            try {
                outval = QueryTable.resolveObject(cstmt.getObject(i + 1), -1, -1);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            OutParameter out_p = (OutParameter)obj;
            out_p.setOutput(outval);
        }
    }

    public ArrayList getAllParameters() {
        return this.params;
    }

    public Object clone() {
        ArrayList list;
        ParameterList paramList = new ParameterList();
        paramList.params = list = new ArrayList(this.params);
        return paramList;
    }

    public int hashCode() {
        int hash = 0;
        Iterator allParams = this.params.iterator();
        while (allParams.hasNext()) {
            hash += allParams.next().hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ParameterList) {
            int cSize;
            ArrayList cParams = ((ParameterList)obj).params;
            int size = this.params.size();
            if (size == (cSize = cParams.size())) {
                for (int x = 0; x < size; ++x) {
                    Parameter cParam;
                    Parameter param = (Parameter)this.params.get(x);
                    if (param.equals(cParam = (Parameter)cParams.get(x))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

