/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.Cast;
import coldfusion.runtime.Cloner;
import coldfusion.runtime.Copyable;
import coldfusion.runtime.ExpressionException;
import coldfusion.sql.QueryTable;
import coldfusion.sql.QueryTableMetaData;
import coldfusion.sql.Table;
import coldfusion.tagext.io.FileListTable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;

public class QueryColumn
implements List,
Copyable {
    Table table;
    int colnum;
    int sqltype;
    private static final Integer ONE = new Integer(1);
    private static final Integer ZERO = new Integer(0);

    QueryColumn(Table parent, int colnum) {
        int sqltype;
        this.table = parent;
        this.colnum = colnum;
        QueryTableMetaData meta = (QueryTableMetaData)((QueryTable)this.table).getMetaData();
        if (meta != null && (sqltype = meta.getColumnType(colnum, false)) != -999) {
            this.sqltype = sqltype;
        }
    }

    @Override
    public Object duplicate() {
        Table table;
        try {
            table = this.table instanceof QueryTable ? new QueryTable((QueryTable)this.table) : this.table;
        }
        catch (Exception e) {
            table = this.table;
        }
        QueryColumn ret = new QueryColumn(table, this.colnum);
        return ret;
    }

    @Override
    public QueryColumn clone() throws CloneNotSupportedException {
        return new QueryColumn((Table)Cloner.clone(this.table), this.colnum);
    }

    public Table getParentTable() {
        return this.table;
    }

    @Override
    public int size() {
        return this.table.getRowCount();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object x) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).equals(x)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator iterator() {
        return new QueryColumnIterator(this);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public Object[] toArray(Object[] a) {
        Object[] result = a.length < this.size() ? new Object[this.size()] : a;
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.get(i);
        }
        return result;
    }

    @Override
    public boolean add(Object o) {
        throw new QueryColumnStructureChangeException("");
    }

    @Override
    public boolean remove(Object o) {
        throw new QueryColumnStructureChangeException("");
    }

    @Override
    public boolean containsAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection c) {
        throw new QueryColumnStructureChangeException("");
    }

    public boolean addAll(int i, Collection c) {
        throw new QueryColumnStructureChangeException("");
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new QueryColumnStructureChangeException("");
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new QueryColumnStructureChangeException("");
    }

    @Override
    public void clear() {
        throw new QueryColumnStructureChangeException("");
    }

    @Override
    public boolean equals(Object x) {
        if (x instanceof QueryColumn) {
            QueryColumn prime = (QueryColumn)x;
            return prime.table.equals(this.table) && prime.colnum == this.colnum;
        }
        return false;
    }

    public Object get(int row) {
        Object result = this.table.getField(row + 1, this.colnum);
        if (result != null && this.sqltype == -7) {
            if (result instanceof String && ((String)result).length() == 0) {
                return result;
            }
            result = Cast._boolean(result) ? ONE : ZERO;
        } else if (result != null && this.sqltype == 2005 && result instanceof char[]) {
            result = new String((char[])result);
        } else if (result != null && this.sqltype == 2011 && result instanceof char[]) {
            result = new String((char[])result);
        } else if (result != null && this.sqltype == 2009 && result instanceof char[]) {
            result = new String((char[])result);
        } else if (result == null && !FusionContext.isPreserveNullValues()) {
            result = "";
        }
        if (this.table instanceof FileListTable && result instanceof Date) {
            Locale locale = Locale.getDefault();
            DateFormat formatter = locale.equals(Locale.JAPAN) || locale.equals(Locale.JAPANESE) ? new SimpleDateFormat("yyyy/MM/dd hh:mm:ss a") : (locale.equals(Locale.US) || locale.equals(Locale.ENGLISH) ? new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a") : DateFormat.getDateTimeInstance(3, 3));
            result = formatter.format(result);
        }
        return result;
    }

    public Object set(int row, Object value) {
        Object result = this.get(row);
        this.table.setField(row + 1, this.colnum, value);
        return result;
    }

    public void add(int pos, Object value) {
        throw new QueryColumnStructureChangeException("");
    }

    public Object remove(int pos) {
        throw new QueryColumnStructureChangeException("");
    }

    @Override
    public int indexOf(Object needle) {
        for (int i = 0; i < this.size(); ++i) {
            if (!needle.equals(this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object needle) {
        int result = -1;
        for (int i = 0; i < this.size(); ++i) {
            if (!needle.equals(this.get(i))) continue;
            result = i;
        }
        return result;
    }

    public ListIterator listIterator() {
        return new QueryColumnIterator(this);
    }

    public ListIterator listIterator(int pos) {
        return new QueryColumnIterator(this, pos);
    }

    public List subList(int start, int end) {
        throw new UnsupportedOperationException();
    }

    public class QueryColumnIterator
    implements ListIterator {
        private int pos;
        private QueryColumn qCol;

        public QueryColumnIterator(QueryColumn c) {
            this(c, -1);
        }

        public QueryColumnIterator(QueryColumn c, int pos) {
            this.qCol = c;
            this.pos = pos;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.qCol.size();
        }

        @Override
        public Object next() {
            return this.qCol.get(this.pos++);
        }

        @Override
        public boolean hasPrevious() {
            return this.pos > 0;
        }

        public Object previous() {
            return this.qCol.get(--this.pos);
        }

        @Override
        public int nextIndex() {
            return this.pos;
        }

        @Override
        public int previousIndex() {
            return this.pos - 1;
        }

        @Override
        public void remove() {
            throw new QueryColumnStructureChangeException("remove");
        }

        public void set(Object value) {
            this.qCol.set(this.pos, value);
        }

        public void add(Object o) {
            throw new QueryColumnStructureChangeException("add");
        }
    }

    public class QueryColumnStructureChangeException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String methodName;

        public QueryColumnStructureChangeException(String methodName) {
            this.methodName = methodName;
        }
    }
}

