/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql;

import coldfusion.runtime.QueryFunction;
import coldfusion.runtime.TableWrapper;
import coldfusion.sql.Parameter;
import coldfusion.sql.QueryColumn;
import coldfusion.sql.QueryTable;
import coldfusion.sql.imq.imqTable;
import java.util.List;

public class Table
extends imqTable {
    private Table prev;
    private Table next;

    Table() {
    }

    public Table(int rows, int cols) {
        super(rows, cols);
        this.next = null;
        this.prev = null;
    }

    public Table(int rows, String[] columns) {
        super(rows, columns);
        this.next = null;
        this.prev = null;
    }

    public Table(int rows, String[] columns, String[] sqlColTypeName) {
        super(rows, columns, sqlColTypeName);
        this.next = null;
        this.prev = null;
    }

    public Table(int rows, String[] columns, String[] sqlColTypeName, int[] sqlColTypes) {
        super(rows, columns, sqlColTypeName, sqlColTypes);
        this.next = null;
        this.prev = null;
    }

    public Table(int rows, String collist) {
        super(rows, collist);
        this.next = null;
        this.prev = null;
    }

    public Table(TableWrapper tWrapper) {
        this();
        this.initTableFromWrapper(tWrapper);
    }

    private void initTableFromWrapper(TableWrapper tWrapper) {
        this.next = (Table)tWrapper.getNext();
        this.prev = (Table)tWrapper.getPrev();
        imqTable iTable = (imqTable)tWrapper.getImqTableWrapper();
        this.setCached(iTable.isCached());
        this.setCol_count(iTable.getCol_count());
        this.setColumnNames(iTable.getColumnNames(), false);
        this.setHead(iTable.getHead());
        this.setTail(iTable.getTail());
        this.setMeta(iTable.getMeta());
        this.setRow_count(iTable.getRow_count());
        this.setRowVector(iTable.getRowVector());
    }

    public Table nextTable() {
        return this.next;
    }

    public Table previousTable() {
        return this.prev;
    }

    public Table firstTable() {
        Table rs = null;
        Table curr = this;
        while ((rs = curr.previousTable()) != null) {
            curr = rs;
        }
        return curr;
    }

    public Table lastTable() {
        Table rs = null;
        Table curr = this;
        while ((rs = curr.nextTable()) != null) {
            curr = rs;
        }
        return curr;
    }

    public void setNextTable(Table rs) {
        this.next = rs;
    }

    public void setPreviousTable(Table rs) {
        this.prev = rs;
    }

    public int addRows(int rows) {
        return this.addRows(rows, false);
    }

    public int getColumnCount() {
        return this.col_count;
    }

    public List getColumn(int colId) {
        return new QueryColumn(this, colId);
    }

    public List getColumn(String column_name) {
        int colId = this.findColumn(column_name);
        if (colId == 0) {
            return null;
        }
        return this.getColumn(colId);
    }

    public int findColumn(String column_name) {
        for (int i = 0; i < this.col_count; ++i) {
            if (!this.col_names[i].equalsIgnoreCase(column_name)) continue;
            return i + 1;
        }
        return 0;
    }

    @Override
    public String[] getColumnNames() {
        String[] names = new String[this.col_count];
        System.arraycopy(this.col_names, 0, names, 0, this.col_count);
        return names;
    }

    public String getColumnName(int i) {
        return this.col_names[i - 1];
    }

    public Object getField(int row, int column) {
        return row < 1 || row > this.row_count || column < 1 || column > this.col_count ? null : this.getRow(row - 1).getColumn(column - 1);
    }

    public void setField(int row, int column, Object value) {
        this.setField(row, column, value, false);
    }

    public void setField(int row, int column, Object value, boolean validate) {
        block4: {
            if (row < 1 || row > this.row_count || column < 1 || column > this.col_count) {
                return;
            }
            if (this instanceof QueryTable) {
                try {
                    value = QueryFunction.validateDataType((QueryTable)this, column, value);
                }
                catch (Parameter.DataTypeMismatchException dtmex) {
                    if (!validate) break block4;
                    throw dtmex;
                }
            }
        }
        this.getRow(row - 1).setColumn(column - 1, value);
    }

    public String toString() {
        int column;
        int rowCount = this.getRowCount();
        int columnCount = this.getColumnCount();
        String[] columnNames = this.getColumnNames();
        StringBuffer sb = new StringBuffer("[Table (rows ");
        sb.append(rowCount);
        sb.append(" columns ");
        for (column = 0; column < columnCount; ++column) {
            if (column > 0) {
                sb.append(", ");
            }
            sb.append(columnNames[column]);
        }
        sb.append("): ");
        for (column = 1; column <= columnCount; ++column) {
            sb.append("[");
            sb.append(this.getColumnName(column));
            sb.append(": ");
            sb.append(this.getColumn(column).toString());
            sb.append("] ");
        }
        sb.append("]");
        if (this.nextTable() != null) {
            return sb.toString() + " " + this.nextTable().toString();
        }
        return sb.toString();
    }

    protected void makeShallowCopy(Table qt, int maxrows) {
        super.makeShallowCopy(qt, maxrows);
        this.prev = qt.prev;
        this.next = qt.next;
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public Object writeReplace() {
        TableWrapper tWrapper = new TableWrapper();
        tWrapper.setImqTableWrapper(super.writeReplace());
        return tWrapper;
    }
}

