/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql;

import coldfusion.sql.ColumnMetaData;
import coldfusion.sql.ForeignKeyMetaData;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TableMetaData {
    private String catalog;
    private String schema;
    private String name;
    private Set<String> pkColumns;
    private Map<String, ColumnMetaData> columns;
    private Map<String, ForeignKeyMetaData> foreignKeys;
    private Map<String, List<ForeignKeyMetaData>> exportedKeys;

    public TableMetaData(ResultSet rs, DatabaseMetaData meta) throws SQLException {
        this.catalog = rs.getString("TABLE_CAT");
        this.schema = rs.getString("TABLE_SCHEM");
        this.name = rs.getString("TABLE_NAME");
        this.initPrimaryKeys(meta);
        this.initColumns(meta);
        this.initImportedKeys(meta);
        this.initExportedKeys(meta);
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getPkColumns() {
        return this.pkColumns;
    }

    public Map<String, ColumnMetaData> getColumns() {
        return this.columns;
    }

    public ColumnMetaData getColumnMetaData(String colName) {
        return this.columns.get(colName.toLowerCase());
    }

    public Map<String, List<ForeignKeyMetaData>> getExportedKeys() {
        return this.exportedKeys;
    }

    public List<ForeignKeyMetaData> getExportedKeyMetaData(String pkColumn) {
        return this.exportedKeys.get(pkColumn.toLowerCase());
    }

    public Map<String, ForeignKeyMetaData> getForeignKeys() {
        return this.foreignKeys;
    }

    public ForeignKeyMetaData getForeignKeyMetaData(String fkColumn) {
        return this.foreignKeys.get(fkColumn.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPrimaryKeys(DatabaseMetaData meta) throws SQLException {
        this.pkColumns = new HashSet<String>();
        try (ResultSet pkrs = null;){
            pkrs = meta.getPrimaryKeys(this.catalog, this.schema, this.name);
            while (pkrs.next()) {
                String columnName = pkrs.getString("COLUMN_NAME");
                this.pkColumns.add(columnName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initColumns(DatabaseMetaData meta) throws SQLException {
        this.columns = new HashMap<String, ColumnMetaData>();
        try (ResultSet rs = null;){
            rs = meta.getColumns(this.catalog, this.schema, this.name, "%");
            while (rs.next()) {
                ColumnMetaData colMetadata = new ColumnMetaData(rs);
                String colName = colMetadata.getName();
                if (this.pkColumns.contains(colName)) {
                    colMetadata.setPK(true);
                }
                this.columns.put(colName.toLowerCase(), colMetadata);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initImportedKeys(DatabaseMetaData meta) throws SQLException {
        this.foreignKeys = new HashMap<String, ForeignKeyMetaData>();
        try (ResultSet importedKeys = null;){
            importedKeys = meta.getImportedKeys(this.catalog, this.schema, this.name);
            while (importedKeys.next()) {
                ForeignKeyMetaData fkMetaData = new ForeignKeyMetaData(importedKeys);
                this.foreignKeys.put(fkMetaData.getFkColName().toLowerCase(), fkMetaData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initExportedKeys(DatabaseMetaData meta) throws SQLException {
        this.exportedKeys = new HashMap<String, List<ForeignKeyMetaData>>();
        try (ResultSet exportedKeyRS = null;){
            exportedKeyRS = meta.getExportedKeys(this.catalog, this.schema, this.name);
            while (exportedKeyRS.next()) {
                ForeignKeyMetaData fkMetaData = new ForeignKeyMetaData(exportedKeyRS);
                String pkCol = fkMetaData.getPkColName().toLowerCase();
                List<ForeignKeyMetaData> fklist = this.exportedKeys.get(pkCol);
                if (fklist == null) {
                    fklist = new ArrayList<ForeignKeyMetaData>();
                    this.exportedKeys.put(pkCol, fklist);
                }
                fklist.add(fkMetaData);
            }
        }
    }
}

