/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.imq.RowTuple;
import coldfusion.sql.imq.TableList;
import coldfusion.sql.imq.TableListIterator;
import coldfusion.sql.imq.TupleSorter;
import java.util.Vector;

class GroupTableListIterator
extends TableListIterator {
    private TupleSorter tupleSorter;
    private int currTupleId = 0;
    private int firstTupleId = 0;
    private int lastTupleId = 0;
    private Vector tupleVect;
    private int tupleVectSize;
    private boolean oneGroup;

    GroupTableListIterator(TableList TableList2, TupleSorter TupleSorter2) {
        super(TableList2, 2);
        this.tupleSorter = TupleSorter2;
        this.tupleVect = this.tupleSorter.getSortedTupleVector();
        this.tupleVectSize = this.tupleVect.size();
        this.currTuple = this.tupleVectSize == 0 ? null : this.getRowTuple(this.currTupleId);
    }

    GroupTableListIterator(TableList TableList2, Vector TupleVect, boolean OneGroup) {
        super(TableList2, 2);
        this.tupleSorter = null;
        this.tupleVect = TupleVect;
        this.tupleVectSize = TupleVect.size();
        this.currTuple = this.tupleVectSize == 0 ? null : this.getRowTuple(this.currTupleId);
        this.oneGroup = OneGroup;
    }

    private RowTuple getRowTuple(int tupleId) {
        return (RowTuple)this.tupleVect.get(tupleId);
    }

    @Override
    boolean hasNext(int X) {
        return this.currTupleId < this.lastTupleId;
    }

    @Override
    void next(int X) {
        ++this.currTupleId;
        this.currTuple = this.currTupleId < this.lastTupleId ? this.getRowTuple(this.currTupleId) : null;
    }

    @Override
    void resetWithinGroup(int X) {
        this.currTupleId = this.firstTupleId;
        this.currTuple = !this.tupleVect.isEmpty() ? this.getRowTuple(this.currTupleId) : null;
    }

    int getGroupSize() {
        return this.lastTupleId - this.firstTupleId;
    }

    boolean hasNextGroup() {
        return this.lastTupleId < this.tupleVectSize;
    }

    void nextGroup() {
        this.currTupleId = this.lastTupleId;
        this.firstTupleId = this.lastTupleId;
        this.currTuple = this.getRowTuple(this.lastTupleId);
        if (this.tupleSorter != null) {
            do {
                ++this.lastTupleId;
            } while (this.lastTupleId < this.tupleVectSize && this.tupleSorter.compareTo(this.getRowTuple(this.firstTupleId), this.getRowTuple(this.lastTupleId)) == 0);
        } else {
            this.lastTupleId = this.oneGroup ? this.tupleVectSize : ++this.lastTupleId;
        }
    }
}

