/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.imq.ExprColumn;
import coldfusion.sql.imq.GroupByColumnList;
import coldfusion.sql.imq.ImqParserConstants;
import coldfusion.sql.imq.ImqParserTokenManager;
import coldfusion.sql.imq.OrderByColumnList;
import coldfusion.sql.imq.ParseException;
import coldfusion.sql.imq.SelectColumn;
import coldfusion.sql.imq.SelectColumnList;
import coldfusion.sql.imq.SimpleCharStream;
import coldfusion.sql.imq.StarColumn;
import coldfusion.sql.imq.TableList;
import coldfusion.sql.imq.TableStarColumn;
import coldfusion.sql.imq.Token;
import coldfusion.sql.imq.TokenMgrError;
import coldfusion.sql.imq.rttExpr;
import coldfusion.sql.imq.rttExprColumnref;
import coldfusion.sql.imq.rttExprCond;
import coldfusion.sql.imq.rttExprCondAnd;
import coldfusion.sql.imq.rttExprCondBetween;
import coldfusion.sql.imq.rttExprCondComp;
import coldfusion.sql.imq.rttExprCondIn;
import coldfusion.sql.imq.rttExprCondLike;
import coldfusion.sql.imq.rttExprCondNot;
import coldfusion.sql.imq.rttExprCondNull;
import coldfusion.sql.imq.rttExprCondOr;
import coldfusion.sql.imq.rttExprCondTest;
import coldfusion.sql.imq.rttExprDate;
import coldfusion.sql.imq.rttExprDateCast;
import coldfusion.sql.imq.rttExprNum;
import coldfusion.sql.imq.rttExprNumAggr;
import coldfusion.sql.imq.rttExprNumAggrAvg;
import coldfusion.sql.imq.rttExprNumAggrCount;
import coldfusion.sql.imq.rttExprNumAggrCountstar;
import coldfusion.sql.imq.rttExprNumAggrMax;
import coldfusion.sql.imq.rttExprNumAggrMin;
import coldfusion.sql.imq.rttExprNumAggrSum;
import coldfusion.sql.imq.rttExprNumBinary;
import coldfusion.sql.imq.rttExprNumBinaryAdd;
import coldfusion.sql.imq.rttExprNumBinaryDiv;
import coldfusion.sql.imq.rttExprNumBinaryModulus;
import coldfusion.sql.imq.rttExprNumBinaryMult;
import coldfusion.sql.imq.rttExprNumBinarySub;
import coldfusion.sql.imq.rttExprNumBitwiseOp;
import coldfusion.sql.imq.rttExprNumCast;
import coldfusion.sql.imq.rttExprNumMinus;
import coldfusion.sql.imq.rttExprOrderedcolumnref;
import coldfusion.sql.imq.rttExprRef;
import coldfusion.sql.imq.rttExprString;
import coldfusion.sql.imq.rttExprStringCast;
import coldfusion.sql.imq.rttExprStringConcat;
import coldfusion.sql.imq.rttExprTime;
import coldfusion.sql.imq.rttExprTimestamp;
import coldfusion.sql.imq.rttResultcolumnref;
import coldfusion.sql.imq.rttSelectExpr;
import coldfusion.sql.imq.rttSelectExprSpec;
import coldfusion.sql.imq.rttSelectExprUnion;
import coldfusion.sql.imq.rttSelectStmt;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ImqParser
implements ImqParserConstants {
    private static String eol = System.getProperty("line.separator", "\n");
    public ImqParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private boolean jj_lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[61];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static int[] jj_la1_5;
    private static int[] jj_la1_6;
    private static int[] jj_la1_7;
    private static int[] jj_la1_8;
    private final JJCalls[] jj_2_rtns = new JJCalls[10];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private static final LookaheadSuccess jj_ls;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;
    private boolean trace_enabled;

    public static void main(String[] args) throws ParseException {
        ImqParser parser = new ImqParser(System.in);
        parser.Input();
    }

    private boolean isNullRttExpr(rttExprNum obj) {
        return !(obj instanceof rttExprNumBinary) && obj.isInitializedNull && obj.colRefExpr == null;
    }

    String stripStringLiteral(String strVal) {
        return strVal.substring(1, strVal.length() - 1);
    }

    public boolean isValidDate(String dateStr) {
        if (null == dateStr) {
            return false;
        }
        if (dateStr.startsWith("'") && dateStr.length() > 1) {
            dateStr = dateStr.substring(1, dateStr.length() - 1);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        dateFormat.setLenient(false);
        try {
            dateFormat.parse(dateStr);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public final rttSelectStmt Input() throws ParseException {
        try {
            rttSelectStmt rttSelectStmtNode = this.select_statement();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 248: {
                    this.jj_consume_token(248);
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                }
            }
            this.jj_consume_token(0);
            return rttSelectStmtNode;
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (TokenMgrError e) {
            String errMsg = e.getMessage();
            ParseException pe = this.generateParseException();
            pe.prependImqMessage(errMsg, 13);
            throw pe;
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            ParseException pe = this.generateParseException();
            pe.prependImqMessage(errMsg, 13);
            throw pe;
        }
    }

    public final rttSelectStmt select_statement() throws ParseException {
        OrderByColumnList orderByList = null;
        rttSelectExpr selectExprNode = this.select_expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 154: {
                this.jj_consume_token(154);
                this.jj_consume_token(27);
                orderByList = this.order_by_list();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        return new rttSelectStmt(selectExprNode, orderByList);
    }

    public final rttSelectExpr select_expression() throws ParseException {
        rttSelectExpr exprL = null;
        rttSelectExpr exprR = null;
        boolean allFlag = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 260: {
                this.jj_consume_token(260);
                exprL = this.select_expression();
                this.jj_consume_token(261);
                break;
            }
            case 181: {
                exprL = this.select_specification();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 206: {
                this.jj_consume_token(206);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 8: {
                        this.jj_consume_token(8);
                        allFlag = true;
                        break;
                    }
                    default: {
                        this.jj_la1[3] = this.jj_gen;
                    }
                }
                exprR = this.select_expression();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        if (exprR != null) {
            return new rttSelectExprUnion(exprL, exprR, allFlag);
        }
        return exprL;
    }

    public final rttSelectExprSpec select_specification() throws ParseException {
        boolean distinctFlag = false;
        SelectColumnList selectList = null;
        rttSelectExprSpec selectSpecNode = new rttSelectExprSpec();
        TableList tableList = null;
        rttExprCond whereCond = null;
        rttExprCond havingCond = null;
        GroupByColumnList groupByList = null;
        this.jj_consume_token(181);
        block1 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 8: 
            case 74: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 8: {
                        this.jj_consume_token(8);
                        break block1;
                    }
                    case 74: {
                        this.jj_consume_token(74);
                        distinctFlag = true;
                        break block1;
                    }
                }
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        selectList = this.select_list();
        if (this.getToken((int)1).kind != 95) {
            ParseException pe = this.generateParseException();
            String strTok = this.getToken(1).toString();
            String msg = this.getToken((int)1).kind == 118 ? "Incorrect Select Statement, " + eol + "Query of Queries does not support 'INTO' constructs " : "Incorrect Select Statement, " + eol + "Expecting a 'FROM', but encountered '" + strTok + "' instead, " + eol + "A select statement should have a 'FROM' construct.";
            pe.prependImqMessage(msg, 10);
            throw pe;
        }
        selectSpecNode.setSelectList(selectList);
        if (distinctFlag) {
            selectSpecNode.setDistinctFlag();
        }
        this.jj_consume_token(95);
        tableList = this.from_table_list();
        selectSpecNode.setTableList(tableList);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 221: {
                this.jj_consume_token(221);
                whereCond = this.cond_exp();
                selectSpecNode.setWhereCondition(whereCond);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 102: {
                this.jj_consume_token(102);
                this.jj_consume_token(27);
                groupByList = this.group_by_list();
                selectSpecNode.setGroupByList(groupByList);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 103: {
                this.jj_consume_token(103);
                havingCond = this.cond_exp();
                selectSpecNode.setHavingCondition(havingCond);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                break;
            }
        }
        return selectSpecNode;
    }

    public final OrderByColumnList order_by_list() throws ParseException {
        OrderByColumnList list = new OrderByColumnList();
        rttExprOrderedcolumnref expr = null;
        expr = this.order_by_column();
        list.addColumn(expr);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 250: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(250);
            expr = this.order_by_column();
            list.addColumn(expr);
        }
        return list;
    }

    public final rttExprOrderedcolumnref order_by_column() throws ParseException {
        rttExprColumnref colrefExpr = null;
        rttExprOrderedcolumnref resultExpr = null;
        boolean descFlag = false;
        Token litTok = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 10: 
            case 14: 
            case 15: 
            case 27: 
            case 52: 
            case 60: 
            case 69: 
            case 77: 
            case 90: 
            case 95: 
            case 113: 
            case 121: 
            case 124: 
            case 149: 
            case 154: 
            case 181: 
            case 209: 
            case 242: {
                colrefExpr = this.column_ref();
                resultExpr = new rttExprOrderedcolumnref(colrefExpr);
                break;
            }
            case 228: {
                litTok = this.jj_consume_token(228);
                Integer colId = new Integer(litTok.toString());
                resultExpr = new rttExprOrderedcolumnref(colId);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                ParseException pe = this.generateParseException();
                String strTok = this.getToken(1).toString();
                pe.prependImqMessage("Incorrect ORDER BY column reference [" + strTok + "].<br> Only simple column reference, alias name, and integer column id are allowed. <br><b>Example</b>: You can use alias to refer to a complex expression: <br><i>SELECT (a+b)/2 as x FROM T ORDER BY x</i>", 15);
                throw pe;
            }
        }
        block4 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 15: 
            case 69: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        break block4;
                    }
                    case 69: {
                        this.jj_consume_token(69);
                        descFlag = true;
                        break block4;
                    }
                }
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        if (descFlag) {
            resultExpr.setDescendingOrder();
        }
        return resultExpr;
    }

    public final GroupByColumnList group_by_list() throws ParseException {
        GroupByColumnList list = new GroupByColumnList();
        rttResultcolumnref colref = null;
        colref = this.group_by_column();
        list.addColumn(colref);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 250: {
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(250);
            colref = this.group_by_column();
            list.addColumn(colref);
        }
        return list;
    }

    public final rttResultcolumnref group_by_column() throws ParseException {
        rttExprColumnref colrefExpr = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 10: 
            case 14: 
            case 15: 
            case 27: 
            case 52: 
            case 60: 
            case 69: 
            case 77: 
            case 90: 
            case 95: 
            case 113: 
            case 121: 
            case 124: 
            case 149: 
            case 154: 
            case 181: 
            case 209: 
            case 242: {
                colrefExpr = this.column_ref();
                return new rttResultcolumnref(colrefExpr);
            }
        }
        this.jj_la1[15] = this.jj_gen;
        ParseException pe = this.generateParseException();
        String strTok = this.getToken(1).toString();
        pe.prependImqMessage("Incorrect GROUP BY column reference [" + strTok + "].<br> Only simple column reference, and alias name are allowed. <br><b>Example</b>: You can use alias to refer to a complex expression: <br><i>SELECT (a+b)/2 as x, count(*) FROM T GROUP BY x</i>", 15);
        throw pe;
    }

    public final TableList from_table_list() throws ParseException {
        TableList tableList = new TableList();
        String tableName = this.from_table_name();
        tableList.addTableName(tableName);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 250: {
                this.jj_consume_token(250);
                tableName = this.from_table_name();
                tableList.addTableName(tableName);
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
            }
        }
        if (this.getToken((int)1).kind == 250) {
            ParseException pe = this.generateParseException();
            String strTok = this.getToken(2).toString();
            String msg = "Detected more than two tables in the 'from' list '" + strTok + "', " + eol + "Currently only 2 tables are supported,  ";
            pe.prependImqMessage(msg, 12);
            throw pe;
        }
        return tableList;
    }

    public final String from_table_name() throws ParseException {
        Object tableName = this.TableIdentifier();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 249: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(249);
            String subName = this.TableIdentifier();
            tableName = (String)tableName + "." + subName;
        }
        return tableName;
    }

    public final SelectColumnList select_list() throws ParseException {
        SelectColumnList colList;
        block6: {
            colList = new SelectColumnList();
            SelectColumn col = null;
            try {
                col = this.select_column();
                colList.addColumn(col);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 250: {
                            break;
                        }
                        default: {
                            this.jj_la1[18] = this.jj_gen;
                            break block6;
                        }
                    }
                    this.jj_consume_token(250);
                    col = this.select_column();
                    colList.addColumn(col);
                }
            }
            catch (ParseException pe) {
                pe.prependImqMessage("Incorrect Select List, ", 11);
                throw pe;
            }
        }
        return colList;
    }

    public final Token consumeVariableANDTokens() throws ParseException {
        Token token = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 242: {
                token = this.jj_consume_token(242);
                break;
            }
            case 0: {
                token = this.jj_consume_token(0);
                break;
            }
            case 5: {
                token = this.jj_consume_token(5);
                break;
            }
            case 6: {
                token = this.jj_consume_token(6);
                break;
            }
            case 7: {
                token = this.jj_consume_token(7);
                break;
            }
            case 8: {
                token = this.jj_consume_token(8);
                break;
            }
            case 9: {
                token = this.jj_consume_token(9);
                break;
            }
            case 10: {
                token = this.jj_consume_token(10);
                break;
            }
            case 11: {
                token = this.jj_consume_token(11);
                break;
            }
            case 12: {
                token = this.jj_consume_token(12);
                break;
            }
            case 13: {
                token = this.jj_consume_token(13);
                break;
            }
            case 14: {
                token = this.jj_consume_token(14);
                break;
            }
            case 15: {
                token = this.jj_consume_token(15);
                break;
            }
            case 16: {
                token = this.jj_consume_token(16);
                break;
            }
            case 17: {
                token = this.jj_consume_token(17);
                break;
            }
            case 18: {
                token = this.jj_consume_token(18);
                break;
            }
            case 19: {
                token = this.jj_consume_token(19);
                break;
            }
            case 20: {
                token = this.jj_consume_token(20);
                break;
            }
            case 21: {
                token = this.jj_consume_token(21);
                break;
            }
            case 22: {
                token = this.jj_consume_token(22);
                break;
            }
            case 23: {
                token = this.jj_consume_token(23);
                break;
            }
            case 24: {
                token = this.jj_consume_token(24);
                break;
            }
            case 25: {
                token = this.jj_consume_token(25);
                break;
            }
            case 26: {
                token = this.jj_consume_token(26);
                break;
            }
            case 27: {
                token = this.jj_consume_token(27);
                break;
            }
            case 28: {
                token = this.jj_consume_token(28);
                break;
            }
            case 29: {
                token = this.jj_consume_token(29);
                break;
            }
            case 30: {
                token = this.jj_consume_token(30);
                break;
            }
            case 31: {
                token = this.jj_consume_token(31);
                break;
            }
            case 32: {
                token = this.jj_consume_token(32);
                break;
            }
            case 33: {
                token = this.jj_consume_token(33);
                break;
            }
            case 34: {
                token = this.jj_consume_token(34);
                break;
            }
            case 35: {
                token = this.jj_consume_token(35);
                break;
            }
            case 36: {
                token = this.jj_consume_token(36);
                break;
            }
            case 37: {
                token = this.jj_consume_token(37);
                break;
            }
            case 38: {
                token = this.jj_consume_token(38);
                break;
            }
            case 39: {
                token = this.jj_consume_token(39);
                break;
            }
            case 40: {
                token = this.jj_consume_token(40);
                break;
            }
            case 41: {
                token = this.jj_consume_token(41);
                break;
            }
            case 42: {
                token = this.jj_consume_token(42);
                break;
            }
            case 43: {
                token = this.jj_consume_token(43);
                break;
            }
            case 44: {
                token = this.jj_consume_token(44);
                break;
            }
            case 45: {
                token = this.jj_consume_token(45);
                break;
            }
            case 46: {
                token = this.jj_consume_token(46);
                break;
            }
            case 47: {
                token = this.jj_consume_token(47);
                break;
            }
            case 48: {
                token = this.jj_consume_token(48);
                break;
            }
            case 49: {
                token = this.jj_consume_token(49);
                break;
            }
            case 50: {
                token = this.jj_consume_token(50);
                break;
            }
            case 51: {
                token = this.jj_consume_token(51);
                break;
            }
            case 52: {
                token = this.jj_consume_token(52);
                break;
            }
            case 53: {
                token = this.jj_consume_token(53);
                break;
            }
            case 54: {
                token = this.jj_consume_token(54);
                break;
            }
            case 55: {
                token = this.jj_consume_token(55);
                break;
            }
            case 56: {
                token = this.jj_consume_token(56);
                break;
            }
            case 57: {
                token = this.jj_consume_token(57);
                break;
            }
            case 58: {
                token = this.jj_consume_token(58);
                break;
            }
            case 59: {
                token = this.jj_consume_token(59);
                break;
            }
            case 60: {
                token = this.jj_consume_token(60);
                break;
            }
            case 61: {
                token = this.jj_consume_token(61);
                break;
            }
            case 62: {
                token = this.jj_consume_token(62);
                break;
            }
            case 63: {
                token = this.jj_consume_token(63);
                break;
            }
            case 64: {
                token = this.jj_consume_token(64);
                break;
            }
            case 65: {
                token = this.jj_consume_token(65);
                break;
            }
            case 66: {
                token = this.jj_consume_token(66);
                break;
            }
            case 67: {
                token = this.jj_consume_token(67);
                break;
            }
            case 68: {
                token = this.jj_consume_token(68);
                break;
            }
            case 69: {
                token = this.jj_consume_token(69);
                break;
            }
            case 70: {
                token = this.jj_consume_token(70);
                break;
            }
            case 71: {
                token = this.jj_consume_token(71);
                break;
            }
            case 72: {
                token = this.jj_consume_token(72);
                break;
            }
            case 73: {
                token = this.jj_consume_token(73);
                break;
            }
            case 74: {
                token = this.jj_consume_token(74);
                break;
            }
            case 75: {
                token = this.jj_consume_token(75);
                break;
            }
            case 76: {
                token = this.jj_consume_token(76);
                break;
            }
            case 77: {
                token = this.jj_consume_token(77);
                break;
            }
            case 78: {
                token = this.jj_consume_token(78);
                break;
            }
            case 79: {
                token = this.jj_consume_token(79);
                break;
            }
            case 80: {
                token = this.jj_consume_token(80);
                break;
            }
            case 81: {
                token = this.jj_consume_token(81);
                break;
            }
            case 82: {
                token = this.jj_consume_token(82);
                break;
            }
            case 83: {
                token = this.jj_consume_token(83);
                break;
            }
            case 84: {
                token = this.jj_consume_token(84);
                break;
            }
            case 85: {
                token = this.jj_consume_token(85);
                break;
            }
            case 86: {
                token = this.jj_consume_token(86);
                break;
            }
            case 87: {
                token = this.jj_consume_token(87);
                break;
            }
            case 88: {
                token = this.jj_consume_token(88);
                break;
            }
            case 89: {
                token = this.jj_consume_token(89);
                break;
            }
            case 90: {
                token = this.jj_consume_token(90);
                break;
            }
            case 91: {
                token = this.jj_consume_token(91);
                break;
            }
            case 92: {
                token = this.jj_consume_token(92);
                break;
            }
            case 93: {
                token = this.jj_consume_token(93);
                break;
            }
            case 94: {
                token = this.jj_consume_token(94);
                break;
            }
            case 95: {
                token = this.jj_consume_token(95);
                break;
            }
            case 96: {
                token = this.jj_consume_token(96);
                break;
            }
            case 97: {
                token = this.jj_consume_token(97);
                break;
            }
            case 98: {
                token = this.jj_consume_token(98);
                break;
            }
            case 99: {
                token = this.jj_consume_token(99);
                break;
            }
            case 100: {
                token = this.jj_consume_token(100);
                break;
            }
            case 101: {
                token = this.jj_consume_token(101);
                break;
            }
            case 102: {
                token = this.jj_consume_token(102);
                break;
            }
            case 103: {
                token = this.jj_consume_token(103);
                break;
            }
            case 104: {
                token = this.jj_consume_token(104);
                break;
            }
            case 105: {
                token = this.jj_consume_token(105);
                break;
            }
            case 106: {
                token = this.jj_consume_token(106);
                break;
            }
            case 107: {
                token = this.jj_consume_token(107);
                break;
            }
            case 108: {
                token = this.jj_consume_token(108);
                break;
            }
            case 109: {
                token = this.jj_consume_token(109);
                break;
            }
            case 110: {
                token = this.jj_consume_token(110);
                break;
            }
            case 111: {
                token = this.jj_consume_token(111);
                break;
            }
            case 112: {
                token = this.jj_consume_token(112);
                break;
            }
            case 113: {
                token = this.jj_consume_token(113);
                break;
            }
            case 114: {
                token = this.jj_consume_token(114);
                break;
            }
            case 115: {
                token = this.jj_consume_token(115);
                break;
            }
            case 116: {
                token = this.jj_consume_token(116);
                break;
            }
            case 117: {
                token = this.jj_consume_token(117);
                break;
            }
            case 118: {
                token = this.jj_consume_token(118);
                break;
            }
            case 119: {
                token = this.jj_consume_token(119);
                break;
            }
            case 120: {
                token = this.jj_consume_token(120);
                break;
            }
            case 121: {
                token = this.jj_consume_token(121);
                break;
            }
            case 122: {
                token = this.jj_consume_token(122);
                break;
            }
            case 123: {
                token = this.jj_consume_token(123);
                break;
            }
            case 124: {
                token = this.jj_consume_token(124);
                break;
            }
            case 125: {
                token = this.jj_consume_token(125);
                break;
            }
            case 126: {
                token = this.jj_consume_token(126);
                break;
            }
            case 127: {
                token = this.jj_consume_token(127);
                break;
            }
            case 128: {
                token = this.jj_consume_token(128);
                break;
            }
            case 129: {
                token = this.jj_consume_token(129);
                break;
            }
            case 130: {
                token = this.jj_consume_token(130);
                break;
            }
            case 131: {
                token = this.jj_consume_token(131);
                break;
            }
            case 132: {
                token = this.jj_consume_token(132);
                break;
            }
            case 133: {
                token = this.jj_consume_token(133);
                break;
            }
            case 134: {
                token = this.jj_consume_token(134);
                break;
            }
            case 135: {
                token = this.jj_consume_token(135);
                break;
            }
            case 136: {
                token = this.jj_consume_token(136);
                break;
            }
            case 137: {
                token = this.jj_consume_token(137);
                break;
            }
            case 138: {
                token = this.jj_consume_token(138);
                break;
            }
            case 139: {
                token = this.jj_consume_token(139);
                break;
            }
            case 140: {
                token = this.jj_consume_token(140);
                break;
            }
            case 141: {
                token = this.jj_consume_token(141);
                break;
            }
            case 142: {
                token = this.jj_consume_token(142);
                break;
            }
            case 143: {
                token = this.jj_consume_token(143);
                break;
            }
            case 144: {
                token = this.jj_consume_token(144);
                break;
            }
            case 145: {
                token = this.jj_consume_token(145);
                break;
            }
            case 146: {
                token = this.jj_consume_token(146);
                break;
            }
            case 147: {
                token = this.jj_consume_token(147);
                break;
            }
            case 148: {
                token = this.jj_consume_token(148);
                break;
            }
            case 149: {
                token = this.jj_consume_token(149);
                break;
            }
            case 150: {
                token = this.jj_consume_token(150);
                break;
            }
            case 151: {
                token = this.jj_consume_token(151);
                break;
            }
            case 152: {
                token = this.jj_consume_token(152);
                break;
            }
            case 153: {
                token = this.jj_consume_token(153);
                break;
            }
            case 154: {
                token = this.jj_consume_token(154);
                break;
            }
            case 155: {
                token = this.jj_consume_token(155);
                break;
            }
            case 156: {
                token = this.jj_consume_token(156);
                break;
            }
            case 157: {
                token = this.jj_consume_token(157);
                break;
            }
            case 158: {
                token = this.jj_consume_token(158);
                break;
            }
            case 159: {
                token = this.jj_consume_token(159);
                break;
            }
            case 160: {
                token = this.jj_consume_token(160);
                break;
            }
            case 161: {
                token = this.jj_consume_token(161);
                break;
            }
            case 162: {
                token = this.jj_consume_token(162);
                break;
            }
            case 163: {
                token = this.jj_consume_token(163);
                break;
            }
            case 164: {
                token = this.jj_consume_token(164);
                break;
            }
            case 165: {
                token = this.jj_consume_token(165);
                break;
            }
            case 166: {
                token = this.jj_consume_token(166);
                break;
            }
            case 167: {
                token = this.jj_consume_token(167);
                break;
            }
            case 168: {
                token = this.jj_consume_token(168);
                break;
            }
            case 169: {
                token = this.jj_consume_token(169);
                break;
            }
            case 170: {
                token = this.jj_consume_token(170);
                break;
            }
            case 171: {
                token = this.jj_consume_token(171);
                break;
            }
            case 172: {
                token = this.jj_consume_token(172);
                break;
            }
            case 173: {
                token = this.jj_consume_token(173);
                break;
            }
            case 174: {
                token = this.jj_consume_token(174);
                break;
            }
            case 175: {
                token = this.jj_consume_token(175);
                break;
            }
            case 176: {
                token = this.jj_consume_token(176);
                break;
            }
            case 177: {
                token = this.jj_consume_token(177);
                break;
            }
            case 178: {
                token = this.jj_consume_token(178);
                break;
            }
            case 179: {
                token = this.jj_consume_token(179);
                break;
            }
            case 180: {
                token = this.jj_consume_token(180);
                break;
            }
            case 181: {
                token = this.jj_consume_token(181);
                break;
            }
            case 182: {
                token = this.jj_consume_token(182);
                break;
            }
            case 183: {
                token = this.jj_consume_token(183);
                break;
            }
            case 184: {
                token = this.jj_consume_token(184);
                break;
            }
            case 185: {
                token = this.jj_consume_token(185);
                break;
            }
            case 186: {
                token = this.jj_consume_token(186);
                break;
            }
            case 187: {
                token = this.jj_consume_token(187);
                break;
            }
            case 188: {
                token = this.jj_consume_token(188);
                break;
            }
            case 189: {
                token = this.jj_consume_token(189);
                break;
            }
            case 190: {
                token = this.jj_consume_token(190);
                break;
            }
            case 191: {
                token = this.jj_consume_token(191);
                break;
            }
            case 192: {
                token = this.jj_consume_token(192);
                break;
            }
            case 193: {
                token = this.jj_consume_token(193);
                break;
            }
            case 194: {
                token = this.jj_consume_token(194);
                break;
            }
            case 195: {
                token = this.jj_consume_token(195);
                break;
            }
            case 196: {
                token = this.jj_consume_token(196);
                break;
            }
            case 197: {
                token = this.jj_consume_token(197);
                break;
            }
            case 198: {
                token = this.jj_consume_token(198);
                break;
            }
            case 199: {
                token = this.jj_consume_token(199);
                break;
            }
            case 200: {
                token = this.jj_consume_token(200);
                break;
            }
            case 201: {
                token = this.jj_consume_token(201);
                break;
            }
            case 202: {
                token = this.jj_consume_token(202);
                break;
            }
            case 203: {
                token = this.jj_consume_token(203);
                break;
            }
            case 204: {
                token = this.jj_consume_token(204);
                break;
            }
            case 205: {
                token = this.jj_consume_token(205);
                break;
            }
            case 206: {
                token = this.jj_consume_token(206);
                break;
            }
            case 207: {
                token = this.jj_consume_token(207);
                break;
            }
            case 208: {
                token = this.jj_consume_token(208);
                break;
            }
            case 209: {
                token = this.jj_consume_token(209);
                break;
            }
            case 210: {
                token = this.jj_consume_token(210);
                break;
            }
            case 211: {
                token = this.jj_consume_token(211);
                break;
            }
            case 212: {
                token = this.jj_consume_token(212);
                break;
            }
            case 213: {
                token = this.jj_consume_token(213);
                break;
            }
            case 214: {
                token = this.jj_consume_token(214);
                break;
            }
            case 215: {
                token = this.jj_consume_token(215);
                break;
            }
            case 216: {
                token = this.jj_consume_token(216);
                break;
            }
            case 217: {
                token = this.jj_consume_token(217);
                break;
            }
            case 218: {
                token = this.jj_consume_token(218);
                break;
            }
            case 219: {
                token = this.jj_consume_token(219);
                break;
            }
            case 220: {
                token = this.jj_consume_token(220);
                break;
            }
            case 221: {
                token = this.jj_consume_token(221);
                break;
            }
            case 222: {
                token = this.jj_consume_token(222);
                break;
            }
            case 223: {
                token = this.jj_consume_token(223);
                break;
            }
            case 224: {
                token = this.jj_consume_token(224);
                break;
            }
            case 225: {
                token = this.jj_consume_token(225);
                break;
            }
            case 226: {
                token = this.jj_consume_token(226);
                break;
            }
            case 227: {
                token = this.jj_consume_token(227);
                break;
            }
            case 228: {
                token = this.jj_consume_token(228);
                break;
            }
            case 229: {
                token = this.jj_consume_token(229);
                break;
            }
            case 231: {
                token = this.jj_consume_token(231);
                break;
            }
            case 232: {
                token = this.jj_consume_token(232);
                break;
            }
            case 233: {
                token = this.jj_consume_token(233);
                break;
            }
            case 234: {
                token = this.jj_consume_token(234);
                break;
            }
            case 235: {
                token = this.jj_consume_token(235);
                break;
            }
            case 236: {
                token = this.jj_consume_token(236);
                break;
            }
            case 241: {
                token = this.jj_consume_token(241);
                break;
            }
            case 246: {
                token = this.jj_consume_token(246);
                break;
            }
            case 247: {
                token = this.jj_consume_token(247);
                break;
            }
            case 248: {
                token = this.jj_consume_token(248);
                break;
            }
            case 249: {
                token = this.jj_consume_token(249);
                break;
            }
            case 250: {
                token = this.jj_consume_token(250);
                break;
            }
            case 251: {
                token = this.jj_consume_token(251);
                break;
            }
            case 271: {
                token = this.jj_consume_token(271);
                break;
            }
            case 272: {
                token = this.jj_consume_token(272);
                break;
            }
            case 273: {
                token = this.jj_consume_token(273);
                break;
            }
            case 274: {
                token = this.jj_consume_token(274);
                break;
            }
            case 275: {
                token = this.jj_consume_token(275);
                break;
            }
            case 276: {
                token = this.jj_consume_token(276);
                break;
            }
            case 252: {
                token = this.jj_consume_token(252);
                break;
            }
            case 253: {
                token = this.jj_consume_token(253);
                break;
            }
            case 254: {
                token = this.jj_consume_token(254);
                break;
            }
            case 255: {
                token = this.jj_consume_token(255);
                break;
            }
            case 256: {
                token = this.jj_consume_token(256);
                break;
            }
            case 257: {
                token = this.jj_consume_token(257);
                break;
            }
            case 258: {
                token = this.jj_consume_token(258);
                break;
            }
            case 259: {
                token = this.jj_consume_token(259);
                break;
            }
            case 260: {
                token = this.jj_consume_token(260);
                break;
            }
            case 261: {
                token = this.jj_consume_token(261);
                break;
            }
            case 262: {
                token = this.jj_consume_token(262);
                break;
            }
            case 263: {
                token = this.jj_consume_token(263);
                break;
            }
            case 264: {
                token = this.jj_consume_token(264);
                break;
            }
            case 265: {
                token = this.jj_consume_token(265);
                break;
            }
            case 266: {
                token = this.jj_consume_token(266);
                break;
            }
            case 267: {
                token = this.jj_consume_token(267);
                break;
            }
            case 268: {
                token = this.jj_consume_token(268);
                break;
            }
            case 269: {
                token = this.jj_consume_token(269);
                break;
            }
            case 270: {
                token = this.jj_consume_token(270);
                break;
            }
            case 277: {
                token = this.jj_consume_token(277);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token;
    }

    public final SelectColumn select_column() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 264: {
                SelectColumn col = this.asterisk_column();
                return col;
            }
        }
        this.jj_la1[20] = this.jj_gen;
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            SelectColumn col = this.dot_column();
            return col;
        }
        if (this.jj_2_2(1)) {
            SelectColumn col = this.expr_column();
            return col;
        }
        ParseException pe = this.generateParseException();
        pe.prependImqMessage("Incorrect select column, ", 12);
        throw pe;
    }

    public final SelectColumn asterisk_column() throws ParseException {
        this.jj_consume_token(264);
        if (this.getToken((int)1).kind != 250 && this.getToken((int)1).kind != 95) {
            ParseException pe = this.generateParseException();
            String strTok = this.getToken(1).toString();
            String msg = "Incorrect select column, " + eol + "* cannot be followed by '" + strTok + "'";
            pe.prependImqMessage(msg, 12);
            throw pe;
        }
        return new StarColumn();
    }

    public final SelectColumn dot_column() throws ParseException {
        String tableName = null;
        Object colName = null;
        Object aliasName = null;
        Object token = null;
        tableName = this.identifier();
        this.jj_consume_token(249);
        this.asterisk_column();
        return new TableStarColumn(tableName);
    }

    public final SelectColumn expr_column() throws ParseException {
        rttExpr expr = null;
        String aliasName = null;
        expr = this.expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 14: 
            case 242: {
                aliasName = this.alias();
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        return new ExprColumn(expr, aliasName, '\u0001');
    }

    public final String alias() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
            }
        }
        String aliasName = this.identifier();
        return aliasName;
    }

    public final rttExprCond cond_exp() throws ParseException {
        rttExprCond leftExpr = null;
        rttExprCond rightExpr = null;
        try {
            leftExpr = this.cond_term();
        }
        catch (ParseException pe) {
            pe.prependImqMessage("Incorrect conditional expression, ", 1);
            throw pe;
        }
        catch (TokenMgrError tme) {
            ParseException pe = this.generateParseException();
            String msg = "Incorrect conditional expression, \n" + tme.getMessage();
            pe.prependImqMessage(msg, 1);
            throw pe;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 153: {
                this.jj_consume_token(153);
                rightExpr = this.cond_exp();
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
            }
        }
        if (rightExpr != null) {
            return new rttExprCondOr(leftExpr, rightExpr);
        }
        return leftExpr;
    }

    public final rttExprCond cond_term() throws ParseException {
        rttExprCond leftExpr = null;
        rttExprCond rightExpr = null;
        leftExpr = this.cond_factor();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                rightExpr = this.cond_term();
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
            }
        }
        if (rightExpr != null) {
            return new rttExprCondAnd(leftExpr, rightExpr);
        }
        return leftExpr;
    }

    public final rttExprCond cond_factor() throws ParseException {
        rttExprCond expr = null;
        boolean notFlag = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 143: {
                this.jj_consume_token(143);
                notFlag = true;
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        expr = this.cond_test();
        if (notFlag) {
            return new rttExprCondNot(expr);
        }
        return expr;
    }

    public final rttExprCond cond_test() throws ParseException {
        boolean trueFlag = true;
        boolean notFlag = false;
        rttExprCond expr = this.cond_primary();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 119: {
                this.jj_consume_token(119);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 143: {
                        this.jj_consume_token(143);
                        notFlag = true;
                        break;
                    }
                    default: {
                        this.jj_la1[26] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 205: {
                        this.jj_consume_token(205);
                        break block0;
                    }
                    case 88: {
                        this.jj_consume_token(88);
                        trueFlag = false;
                        break block0;
                    }
                }
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
            }
        }
        boolean isTrue = trueFlag && !notFlag || !trueFlag && notFlag;
        return new rttExprCondTest(expr, isTrue);
    }

    public final rttExprCond cond_primary() throws ParseException {
        try {
            if (this.jj_2_3(Integer.MAX_VALUE)) {
                rttExprCond expr = this.simple_cond();
                return expr;
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 260: {
                    this.jj_consume_token(260);
                    rttExprCond expr = this.cond_exp();
                    this.jj_consume_token(261);
                    return expr;
                }
            }
            this.jj_la1[29] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        catch (ParseException pe) {
            pe.prependImqMessage("Expected one of [like|null|between|in|comparison] condition, ", 2);
            throw pe;
        }
        catch (TokenMgrError tme) {
            ParseException pe = this.generateParseException();
            String msg = "Incorrect conditional expression, \n" + tme.getMessage();
            pe.prependImqMessage(msg, 2);
            throw pe;
        }
    }

    public final rttExprCond simple_cond() throws ParseException {
        if (this.jj_2_4(Integer.MAX_VALUE)) {
            rttExprCondLike expr = this.like_cond();
            return expr;
        }
        if (this.jj_2_5(Integer.MAX_VALUE)) {
            rttExprCondNull expr = this.null_cond();
            return expr;
        }
        if (this.jj_2_6(Integer.MAX_VALUE)) {
            rttExprCondBetween expr = this.between_cond();
            return expr;
        }
        if (this.jj_2_7(Integer.MAX_VALUE)) {
            rttExprCondIn expr = this.in_cond();
            return expr;
        }
        if (this.jj_2_8(1)) {
            rttExprCondComp expr = this.comparison_cond();
            return expr;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final rttExprCondLike like_cond() throws ParseException {
        rttExprString leftExpr = null;
        rttExprString rightExpr = null;
        boolean notLike = false;
        char escapeChar = '\u0000';
        Token escapeToken = null;
        leftExpr = this.string_exp();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 143: {
                this.jj_consume_token(143);
                notLike = true;
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
            }
        }
        this.jj_consume_token(128);
        rightExpr = this.string_exp();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 80: {
                this.jj_consume_token(80);
                escapeToken = this.jj_consume_token(241);
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
            }
        }
        if (escapeToken != null) {
            String escapeStr = escapeToken.toString();
            if (escapeStr.length() > 3) {
                String msg = "Invalid escape character " + escapeStr + " has been specified in a LIKE conditional";
                ParseException pe = this.generateParseException();
                pe.prependImqMessage(msg, 14);
                throw pe;
            }
            escapeChar = escapeToken.toString().charAt(1);
        }
        return new rttExprCondLike(leftExpr, rightExpr, notLike, escapeChar);
    }

    public final rttExprCondNull null_cond() throws ParseException {
        rttExpr expr = null;
        boolean notFlag = false;
        try {
            expr = this.row_constructor();
            this.jj_consume_token(119);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 143: {
                    this.jj_consume_token(143);
                    notFlag = true;
                    break;
                }
                default: {
                    this.jj_la1[32] = this.jj_gen;
                }
            }
            this.jj_consume_token(144);
            return new rttExprCondNull(expr, notFlag);
        }
        catch (ParseException pe) {
            pe.prependImqMessage("Unrecognized null condition, ", 9);
            throw pe;
        }
    }

    public final rttExprCondBetween between_cond() throws ParseException {
        boolean notBetween = false;
        rttExpr expr = this.row_constructor();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 143: {
                this.jj_consume_token(143);
                notBetween = true;
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
            }
        }
        this.jj_consume_token(21);
        rttExpr fromExpr = this.row_constructor();
        this.jj_consume_token(11);
        rttExpr toExpr = this.row_constructor();
        return new rttExprCondBetween(expr, fromExpr, toExpr, notBetween);
    }

    public final rttExprCondIn in_cond() throws ParseException {
        rttExpr expr = null;
        List exprList = null;
        boolean notFlag = false;
        expr = this.row_constructor();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 143: {
                this.jj_consume_token(143);
                notFlag = true;
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
            }
        }
        this.jj_consume_token(107);
        this.jj_consume_token(260);
        exprList = this.expression_list();
        this.jj_consume_token(261);
        return new rttExprCondIn(expr, exprList, notFlag);
    }

    public final rttExpr row_constructor() throws ParseException {
        rttExpr expr;
        try {
            expr = this.expression();
        }
        catch (ParseException pe) {
            pe.prependImqMessage("Unrecognized character in operand, ", 8);
            throw pe;
        }
        return expr;
    }

    public final rttExprCondComp comparison_cond() throws ParseException {
        rttExpr leftExpr = this.row_constructor();
        int operatorId = this.comparison_operator();
        rttExpr rightExpr = this.row_constructor();
        return new rttExprCondComp(leftExpr, rightExpr, operatorId);
    }

    public final int comparison_operator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 253: {
                this.jj_consume_token(253);
                return 2;
            }
            case 255: {
                this.jj_consume_token(255);
                return 4;
            }
            case 257: {
                this.jj_consume_token(257);
                return 6;
            }
            case 258: {
                this.jj_consume_token(258);
                return 6;
            }
            case 256: {
                this.jj_consume_token(256);
                return 5;
            }
            case 252: {
                this.jj_consume_token(252);
                return 1;
            }
            case 254: {
                this.jj_consume_token(254);
                return 3;
            }
        }
        this.jj_la1[35] = this.jj_gen;
        ParseException pe = this.generateParseException();
        pe.prependImqMessage("Unrecognized comparison operator, ", 6);
        throw pe;
    }

    public final List expression_list() throws ParseException {
        LinkedList<rttExpr> list = new LinkedList<rttExpr>();
        rttExpr expr = null;
        expr = this.expression();
        list.add(expr);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 250: {
                    break;
                }
                default: {
                    this.jj_la1[36] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(250);
            expr = this.expression();
            list.add(expr);
        }
        return list;
    }

    public final rttExpr expression() throws ParseException {
        rttExprRef expr = null;
        rttExprNum numExpr = null;
        Object strExpr = null;
        if (this.jj_2_9(Integer.MAX_VALUE)) {
            numExpr = this.numeric_exp();
            rttExprColumnref colrefExpr = numExpr.getColumnrefExpr();
            if (colrefExpr != null) {
                return colrefExpr;
            }
            return numExpr;
        }
        if (this.isValidDate(this.getToken((int)1).image)) {
            expr = this.date_exp();
            return expr;
        }
        if (this.jj_2_10(Integer.MAX_VALUE)) {
            expr = this.date_exp();
            return expr;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 10: 
            case 14: 
            case 15: 
            case 27: 
            case 31: 
            case 52: 
            case 60: 
            case 69: 
            case 77: 
            case 90: 
            case 95: 
            case 113: 
            case 121: 
            case 124: 
            case 130: 
            case 149: 
            case 154: 
            case 181: 
            case 209: 
            case 210: 
            case 234: 
            case 235: 
            case 236: 
            case 241: 
            case 242: 
            case 260: {
                expr = this.string_exp();
                return expr;
            }
        }
        this.jj_la1[37] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final rttExprNum numeric_exp() throws ParseException {
        Token operTok = null;
        String operator = null;
        rttExprNum leftExpr = null;
        rttExprNum rightExpr = null;
        leftExpr = this.numeric_term();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 247: 
            case 266: 
            case 267: 
            case 268: 
            case 271: 
            case 272: 
            case 274: 
            case 275: 
            case 276: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 266: {
                        operTok = this.jj_consume_token(266);
                        break;
                    }
                    case 267: {
                        operTok = this.jj_consume_token(267);
                        break;
                    }
                    case 247: {
                        operTok = this.jj_consume_token(247);
                        break;
                    }
                    case 268: {
                        operTok = this.jj_consume_token(268);
                        break;
                    }
                    case 271: {
                        operTok = this.jj_consume_token(271);
                        break;
                    }
                    case 272: {
                        operTok = this.jj_consume_token(272);
                        break;
                    }
                    case 274: {
                        operTok = this.jj_consume_token(274);
                        break;
                    }
                    case 275: {
                        operTok = this.jj_consume_token(275);
                        break;
                    }
                    case 276: {
                        operTok = this.jj_consume_token(276);
                        break;
                    }
                    default: {
                        this.jj_la1[38] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                rightExpr = this.numeric_exp();
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
            }
        }
        if (operTok == null || this.isNullRttExpr(leftExpr)) {
            return leftExpr;
        }
        if (this.isNullRttExpr(rightExpr)) {
            return rightExpr;
        }
        switch (operator = operTok.toString().trim()) {
            case "+": 
            case "||": {
                return new rttExprNumBinaryAdd(leftExpr, rightExpr);
            }
            case "-": {
                return new rttExprNumBinarySub(leftExpr, rightExpr);
            }
            case "%": {
                return new rttExprNumBinaryModulus(leftExpr, rightExpr);
            }
            case "&": 
            case "|": 
            case "^": 
            case "<<": 
            case ">>": {
                return new rttExprNumBitwiseOp(leftExpr, rightExpr, operator);
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final rttExprNum numeric_term() throws ParseException {
        Token operTok = null;
        String operator = null;
        rttExprNum leftExpr = null;
        rttExprNum rightExpr = null;
        leftExpr = this.numeric_factor();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 264: 
            case 265: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 264: {
                        operTok = this.jj_consume_token(264);
                        break;
                    }
                    case 265: {
                        operTok = this.jj_consume_token(265);
                        break;
                    }
                    default: {
                        this.jj_la1[40] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                rightExpr = this.numeric_term();
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
            }
        }
        if (operTok == null || this.isNullRttExpr(leftExpr)) {
            return leftExpr;
        }
        if (this.isNullRttExpr(rightExpr)) {
            return rightExpr;
        }
        operator = operTok.toString().trim();
        if (operator.equals("*")) {
            return new rttExprNumBinaryMult(leftExpr, rightExpr);
        }
        return new rttExprNumBinaryDiv(leftExpr, rightExpr);
    }

    public final rttExprNum numeric_factor() throws ParseException {
        boolean minusFlag = false;
        boolean bitwiseNot = false;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 266: 
            case 267: 
            case 273: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 266: {
                        this.jj_consume_token(266);
                        break block0;
                    }
                    case 267: {
                        this.jj_consume_token(267);
                        minusFlag = true;
                        break block0;
                    }
                    case 273: {
                        this.jj_consume_token(273);
                        bitwiseNot = true;
                        break block0;
                    }
                }
                this.jj_la1[42] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
            }
        }
        rttExprNum expr = this.numeric_primary();
        if (minusFlag) {
            expr = new rttExprNumMinus(expr);
        }
        if (bitwiseNot) {
            expr = new rttExprNumBitwiseOp(expr, expr, "~");
        }
        return expr;
    }

    public final String castTypeIdentifier() throws ParseException {
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 22: {
                    Token token = this.jj_consume_token(22);
                    return this.getToken(0).toString();
                }
                case 23: {
                    Token token = this.jj_consume_token(23);
                    return this.getToken(0).toString();
                }
                case 24: {
                    Token token = this.jj_consume_token(24);
                    return this.getToken(0).toString();
                }
                case 60: {
                    Token token = this.jj_consume_token(60);
                    return this.getToken(0).toString();
                }
                case 64: {
                    Token token = this.jj_consume_token(64);
                    return this.getToken(0).toString();
                }
                case 76: {
                    Token token = this.jj_consume_token(76);
                    return this.getToken(0).toString();
                }
                case 115: {
                    Token token = this.jj_consume_token(115);
                    return this.getToken(0).toString();
                }
                case 195: {
                    Token token = this.jj_consume_token(195);
                    return this.getToken(0).toString();
                }
                case 196: {
                    Token token = this.jj_consume_token(196);
                    return this.getToken(0).toString();
                }
                case 216: {
                    Token token = this.jj_consume_token(216);
                    return this.getToken(0).toString();
                }
            }
            this.jj_la1[44] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        catch (ParseException pe) {
            String msg = "Unsupported cast type: " + this.getToken(0).toString();
            pe.prependImqMessage(msg, 1);
            throw pe;
        }
    }

    public final rttExprNum numeric_primary() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 31: {
                this.jj_consume_token(31);
                this.jj_consume_token(260);
                rttExprNum expr = this.numeric_exp();
                this.jj_consume_token(14);
                String castType = this.castTypeIdentifier();
                this.jj_consume_token(261);
                return new rttExprNumCast(expr, castType);
            }
            case 260: {
                this.jj_consume_token(260);
                rttExprNum expr = this.numeric_exp();
                this.jj_consume_token(261);
                return expr;
            }
            case 228: {
                Token numToken = this.jj_consume_token(228);
                Long lval = new Long(numToken.toString());
                rttExprNum expr = new rttExprNum(lval);
                return expr;
            }
            case 229: {
                Token numToken = this.jj_consume_token(229);
                Double dval = new Double(numToken.toString());
                rttExprNum expr = new rttExprNum(dval);
                return expr;
            }
            case 144: {
                Token numToken = this.jj_consume_token(144);
                return new rttExprNum((Object)null);
            }
            case 241: {
                Token numToken = this.jj_consume_token(241);
                return new rttExprNum(this.stripStringLiteral(numToken.toString()));
            }
            case 19: 
            case 51: 
            case 132: 
            case 133: 
            case 191: {
                rttExprNumAggr expr = this.aggregate_func();
                return expr;
            }
            case 10: 
            case 14: 
            case 15: 
            case 27: 
            case 52: 
            case 60: 
            case 69: 
            case 77: 
            case 90: 
            case 95: 
            case 113: 
            case 121: 
            case 124: 
            case 149: 
            case 154: 
            case 181: 
            case 209: 
            case 242: {
                rttExprColumnref colRefExpr = this.column_ref();
                return new rttExprNum(colRefExpr);
            }
        }
        this.jj_la1[45] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final rttExprNumAggr aggregate_func() throws ParseException {
        boolean distinctFlag = false;
        rttExprNum numExpr = null;
        rttExprNumAggr aggrExpr = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 51: {
                this.jj_consume_token(51);
                this.jj_consume_token(260);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 264: {
                        this.jj_consume_token(264);
                        aggrExpr = new rttExprNumAggrCountstar();
                        break;
                    }
                    case 8: 
                    case 10: 
                    case 14: 
                    case 15: 
                    case 19: 
                    case 27: 
                    case 31: 
                    case 51: 
                    case 52: 
                    case 60: 
                    case 69: 
                    case 74: 
                    case 77: 
                    case 90: 
                    case 95: 
                    case 113: 
                    case 121: 
                    case 124: 
                    case 132: 
                    case 133: 
                    case 144: 
                    case 149: 
                    case 154: 
                    case 181: 
                    case 191: 
                    case 209: 
                    case 228: 
                    case 229: 
                    case 241: 
                    case 242: 
                    case 260: 
                    case 266: 
                    case 267: 
                    case 273: {
                        block8 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 8: 
                            case 74: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 8: {
                                        this.jj_consume_token(8);
                                        break block8;
                                    }
                                    case 74: {
                                        this.jj_consume_token(74);
                                        distinctFlag = true;
                                        break block8;
                                    }
                                }
                                this.jj_la1[46] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                            default: {
                                this.jj_la1[47] = this.jj_gen;
                            }
                        }
                        numExpr = this.numeric_exp();
                        aggrExpr = new rttExprNumAggrCount(numExpr, distinctFlag);
                        break;
                    }
                    default: {
                        this.jj_la1[48] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(261);
                return aggrExpr;
            }
            case 19: 
            case 132: 
            case 133: 
            case 191: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 19: {
                        this.jj_consume_token(19);
                        aggrExpr = new rttExprNumAggrAvg();
                        break;
                    }
                    case 191: {
                        this.jj_consume_token(191);
                        aggrExpr = new rttExprNumAggrSum();
                        break;
                    }
                    case 133: {
                        this.jj_consume_token(133);
                        aggrExpr = new rttExprNumAggrMin();
                        break;
                    }
                    case 132: {
                        this.jj_consume_token(132);
                        aggrExpr = new rttExprNumAggrMax();
                        break;
                    }
                    default: {
                        this.jj_la1[49] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(260);
                block21 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 8: 
                    case 74: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 8: {
                                this.jj_consume_token(8);
                                break block21;
                            }
                            case 74: {
                                this.jj_consume_token(74);
                                distinctFlag = true;
                                break block21;
                            }
                        }
                        this.jj_la1[50] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[51] = this.jj_gen;
                    }
                }
                numExpr = this.numeric_exp();
                this.jj_consume_token(261);
                aggrExpr.setNumExpr(numExpr);
                if (distinctFlag) {
                    aggrExpr.setDistinctFlag();
                }
                return aggrExpr;
            }
        }
        this.jj_la1[52] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final rttExprString string_exp() throws ParseException {
        rttExprString rightExpr = null;
        rttExprString leftExpr = this.string_term();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 247: 
            case 266: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 266: {
                        this.jj_consume_token(266);
                        break;
                    }
                    case 247: {
                        this.jj_consume_token(247);
                        break;
                    }
                    default: {
                        this.jj_la1[53] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                rightExpr = this.string_exp();
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
            }
        }
        if (rightExpr != null) {
            return new rttExprStringConcat(leftExpr, rightExpr);
        }
        return leftExpr;
    }

    public final rttExprString string_term() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 260: {
                this.jj_consume_token(260);
                rttExprString expr = this.string_exp();
                this.jj_consume_token(261);
                return expr;
            }
            case 210: {
                this.jj_consume_token(210);
                this.jj_consume_token(260);
                rttExprString expr = this.string_exp();
                this.jj_consume_token(261);
                expr.setMode(1);
                return expr;
            }
            case 130: {
                this.jj_consume_token(130);
                this.jj_consume_token(260);
                rttExprString expr = this.string_exp();
                this.jj_consume_token(261);
                expr.setMode(2);
                return expr;
            }
            case 31: {
                this.jj_consume_token(31);
                this.jj_consume_token(260);
                rttExprString expr = this.string_exp();
                this.jj_consume_token(14);
                String castType = this.castTypeIdentifier();
                this.jj_consume_token(261);
                return new rttExprStringCast(expr, castType);
            }
            case 234: 
            case 235: 
            case 236: 
            case 241: {
                String str = this.string_literal();
                return new rttExprString(str);
            }
            case 10: 
            case 14: 
            case 15: 
            case 27: 
            case 52: 
            case 60: 
            case 69: 
            case 77: 
            case 90: 
            case 95: 
            case 113: 
            case 121: 
            case 124: 
            case 149: 
            case 154: 
            case 181: 
            case 209: 
            case 242: {
                rttExprColumnref colRefExpr = this.column_ref();
                return new rttExprString(colRefExpr, 0);
            }
        }
        this.jj_la1[55] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String string_literal() throws ParseException {
        Token token = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 234: {
                token = this.jj_consume_token(234);
                return token.toString();
            }
            case 236: {
                token = this.jj_consume_token(236);
                return token.toString();
            }
            case 235: {
                token = this.jj_consume_token(235);
                return token.toString();
            }
            case 241: {
                token = this.jj_consume_token(241);
                return this.stripStringLiteral(token.toString());
            }
        }
        this.jj_la1[56] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final rttExprDate date_exp() throws ParseException {
        rttExprDate expr = this.date_primary();
        return expr;
    }

    public final rttExprDate date_primary() throws ParseException {
        String type = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 260: {
                this.jj_consume_token(260);
                rttExprDate expr = this.date_exp();
                this.jj_consume_token(261);
                return expr;
            }
            case 31: {
                this.jj_consume_token(31);
                this.jj_consume_token(260);
                rttExprDate expr = this.date_exp();
                this.jj_consume_token(14);
                type = this.castTypeIdentifier();
                this.jj_consume_token(261);
                return new rttExprDateCast(expr, type);
            }
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: {
                rttExprDate expr = this.datetime_literal();
                return expr;
            }
            case 10: 
            case 14: 
            case 15: 
            case 27: 
            case 52: 
            case 60: 
            case 69: 
            case 77: 
            case 90: 
            case 95: 
            case 113: 
            case 121: 
            case 124: 
            case 149: 
            case 154: 
            case 181: 
            case 209: 
            case 242: {
                rttExprColumnref colRefExpr = this.column_ref();
                return new rttExprDate(colRefExpr);
            }
        }
        this.jj_la1[57] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final rttExprDate datetime_literal() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 234: {
                rttExprTimestamp expr = this.sql_timestamp_literal();
                return expr;
            }
            case 235: {
                rttExprDate expr = this.sql_date_literal();
                return expr;
            }
            case 236: {
                rttExprTime expr = this.sql_time_literal();
                return expr;
            }
            case 232: {
                rttExprDate expr = this.odbc_date_literal();
                return expr;
            }
            case 233: {
                rttExprTime expr = this.odbc_time_literal();
                return expr;
            }
            case 231: {
                rttExprTimestamp expr = this.odbc_timestamp_literal();
                return expr;
            }
        }
        this.jj_la1[58] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final rttExprDate sql_date_literal() throws ParseException {
        Token token = this.jj_consume_token(235);
        return new rttExprDate(token.toString());
    }

    public final rttExprTime sql_time_literal() throws ParseException {
        Token token = this.jj_consume_token(236);
        return new rttExprTime(token.toString());
    }

    public final rttExprTimestamp sql_timestamp_literal() throws ParseException {
        Token token = this.jj_consume_token(234);
        return new rttExprTimestamp(token.toString());
    }

    public final rttExprDate odbc_date_literal() throws ParseException {
        Token token = this.jj_consume_token(232);
        return new rttExprDate(token.toString());
    }

    public final rttExprTime odbc_time_literal() throws ParseException {
        Token token = this.jj_consume_token(233);
        return new rttExprTime(token.toString());
    }

    public final rttExprTimestamp odbc_timestamp_literal() throws ParseException {
        Token token = this.jj_consume_token(231);
        return new rttExprTimestamp(token.toString());
    }

    public final rttExprColumnref column_ref() throws ParseException {
        String tableName = null;
        String colName = null;
        tableName = this.extendedIdentifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 249: {
                this.jj_consume_token(249);
                colName = this.extendedIdentifier();
                break;
            }
            default: {
                this.jj_la1[59] = this.jj_gen;
            }
        }
        if (colName == null) {
            colName = tableName;
            tableName = null;
        }
        rttExprColumnref expr = new rttExprColumnref(tableName, colName);
        return expr;
    }

    public final String TableIdentifier() throws ParseException {
        Token token = null;
        String name = null;
        token = this.consumeVariableANDTokens();
        name = token.toString();
        if (name.charAt(0) == '[') {
            name = name.substring(1, name.length() - 1);
        }
        return name;
    }

    public final String identifier() throws ParseException {
        Token token = null;
        String name = null;
        token = this.jj_consume_token(242);
        name = token.toString();
        if (name.charAt(0) == '[') {
            name = name.substring(1, name.length() - 1);
        }
        return name;
    }

    public final String extendedIdentifier() throws ParseException {
        Token token = null;
        String name = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 242: {
                token = this.jj_consume_token(242);
                break;
            }
            case 90: {
                token = this.jj_consume_token(90);
                break;
            }
            case 124: {
                token = this.jj_consume_token(124);
                break;
            }
            case 60: {
                token = this.jj_consume_token(60);
                break;
            }
            case 181: {
                token = this.jj_consume_token(181);
                break;
            }
            case 95: {
                token = this.jj_consume_token(95);
                break;
            }
            case 154: {
                token = this.jj_consume_token(154);
                break;
            }
            case 27: {
                token = this.jj_consume_token(27);
                break;
            }
            case 14: {
                token = this.jj_consume_token(14);
                break;
            }
            case 121: {
                token = this.jj_consume_token(121);
                break;
            }
            case 149: {
                token = this.jj_consume_token(149);
                break;
            }
            case 15: {
                token = this.jj_consume_token(15);
                break;
            }
            case 69: {
                token = this.jj_consume_token(69);
                break;
            }
            case 113: {
                token = this.jj_consume_token(113);
                break;
            }
            case 209: {
                token = this.jj_consume_token(209);
                break;
            }
            case 10: {
                token = this.jj_consume_token(10);
                break;
            }
            case 52: {
                token = this.jj_consume_token(52);
                break;
            }
            case 77: {
                token = this.jj_consume_token(77);
                break;
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        name = token.toString();
        if (name.charAt(0) == '[') {
            name = name.substring(1, name.length() - 1);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    private boolean jj_3R_string_exp_1708_6_41() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(266)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(247)) {
                return true;
            }
        }
        return this.jj_3R_string_exp_1707_5_20();
    }

    private boolean jj_3R_numeric_term_1519_3_28() {
        if (this.jj_3R_numeric_factor_1549_3_43()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_numeric_term_1519_32_44()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_string_exp_1707_5_20() {
        if (this.jj_3R_string_term_1732_4_40()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_string_exp_1708_6_41()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_sql_time_literal_1898_3_47() {
        return this.jj_scan_token(236);
    }

    private boolean jj_3R_aggregate_func_1674_27_114() {
        return this.jj_scan_token(74);
    }

    private boolean jj_3R_in_cond_1312_3_11() {
        if (this.jj_3R_row_constructor_1332_5_23()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_in_cond_1312_29_26()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(107)) {
            return true;
        }
        if (this.jj_scan_token(260)) {
            return true;
        }
        if (this.jj_3R_expression_list_1421_5_27()) {
            return true;
        }
        return this.jj_scan_token(261);
    }

    private boolean jj_3R_sql_date_literal_1882_4_46() {
        return this.jj_scan_token(235);
    }

    private boolean jj_3R_aggregate_func_1674_19_112() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(8)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_aggregate_func_1674_27_114()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_extendedIdentifier_2071_2_101() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(242)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(90)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(124)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(60)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(181)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(95)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(154)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(27)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(14)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(121)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(149)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(15)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(69)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(113)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(209)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_scan_token(10)) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_scan_token(52)) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_scan_token(77)) {
                                                                                return true;
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_null_cond_1273_34_24() {
        return this.jj_scan_token(143);
    }

    private boolean jj_3R_between_cond_1294_6_25() {
        return this.jj_scan_token(143);
    }

    private boolean jj_3R_aggregate_func_1673_7_111() {
        return this.jj_scan_token(132);
    }

    private boolean jj_3R_between_cond_1293_5_10() {
        if (this.jj_3R_row_constructor_1332_5_23()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_between_cond_1294_6_25()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(21)) {
            return true;
        }
        if (this.jj_3R_row_constructor_1332_5_23()) {
            return true;
        }
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_3R_row_constructor_1332_5_23();
    }

    private boolean jj_3R_aggregate_func_1672_7_110() {
        return this.jj_scan_token(133);
    }

    private boolean jj_3R_numeric_exp_1482_6_29() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(266)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(267)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(247)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(268)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(271)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(272)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(274)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(275)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(276)) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return this.jj_3R_numeric_exp_1481_2_13();
    }

    private boolean jj_3R_aggregate_func_1671_7_109() {
        return this.jj_scan_token(191);
    }

    private boolean jj_3R_aggregate_func_1670_8_108() {
        return this.jj_scan_token(19);
    }

    private boolean jj_3R_datetime_literal_1865_4_35() {
        return this.jj_3R_odbc_timestamp_literal_1988_3_50();
    }

    private boolean jj_3R_aggregate_func_1661_16_115() {
        return this.jj_scan_token(74);
    }

    private boolean jj_3R_aggregate_func_1670_5_105() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_aggregate_func_1670_8_108()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_aggregate_func_1671_7_109()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_aggregate_func_1672_7_110()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_aggregate_func_1673_7_111()) {
                        return true;
                    }
                }
            }
        }
        if (this.jj_scan_token(260)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_aggregate_func_1674_19_112()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_numeric_exp_1481_2_13()) {
            return true;
        }
        return this.jj_scan_token(261);
    }

    private boolean jj_3R_numeric_exp_1481_2_13() {
        if (this.jj_3R_numeric_term_1519_3_28()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_numeric_exp_1482_6_29()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_datetime_literal_1861_4_34() {
        return this.jj_3R_odbc_time_literal_1973_3_49();
    }

    private boolean jj_3R_aggregate_func_1661_10_113() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(8)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_aggregate_func_1661_16_115()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_aggregate_func_1661_9_107() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_aggregate_func_1661_10_113()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_numeric_exp_1481_2_13();
    }

    private boolean jj_3R_datetime_literal_1857_4_33() {
        return this.jj_3R_odbc_date_literal_1957_3_48();
    }

    private boolean jj_3R_aggregate_func_1657_9_106() {
        return this.jj_scan_token(264);
    }

    private boolean jj_3R_column_ref_2011_37_102() {
        if (this.jj_scan_token(249)) {
            return true;
        }
        return this.jj_3R_extendedIdentifier_2071_2_101();
    }

    private boolean jj_3R_datetime_literal_1853_3_32() {
        return this.jj_3R_sql_time_literal_1898_3_47();
    }

    private boolean jj_3_10() {
        return this.jj_3R_datetime_literal_1843_3_14();
    }

    private boolean jj_3R_datetime_literal_1848_3_31() {
        return this.jj_3R_sql_date_literal_1882_4_46();
    }

    private boolean jj_3R_aggregate_func_1655_4_104() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_scan_token(260)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_aggregate_func_1657_9_106()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_aggregate_func_1661_9_107()) {
                return true;
            }
        }
        return this.jj_scan_token(261);
    }

    private boolean jj_3R_aggregate_func_1655_4_103() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_aggregate_func_1655_4_104()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_aggregate_func_1670_5_105()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_expression_1461_6_39() {
        return this.jj_3R_string_exp_1707_5_20();
    }

    private boolean jj_3R_null_cond_1272_1_9() {
        if (this.jj_3R_row_constructor_1332_5_23()) {
            return true;
        }
        if (this.jj_scan_token(119)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_null_cond_1273_34_24()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(144);
    }

    private boolean jj_3R_datetime_literal_1843_3_30() {
        return this.jj_3R_sql_timestamp_literal_1914_3_45();
    }

    private boolean jj_3R_datetime_literal_1843_3_14() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_datetime_literal_1843_3_30()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_datetime_literal_1848_3_31()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_datetime_literal_1853_3_32()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_datetime_literal_1857_4_33()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_datetime_literal_1861_4_34()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_datetime_literal_1865_4_35()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_expression_1457_5_38() {
        return this.jj_3R_date_exp_1797_4_51();
    }

    private boolean jj_3R_expression_1453_5_37() {
        return this.jj_3R_date_exp_1797_4_51();
    }

    private boolean jj_3R_expr_column_1070_5_6() {
        return this.jj_3R_expression_1442_3_15();
    }

    private boolean jj_3_9() {
        return this.jj_3R_numeric_exp_1481_2_13();
    }

    private boolean jj_3R_date_primary_1826_4_86() {
        return this.jj_3R_column_ref_2011_3_72();
    }

    private boolean jj_3R_numeric_primary_1635_4_82() {
        return this.jj_3R_column_ref_2011_3_72();
    }

    private boolean jj_3R_expression_1442_3_15() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_expression_1442_3_36()) {
            this.jj_scanpos = xsp;
            this.jj_lookingAhead = true;
            this.jj_semLA = this.isValidDate(this.getToken((int)1).image);
            this.jj_lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_expression_1453_5_37()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_expression_1457_5_38()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_expression_1461_6_39()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_expression_1442_3_36() {
        return this.jj_3R_numeric_exp_1481_2_13();
    }

    private boolean jj_3R_date_primary_1822_4_85() {
        return this.jj_3R_datetime_literal_1843_3_14();
    }

    private boolean jj_3R_numeric_primary_1631_4_81() {
        return this.jj_3R_aggregate_func_1655_4_103();
    }

    private boolean jj_3R_numeric_primary_1627_5_80() {
        return this.jj_scan_token(241);
    }

    private boolean jj_3R_column_ref_2011_3_72() {
        if (this.jj_3R_extendedIdentifier_2071_2_101()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_column_ref_2011_37_102()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_date_primary_1818_4_84() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        if (this.jj_scan_token(260)) {
            return true;
        }
        if (this.jj_3R_date_exp_1797_4_51()) {
            return true;
        }
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_3R_castTypeIdentifier_1570_1_70()) {
            return true;
        }
        return this.jj_scan_token(261);
    }

    private boolean jj_3R_like_cond_1243_6_22() {
        if (this.jj_scan_token(80)) {
            return true;
        }
        return this.jj_scan_token(241);
    }

    private boolean jj_3R_like_cond_1241_6_21() {
        return this.jj_scan_token(143);
    }

    private boolean jj_3R_numeric_primary_1623_5_79() {
        return this.jj_scan_token(144);
    }

    private boolean jj_3R_date_primary_1814_4_83() {
        if (this.jj_scan_token(260)) {
            return true;
        }
        if (this.jj_3R_date_exp_1797_4_51()) {
            return true;
        }
        return this.jj_scan_token(261);
    }

    private boolean jj_3R_like_cond_1240_5_8() {
        if (this.jj_3R_string_exp_1707_5_20()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_like_cond_1241_6_21()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(128)) {
            return true;
        }
        if (this.jj_3R_string_exp_1707_5_20()) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_like_cond_1243_6_22()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_date_primary_1814_4_61() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_date_primary_1814_4_83()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_date_primary_1818_4_84()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_date_primary_1822_4_85()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_date_primary_1826_4_86()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_numeric_primary_1617_4_78() {
        return this.jj_scan_token(229);
    }

    private boolean jj_3R_expression_list_1422_6_42() {
        if (this.jj_scan_token(250)) {
            return true;
        }
        return this.jj_3R_expression_1442_3_15();
    }

    private boolean jj_3_7() {
        return this.jj_3R_in_cond_1312_3_11();
    }

    private boolean jj_3_6() {
        return this.jj_3R_between_cond_1293_5_10();
    }

    private boolean jj_3R_expression_list_1421_5_27() {
        Token xsp;
        if (this.jj_3R_expression_1442_3_15()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_expression_list_1422_6_42());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_5() {
        return this.jj_3R_null_cond_1272_1_9();
    }

    private boolean jj_3R_numeric_primary_1611_4_77() {
        return this.jj_scan_token(228);
    }

    private boolean jj_3_4() {
        return this.jj_3R_like_cond_1240_5_8();
    }

    private boolean jj_3R_numeric_primary_1607_4_76() {
        if (this.jj_scan_token(260)) {
            return true;
        }
        if (this.jj_3R_numeric_exp_1481_2_13()) {
            return true;
        }
        return this.jj_scan_token(261);
    }

    private boolean jj_3R_date_exp_1797_4_51() {
        return this.jj_3R_date_primary_1814_4_61();
    }

    private boolean jj_3_8() {
        return this.jj_3R_comparison_cond_1365_2_12();
    }

    private boolean jj_3R_odbc_timestamp_literal_1988_3_50() {
        return this.jj_scan_token(231);
    }

    private boolean jj_3R_simple_cond_1222_4_19() {
        return this.jj_3R_in_cond_1312_3_11();
    }

    private boolean jj_3R_simple_cond_1221_4_18() {
        return this.jj_3R_between_cond_1293_5_10();
    }

    private boolean jj_3R_numeric_primary_1603_3_75() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        if (this.jj_scan_token(260)) {
            return true;
        }
        if (this.jj_3R_numeric_exp_1481_2_13()) {
            return true;
        }
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_3R_castTypeIdentifier_1570_1_70()) {
            return true;
        }
        return this.jj_scan_token(261);
    }

    private boolean jj_3R_simple_cond_1220_4_17() {
        return this.jj_3R_null_cond_1272_1_9();
    }

    private boolean jj_3R_numeric_primary_1603_3_60() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_numeric_primary_1603_3_75()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_numeric_primary_1607_4_76()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_numeric_primary_1611_4_77()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_numeric_primary_1617_4_78()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_numeric_primary_1623_5_79()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_numeric_primary_1627_5_80()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_numeric_primary_1631_4_81()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_numeric_primary_1635_4_82()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_simple_cond_1219_4_16() {
        return this.jj_3R_like_cond_1240_5_8();
    }

    private boolean jj_3R_simple_cond_1219_4_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_simple_cond_1219_4_16()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_simple_cond_1220_4_17()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_simple_cond_1221_4_18()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_simple_cond_1222_4_19()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_8()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(242)) {
            return true;
        }
        if (this.jj_scan_token(249)) {
            return true;
        }
        return this.jj_scan_token(264);
    }

    private boolean jj_3R_odbc_time_literal_1973_3_49() {
        return this.jj_scan_token(233);
    }

    private boolean jj_3R_string_literal_1780_4_100() {
        return this.jj_scan_token(241);
    }

    private boolean jj_3R_string_literal_1777_4_99() {
        return this.jj_scan_token(235);
    }

    private boolean jj_3R_numeric_factor_1549_41_74() {
        return this.jj_scan_token(273);
    }

    private boolean jj_3_2() {
        return this.jj_3R_expr_column_1070_5_6();
    }

    private boolean jj_3_3() {
        return this.jj_3R_simple_cond_1219_4_7();
    }

    private boolean jj_3R_string_literal_1774_4_98() {
        return this.jj_scan_token(236);
    }

    private boolean jj_3R_comparison_operator_1390_5_69() {
        return false;
    }

    private boolean jj_3R_castTypeIdentifier_1580_5_96() {
        return this.jj_scan_token(216);
    }

    private boolean jj_3R_castTypeIdentifier_1579_5_95() {
        return this.jj_scan_token(196);
    }

    private boolean jj_3R_comparison_operator_1389_4_68() {
        return this.jj_scan_token(254);
    }

    private boolean jj_3R_castTypeIdentifier_1578_5_94() {
        return this.jj_scan_token(195);
    }

    private boolean jj_3R_comparison_operator_1388_4_67() {
        return this.jj_scan_token(252);
    }

    private boolean jj_3R_castTypeIdentifier_1577_5_93() {
        return this.jj_scan_token(115);
    }

    private boolean jj_3R_comparison_operator_1387_4_66() {
        return this.jj_scan_token(256);
    }

    private boolean jj_3R_string_literal_1770_2_97() {
        return this.jj_scan_token(234);
    }

    private boolean jj_3R_castTypeIdentifier_1576_5_92() {
        return this.jj_scan_token(76);
    }

    private boolean jj_3R_string_literal_1770_2_71() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_string_literal_1770_2_97()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_string_literal_1774_4_98()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_string_literal_1777_4_99()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_string_literal_1780_4_100()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_comparison_operator_1386_4_65() {
        return this.jj_scan_token(258);
    }

    private boolean jj_3R_castTypeIdentifier_1575_5_91() {
        return this.jj_scan_token(64);
    }

    private boolean jj_3R_comparison_operator_1385_4_64() {
        return this.jj_scan_token(257);
    }

    private boolean jj_3R_castTypeIdentifier_1574_5_90() {
        return this.jj_scan_token(60);
    }

    private boolean jj_3R_comparison_operator_1384_4_63() {
        return this.jj_scan_token(255);
    }

    private boolean jj_3R_castTypeIdentifier_1573_5_89() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_odbc_date_literal_1957_3_48() {
        return this.jj_scan_token(232);
    }

    private boolean jj_3R_castTypeIdentifier_1572_5_88() {
        return this.jj_scan_token(23);
    }

    private boolean jj_3R_comparison_operator_1383_3_52() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_comparison_operator_1383_3_62()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_comparison_operator_1384_4_63()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_comparison_operator_1385_4_64()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_comparison_operator_1386_4_65()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_comparison_operator_1387_4_66()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_comparison_operator_1388_4_67()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_comparison_operator_1389_4_68()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_comparison_operator_1390_5_69()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_comparison_operator_1383_3_62() {
        return this.jj_scan_token(253);
    }

    private boolean jj_3R_castTypeIdentifier_1571_5_87() {
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_castTypeIdentifier_1570_1_70() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_castTypeIdentifier_1571_5_87()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_castTypeIdentifier_1572_5_88()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_castTypeIdentifier_1573_5_89()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_castTypeIdentifier_1574_5_90()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_castTypeIdentifier_1575_5_91()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_castTypeIdentifier_1576_5_92()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_castTypeIdentifier_1577_5_93()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_castTypeIdentifier_1578_5_94()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_castTypeIdentifier_1579_5_95()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_castTypeIdentifier_1580_5_96()) {
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_string_term_1754_4_58() {
        return this.jj_3R_column_ref_2011_3_72();
    }

    private boolean jj_3R_string_term_1750_4_57() {
        return this.jj_3R_string_literal_1770_2_71();
    }

    private boolean jj_3R_numeric_factor_1549_13_73() {
        return this.jj_scan_token(267);
    }

    private boolean jj_3R_string_term_1746_4_56() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        if (this.jj_scan_token(260)) {
            return true;
        }
        if (this.jj_3R_string_exp_1707_5_20()) {
            return true;
        }
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_3R_castTypeIdentifier_1570_1_70()) {
            return true;
        }
        return this.jj_scan_token(261);
    }

    private boolean jj_3R_comparison_cond_1365_2_12() {
        if (this.jj_3R_row_constructor_1332_5_23()) {
            return true;
        }
        if (this.jj_3R_comparison_operator_1383_3_52()) {
            return true;
        }
        return this.jj_3R_row_constructor_1332_5_23();
    }

    private boolean jj_3R_string_term_1741_4_55() {
        if (this.jj_scan_token(130)) {
            return true;
        }
        if (this.jj_scan_token(260)) {
            return true;
        }
        if (this.jj_3R_string_exp_1707_5_20()) {
            return true;
        }
        return this.jj_scan_token(261);
    }

    private boolean jj_3R_numeric_factor_1549_4_59() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(266)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_numeric_factor_1549_13_73()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_numeric_factor_1549_41_74()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_numeric_factor_1549_3_43() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_numeric_factor_1549_4_59()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_numeric_primary_1603_3_60();
    }

    private boolean jj_3R_numeric_term_1519_32_44() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(264)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(265)) {
                return true;
            }
        }
        return this.jj_3R_numeric_term_1519_3_28();
    }

    private boolean jj_3R_string_term_1736_4_54() {
        if (this.jj_scan_token(210)) {
            return true;
        }
        if (this.jj_scan_token(260)) {
            return true;
        }
        if (this.jj_3R_string_exp_1707_5_20()) {
            return true;
        }
        return this.jj_scan_token(261);
    }

    private boolean jj_3R_string_term_1732_4_40() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_string_term_1732_4_53()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_string_term_1736_4_54()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_string_term_1741_4_55()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_string_term_1746_4_56()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_string_term_1750_4_57()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_string_term_1754_4_58()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_string_term_1732_4_53() {
        if (this.jj_scan_token(260)) {
            return true;
        }
        if (this.jj_3R_string_exp_1707_5_20()) {
            return true;
        }
        return this.jj_scan_token(261);
    }

    private boolean jj_3R_sql_timestamp_literal_1914_3_45() {
        return this.jj_scan_token(234);
    }

    private boolean jj_3R_in_cond_1312_29_26() {
        return this.jj_scan_token(143);
    }

    private boolean jj_3R_row_constructor_1332_5_23() {
        return this.jj_3R_expression_1442_3_15();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 0, 0, 256, 0, 256, 256, 0, 0, 0, 0, 134267904, 32768, 32768, 0, 134267904, 0, 0, 0, -31, 0, 16384, 16384, 0, 2048, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2013215744, 0, 0, 0, 0, 0, 0, 0x1C00000, -2012691456, 256, 256, -2012691200, 524288, 256, 256, 524288, 0, 0, -2013215744, 0, -2013215744, 0, 0, 134267904};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x10100000, 0, 0, 0, 0x10100000, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x10100000, 0, 0, 0, 0, 0, 0, 0x10000000, 0x10180000, 0, 0, 0x10180000, 0, 0, 0, 524288, 0, 0, 0x10100000, 0, 0x10100000, 0, 0, 0x10100000};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 1024, 1024, 0, 0, 0, 0, -2080366560, 32, 32, 0, -2080366560, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0x1000000, 0, 0, 0, 65536, 0, 0, 0, 0, 0, -2080366560, 0, 0, 0, 0, 0, 0, 4097, -2080366560, 1024, 1024, -2080365536, 0, 1024, 1024, 0, 0, 0, -2080366560, 0, -2080366560, 0, 0, -2080366560};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 64, 128, 0, 0x12020000, 0, 0, 0, 0x12020000, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0x800000, 0, 0, 0, 0, 0, 0, 0, 0, 0x12020000, 0, 0, 0, 0, 0, 0, 524288, 0x12020000, 0, 0, 0x12020000, 0, 0, 0, 0, 0, 0, 0x12020000, 0, 0x12020000, 0, 0, 0x12020000};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{0, 0x4000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4200000, 0, 0, 0, 0x4200000, 0, 0, 0, -1, 0, 0, 0, 0x2000000, 0, 32768, 32768, 0, 0, 0, 32768, 0, 32768, 32768, 32768, 0, 0, 0x4200004, 0, 0, 0, 0, 0, 0, 0, 69271600, 0, 0, 69271600, 48, 0, 0, 48, 0, 0, 0x4200004, 0, 0x4200000, 0, 0, 0x4200000};
    }

    private static void jj_la1_init_5() {
        jj_la1_5 = new int[]{0, 0, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0, 0, 0, 0x200000, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0, 0, 0, 0, 0, 0, 0, -2145386496, 0, 0, -2145386496, Integer.MIN_VALUE, 0, 0, Integer.MIN_VALUE, 0, 0, 0x200000, 0, 0x200000, 0, 0, 0x200000};
    }

    private static void jj_la1_init_6() {
        jj_la1_6 = new int[]{0, 0, 0, 0, 16384, 0, 0, 0x20000000, 0, 0, 0, 131072, 0, 0, 0, 131072, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 8192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 393216, 0, 0, 0, 0, 0, 0, 0x1000018, 131072, 0, 0, 131072, 0, 0, 0, 0, 0, 0, 393216, 0, 131072, 0, 0, 131072};
    }

    private static void jj_la1_init_7() {
        jj_la1_7 = new int[]{0x1000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 262160, 0, 0, 0x4000000, 262144, 0x4000000, 0x2000000, 0x4000000, -3792961, 0, 262144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -268435456, 0x4000000, 400384, 0x800000, 0x800000, 0, 0, 0, 0, 0, 393264, 0, 0, 393264, 0, 0, 0, 0, 0x800000, 0x800000, 400384, 138240, 270208, 8064, 0x2000000, 262144};
    }

    private static void jj_la1_init_8() {
        jj_la1_8 = new int[]{0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x3FFFFF, 256, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 7, 0, 16, 1940480, 1940480, 768, 768, 134144, 134144, 0, 16, 0, 0, 134416, 0, 0, 0, 0, 1024, 1024, 16, 0, 16, 0, 0, 0};
    }

    public ImqParser(InputStream stream) {
        this(stream, null);
    }

    public ImqParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ImqParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 61; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 61; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ImqParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ImqParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 61; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new ImqParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 61; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ImqParser(ImqParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 61; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ImqParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 61; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.jj_lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[278];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 61; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) != 0) {
                    la1tokens[128 + j] = true;
                }
                if ((jj_la1_5[i] & 1 << j) != 0) {
                    la1tokens[160 + j] = true;
                }
                if ((jj_la1_6[i] & 1 << j) != 0) {
                    la1tokens[192 + j] = true;
                }
                if ((jj_la1_7[i] & 1 << j) != 0) {
                    la1tokens[224 + j] = true;
                }
                if ((jj_la1_8[i] & 1 << j) == 0) continue;
                la1tokens[256 + j] = true;
            }
        }
        for (i = 0; i < 278; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 10; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        ImqParser.jj_la1_init_0();
        ImqParser.jj_la1_init_1();
        ImqParser.jj_la1_init_2();
        ImqParser.jj_la1_init_3();
        ImqParser.jj_la1_init_4();
        ImqParser.jj_la1_init_5();
        ImqParser.jj_la1_init_6();
        ImqParser.jj_la1_init_7();
        ImqParser.jj_la1_init_8();
        jj_ls = new LookaheadSuccess();
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

