/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.monitor.memory.MemoryTrackerProxy;
import coldfusion.runtime.RowWrapper;
import coldfusion.sql.imq.ImqTypeMismatchException;
import coldfusion.sql.imq.imqException;
import coldfusion.sql.imq.rttExpr;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Row
implements Serializable {
    private static final int INITIAL_SIZE = 16;
    private Object[] rowData;
    Row prev;
    Row next;
    int id;
    private MemoryTrackerProxy mtProxy;

    public Row() {
        this(16, true);
    }

    public Row(int initSize, boolean exact) {
        int size = exact ? initSize : this.findGrowSize(initSize);
        this.rowData = new Object[size];
        this.next = null;
        this.prev = null;
        this.id = 0;
    }

    public Row(Object[] data) {
        this.rowData = data;
        this.next = null;
        this.prev = null;
        this.id = 0;
    }

    public Row(RowWrapper rowWrapper) {
        this(16, true);
        this.initFromWrapper(rowWrapper);
    }

    private void initFromWrapper(RowWrapper rowWrapper) {
        this.id = rowWrapper.getId();
        RowWrapper wrapper = null;
        if (rowWrapper.getPrev() != null) {
            if (rowWrapper.getPrev() instanceof RowWrapper) {
                wrapper = (RowWrapper)rowWrapper.getPrev();
                this.prev = new Row(wrapper.getRowData());
            } else {
                this.prev = (Row)rowWrapper.getPrev();
            }
        }
        this.rowData = rowWrapper.getRowData();
    }

    public Object[] getRowData() {
        return this.rowData;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Row) {
            try {
                return this.compareTo((Row)obj) == 0;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    boolean equals(Row row) throws imqException {
        return this.equals(this.rowData.length);
    }

    boolean equals(Row row, int colCount) throws imqException {
        if (colCount == -1) {
            colCount = this.rowData.length;
        }
        return this.compareTo(row, colCount) == 0;
    }

    int compareTo(Row row) throws imqException {
        return this.compareTo(row, this.rowData.length);
    }

    int compareTo(Row row, int colCount) throws imqException {
        for (int i = 0; i < this.rowData.length && i < colCount; ++i) {
            boolean bR;
            boolean bL;
            int returnVal;
            Object objL = this.rowData[i];
            Object objR = row.rowData[i];
            if (objL == null) {
                if (objR == null) continue;
                return -1;
            }
            if (objR == null) {
                return 1;
            }
            if (objL instanceof Comparable) {
                try {
                    returnVal = ((Comparable)objL).compareTo(objR);
                    if (returnVal == 0) continue;
                    return returnVal;
                }
                catch (Throwable e) {
                    ImqTypeMismatchException ex = new ImqTypeMismatchException("compare", rttExpr.getSqlTypeName(objL), rttExpr.getSqlTypeName(objR));
                    throw ex;
                }
            }
            if (!(objL instanceof Boolean) || !(objR instanceof Boolean) || (bL = ((Boolean)objL).booleanValue()) == (bR = ((Boolean)objR).booleanValue())) continue;
            returnVal = bL ? 1 : -1;
            return returnVal;
        }
        return 0;
    }

    private int findGrowSize(int size) {
        int gsize = 16;
        if (size > 0) {
            gsize = size - 1 + 16;
        }
        return gsize;
    }

    public Object getColumn(int colId) {
        return this.rowData[colId];
    }

    public void setColumn(int colId, Object obj) {
        this.rowData[colId] = obj;
        if (this.mtProxy != null) {
            this.mtProxy.onReplace(obj, this.rowData[colId]);
        }
    }

    public void deleteColumn(int colId, int colCount) {
        int i = 0;
        for (i = colId + 1; i < this.rowData.length && i < colCount; ++i) {
            this.rowData[i - 1] = this.rowData[i];
        }
        if (i == colCount) {
            this.setColumn(i - 1, null);
        }
    }

    public int getSize() {
        return this.rowData.length;
    }

    public void setSize(int size) {
        if (size > this.rowData.length) {
            int gsize = this.findGrowSize(size);
            Object[] tempData = new Object[gsize];
            System.arraycopy(this.rowData, 0, tempData, 0, this.rowData.length);
            this.rowData = tempData;
        }
    }

    public MemoryTrackerProxy getMemoryTrackerProxy() {
        return this.mtProxy;
    }

    public void setMemoryTrackerProxy(MemoryTrackerProxy mtp) {
        if (mtp != null && mtp != this.mtProxy) {
            mtp.onAddObject(this.rowData);
        }
        this.mtProxy = mtp;
    }

    public Iterator valuesIterator() {
        return new Iterator(){
            int index = -1;

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.index < Row.this.rowData.length - 1;
            }

            public Object next() {
                if (this.index == Row.this.rowData.length - 1) {
                    throw new NoSuchElementException();
                }
                return Row.this.rowData[++this.index];
            }
        };
    }

    public Object writeReplace() {
        RowWrapper rowWrapper = new RowWrapper();
        rowWrapper.setId(this.id);
        rowWrapper.setPrev((Object)this.prev);
        rowWrapper.setRowData(this.rowData);
        return rowWrapper;
    }
}

