/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.imq.ExprColumn;
import coldfusion.sql.imq.ImqAliasNotUniqueException;
import coldfusion.sql.imq.Row;
import coldfusion.sql.imq.SelectColumn;
import coldfusion.sql.imq.TableList;
import coldfusion.sql.imq.TableListIterator;
import coldfusion.sql.imq.imqException;
import coldfusion.sql.imq.rttExpr;
import coldfusion.sql.imq.rttExprColumnref;
import coldfusion.sql.imq.rttSelectExprSpec;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TreeSet;

class SelectColumnList {
    LinkedList colList = new LinkedList();
    private String[] colNames = null;

    SelectColumnList() {
    }

    int addColumn(SelectColumn col) {
        int colId = this.colList.size();
        col.setResultColumnId(colId);
        this.colList.add(col);
        return colId;
    }

    ExprColumn getColumn(int colId) {
        return (ExprColumn)this.colList.get(colId);
    }

    int getColumnCount() {
        return this.colList.size();
    }

    int getResultColumnCount() {
        ListIterator iter = this.colList.listIterator();
        int count = 0;
        while (iter.hasNext()) {
            ExprColumn col = (ExprColumn)iter.next();
            if (!col.isResultColumnOnly()) continue;
            ++count;
        }
        return count;
    }

    String[] getColumnNames() {
        if (this.colNames == null) {
            ListIterator iter = this.colList.listIterator();
            this.colNames = new String[this.colList.size()];
            int i = 0;
            while (iter.hasNext()) {
                ExprColumn col = (ExprColumn)iter.next();
                this.colNames[i++] = col.getName();
            }
        }
        return this.colNames;
    }

    int getColumnId(String colName) {
        this.getColumnNames();
        for (int i = 0; i < this.colNames.length; ++i) {
            if (colName.compareToIgnoreCase(this.colNames[i]) != 0) continue;
            return i;
        }
        return -1;
    }

    boolean hasAggrExpr() {
        ListIterator iter = this.colList.listIterator();
        while (iter.hasNext()) {
            ExprColumn col = (ExprColumn)iter.next();
            if (!col.hasAggrExpr()) continue;
            return true;
        }
        return false;
    }

    ExprColumn findByAlias(String aliasName) {
        if (aliasName == null) {
            return null;
        }
        ListIterator iter = this.colList.listIterator();
        while (iter.hasNext()) {
            ExprColumn exprCol = (ExprColumn)iter.next();
            if (!aliasName.equalsIgnoreCase(exprCol.getAliasName())) continue;
            return exprCol;
        }
        return null;
    }

    ExprColumn findByColumnName(String tableName, String colName) {
        if (tableName == null || colName == null) {
            return null;
        }
        ListIterator iter = this.colList.listIterator();
        while (iter.hasNext()) {
            rttExprColumnref colref;
            ExprColumn exprCol = (ExprColumn)iter.next();
            rttExpr expr = exprCol.getExpr();
            if (!(expr instanceof rttExprColumnref) || !tableName.equalsIgnoreCase((colref = (rttExprColumnref)expr).getTableName()) || !colName.equalsIgnoreCase(colref.getColumnName())) continue;
            return exprCol;
        }
        return null;
    }

    Row evaluate(TableListIterator tblListIter) throws imqException {
        Object[] data = new Object[this.colList.size()];
        ListIterator iter = this.colList.listIterator();
        int i = 0;
        while (iter.hasNext()) {
            SelectColumn col = (SelectColumn)iter.next();
            tblListIter.resetWithinGroup(0);
            data[i++] = col.evaluate(tblListIter);
        }
        Row row = new Row(data);
        return row;
    }

    void validate(SelectColumnList expandedList, TableList tableList) throws imqException {
        ListIterator iter = this.colList.listIterator();
        while (iter.hasNext()) {
            SelectColumn col = (SelectColumn)iter.next();
            col.validate(expandedList, tableList);
        }
    }

    void validateGroupBy(rttSelectExprSpec selectSpec) throws imqException {
        ListIterator iter = this.colList.listIterator();
        while (iter.hasNext()) {
            ExprColumn col = (ExprColumn)iter.next();
            col.validateGroupBy(selectSpec);
        }
    }

    void validateUniqueAliases() throws imqException {
        TreeSet<String> set = new TreeSet<String>();
        ListIterator iter = this.colList.listIterator();
        while (iter.hasNext()) {
            ExprColumn col = (ExprColumn)iter.next();
            String alias = col.getAliasName();
            if (alias == null || set.add(alias)) continue;
            throw new imqException(new ImqAliasNotUniqueException(alias));
        }
    }
}

