/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.runtime.Struct;
import coldfusion.sql.QueryTable;
import coldfusion.sql.QueryTableMetaData;
import coldfusion.sql.imq.ImqAmbiguousColumnNameException;
import coldfusion.sql.imq.ImqUndefinedTableNameException;
import coldfusion.sql.imq.imqException;
import coldfusion.sql.imq.imqTable;
import coldfusion.sql.imq.jdbcConnection;
import java.sql.SQLException;

class TableList {
    static int MAX_NUM_TABLES = 2;
    String[] tableNames = new String[MAX_NUM_TABLES];
    QueryTable[] queryTables = new QueryTable[MAX_NUM_TABLES];
    int count = 0;

    TableList() {
    }

    void addTableName(String tableName) {
        this.tableNames[this.count++] = tableName;
    }

    void setTable(QueryTable qt, int id) {
        this.queryTables[id] = qt;
    }

    int size() {
        return this.count;
    }

    String getTableName(int index) {
        if (index >= 0 && index < this.count) {
            return this.tableNames[index];
        }
        return null;
    }

    int getTableId(String tableName) {
        for (int i = 0; i < this.size(); ++i) {
            if (!tableName.equalsIgnoreCase(this.tableNames[i])) continue;
            return i;
        }
        return -1;
    }

    QueryTable getQueryTable(int index) {
        if (index >= 0 && index < this.size()) {
            return this.queryTables[index];
        }
        return null;
    }

    imqTable getImqTable(int id) {
        return this.getQueryTable(id);
    }

    imqTable[] asImqTableArray() {
        imqTable[] tables = new imqTable[this.queryTables.length];
        for (int i = 0; i < this.queryTables.length; ++i) {
            tables[i] = this.queryTables[i];
        }
        return tables;
    }

    QueryTable getQueryTable(String tableName) {
        for (int i = 0; i < this.size(); ++i) {
            if (!tableName.equalsIgnoreCase(this.tableNames[i])) continue;
            return this.queryTables[i];
        }
        return null;
    }

    int getTableIdByTableName(String tableName) {
        for (int i = 0; i < this.size(); ++i) {
            if (!tableName.equalsIgnoreCase(this.tableNames[i])) continue;
            return i;
        }
        return -1;
    }

    int getTableIdByColName(String columnName) throws imqException {
        int foundTableId = -1;
        for (int i = 0; i < this.size(); ++i) {
            QueryTable qTable = this.queryTables[i];
            int colId = qTable.findColumn(columnName);
            if (colId == 0) continue;
            if (foundTableId != -1) {
                throw new imqException(new ImqAmbiguousColumnNameException(columnName));
            }
            foundTableId = i;
        }
        return foundTableId;
    }

    void validate(jdbcConnection conn) throws imqException {
        for (int i = 0; i < this.size(); ++i) {
            if (this.tableNames[i].indexOf(".") != this.tableNames[i].lastIndexOf(".")) {
                String[] complexVar = this.tableNames[i].split("\\.");
                int iter = 0;
                if (conn.isQueryTable(this.tableNames[i])) {
                    this.queryTables[i] = conn.getQueryTable(this.tableNames[i]);
                } else {
                    Struct value = conn.getQueryTableStruct(complexVar[iter]);
                    for (iter = 1; iter < complexVar.length - 1; ++iter) {
                        value = (Struct)value.get(complexVar[iter]);
                    }
                    this.queryTables[i] = (QueryTable)value.get(complexVar[iter]);
                }
            } else {
                this.queryTables[i] = conn.getQueryTable(this.tableNames[i]);
            }
            if (this.queryTables[i] == null) {
                throw new imqException(new ImqUndefinedTableNameException(this.tableNames[i]));
            }
            QueryTableMetaData meta = (QueryTableMetaData)this.queryTables[i].getMetaData();
            if (meta.isTypeKnown()) continue;
            try {
                meta.InferMetaDataTypes(this.queryTables[i]);
                continue;
            }
            catch (SQLException sqlE) {
                throw new imqException(sqlE.getMessage());
            }
        }
    }
}

