/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.QueryTable;
import coldfusion.sql.imq.ColumnMetaData;
import coldfusion.sql.imq.ExprColumn;
import coldfusion.sql.imq.ImqNotInTableListException;
import coldfusion.sql.imq.SelectColumn;
import coldfusion.sql.imq.SelectColumnList;
import coldfusion.sql.imq.TableList;
import coldfusion.sql.imq.imqException;
import coldfusion.sql.imq.rttExprColumnref;
import java.sql.ResultSetMetaData;

final class TableStarColumn
extends SelectColumn {
    String tableName;

    TableStarColumn(String TableName) {
        this.tableName = TableName;
    }

    @Override
    void validate(SelectColumnList expandedList, TableList tableList) throws imqException {
        QueryTable table = tableList.getQueryTable(this.tableName);
        if (table == null) {
            String columnName = this.tableName + ".*";
            throw new imqException(new ImqNotInTableListException(columnName));
        }
        ResultSetMetaData tblMeta = table.getMetaData();
        int tblId = tableList.getTableId(this.tableName);
        for (int ci = 1; ci <= table.getColumnCount(); ++ci) {
            String colName = table.getColumnName(ci);
            rttExprColumnref colRefExpr = new rttExprColumnref(this.tableName, colName, table, tblId, ci);
            ExprColumn exprCol = new ExprColumn(colRefExpr, '\u0001');
            ColumnMetaData colMeta = new ColumnMetaData(tblMeta, ci);
            exprCol.setMetaData(colMeta);
            expandedList.addColumn(exprCol);
        }
    }
}

