/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.imq.ColumnList;
import coldfusion.sql.imq.Comparator;
import coldfusion.sql.imq.OrderedColumn;
import coldfusion.sql.imq.RowTuple;
import coldfusion.sql.imq.TableList;
import coldfusion.sql.imq.TableListIterator;
import coldfusion.sql.imq.imqException;
import java.util.ListIterator;
import java.util.Vector;

class TupleSorter {
    TableList tblList;
    Vector tupleVect;
    int[] colOrder;
    int colCount;
    Comparator[] colComparator;
    ColumnList colList;
    Vector[] rowVectors;
    TableListIterator tblListIter;

    public TupleSorter(TableList tableList, Vector tupleVector, ColumnList columnIdList) {
        this.tblList = tableList;
        this.tblListIter = new TableListIterator(tableList);
        this.tupleVect = tupleVector;
        this.colList = columnIdList;
        this.colCount = columnIdList.size();
        this.colOrder = new int[this.colCount];
        this.colComparator = new Comparator[this.colCount];
        int i = 0;
        ListIterator iter = columnIdList.listIterator();
        while (iter.hasNext()) {
            OrderedColumn colObj = (OrderedColumn)iter.next();
            this.colOrder[i] = colObj.isDescendingOrder() ? -1 : 1;
            int sqlType = colObj.getSqlType();
            this.colComparator[i] = Comparator.createComparator(sqlType, true);
            ++i;
        }
        this.rowVectors = new Vector[2];
        int size = this.tupleVect.size();
        this.rowVectors[0] = new Vector(size);
        for (i = 0; i < size; ++i) {
            this.rowVectors[0].add(this.tupleVect.get(i));
        }
        this.rowVectors[1] = new Vector(size);
        for (i = 0; i < size; ++i) {
            this.rowVectors[1].add(null);
        }
    }

    Vector getSortedTupleVector() {
        return this.rowVectors[0];
    }

    int compareTo(Vector vect, int rowId1, int rowId2) {
        return this.compareTo((RowTuple)vect.get(rowId1), (RowTuple)vect.get(rowId2));
    }

    private Object evaluate(OrderedColumn col, RowTuple rt) {
        this.tblListIter.setCurrentTuple(rt);
        try {
            col.evaluate(this.tblListIter);
        }
        catch (imqException imqException2) {
            // empty catch block
        }
        return col.getResult();
    }

    int compareTo(RowTuple rt1, RowTuple rt2) {
        ListIterator iter = this.colList.listIterator();
        int result = 0;
        int i = 0;
        while (iter.hasNext()) {
            Object obj2;
            OrderedColumn colObj = (OrderedColumn)iter.next();
            Object obj1 = this.evaluate(colObj, rt1);
            result = this.colComparator[i].compare(obj1, obj2 = this.evaluate(colObj, rt2));
            if (result != 0) {
                return result * this.colOrder[i];
            }
            ++i;
        }
        return 0;
    }

    private void merge(Vector fromVector, Vector toVector, int Ls, int LeRs, int Re) {
        int Ti = Ls;
        int Li = Ls;
        int Ri = LeRs;
        while (Li < LeRs && Ri < Re) {
            if (this.compareTo(fromVector, Li, Ri) <= 0) {
                toVector.set(Ti++, fromVector.get(Li++));
                continue;
            }
            toVector.set(Ti++, fromVector.get(Ri++));
        }
        while (Li < LeRs) {
            toVector.set(Ti++, fromVector.get(Li++));
        }
        while (Ri < Re) {
            toVector.set(Ti++, fromVector.get(Ri++));
        }
    }

    private void mergeSort(Vector fromVector, Vector toVector, int fromRowId, int toRowId, boolean level) {
        if (fromRowId + 1 < toRowId) {
            int rowId = (int)Math.floor((fromRowId + toRowId) / 2);
            this.mergeSort(fromVector, toVector, fromRowId, rowId, !level);
            this.mergeSort(fromVector, toVector, rowId, toRowId, !level);
            if (level) {
                this.merge(toVector, fromVector, fromRowId, rowId, toRowId);
            } else {
                this.merge(fromVector, toVector, fromRowId, rowId, toRowId);
            }
        } else if (fromRowId + 1 == toRowId) {
            toVector.set(fromRowId, fromVector.get(fromRowId));
        }
    }

    void mergeSort() {
        this.mergeSort(this.rowVectors[0], this.rowVectors[1], 0, this.rowVectors[0].size(), true);
    }
}

