/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.imq.jdbcConnection;
import coldfusion.sql.imq.jdbcStatement;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;

public class jdbcPreparedStatement
extends jdbcStatement
implements PreparedStatement {
    private static final char[] HEXCHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private String sql;
    private Vector paramVect;

    jdbcPreparedStatement(jdbcConnection con, String sqlStr) {
        super(con);
        this.sql = sqlStr;
        this.paramVect = new Vector(4);
    }

    @Override
    public void addBatch() throws SQLException {
        throw new UnsupportedOperationException("addBatch()");
    }

    @Override
    public void clearParameters() {
        this.paramVect.removeAllElements();
    }

    @Override
    public boolean execute() throws SQLException {
        return super.execute(this.build());
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return super.executeQuery(this.build());
    }

    @Override
    public int executeUpdate() throws SQLException {
        return super.executeUpdate(this.build());
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.executeQuery().getMetaData();
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        throw new UnsupportedOperationException("setArray()");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("setAsciiStream()");
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex);
        } else {
            this.setParameter(parameterIndex, x.toString());
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (x == null || length == 0) {
            this.setNull(parameterIndex);
        } else {
            byte[] b = new byte[length];
            try {
                x.read(b, 0, length);
                x.close();
            }
            catch (IOException e) {
                throw new SQLException(e.getMessage());
            }
            this.setBytes(parameterIndex, b);
        }
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        throw new UnsupportedOperationException("setBlob()");
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setParameter(parameterIndex, x ? "'TRUE'" : "'FALSE'");
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setParameter(parameterIndex, "" + x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex);
        } else {
            this.setParameter(parameterIndex, "'" + jdbcPreparedStatement.BytesToHex(x) + "'");
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new UnsupportedOperationException("setCharacterStream()");
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        throw new UnsupportedOperationException("setClob()");
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex);
        } else {
            this.setParameter(parameterIndex, "'" + x.toString() + "'");
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setDate(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setParameter(parameterIndex, "" + x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setParameter(parameterIndex, "" + x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setParameter(parameterIndex, "" + x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setParameter(parameterIndex, "" + x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setNull(parameterIndex);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setObject(int i, Object x, int type, int scale) throws SQLException {
        this.setObject(i, x, type);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int type) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex);
            return;
        }
        x = jdbcPreparedStatement.convertObject(x, type);
        this.setObjectInType(parameterIndex, x, type);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex);
            return;
        }
        int type = 1111;
        if (x instanceof String) {
            type = 12;
        } else if (x instanceof BigDecimal) {
            type = 2;
        } else if (x instanceof Integer) {
            type = 4;
        } else if (x instanceof Long) {
            type = -5;
        } else if (x instanceof Float) {
            type = 7;
        } else if (x instanceof Double) {
            type = 8;
        } else if (x instanceof byte[]) {
            type = -2;
        } else if (x instanceof Date) {
            type = 91;
        } else if (x instanceof Time) {
            type = 92;
        } else if (x instanceof Timestamp) {
            type = 93;
        } else if (x instanceof Boolean) {
            type = -7;
        } else if (x instanceof Byte) {
            type = -6;
        } else if (x instanceof Short) {
            type = 5;
        }
        this.setObjectInType(parameterIndex, x, type);
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        throw new UnsupportedOperationException("setRef()");
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setParameter(parameterIndex, "" + x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex);
        } else {
            this.setParameter(parameterIndex, jdbcPreparedStatement.createString(x));
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex);
        } else {
            this.setParameter(parameterIndex, "'" + x.toString() + "'");
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex);
        } else {
            this.setParameter(parameterIndex, "'" + x.toString() + "'");
        }
    }

    @Override
    public void setUnicodeStream(int paramIndex, InputStream x, int length) throws SQLException {
        this.setAsciiStream(paramIndex, x, length);
    }

    private String getParameter(int i) {
        if (i >= this.paramVect.size()) {
            return null;
        }
        return (String)this.paramVect.elementAt(i);
    }

    private String build() {
        if (this.paramVect.isEmpty()) {
            return this.sql;
        }
        StringBuffer s = new StringBuffer();
        int i = 0;
        int l = this.sql.length();
        boolean bSkip = false;
        boolean bSkip2 = false;
        for (int j = 0; j < l; ++j) {
            char c = this.sql.charAt(j);
            if (c == '?' && !bSkip && !bSkip2) {
                s.append(this.getParameter(i++));
                continue;
            }
            if (c == '\'' && !bSkip2) {
                bSkip = !bSkip;
            } else if (c == '\"' && !bSkip) {
                bSkip2 = !bSkip2;
            }
            s.append(c);
        }
        return s.toString();
    }

    private void setObjectInType(int parameterIndex, Object x, int type) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex);
            return;
        }
        switch (type) {
            case -7: {
                this.setBoolean(parameterIndex, (Boolean)x);
                break;
            }
            case -6: {
                this.setByte(parameterIndex, (Byte)x);
                break;
            }
            case 5: {
                this.setShort(parameterIndex, (Short)x);
                break;
            }
            case 4: {
                this.setInt(parameterIndex, (Integer)x);
                break;
            }
            case -5: {
                this.setLong(parameterIndex, (Long)x);
                break;
            }
            case 7: {
                this.setFloat(parameterIndex, ((Float)x).floatValue());
                break;
            }
            case 6: 
            case 8: {
                this.setDouble(parameterIndex, (Double)x);
                break;
            }
            case 2: {
                this.setBigDecimal(parameterIndex, (BigDecimal)x);
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                this.setString(parameterIndex, (String)x);
                break;
            }
            case 91: {
                this.setDate(parameterIndex, (Date)x);
                break;
            }
            case 92: {
                this.setTime(parameterIndex, (Time)x);
                break;
            }
            case 93: {
                this.setTimestamp(parameterIndex, (Timestamp)x);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setBytes(parameterIndex, (byte[])x);
                break;
            }
            case 1111: {
                throw new SQLException("Unrecognized Type");
            }
            default: {
                this.setParameter(parameterIndex, x.toString());
            }
        }
    }

    private void setParameter(int i, String s) {
        if (this.paramVect.size() < i) {
            this.paramVect.setSize(i);
        }
        this.paramVect.setElementAt(s, --i);
    }

    private void setNull(int parameterIndex) {
        this.setParameter(parameterIndex, "NULL");
    }

    private static int HexToInt(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        return c;
    }

    static byte[] HexToBytes(String str) {
        byte[] outBytes = new byte[str.length() / 2];
        for (int i = 0; i < outBytes.length; ++i) {
            int j = i * 2;
            int c1 = jdbcPreparedStatement.HexToInt(str.charAt(j));
            int c2 = jdbcPreparedStatement.HexToInt(str.charAt(j + 1));
            int c = c1 << 4 | c2;
            outBytes[i] = (byte)c;
        }
        return outBytes;
    }

    static String BytesToHex(byte[] b) {
        int len = b.length;
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            int c = b[i] & 0xFF;
            s.append(HEXCHAR[c >> 4 & 0xF]);
            s.append(HEXCHAR[c & 0xF]);
        }
        return s.toString();
    }

    static Object convertObject(Object o, int type) throws SQLException {
        if (o == null) {
            return null;
        }
        switch (type) {
            case -4: 
            case -3: 
            case -2: {
                if (o instanceof byte[]) {
                    return o;
                }
                return jdbcPreparedStatement.convertString(o.toString(), type);
            }
        }
        return jdbcPreparedStatement.convertString(o.toString(), type);
    }

    static String createString(String s) {
        StringBuffer b = new StringBuffer().append('\'');
        if (s != null) {
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if (c == '\'') {
                    b.append(c);
                }
                b.append(c);
            }
        }
        return b.append('\'').toString();
    }

    static Object convertString(String s, int type) throws SQLException {
        if (s == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 4: {
                return new Integer(s);
            }
            case 6: 
            case 8: {
                return new Double(s);
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return s;
            }
            case 91: {
                return Date.valueOf(s);
            }
            case 92: {
                return Time.valueOf(s);
            }
            case 93: {
                return Timestamp.valueOf(s);
            }
            case 2: 
            case 3: {
                return new BigDecimal(s.trim());
            }
            case -7: {
                return new Boolean(s);
            }
            case -6: {
                return new Byte(s);
            }
            case 5: {
                return new Short(s);
            }
            case -5: {
                return new Long(s);
            }
            case 7: {
                return new Float(s);
            }
        }
        throw new SQLException("Unrecognized Type " + type);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new UnsupportedOperationException("PreparedStatement.getParameterMetaData()");
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new UnsupportedOperationException("PreparedStatement.setURL()");
    }

    public Struct createStruct(String s, Object[] o) throws SQLException {
        throw new UnsupportedOperationException("Connection.createStruct(java.lang.String,java.lang.Object[])");
    }

    @Override
    public void setBlob(int i, InputStream is) {
        throw new UnsupportedOperationException("PreparedStatement.setBlob(int,java.io.InputStream)");
    }

    @Override
    public void setClob(int i, Reader r) {
        throw new UnsupportedOperationException("PreparedStatement.setClob(int,java.io.Reader)");
    }

    @Override
    public void setNCharacterStream(int i, Reader r) {
        throw new UnsupportedOperationException("PreparedStatement.setNCharacterStream(int,java.io.Reader)");
    }

    @Override
    public void setCharacterStream(int i, Reader r) {
        throw new UnsupportedOperationException("PreparedStatement.setCharacterStream(int,java.io.Reader)");
    }

    @Override
    public void setBinaryStream(int i, InputStream is) {
        throw new UnsupportedOperationException("PreparedStatement.setBinaryStream(int,java.io.InputStream)");
    }

    @Override
    public void setAsciiStream(int i, InputStream is) {
        throw new UnsupportedOperationException("PreparedStatement.setAsciiStream(int,java.io.InputStream)");
    }

    @Override
    public void setCharacterStream(int i, Reader r, long l) {
        throw new UnsupportedOperationException("PreparedStatement.setCharacterStream(int,java.io.Reader,long)");
    }

    @Override
    public void setBinaryStream(int i, InputStream is, long l) {
        throw new UnsupportedOperationException("PreparedStatement.setBinaryStream(int,java.io.InputStream,long)");
    }

    @Override
    public void setAsciiStream(int i, InputStream is, long l) {
        throw new UnsupportedOperationException("PreparedStatement.setAsciiStream(int,java.io.InputStream,long)");
    }

    @Override
    public void setBlob(int i, InputStream is, long l) {
        throw new UnsupportedOperationException("PreparedStatement.setBlob(int,java.io.InputStream,long)");
    }

    @Override
    public void setClob(int i, Reader r, long l) {
        throw new UnsupportedOperationException("PreparedStatement.setClob(int,java.io.Reader,long)");
    }

    @Override
    public void setNCharacterStream(int i, Reader r, long l) {
        throw new UnsupportedOperationException("PreparedStatement.setNCharacterStream(int,java.io.Reader,long)");
    }

    @Override
    public void setNString(int i, String s) {
        throw new UnsupportedOperationException("PreparedStatement.setNString(int,java.lang.String)");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("PreparedStatement.setNClob(int, Reader, long)");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new UnsupportedOperationException("PreparedStatement.setNClob(int, NClob)");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("PreparedStatement.setNClob(int, Reader)");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException("PreparedStatement.setRowId(int, RowId)");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException("PreparedStatement.setSQLXML(int, SQLXML)");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return super.isCloseOnCompletion();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        super.closeOnCompletion();
    }
}

