/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.QueryTable;
import coldfusion.sql.QueryTableMetaData;
import coldfusion.sql.imq.ImqParser;
import coldfusion.sql.imq.ImqParserTokenManager;
import coldfusion.sql.imq.ParseException;
import coldfusion.sql.imq.SimpleCharStream;
import coldfusion.sql.imq.jdbcConnection;
import coldfusion.sql.imq.rttSelectStmt;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class jdbcStatement
implements Statement {
    private jdbcConnection cConnection;
    private QueryTable rSet;
    private boolean bEscapeProcessing = true;
    private int iMaxRows;

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new UnsupportedOperationException("addBatch()");
    }

    @Override
    public void cancel() {
        throw new UnsupportedOperationException("cancel()");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new UnsupportedOperationException("clearBatch()");
    }

    @Override
    public void clearWarnings() {
        throw new UnsupportedOperationException("clearWarnings()");
    }

    @Override
    public void close() {
        this.closeResultSet();
        this.rSet = null;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.fetchResult(sql);
        return this.rSet != null;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new UnsupportedOperationException("executeBatch()");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.fetchResult(sql);
        return this.rSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.fetchResult(sql);
        if (this.rSet == null) {
            return -1;
        }
        return this.rSet.getUpdateCount();
    }

    @Override
    public Connection getConnection() {
        return this.cConnection;
    }

    jdbcConnection getJdbcConnection() {
        return this.cConnection;
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public int getFetchSize() {
        return 1;
    }

    @Override
    public int getMaxFieldSize() {
        return 0;
    }

    @Override
    public int getMaxRows() {
        return this.iMaxRows;
    }

    @Override
    public boolean getMoreResults() {
        if (this.rSet != null) {
            this.rSet.close();
            this.rSet = null;
        }
        return false;
    }

    @Override
    public int getQueryTimeout() {
        return 0;
    }

    @Override
    public ResultSet getResultSet() {
        return this.rSet;
    }

    @Override
    public int getResultSetConcurrency() {
        return 1007;
    }

    @Override
    public int getResultSetType() {
        return 1003;
    }

    @Override
    public int getUpdateCount() {
        if (this.rSet == null) {
            return -1;
        }
        return this.rSet.getUpdateCount();
    }

    @Override
    public SQLWarning getWarnings() {
        throw new UnsupportedOperationException("getWarnings()");
    }

    @Override
    public void setCursorName(String name) {
        throw new UnsupportedOperationException("getCursorName()");
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
        this.bEscapeProcessing = enable;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public void setFetchSize(int rows) {
    }

    @Override
    public void setMaxFieldSize(int max) {
    }

    @Override
    public void setMaxRows(int max) {
        this.iMaxRows = max;
    }

    @Override
    public void setQueryTimeout(int seconds) {
    }

    jdbcStatement(jdbcConnection c) {
        this.cConnection = c;
        this.iMaxRows = -1;
    }

    private void fetchResult(String sql) throws SQLException {
        if (this.bEscapeProcessing) {
            sql = this.cConnection.nativeSQL((String)sql);
        }
        this.closeResultSet();
        sql = (String)sql + " ";
        rttSelectStmt selectStmtNode = this.parseSQL((String)sql);
        selectStmtNode.setJdbcStatement(this);
        selectStmtNode.validate();
        selectStmtNode.evaluate();
        this.rSet = selectStmtNode.getResultTable();
        ResultSetMetaData rsMetaData = this.rSet.getMetaData();
        if (rsMetaData instanceof QueryTableMetaData) {
            this.cleanupResultSet(this.rSet, ((QueryTableMetaData)rsMetaData).getColumnLabels());
        }
        ((QueryTableMetaData)rsMetaData).removeUnnamedColumns();
    }

    private void cleanupResultSet(QueryTable resultSet, String[] columnLabels) {
        String[] resultSetColNames = resultSet.getColumnNames();
        int columnsLength = resultSetColNames.length < columnLabels.length ? resultSetColNames.length : columnLabels.length;
        for (int i = 0; i < columnsLength; ++i) {
            if (columnLabels[i] != null && !columnLabels[i].equals("")) continue;
            resultSet.deleteColumn(resultSetColNames[i]);
        }
    }

    private rttSelectStmt parseSQL(String sql) throws SQLException {
        rttSelectStmt selectStmtNode;
        StringReader reader = new StringReader(sql);
        SimpleCharStream stream = new SimpleCharStream(reader, 1, 1);
        ImqParserTokenManager tokenizer = new ImqParserTokenManager(stream);
        ImqParser parser = new ImqParser(tokenizer);
        try {
            selectStmtNode = parser.Input();
        }
        catch (ParseException pe) {
            SQLException sqlE = new SQLException(pe.getMessage());
            throw sqlE;
        }
        return selectStmtNode;
    }

    private void closeResultSet() {
        if (this.rSet != null) {
            this.rSet.close();
            this.rSet = null;
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException("Statement.execute(String, int)");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("Statement.execute(String, int[])");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("Statement.execute(String, String[])");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException("Statement.executeUpdate(String, int)");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("Statement.executeUpdate(String, int[])");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("Statement.executeUpdate(String, String[])");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException("Statement.getGeneratedKeys()");
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new UnsupportedOperationException("Statement.getMoreResults(int)");
    }

    @Override
    public boolean isPoolable() {
        throw new UnsupportedOperationException("Statement.isPoolable()");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException("Statement.getResultSetHoldability()");
    }

    @Override
    public void setPoolable(boolean b) {
        throw new UnsupportedOperationException("Statement.setPoolable(boolean)");
    }

    @Override
    public boolean isClosed() {
        throw new UnsupportedOperationException("Statement.isClosed()");
    }

    @Override
    public boolean isWrapperFor(Class<?> c) {
        throw new UnsupportedOperationException("Wrapper.isWrapperFor(java.lang.Class<?>)");
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        throw new UnsupportedOperationException("Wrapper.unwrap(Class<T> iface)");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }
}

