/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.runtime.CFDouble;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.OleTime;
import coldfusion.runtime.locale.CFNumberFormat;
import coldfusion.sql.imq.ExprColumn;
import coldfusion.sql.imq.ImqCastException;
import coldfusion.sql.imq.ImqUnsupportedCastException;
import coldfusion.sql.imq.ImqUnsupportedSQLTypeException;
import coldfusion.sql.imq.TableList;
import coldfusion.sql.imq.TableListIterator;
import coldfusion.sql.imq.imqException;
import coldfusion.sql.imq.jdbcPreparedStatement;
import coldfusion.sql.imq.rttNode;
import coldfusion.sql.imq.rttSelectExprSpec;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class rttExpr
extends rttNode {
    static final int UNKNOWN = -1;
    static final int NULL = 0;
    static final int INTEGER = 1;
    static final int LONG = 2;
    static final int FLOAT = 3;
    static final int DOUBLE = 4;
    static final int BIGDECIMAL = 5;
    static final int TIME = 6;
    static final int TIMESTAMP = 7;
    static final int DATE = 8;
    static final int STRING = 9;
    static final int BINARY = 10;
    static final int BOOLEAN = 11;
    static final int OBJECT = 12;
    static final int CLOB = 13;
    static final int NCLOB = 14;
    public static final Map supportedSqlTypes = new HashMap(11);
    protected Object resultObj = null;
    protected int sqlType;
    protected int javaType;
    protected boolean metaDataKnown = false;
    protected ExprColumn exprColumn = null;

    rttExpr() {
    }

    void validate(TableList tableList) throws imqException {
    }

    void validateGroupBy(rttSelectExprSpec selectSpec) throws imqException {
    }

    void validateHaving(rttSelectExprSpec selectSpec) throws imqException {
    }

    abstract void evaluate(TableListIterator var1) throws imqException;

    @Override
    void evaluate() throws imqException {
    }

    boolean hasAggrExpr() {
        return false;
    }

    int getJavaType() {
        return this.javaType;
    }

    int getSqlType() {
        return this.sqlType;
    }

    Object getResult() {
        return this.resultObj;
    }

    String getName() {
        return "";
    }

    boolean getCase() {
        return false;
    }

    void setResult(Object obj) {
        this.resultObj = obj;
    }

    ExprColumn getExprColumn() {
        return this.exprColumn;
    }

    void setExprColumn(ExprColumn exprCol) {
        this.exprColumn = exprCol;
    }

    boolean isMetaDataKnown() {
        return this.metaDataKnown;
    }

    void setMetaDataKnown(boolean tf) {
        this.metaDataKnown = tf;
    }

    boolean isString() {
        return this.getJavaType() == 9;
    }

    boolean isDate() {
        return rttExpr.isDate(this.getJavaType());
    }

    boolean isTime() {
        return rttExpr.isTime(this.getJavaType());
    }

    boolean isTimeStamp() {
        return rttExpr.isTimeStamp(this.getJavaType());
    }

    boolean isBoolean() {
        return this.getJavaType() == 11;
    }

    boolean isNumeric() {
        return this.getJavaType() >= 1 && this.getJavaType() <= 4;
    }

    boolean isBinary() {
        return this.getJavaType() == 10;
    }

    static boolean isBoolean(int javaType) {
        return javaType == 11 || javaType == -1 || javaType == 9;
    }

    static boolean isNumeric(int javaType) {
        return javaType >= 1 && javaType <= 5 || javaType == -1 || javaType == 11;
    }

    static boolean isNumericOrString(int javaType) {
        return javaType == 9 || rttExpr.isNumeric(javaType);
    }

    static boolean isDate(int javaType) {
        return javaType >= 6 && javaType < 9 || javaType == -1;
    }

    static boolean isTime(int javaType) {
        return javaType == 6;
    }

    static boolean isTimeStamp(int javaType) {
        return javaType == 7;
    }

    static boolean isDateOrString(int javaType) {
        return javaType == 9 || rttExpr.isDate(javaType);
    }

    static boolean isBinaryOrString(int javaType) {
        return javaType == 9 || javaType == 10;
    }

    static boolean isPlusCompatible(int javaType) {
        return javaType >= 1 && javaType <= 9 || javaType == -1;
    }

    static boolean isMinusCompatible(int javaType) {
        return javaType >= 1 && javaType <= 8 || javaType == -1;
    }

    static int getJavaObjectType(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Integer) {
            return 1;
        }
        if (obj instanceof Long) {
            return 2;
        }
        if (obj instanceof Float) {
            return 3;
        }
        if (obj instanceof Double) {
            return 4;
        }
        if (obj instanceof BigDecimal) {
            return 5;
        }
        if (obj instanceof String) {
            return 9;
        }
        if (obj instanceof byte[]) {
            return 10;
        }
        if (obj instanceof Boolean) {
            return 11;
        }
        if (obj instanceof Time) {
            return 6;
        }
        if (obj instanceof Timestamp) {
            return 7;
        }
        if (obj instanceof Date) {
            return 8;
        }
        if (obj instanceof OleDateTime) {
            return 8;
        }
        return 12;
    }

    public static int guesstimateJavaType(Object obj) throws imqException {
        if (obj instanceof String) {
            return rttExpr.guesstimateJavaType((String)obj);
        }
        return rttExpr.getJavaObjectType(obj);
    }

    private static int guesstimateJavaType(String str) throws imqException {
        if (Locale.getDefault().getCountry().compareToIgnoreCase("US") == 0) {
            try {
                Long.decode(str);
                return 2;
            }
            catch (Exception e1) {
                try {
                    CFDouble.parseDouble((String)str);
                    return 4;
                }
                catch (Exception e2) {
                    try {
                        Time.valueOf(str);
                        return 6;
                    }
                    catch (Exception e3) {
                        try {
                            java.util.Date date = CFPage.ParseDateTime(str);
                            return 8;
                        }
                        catch (Exception e4) {
                            return 9;
                        }
                    }
                }
            }
        }
        try {
            CFNumberFormat.LsParseNumber(str, Locale.getDefault());
            return 4;
        }
        catch (Exception e2) {
            try {
                OleDateTime date = CFPage.internal_LSParseDateTime(str, Locale.getDefault());
                return 8;
            }
            catch (Exception e3) {
                return 9;
            }
        }
    }

    private static String trimLeadingZeros(String str) {
        int i;
        int len = str.length() - 1;
        for (i = 0; i < len && str.charAt(i) == '0'; ++i) {
        }
        if (i > 0) {
            str = str.substring(i);
        }
        return str;
    }

    static Object castTo(Object obj, int castType) {
        int objType = rttExpr.getJavaObjectType(obj);
        if (objType == castType || objType == 0) {
            return obj;
        }
        switch (castType) {
            case 1: {
                return new Integer(Cast._int(obj));
            }
            case 2: {
                return new Long(Cast._long(obj));
            }
            case 3: {
                return new Float(Cast._double(obj));
            }
            case 4: {
                return rttExpr.castToDouble(obj);
            }
            case 5: {
                return rttExpr.castToBigDecimal(obj);
            }
            case 6: {
                long time = rttExpr.castToDate(obj).getTime();
                return new Time(time);
            }
            case 7: {
                long time = rttExpr.castToDate(obj).getTime();
                return new Timestamp(time);
            }
            case 8: {
                long time = rttExpr.castToDate(obj).getTime();
                return new Date(time);
            }
            case 9: {
                return Cast._String(obj);
            }
            case 10: {
                return Cast._Binary(obj);
            }
            case 11: {
                return rttExpr.castToBoolean(obj);
            }
        }
        throw new ImqUnsupportedCastException(rttExpr.getJavaTypeName(castType));
    }

    static String castToString(Object obj) {
        return Cast._String(obj);
    }

    static BigDecimal castToBigDecimal(Object obj) {
        return Cast._BigDecimal(obj);
    }

    static Double castToDouble(Object obj) {
        return new Double(Cast._double(obj));
    }

    static Boolean castToBoolean(Object obj) {
        return Cast._boolean(obj) ? Boolean.TRUE : Boolean.FALSE;
    }

    static byte[] castToBinary(Object x) {
        byte[] result = null;
        if (x instanceof byte[]) {
            result = (byte[])x;
        } else if (x instanceof String) {
            return jdbcPreparedStatement.HexToBytes((String)x);
        }
        return result;
    }

    static java.util.Date castToDate(Object obj) {
        if (obj instanceof java.util.Date) {
            return (java.util.Date)obj;
        }
        if (obj instanceof String) {
            return rttExpr.castToDate((String)obj);
        }
        try {
            return Cast._Date(obj);
        }
        catch (Exception e) {
            throw new ImqCastException(obj, "java.util.Date");
        }
    }

    static java.util.Date castToTime(Object obj) {
        try {
            return new OleTime(rttExpr.castToDate(obj));
        }
        catch (Exception e) {
            throw new ImqCastException(obj, "java.util.Date");
        }
    }

    private static java.util.Date castToDate(String s) {
        java.util.Date date;
        String str = rttExpr.stripSingleQuotes(s);
        Locale locale = Locale.getDefault();
        try {
            date = Cast._Date(str);
        }
        catch (Exception e2) {
            try {
                DateFormat formatter = DateFormat.getDateTimeInstance(3, 3, locale);
                date = formatter.parse(str);
            }
            catch (Exception e3) {
                throw new ImqCastException((Object)s, "java.util.Date");
            }
        }
        if (date == null) {
            return null;
        }
        return new Date(date.getTime());
    }

    private static Object castDateTo(java.util.Date obj, int castType) throws imqException {
        switch (castType) {
            case 6: {
                return new Time(obj.getTime());
            }
            case 7: {
                return new Timestamp(obj.getTime());
            }
            case 8: {
                return obj;
            }
            case 9: {
                return obj.toString();
            }
        }
        throw new imqException("Unsupported Date type conversion in Query of Queries.");
    }

    private static Object castNumericTo(Number obj, int castType) throws imqException {
        switch (castType) {
            case 1: {
                return new Integer(obj.intValue());
            }
            case 2: {
                return new Long(obj.longValue());
            }
            case 3: {
                return new Float(obj.floatValue());
            }
            case 4: {
                return new Double(obj.doubleValue());
            }
            case 5: {
                return new BigDecimal(obj.doubleValue());
            }
            case 9: {
                return obj.toString();
            }
        }
        throw new imqException("Unsupported Numeric type conversion in Query of Queries.");
    }

    static boolean isUnionCompatibleSqlTypes(int sqlType1, int sqlType2) throws imqException {
        int javaType2;
        int javaType1 = rttExpr.SqlToJavaMapping(sqlType1);
        if (javaType1 == (javaType2 = rttExpr.SqlToJavaMapping(sqlType2))) {
            return true;
        }
        if (rttExpr.isNumeric(javaType1) && rttExpr.isNumeric(javaType2)) {
            return true;
        }
        return rttExpr.isDate(javaType1) && rttExpr.isDate(javaType2);
    }

    static int getMaxCompatible(int javaType1, int javaType2) throws imqException {
        if (javaType1 == javaType2) {
            return javaType1;
        }
        if (rttExpr.isNumeric(javaType1) && rttExpr.isNumeric(javaType2)) {
            return javaType1 > javaType2 ? javaType1 : javaType2;
        }
        if (rttExpr.isDate(javaType1) && rttExpr.isDate(javaType2)) {
            return 7;
        }
        if (javaType1 == -1 || javaType1 == 0) {
            return javaType2;
        }
        if (javaType2 == -1 || javaType2 == 0) {
            return javaType1;
        }
        if (javaType1 == 9 || javaType2 == 9) {
            return 9;
        }
        return 9;
    }

    static int getMaxSqlCompatible(int sqlType1, int sqlType2) throws imqException {
        int jt = rttExpr.getMaxCompatible(rttExpr.SqlToJavaMapping(sqlType1), rttExpr.SqlToJavaMapping(sqlType2));
        return rttExpr.JavaToSqlMapping(jt);
    }

    static int JavaToSqlMapping(int javaType) throws imqException {
        switch (javaType) {
            case 1: {
                return 4;
            }
            case 2: {
                return -5;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 3;
            }
            case 9: {
                return 12;
            }
            case 10: {
                return -3;
            }
            case 11: {
                return -7;
            }
            case 6: {
                return 92;
            }
            case 7: {
                return 93;
            }
            case 8: {
                return 91;
            }
            case -1: {
                return 1111;
            }
            case 0: {
                return 0;
            }
            case 12: {
                return 2000;
            }
        }
        throw new imqException("Unrecognized java type");
    }

    static int SqlToJavaMapping(int sqlType) {
        switch (sqlType) {
            case -6: 
            case 4: 
            case 5: {
                return 1;
            }
            case -5: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 6: 
            case 8: {
                return 4;
            }
            case 2: 
            case 3: {
                return 5;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return 9;
            }
            case -4: 
            case -3: 
            case -2: {
                return 10;
            }
            case -7: {
                return 11;
            }
            case 92: {
                return 6;
            }
            case 93: {
                return 7;
            }
            case 91: {
                return 8;
            }
            case 1111: {
                return -1;
            }
            case 2000: {
                return 12;
            }
            case 0: {
                return 0;
            }
            case 2009: {
                return 9;
            }
            case 2005: {
                return 13;
            }
            case 2011: {
                return 14;
            }
        }
        throw new ImqUnsupportedSQLTypeException(rttExpr.getSqlTypeName(sqlType));
    }

    public static String getSqlTypeName(int sqlType) {
        switch (sqlType) {
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 7: {
                return "REAL";
            }
            case 6: {
                return "FLOAT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case -15: {
                return "NCHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -9: {
                return "NVARCHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case -16: {
                return "LONGNVARCHAR";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -7: {
                return "BIT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 91: {
                return "DATE";
            }
            case 2003: {
                return "ARRAY";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case 2011: {
                return "NCLOB";
            }
            case 2009: {
                return "SQLXML";
            }
            case 2006: {
                return "REF";
            }
            case 2002: {
                return "STRUCT";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case 0: {
                return "NULL";
            }
            case 1111: {
                return "OTHER";
            }
            case 2001: {
                return "DISTINCT";
            }
        }
        return "UNKNOWN";
    }

    static String getSqlTypeName(Object obj) throws imqException {
        return rttExpr.getSqlTypeName(rttExpr.JavaToSqlMapping(rttExpr.getJavaObjectType(obj)));
    }

    static String getJavaTypeName(int JType) {
        switch (JType) {
            case 1: {
                return "INTEGER";
            }
            case 2: {
                return "LONG";
            }
            case 3: {
                return "FLOAT";
            }
            case 4: {
                return "DOUBLE";
            }
            case 5: {
                return "BIGDECIMAL";
            }
            case 6: {
                return "TIME";
            }
            case 7: {
                return "TIMESTAMP";
            }
            case 8: {
                return "DATE";
            }
            case 9: {
                return "STRING";
            }
            case 10: {
                return "BINARY";
            }
            case 11: {
                return "BOOLEAN";
            }
            case -1: {
                return "UNKNOWN";
            }
            case 0: {
                return "NULL";
            }
            case 12: {
                return "OBJECT";
            }
        }
        return "UNRECOGNIZABLE";
    }

    private static String stripSingleQuotes(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (str.charAt(0) == '\'' && str.charAt(str.length() - 1) == '\'') {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    static {
        supportedSqlTypes.put("CF_SQL_INTEGER", new Integer(4));
        supportedSqlTypes.put("CF_SQL_BIGINT", new Integer(-5));
        supportedSqlTypes.put("CF_SQL_DOUBLE", new Integer(8));
        supportedSqlTypes.put("CF_SQL_DECIMAL", new Integer(3));
        supportedSqlTypes.put("CF_SQL_VARCHAR", new Integer(12));
        supportedSqlTypes.put("CF_SQL_BINARY", new Integer(-2));
        supportedSqlTypes.put("CF_SQL_BIT", new Integer(-7));
        supportedSqlTypes.put("CF_SQL_TIME", new Integer(92));
        supportedSqlTypes.put("CF_SQL_DATE", new Integer(91));
        supportedSqlTypes.put("CF_SQL_TIMESTAMP", new Integer(93));
        supportedSqlTypes.put("CF_SQL_OBJECT", new Integer(2000));
        supportedSqlTypes.put("INTEGER", new Integer(4));
        supportedSqlTypes.put("BIGINT", new Integer(-5));
        supportedSqlTypes.put("DOUBLE", new Integer(8));
        supportedSqlTypes.put("DECIMAL", new Integer(3));
        supportedSqlTypes.put("VARCHAR", new Integer(12));
        supportedSqlTypes.put("BINARY", new Integer(-2));
        supportedSqlTypes.put("BIT", new Integer(-7));
        supportedSqlTypes.put("TIME", new Integer(92));
        supportedSqlTypes.put("DATE", new Integer(91));
        supportedSqlTypes.put("TIMESTAMP", new Integer(93));
        supportedSqlTypes.put("OBJECT", new Integer(2000));
    }
}

