/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.QueryTable;
import coldfusion.sql.imq.ExprColumn;
import coldfusion.sql.imq.GroupByColumnList;
import coldfusion.sql.imq.ImqColumnNotInTableException;
import coldfusion.sql.imq.ImqColumnNotInTablesException;
import coldfusion.sql.imq.ImqInvalidGroupbyColumnException;
import coldfusion.sql.imq.ImqInvalidGroupbyColumnNoGrpException;
import coldfusion.sql.imq.ImqNotInTableListException;
import coldfusion.sql.imq.Row;
import coldfusion.sql.imq.TableList;
import coldfusion.sql.imq.TableListIterator;
import coldfusion.sql.imq.imqException;
import coldfusion.sql.imq.rttExpr;
import coldfusion.sql.imq.rttResultcolumnref;
import coldfusion.sql.imq.rttSelectExprSpec;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

class rttExprColumnref
extends rttExpr {
    private String tableName;
    private String colName;
    private QueryTable table;
    private int tableId;
    private int colId;
    private static final boolean trimDbResult = Boolean.getBoolean("coldfusion.trim.dbresult");

    rttExprColumnref(String tblname, String colname) {
        this.tableName = tblname;
        this.colName = colname;
        this.table = null;
        this.tableId = -1;
        this.colId = 0;
    }

    public rttExprColumnref(String tblname, String colname, QueryTable tbl, int tblId, int columnId) {
        this.tableName = tblname;
        this.colName = colname;
        this.table = tbl;
        this.tableId = tblId;
        this.colId = columnId;
    }

    @Override
    String getName() {
        return this.colName;
    }

    @Override
    boolean getCase() {
        try {
            return this.table.getMetaData().isCaseSensitive(this.colId);
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    Object getValue() {
        return this.resultObj;
    }

    String getTableName() {
        return this.tableName;
    }

    String getColumnName() {
        return this.colName;
    }

    @Override
    int getJavaType() {
        return this.javaType;
    }

    @Override
    int getSqlType() {
        return this.sqlType;
    }

    @Override
    Object getResult() {
        return this.resultObj;
    }

    @Override
    boolean hasAggrExpr() {
        return false;
    }

    String getQualifiedColumnName() {
        if (this.tableName != null) {
            return this.tableName + "." + this.colName;
        }
        return this.colName;
    }

    int getTableId() {
        return this.tableId;
    }

    int getColumnId() {
        return this.colId;
    }

    @Override
    void evaluate(TableListIterator tblListIter) throws imqException {
        boolean isStringExpr;
        Row currRow = tblListIter.getCurrentRow(this.tableId);
        this.resultObj = currRow.getColumn(this.colId - 1);
        boolean bl = isStringExpr = this.javaType == 9;
        if (isStringExpr && this.resultObj == null) {
            this.resultObj = "";
        }
        if (trimDbResult && isStringExpr && this.resultObj instanceof String) {
            this.resultObj = ((String)this.resultObj).trim();
        }
    }

    @Override
    void validate(TableList tableList) throws imqException {
        Object qualColName = null;
        String msg = null;
        if (this.tableName != null) {
            this.tableId = tableList.getTableIdByTableName(this.tableName);
            qualColName = this.tableName + "." + this.colName;
            if (this.tableId == -1) {
                throw new imqException(new ImqNotInTableListException((String)qualColName));
            }
            this.table = tableList.getQueryTable(this.tableId);
            this.colId = this.table.findColumn(this.colName);
            if (this.colId == 0) {
                throw new imqException(new ImqColumnNotInTableException((String)qualColName, this.tableName));
            }
        } else {
            this.tableId = tableList.getTableIdByColName(this.colName);
            qualColName = this.colName;
            if (this.tableId == -1) {
                throw new imqException(new ImqColumnNotInTablesException((String)qualColName));
            }
            this.table = tableList.getQueryTable(this.tableId);
            this.tableName = tableList.getTableName(this.tableId);
            this.colId = this.table.findColumn(this.colName);
        }
        ResultSetMetaData metadata = this.table.getMetaData();
        try {
            if (metadata != null) {
                this.metaDataKnown = true;
                this.sqlType = metadata.getColumnType(this.colId);
                this.javaType = rttExpr.SqlToJavaMapping(this.sqlType);
            }
        }
        catch (SQLException e) {
            msg = "Failed to get meta_data for column" + this.tableName + "." + this.colName + " .";
            imqException imqe = new imqException(msg);
            imqe.setNextException(e);
            throw imqe;
        }
    }

    @Override
    void validateGroupBy(rttSelectExprSpec selectSpec) throws imqException {
        GroupByColumnList groupByList = selectSpec.getGroupByList();
        if (groupByList == null) {
            throw new imqException(new ImqInvalidGroupbyColumnNoGrpException(this.getQualifiedColumnName(), "SELECT list"));
        }
        rttResultcolumnref foundColRef = groupByList.findByColumnName(this.tableName, this.colName);
        if (foundColRef == null) {
            throw new imqException(new ImqInvalidGroupbyColumnException(this.getQualifiedColumnName(), "SELECT list"));
        }
    }

    private void setHavingParams(ExprColumn exprCol) {
        this.exprColumn = exprCol;
        this.exprColumn.addUse('\b');
        this.sqlType = this.exprColumn.getExpr().getSqlType();
        this.javaType = this.exprColumn.getExpr().getJavaType();
        this.metaDataKnown = this.exprColumn.getExpr().metaDataKnown;
        this.tableId = 0;
        this.colId = this.exprColumn.getResultColumnId() + 1;
    }

    @Override
    void validateHaving(rttSelectExprSpec selectSpec) throws imqException {
        ExprColumn exprCol;
        GroupByColumnList groupByList = selectSpec.getGroupByList();
        if (this.tableName == null && (exprCol = selectSpec.getExpandedSelectList().findByAlias(this.colName)) != null) {
            this.setHavingParams(exprCol);
            return;
        }
        if (groupByList == null) {
            throw new imqException(new ImqInvalidGroupbyColumnNoGrpException(this.getQualifiedColumnName(), "HAVING"));
        }
        this.validate(selectSpec.getTableList());
        rttResultcolumnref foundColRef = groupByList.findByColumnName(this.tableName, this.colName);
        if (foundColRef == null) {
            throw new imqException(new ImqInvalidGroupbyColumnException(this.getQualifiedColumnName(), "HAVING"));
        }
        this.setHavingParams(foundColRef.getExprColumn());
    }
}

