/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.runtime.NeoException;
import coldfusion.runtime.OleTime;
import coldfusion.sql.imq.ImqIncompatibleTypeComparisonException;
import coldfusion.sql.imq.ImqRuntimeException;
import coldfusion.sql.imq.ImqUnsupportedTypeComparisonException;
import coldfusion.sql.imq.imqException;
import coldfusion.sql.imq.rttExpr;
import java.math.BigDecimal;
import java.util.Date;

class rttExprComparator {
    rttExprComparator() {
    }

    private static int stringCompare(Object Lobj, Object Robj) {
        String lStr = rttExpr.castToString(Lobj);
        String rStr = rttExpr.castToString(Robj);
        return lStr.compareTo(rStr);
    }

    private static int dateCompare(rttExpr lrtt, rttExpr rrtt) {
        long rdateMillis;
        Date rdate;
        Date ldate;
        Object lobj = lrtt.getResult();
        Object robj = rrtt.getResult();
        if (lobj instanceof Date) {
            ldate = (Date)lobj;
        } else {
            ldate = rttExpr.castToDate(lobj);
            lrtt.setResult(ldate);
        }
        if (robj instanceof Date) {
            rdate = (Date)robj;
        } else {
            rdate = rttExpr.castToDate(robj);
            rrtt.setResult(rdate);
        }
        if (ldate == null && rdate == null) {
            return 0;
        }
        if (ldate == null && rdate != null) {
            return -1;
        }
        if (ldate != null && rdate == null) {
            return 1;
        }
        long ldateMillis = ldate.getTime();
        return ldateMillis < (rdateMillis = rdate.getTime()) ? -1 : (ldateMillis == rdateMillis ? 0 : 1);
    }

    private static int timeCompare(rttExpr lttExpr, rttExpr rttExpr2) {
        long rdateMillis;
        Date rdate;
        Date ldate;
        Object lobj = lttExpr.getResult();
        Object robj = rttExpr2.getResult();
        if (lobj instanceof OleTime) {
            ldate = (OleTime)lobj;
        } else {
            ldate = rttExpr.castToTime(lobj);
            lttExpr.setResult(ldate);
        }
        if (robj instanceof OleTime) {
            rdate = (OleTime)robj;
        } else {
            rdate = rttExpr.castToTime(robj);
            rttExpr2.setResult(rdate);
        }
        if (ldate == null && rdate == null) {
            return 0;
        }
        if (ldate == null && rdate != null) {
            return -1;
        }
        if (ldate != null && rdate == null) {
            return 1;
        }
        long ldateMillis = ldate.getTime();
        return ldateMillis < (rdateMillis = rdate.getTime()) ? -1 : (ldateMillis == rdateMillis ? 0 : 1);
    }

    private static int bigDecimalCompare(Object Lobj, Object Robj) {
        BigDecimal Lbd = rttExpr.castToBigDecimal(Lobj);
        BigDecimal Rbd = rttExpr.castToBigDecimal(Robj);
        return Lbd.compareTo(Rbd);
    }

    private static int doubleCompare(Object Lobj, Object Robj) {
        Double Ld = rttExpr.castToDouble(Lobj);
        Double Rd = rttExpr.castToDouble(Robj);
        return Ld.compareTo(Rd);
    }

    private static int booleanCompare(Object Lobj, Object Robj) {
        Boolean Lb = rttExpr.castToBoolean(Lobj);
        Boolean Rb = rttExpr.castToBoolean(Robj);
        return Lb.booleanValue() == Rb.booleanValue() ? 0 : 1;
    }

    private static int binaryCompare(Object Lobj, Object Robj) {
        byte[] Rb;
        byte[] Lb = rttExpr.castToBinary(Lobj);
        if (Lb.length != (Rb = rttExpr.castToBinary(Robj)).length) {
            return 1;
        }
        for (int i = 0; i < Lb.length; ++i) {
            if (Lb[i] == Rb[i]) continue;
            return 1;
        }
        return 0;
    }

    private static int stringOrDateCompare(rttExpr Lexp, rttExpr Rexp, String operator) {
        Object Lobj = Lexp.getResult();
        Object Robj = Rexp.getResult();
        if (Lexp.isMetaDataKnown() && !Rexp.isMetaDataKnown()) {
            if (Lexp.isString()) {
                return rttExprComparator.stringCompare(Lobj, Robj);
            }
            if ((Lexp.isTime() || Lexp.isTimeStamp()) && Rexp.isTime()) {
                return rttExprComparator.timeCompare(Lexp, Rexp);
            }
            return rttExprComparator.dateCompare(Lexp, Rexp);
        }
        if (!Lexp.isMetaDataKnown() && Rexp.isMetaDataKnown()) {
            if (Rexp.isString()) {
                return rttExprComparator.stringCompare(Lobj, Robj);
            }
            if (Lexp.isTime() && (Rexp.isTime() || Rexp.isTimeStamp())) {
                return rttExprComparator.timeCompare(Lexp, Rexp);
            }
            return rttExprComparator.dateCompare(Lexp, Rexp);
        }
        if (Lexp.isMetaDataKnown() && Rexp.isMetaDataKnown()) {
            if (Lexp.isString() && Rexp.isString()) {
                return rttExprComparator.stringCompare(Lobj, Robj);
            }
            if (Lexp.isTime() && Rexp.isTime()) {
                return rttExprComparator.timeCompare(Lexp, Rexp);
            }
            if (Lexp.isDate() && Rexp.isDate()) {
                return rttExprComparator.dateCompare(Lexp, Rexp);
            }
            throw new ImqIncompatibleTypeComparisonException(rttExpr.getSqlTypeName(Lexp.getSqlType()), rttExpr.getSqlTypeName(Rexp.getSqlType()), operator);
        }
        try {
            return rttExprComparator.dateCompare(Lexp, Rexp);
        }
        catch (Exception e1) {
            try {
                return rttExprComparator.stringCompare(Lobj, Robj);
            }
            catch (Exception e2) {
                throw new ImqIncompatibleTypeComparisonException(rttExpr.getSqlTypeName(Lexp.getSqlType()), rttExpr.getSqlTypeName(Rexp.getSqlType()), operator);
            }
        }
    }

    private static int numericCompare(rttExpr Lexp, rttExpr Rexp, String operator) {
        Object Lobj = Lexp.getResult();
        Object Robj = Rexp.getResult();
        if (Lobj instanceof BigDecimal || Robj instanceof BigDecimal) {
            return rttExprComparator.bigDecimalCompare(Lobj, Robj);
        }
        if (Lexp.isMetaDataKnown() && !Rexp.isMetaDataKnown()) {
            if (Lexp.isBoolean()) {
                return rttExprComparator.booleanCompare(Lobj, Robj);
            }
            return rttExprComparator.doubleCompare(Lobj, Robj);
        }
        if (!Lexp.isMetaDataKnown() && Rexp.isMetaDataKnown()) {
            if (Rexp.isBoolean()) {
                return rttExprComparator.booleanCompare(Lobj, Robj);
            }
            return rttExprComparator.doubleCompare(Lobj, Robj);
        }
        if (Lexp.isMetaDataKnown() && Rexp.isMetaDataKnown()) {
            if (Lexp.isBoolean() && Rexp.isBoolean()) {
                return rttExprComparator.booleanCompare(Lobj, Robj);
            }
            if (Lexp.isNumeric() && Rexp.isNumeric()) {
                return rttExprComparator.doubleCompare(Lobj, Robj);
            }
            throw new ImqIncompatibleTypeComparisonException(rttExpr.getSqlTypeName(Lexp.getSqlType()), rttExpr.getSqlTypeName(Rexp.getSqlType()), operator);
        }
        return rttExprComparator.doubleCompare(Lobj, Robj);
    }

    private static int stringOrBinaryCompare(rttExpr Lexp, rttExpr Rexp, String operator) {
        Object Lobj = Lexp.getResult();
        Object Robj = Rexp.getResult();
        if (Lexp.isMetaDataKnown() && !Rexp.isMetaDataKnown()) {
            if (Lexp.isString()) {
                return rttExprComparator.stringCompare(Lobj, Robj);
            }
            return rttExprComparator.binaryCompare(Lobj, Robj);
        }
        if (!Lexp.isMetaDataKnown() && Rexp.isMetaDataKnown()) {
            if (Rexp.isString()) {
                return rttExprComparator.stringCompare(Lobj, Robj);
            }
            return rttExprComparator.binaryCompare(Lobj, Robj);
        }
        if (Lexp.isMetaDataKnown() && Rexp.isMetaDataKnown()) {
            if (Lexp.isString() && Rexp.isString()) {
                return rttExprComparator.stringCompare(Lobj, Robj);
            }
            if (Lexp.isBinary() && Rexp.isBinary()) {
                return rttExprComparator.binaryCompare(Lobj, Robj);
            }
            throw new ImqIncompatibleTypeComparisonException(rttExpr.getSqlTypeName(Lexp.getSqlType()), rttExpr.getSqlTypeName(Rexp.getSqlType()), operator);
        }
        try {
            return rttExprComparator.binaryCompare(Lobj, Robj);
        }
        catch (Exception e1) {
            try {
                return rttExprComparator.stringCompare(Lobj, Robj);
            }
            catch (Exception e2) {
                throw new ImqIncompatibleTypeComparisonException(rttExpr.getSqlTypeName(Lexp.getSqlType()), rttExpr.getSqlTypeName(Rexp.getSqlType()), operator);
            }
        }
    }

    private static int stringOrNumericCompare(rttExpr Lexp, rttExpr Rexp, String operator) {
        Object Lobj = Lexp.getResult();
        Object Robj = Rexp.getResult();
        if (Lexp.isMetaDataKnown() && !Rexp.isMetaDataKnown()) {
            if (Lexp.isString()) {
                return rttExprComparator.stringCompare(Lobj, Robj);
            }
            return rttExprComparator.numericCompare(Lexp, Rexp, operator);
        }
        if (!Lexp.isMetaDataKnown() && Rexp.isMetaDataKnown()) {
            if (Rexp.isString()) {
                return rttExprComparator.stringCompare(Lobj, Robj);
            }
            return rttExprComparator.numericCompare(Lexp, Rexp, operator);
        }
        if (Lexp.isMetaDataKnown() && Rexp.isMetaDataKnown()) {
            if (Lexp.isString() && Rexp.isString()) {
                return rttExprComparator.stringCompare(Lobj, Robj);
            }
            if (Lexp.isBinary() && Rexp.isBinary()) {
                return rttExprComparator.numericCompare(Lexp, Rexp, operator);
            }
            throw new ImqIncompatibleTypeComparisonException(rttExpr.getSqlTypeName(Lexp.getSqlType()), rttExpr.getSqlTypeName(Rexp.getSqlType()), operator);
        }
        try {
            return rttExprComparator.numericCompare(Lexp, Rexp, operator);
        }
        catch (Exception e1) {
            try {
                return rttExprComparator.stringCompare(Lobj, Robj);
            }
            catch (Exception e2) {
                throw new ImqIncompatibleTypeComparisonException(rttExpr.getSqlTypeName(Lexp.getSqlType()), rttExpr.getSqlTypeName(Rexp.getSqlType()), operator);
            }
        }
    }

    private static int genericCompare(rttExpr left, rttExpr right, String operator) {
        Object Lobj = left.getResult();
        Object Robj = right.getResult();
        if (Lobj == null && Robj == null) {
            return 0;
        }
        if (Lobj == null && Robj != null) {
            return -1;
        }
        if (Lobj != null && Robj == null) {
            return 1;
        }
        int ljt = left.getJavaType();
        int rjt = right.getJavaType();
        if (ljt == 9 && rjt == 9) {
            return ((String)Lobj).compareTo((String)Robj);
        }
        if (rttExpr.isBoolean(ljt) && rttExpr.isBoolean(rjt)) {
            return rttExprComparator.booleanCompare(Lobj, Robj);
        }
        if (rttExpr.isBinaryOrString(ljt) && rttExpr.isBinaryOrString(rjt)) {
            return rttExprComparator.stringOrBinaryCompare(left, right, operator);
        }
        if (rttExpr.isNumeric(ljt) && rttExpr.isNumeric(rjt)) {
            return rttExprComparator.numericCompare(left, right, operator);
        }
        if (rttExpr.isNumericOrString(ljt) && rttExpr.isNumericOrString(rjt)) {
            return rttExprComparator.stringOrNumericCompare(left, right, operator);
        }
        if (rttExpr.isDateOrString(ljt) && rttExpr.isDateOrString(rjt)) {
            return rttExprComparator.stringOrDateCompare(left, right, operator);
        }
        throw new ImqUnsupportedTypeComparisonException(rttExpr.getJavaTypeName(ljt), rttExpr.getJavaTypeName(rjt), operator);
    }

    static int compare(rttExpr left, rttExpr right, String operator) {
        try {
            return rttExprComparator.genericCompare(left, right, operator);
        }
        catch (NeoException e) {
            String exceptionDetail = e.getDetail();
            if (exceptionDetail.trim().equals("")) {
                exceptionDetail = e.getMessage();
            }
            throw new ImqComparisonException(exceptionDetail, operator);
        }
    }

    static void validate(rttExpr left, rttExpr right) throws imqException {
    }

    public static class ImqComparisonException
    extends ImqRuntimeException {
        private String operator;
        private String msg;

        public ImqComparisonException(String msg, String operator) {
            this.msg = msg;
            this.operator = operator;
        }

        public String getMsg() {
            return this.msg;
        }

        public String getOperator() {
            return this.operator;
        }
    }
}

