/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.imq.QueryJoinPlan;
import coldfusion.sql.imq.TableList;
import coldfusion.sql.imq.TableListIterator;
import coldfusion.sql.imq.imqException;
import coldfusion.sql.imq.rttExpr;
import coldfusion.sql.imq.rttExprColumnref;
import coldfusion.sql.imq.rttExprComparator;
import coldfusion.sql.imq.rttExprCond;
import coldfusion.sql.imq.rttSelectExprSpec;

class rttExprCondComp
extends rttExprCond {
    static final int LESS = 1;
    static final int LESSEQUAL = 2;
    static final int GREATER = 3;
    static final int GREATEREQUAL = 4;
    static final int EQUAL = 5;
    static final int NOTEQUAL = 6;
    rttExpr left;
    rttExpr right;
    int operator;
    rttExpr[] leftRight;

    rttExprCondComp(rttExpr LeftExpr, rttExpr RightExpr, int Operator) {
        this.left = LeftExpr;
        this.right = RightExpr;
        this.operator = Operator;
    }

    @Override
    boolean hasAggrExpr() {
        return this.left.hasAggrExpr() || this.right.hasAggrExpr();
    }

    @Override
    boolean isSimpleJoinCondition() {
        return this.operator == 5 && this.left instanceof rttExprColumnref && this.right instanceof rttExprColumnref;
    }

    @Override
    int[] getJoinColumnsId() {
        int[] colId = new int[2];
        int leftTblId = ((rttExprColumnref)this.left).getTableId();
        int leftColId = ((rttExprColumnref)this.left).getColumnId();
        int rightTblId = ((rttExprColumnref)this.right).getTableId();
        int rightColId = ((rttExprColumnref)this.right).getColumnId();
        colId[leftTblId] = leftColId;
        colId[rightTblId] = rightColId;
        this.leftRight = new rttExpr[2];
        this.leftRight[0] = leftTblId == 0 ? this.left : this.right;
        this.leftRight[1] = leftTblId == 0 ? this.right : this.left;
        return colId;
    }

    @Override
    int evaluateSimpleJoin(TableListIterator tblListIter) throws imqException {
        this.left.evaluate(tblListIter);
        this.right.evaluate(tblListIter);
        return rttExprComparator.compare(this.leftRight[0], this.leftRight[1], "=");
    }

    @Override
    void validate(TableList tableList) throws imqException {
        this.left.validate(tableList);
        this.right.validate(tableList);
        rttExprComparator.validate(this.left, this.right);
    }

    @Override
    void validateHaving(rttSelectExprSpec SelectSpec) throws imqException {
        this.left.validateHaving(SelectSpec);
        this.right.validateHaving(SelectSpec);
        rttExprComparator.validate(this.left, this.right);
    }

    @Override
    void evaluate(TableListIterator tblListIter) throws imqException {
        this.left.evaluate(tblListIter);
        this.right.evaluate(tblListIter);
        int compVal = rttExprComparator.compare(this.left, this.right, this.toString());
        switch (this.operator) {
            case 1: {
                this.result = compVal < 0;
                break;
            }
            case 2: {
                this.result = compVal <= 0;
                break;
            }
            case 3: {
                this.result = compVal > 0;
                break;
            }
            case 4: {
                this.result = compVal >= 0;
                break;
            }
            case 5: {
                this.result = compVal == 0;
                break;
            }
            case 6: {
                this.result = compVal != 0;
                break;
            }
            default: {
                throw new imqException("Unknown conditional operator");
            }
        }
    }

    @Override
    boolean optimize(QueryJoinPlan qjp, rttExprCond parentCond) {
        switch (this.operator) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return false;
            }
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        switch (this.operator) {
            case 1: {
                return "<";
            }
            case 2: {
                return "<=";
            }
            case 3: {
                return ">";
            }
            case 4: {
                return ">=";
            }
            case 5: {
                return "=";
            }
            case 6: {
                return "<>";
            }
        }
        return "unknown";
    }
}

