/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.imq.ImqInvalidEscapeSequenceException;
import coldfusion.sql.imq.QueryJoinPlan;
import coldfusion.sql.imq.TableList;
import coldfusion.sql.imq.TableListIterator;
import coldfusion.sql.imq.imqException;
import coldfusion.sql.imq.rttExprCond;
import coldfusion.sql.imq.rttExprString;
import coldfusion.sql.imq.rttSelectExprSpec;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class rttExprCondLike
extends rttExprCond {
    rttExprString left;
    rttExprString right;
    boolean notLike;
    private static String pattern = null;
    private static Pattern jregPattern = null;
    private static char escapeChar;

    rttExprCondLike(rttExprString LeftExpr, rttExprString RightExpr, boolean NotLike, char escape) {
        this.left = LeftExpr;
        this.right = RightExpr;
        this.notLike = NotLike;
        escapeChar = escape;
    }

    private static String translateSqlPattern(String patternStr) throws imqException {
        StringBuilder newPattern = new StringBuilder(200);
        boolean insideParen = false;
        block8: for (int i = 0; i < patternStr.length(); ++i) {
            if (patternStr.charAt(i) == escapeChar) {
                if (i + 1 >= patternStr.length() || patternStr.charAt(i + 1) != '%' && patternStr.charAt(i + 1) != '_' && patternStr.charAt(i + 1) != escapeChar) {
                    throw new imqException(new ImqInvalidEscapeSequenceException(escapeChar));
                }
                if (patternStr.charAt(i + 1) == '\\') {
                    newPattern.append(escapeChar);
                }
                newPattern.append(patternStr.charAt(i + 1));
                ++i;
                continue;
            }
            switch (patternStr.charAt(i)) {
                case '%': {
                    if (insideParen) {
                        newPattern.append(patternStr.charAt(i));
                        continue block8;
                    }
                    newPattern.append("[\\S\\s]*");
                    continue block8;
                }
                case '_': {
                    if (insideParen) {
                        newPattern.append(patternStr.charAt(i));
                        continue block8;
                    }
                    newPattern.append("[\\S\\s]");
                    continue block8;
                }
                case '\'': {
                    if (i + 1 >= patternStr.length() || patternStr.charAt(i + 1) != '\'') continue block8;
                    newPattern.append('\'');
                    ++i;
                    continue block8;
                }
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '\\': 
                case '{': 
                case '|': 
                case '}': {
                    newPattern.append('\\');
                    newPattern.append(patternStr.charAt(i));
                    continue block8;
                }
                case '[': {
                    if (i + 1 < patternStr.length() && patternStr.charAt(i + 1) == ']') {
                        newPattern.append('[');
                        newPattern.append(0);
                        newPattern.append(']');
                        ++i;
                        continue block8;
                    }
                    insideParen = true;
                    newPattern.append(patternStr.charAt(i));
                    continue block8;
                }
                case ']': {
                    insideParen = false;
                    newPattern.append(patternStr.charAt(i));
                    continue block8;
                }
                default: {
                    newPattern.append(patternStr.charAt(i));
                }
            }
        }
        return newPattern.toString();
    }

    @Override
    void validate(TableList tableList) throws imqException {
        try {
            this.left.validate(tableList);
        }
        catch (imqException le) {
            throw new imqException(le.getMessage() + "on the left of the LIKE condition");
        }
        try {
            this.right.validate(tableList);
        }
        catch (imqException re) {
            throw new imqException(re.getMessage() + "on the right of the LIKE condition");
        }
    }

    @Override
    void validateHaving(rttSelectExprSpec selectSpec) throws imqException {
        this.left.validateHaving(selectSpec);
        this.right.validateHaving(selectSpec);
    }

    @Override
    void evaluate(TableListIterator tblListIter) throws imqException {
        this.left.evaluate(tblListIter);
        this.right.evaluate(tblListIter);
        String leftStr = (String)this.left.getResult();
        String rightStr = (String)this.right.getResult();
        Object processedResult = this.right.getProcessedResult();
        if (this.right.isColumnReference()) {
            this.result = leftStr.equals(rightStr);
        } else {
            if (processedResult instanceof Pattern) {
                jregPattern = (Pattern)processedResult;
            } else {
                try {
                    pattern = rttExprCondLike.translateSqlPattern(rightStr);
                    jregPattern = Pattern.compile(pattern);
                    this.right.setProcessedResult(jregPattern);
                }
                catch (imqException e) {
                    throw new RuntimeException(e);
                }
            }
            if (leftStr != null) {
                Matcher matcher = jregPattern.matcher(leftStr);
                this.result = matcher.matches();
            }
        }
        if (this.notLike) {
            this.result = !this.result;
        }
    }

    @Override
    boolean optimize(QueryJoinPlan qjp, rttExprCond parentCond) {
        return true;
    }
}

