/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.imq.imqException;
import coldfusion.sql.imq.rttExprColumnref;
import coldfusion.sql.imq.rttExprRef;
import coldfusion.sql.imq.rttExprString;
import coldfusion.sql.imq.rttSelectExprSpec;
import java.math.BigDecimal;

class rttExprNum
extends rttExprRef {
    protected boolean isInitializedNull = false;

    rttExprNum() {
    }

    rttExprNum(Float fObj) {
        this.resultObj = new Double(fObj.doubleValue());
        this.sqlType = 7;
        this.javaType = 3;
    }

    rttExprNum(Double dObj) {
        this.resultObj = dObj;
        this.sqlType = 8;
        this.javaType = 4;
    }

    rttExprNum(Integer iObj) {
        this.resultObj = new Long(iObj.longValue());
        this.sqlType = 4;
        this.javaType = 1;
    }

    rttExprNum(Long lObj) {
        this.resultObj = lObj;
        this.sqlType = -5;
        this.javaType = 2;
    }

    rttExprNum(Object obj) {
        this.resultObj = obj;
        if (this.resultObj == null) {
            this.isInitializedNull = true;
        }
        this.sqlType = 0;
        this.javaType = 0;
    }

    rttExprNum(String strObj) {
        this.resultObj = rttExprString.escapeSingleQuotes(strObj);
        this.sqlType = 12;
        this.javaType = 9;
    }

    rttExprNum(rttExprColumnref colExpr) {
        this.colRefExpr = colExpr;
    }

    @Override
    boolean hasAggrExpr() {
        return false;
    }

    rttExprString asRttExprString() {
        if (this.colRefExpr != null) {
            return new rttExprString(this.colRefExpr, 0);
        }
        return new rttExprString((String)this.resultObj);
    }

    @Override
    void validateGroupBy(rttSelectExprSpec selectSpec) throws imqException {
        if (this.colRefExpr != null) {
            this.colRefExpr.validateGroupBy(selectSpec);
        }
    }

    @Override
    void validateHaving(rttSelectExprSpec selectSpec) throws imqException {
        if (this.colRefExpr != null) {
            this.colRefExpr.validateHaving(selectSpec);
        }
    }

    long getLong() throws imqException {
        Object obj = this.getResult();
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1L : 0L;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof Character) {
            char ch = ((Character)obj).charValue();
            if (ch >= '0' && ch <= '9') {
                return Character.digit(ch, 10);
            }
            throw new imqException(obj.getClass().getName() + " -> long");
        }
        if (obj instanceof String) {
            try {
                return Long.parseLong(obj.toString());
            }
            catch (NumberFormatException ex) {
                throw new imqException(obj.getClass().getName() + " -> long");
            }
        }
        if (obj instanceof char[]) {
            return 1L;
        }
        throw new imqException(obj.getClass().getName() + " -> long");
    }

    double getDouble() throws imqException {
        Object obj = this.getResult();
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1.0 : 0.0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof Character) {
            char ch = ((Character)obj).charValue();
            if (ch >= '0' && ch <= '9') {
                return Character.digit(ch, 10);
            }
            throw new imqException(obj.getClass().getName() + " -> double");
        }
        if (obj instanceof String) {
            try {
                return Double.parseDouble(obj.toString());
            }
            catch (NumberFormatException ex) {
                throw new imqException(obj.getClass().getName() + " -> double");
            }
        }
        if (obj instanceof char[]) {
            return 1.0;
        }
        throw new imqException(obj.getClass().getName() + " -> double");
    }

    public BigDecimal getBigDecimal() throws imqException {
        Object obj = this.getResult();
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof Number) {
            try {
                return new BigDecimal(obj.toString());
            }
            catch (NumberFormatException ex) {
                throw new imqException(obj.getClass().getName() + " -> BigDecimal");
            }
        }
        if (obj instanceof String) {
            try {
                return new BigDecimal(obj.toString());
            }
            catch (NumberFormatException ex) {
                throw new imqException(obj.getClass().getName() + " -> BigDecimal");
            }
        }
        if (obj instanceof Character) {
            char ch = ((Character)obj).charValue();
            if (ch >= '0' && ch <= '9') {
                return new BigDecimal(obj.toString());
            }
            throw new imqException(obj.getClass().getName() + " -> BigDecimal");
        }
        if (obj instanceof char[]) {
            return new BigDecimal(1);
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? new BigDecimal(1) : new BigDecimal(0);
        }
        throw new imqException(obj.getClass().getName() + " -> BigDecimal");
    }
}

