/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.imq.ExprColumn;
import coldfusion.sql.imq.GroupTableListIterator;
import coldfusion.sql.imq.ImqInvalidAggrFuncOperandTypeException;
import coldfusion.sql.imq.TableList;
import coldfusion.sql.imq.TableListIterator;
import coldfusion.sql.imq.imqException;
import coldfusion.sql.imq.rttExpr;
import coldfusion.sql.imq.rttExprNum;
import coldfusion.sql.imq.rttExprString;
import coldfusion.sql.imq.rttExprStringAggr;
import coldfusion.sql.imq.rttSelectExprSpec;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Vector;

abstract class rttExprNumAggr
extends rttExprNum {
    protected rttExprNum expr;
    protected boolean distinctFlag;
    static final int SUM_AVG = 0;
    static final int MIN_MAX = 1;
    static final int COUNT_EXPR = 2;

    rttExprNumAggr() {
        this.expr = null;
        this.distinctFlag = false;
    }

    rttExprNumAggr(rttExprNum Expr, boolean AllDistinct) {
        this.expr = Expr;
        this.distinctFlag = AllDistinct;
    }

    boolean isAggrExpr() {
        return true;
    }

    void setNumExpr(rttExprNum numExpr) {
        this.expr = numExpr;
    }

    void setDistinctFlag() {
        this.distinctFlag = true;
    }

    @Override
    boolean hasAggrExpr() {
        return true;
    }

    @Override
    rttExprString asRttExprString() {
        return new rttExprStringAggr(this);
    }

    abstract String getAggrFuncName();

    abstract Object aggrOperator(Comparable var1, Comparable var2);

    abstract double aggrOperator(double var1, double var3);

    abstract long aggrOperator(long var1, long var3);

    abstract BigDecimal aggrOperator(BigDecimal var1, BigDecimal var2);

    double getDoubleAggrSeed() {
        return 0.0;
    }

    long getLongAggrSeed() {
        return 0L;
    }

    void validate(TableList tableList, int type) throws imqException {
        this.expr.validate(tableList);
        int jType = this.expr.getJavaType();
        switch (jType) {
            case 1: 
            case 2: {
                this.javaType = 2;
                break;
            }
            case 3: 
            case 4: {
                this.javaType = 4;
                break;
            }
            case 5: {
                this.javaType = 5;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (type == 1) {
                    this.javaType = jType;
                    break;
                }
                if (type == 2) {
                    this.javaType = 2;
                    break;
                }
                String SqlTypeName = rttExpr.getSqlTypeName(rttExpr.JavaToSqlMapping(jType));
                throw new imqException(new ImqInvalidAggrFuncOperandTypeException(this.getAggrFuncName(), SqlTypeName));
            }
            case -1: {
                this.javaType = -1;
                break;
            }
            default: {
                throw new imqException(new ImqInvalidAggrFuncOperandTypeException(this.getAggrFuncName(), rttExpr.getSqlTypeName(rttExpr.JavaToSqlMapping(jType))));
            }
        }
        this.sqlType = rttExpr.JavaToSqlMapping(this.javaType);
    }

    @Override
    void validateHaving(rttSelectExprSpec selectSpec) throws imqException {
        this.validate(selectSpec.getTableList());
        ExprColumn exprCol = new ExprColumn(this, '\b');
        selectSpec.getExpandedSelectList().addColumn(exprCol);
    }

    private Object aggrGroup(Vector aggrVect) throws imqException {
        if (aggrVect.isEmpty()) {
            return null;
        }
        Object aggregate = null;
        switch (this.javaType) {
            case 2: {
                long accumulator = this.getLongAggrSeed();
                for (int i = 0; i < aggrVect.size(); ++i) {
                    accumulator = this.aggrOperator(accumulator, ((Number)aggrVect.get(i)).longValue());
                }
                aggregate = new Long(accumulator);
                break;
            }
            case 4: {
                double accumulator = this.getDoubleAggrSeed();
                for (int i = 0; i < aggrVect.size(); ++i) {
                    accumulator = this.aggrOperator(accumulator, ((Number)aggrVect.get(i)).doubleValue());
                }
                aggregate = new Double(accumulator);
                break;
            }
            case 5: {
                if (aggrVect.size() <= 0) break;
                aggregate = aggrVect.get(0);
                for (int i = 1; i < aggrVect.size(); ++i) {
                    aggregate = this.aggrOperator((BigDecimal)aggregate, (BigDecimal)aggrVect.get(i));
                }
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (aggrVect.size() <= 0) break;
                aggregate = aggrVect.get(0);
                for (int i = 1; i < aggrVect.size(); ++i) {
                    aggregate = this.aggrOperator((Comparable)aggregate, (Comparable)aggrVect.get(i));
                }
                break;
            }
        }
        return aggregate;
    }

    private Vector removeDuplicates(Vector V) {
        Object[] A = V.toArray();
        Arrays.sort(A);
        V.clear();
        V.add(A[0]);
        int j = 0;
        for (int i = 1; i < A.length; ++i) {
            if (A[j].equals(A[i])) continue;
            j = i;
            V.add(A[i]);
        }
        return V;
    }

    Vector evaluateGroup(GroupTableListIterator giter) throws imqException {
        Vector aggrVect = new Vector(giter.getGroupSize());
        while (giter.hasNext(0)) {
            this.expr.evaluate(giter);
            if (this.expr.getResult() != null) {
                aggrVect.add(this.expr.getResult());
            }
            giter.next(0);
        }
        if (aggrVect.size() > 0) {
            if (this.distinctFlag) {
                aggrVect = this.removeDuplicates(aggrVect);
            }
            giter.resetWithinGroup(0);
        }
        return aggrVect;
    }

    @Override
    void evaluate(TableListIterator tblListIter) throws imqException {
        if (tblListIter.getEvaluationMode() == 1) {
            this.setResult(this.getExprColumn().evaluate(tblListIter));
        } else {
            GroupTableListIterator giter = (GroupTableListIterator)tblListIter;
            Vector aggrVect = this.evaluateGroup(giter);
            Object aggregate = this.aggrGroup(aggrVect);
            this.setResult(aggregate);
        }
    }
}

