/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.imq.TableList;
import coldfusion.sql.imq.TableListIterator;
import coldfusion.sql.imq.imqException;
import coldfusion.sql.imq.rttExpr;
import coldfusion.sql.imq.rttExprNum;
import coldfusion.sql.imq.rttSelectExprSpec;

abstract class rttExprNumBinary
extends rttExprNum {
    rttExprNum Le;
    rttExprNum Re;

    rttExprNumBinary(rttExprNum left, rttExprNum right) {
        this.Le = left;
        this.Re = right;
    }

    @Override
    void evaluate(TableListIterator tblListIter) throws imqException {
        this.Le.evaluate(tblListIter);
        this.Re.evaluate(tblListIter);
    }

    @Override
    void validate(TableList tableList) throws imqException {
        this.Le.validate(tableList);
        this.Re.validate(tableList);
        this.javaType = this.combinedJavaType(this.Le, this.Re);
        this.sqlType = rttExpr.JavaToSqlMapping(this.javaType);
    }

    @Override
    void validateGroupBy(rttSelectExprSpec selectSpec) throws imqException {
        this.Le.validateGroupBy(selectSpec);
        this.Re.validateGroupBy(selectSpec);
    }

    @Override
    void validateHaving(rttSelectExprSpec selectSpec) throws imqException {
        this.Le.validateHaving(selectSpec);
        this.Re.validateHaving(selectSpec);
        int Ljt = this.Le.getJavaType();
        int Rjt = this.Re.getJavaType();
        this.javaType = this.combinedJavaType(Ljt, Rjt);
        this.sqlType = rttExpr.JavaToSqlMapping(this.javaType);
    }

    void setResultObject(long lv) {
        this.resultObj = new Long(lv);
    }

    void setResultObject(double dv) {
        this.resultObj = new Double(dv);
    }

    int combinedJavaType(int lt, int rt) throws imqException {
        if (lt == 0 || rt == 0) {
            return 0;
        }
        if (!rttExpr.isNumeric(lt) || !rttExpr.isNumeric(rt)) {
            throw new imqException("Cannot apply the binary numeric operator [*|/] on a non numeric type");
        }
        return lt < rt ? rt : lt;
    }

    int combinedJavaType(rttExprNum re, rttExprNum le) throws imqException {
        int leJavaType = le.getJavaType();
        int reJavaType = re.getJavaType();
        boolean isLeNumeric = rttExpr.isNumeric(leJavaType);
        boolean isReNumeric = rttExpr.isNumeric(reJavaType);
        if (isLeNumeric && isReNumeric) {
            return leJavaType > reJavaType ? leJavaType : reJavaType;
        }
        if (isReNumeric) {
            this.handleEmptyStringObject(le);
            return reJavaType;
        }
        if (isLeNumeric) {
            this.handleEmptyStringObject(re);
            return leJavaType;
        }
        return this.combinedJavaType(leJavaType, reJavaType);
    }

    @Override
    boolean hasAggrExpr() {
        return this.Le.hasAggrExpr() || this.Re.hasAggrExpr();
    }

    void handleEmptyStringObject(rttExprNum num) {
        if (num.getJavaType() == 9 && num.getResult() == null || num.getResult() instanceof String && ((String)num.getResult()).trim().isEmpty()) {
            num.setResult("0");
        }
    }
}

