/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.imq.TableList;
import coldfusion.sql.imq.TableListIterator;
import coldfusion.sql.imq.imqException;
import coldfusion.sql.imq.rttExprNum;
import coldfusion.sql.imq.rttExprNumBinary;
import java.math.BigDecimal;

final class rttExprNumBinaryDiv
extends rttExprNumBinary {
    private static String DIVIDE_BY_ZERO_EXCEPTION = "Division by zero exception";

    rttExprNumBinaryDiv(rttExprNum left, rttExprNum right) {
        super(left, right);
    }

    @Override
    void evaluate(TableListIterator tblListIter) throws imqException {
        super.evaluate(tblListIter);
        if (this.Re.getDouble() == 0.0) {
            throw new imqException(DIVIDE_BY_ZERO_EXCEPTION);
        }
        switch (this.getJavaType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                double dval = this.Le.getDouble() / this.Re.getDouble();
                this.setResultObject(dval);
                break;
            }
            case 5: {
                BigDecimal dval = this.Le.getBigDecimal().divide(this.Re.getBigDecimal(), 5);
                this.setResult(dval);
                break;
            }
        }
    }

    @Override
    void validate(TableList tableList) throws imqException {
        super.validate(tableList);
        this.javaType = 4;
        this.sqlType = 8;
    }
}

