/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.QueryTable;
import coldfusion.sql.QueryTableMetaData;
import coldfusion.sql.imq.ColumnMetaData;
import coldfusion.sql.imq.ExprColumn;
import coldfusion.sql.imq.GroupByColumnList;
import coldfusion.sql.imq.GroupTableListIterator;
import coldfusion.sql.imq.OrderByColumnList;
import coldfusion.sql.imq.Row;
import coldfusion.sql.imq.RowTuple;
import coldfusion.sql.imq.SelectColumnList;
import coldfusion.sql.imq.TableList;
import coldfusion.sql.imq.TableListIterator;
import coldfusion.sql.imq.TupleSorter;
import coldfusion.sql.imq.imqException;
import coldfusion.sql.imq.imqTable;
import coldfusion.sql.imq.jdbcConnection;
import coldfusion.sql.imq.jdbcStatement;
import coldfusion.sql.imq.rttExpr;
import coldfusion.sql.imq.rttExprColumnref;
import coldfusion.sql.imq.rttExprCond;
import coldfusion.sql.imq.rttExprCondTrue;
import coldfusion.sql.imq.rttExprOrderedcolumnref;
import coldfusion.sql.imq.rttSelectExpr;
import coldfusion.sql.imq.rttSelectStmt;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

class rttSelectExprSpec
extends rttSelectExpr {
    boolean distinctFlag = false;
    protected jdbcStatement jdbcStmt = null;
    private SelectColumnList selectList = null;
    private SelectColumnList expandedSelectList = null;
    private SelectColumnList expandedScratchList = null;
    private TableList fromTableList = null;
    private GroupByColumnList groupByList = null;
    private rttExprCond whereCond = new rttExprCondTrue();
    private rttExprCond havingCond = null;
    private LinkedList columnNames = new LinkedList();
    private static String debugImqStandalone = System.getProperty("DEBUG_IMQ");

    rttSelectExprSpec() {
    }

    @Override
    void setParentStmt(rttSelectStmt stmt) {
        this.parentStmt = stmt;
    }

    void setJdbcStatement(jdbcStatement stmt) {
        this.jdbcStmt = stmt;
    }

    void setSelectList(SelectColumnList selectColList) {
        this.selectList = selectColList;
    }

    SelectColumnList getSelectList() {
        return this.selectList;
    }

    @Override
    SelectColumnList getExpandedSelectList() {
        return this.expandedSelectList;
    }

    void setTableList(TableList tableList) {
        this.fromTableList = tableList;
    }

    TableList getTableList() {
        return this.fromTableList;
    }

    void setGroupByList(GroupByColumnList list) {
        this.groupByList = list;
    }

    GroupByColumnList getGroupByList() {
        return this.groupByList;
    }

    void setWhereCondition(rttExprCond WhereCond) {
        this.whereCond = WhereCond;
    }

    void setHavingCondition(rttExprCond HavingCond) {
        this.havingCond = HavingCond;
    }

    void setDistinctFlag() {
        this.distinctFlag = true;
    }

    private String[] toArray(List ColList) {
        String[] colNames = new String[this.columnNames.size()];
        for (int i = 0; i < this.columnNames.size(); ++i) {
            colNames[i] = (String)this.columnNames.get(i);
        }
        return colNames;
    }

    private QueryTableMetaData createResultTableMetaData() {
        QueryTableMetaData tblMeta = new QueryTableMetaData();
        int colCount = this.expandedSelectList.getColumnCount();
        String[] colName = new String[colCount];
        boolean[] colCase = new boolean[colCount];
        int[] colType = new int[colCount];
        String[] colTypeName = new String[colCount];
        ListIterator iter = this.expandedSelectList.colList.listIterator();
        int i = 0;
        while (iter.hasNext()) {
            ExprColumn col = (ExprColumn)iter.next();
            ColumnMetaData colMeta = col.getMetaData();
            colName[i] = colMeta.colName;
            colCase[i] = colMeta.colCase;
            colType[i] = colMeta.colType;
            colTypeName[i] = rttExpr.getSqlTypeName(colMeta.colType);
            ++i;
        }
        tblMeta.setColumnCount(colCount);
        tblMeta.setColumnLabel(colName);
        tblMeta.setColumnCase(colCase);
        tblMeta.setColumnType(colType);
        tblMeta.setColumnTypeNames(colTypeName);
        return tblMeta;
    }

    private QueryTable createResultTable() {
        String[] colNames = this.toArray(this.columnNames);
        QueryTable tbl = new QueryTable(0, colNames);
        QueryTableMetaData tblMeta = this.createResultTableMetaData();
        tbl.setMetaData(tblMeta);
        this.setResultTable(tbl);
        return tbl;
    }

    @Override
    void evaluate() throws imqException {
        QueryTable resultTable = this.createResultTable();
        boolean selectListHasAggrExpr = this.expandedSelectList.hasAggrExpr();
        if (!selectListHasAggrExpr && this.groupByList == null) {
            if (this.fromTableList.size() == 1) {
                this.evaluateWhere(resultTable);
            } else {
                Vector tupleVect = this.evaluateJoin();
                this.evaluateNonGroupBy(resultTable, tupleVect);
            }
        } else {
            Vector tupleVect = this.fromTableList.size() == 1 ? this.evaluateAggrWhere() : this.evaluateJoin();
            if (!tupleVect.isEmpty()) {
                this.evaluateGroupBy(resultTable, tupleVect);
            } else if (this.groupByList == null) {
                resultTable.addRows(1, false);
            }
            if (this.havingCond != null) {
                this.evaluateHaving(resultTable);
            }
        }
        if (this.distinctFlag && this.groupByList == null && !selectListHasAggrExpr) {
            this.evaluateDistinct(resultTable);
        }
    }

    private void evaluateWhere(QueryTable qTable) throws imqException {
        TableListIterator tblListIter = new TableListIterator(this.fromTableList);
        int tblId = 0;
        while (tblListIter.hasNext(tblId)) {
            this.whereCond.evaluate(tblListIter);
            if (this.whereCond.booleanValue()) {
                Row row = this.expandedSelectList.evaluate(tblListIter);
                qTable.addRowLast(row);
            }
            tblListIter.next(tblId);
        }
    }

    private Vector evaluateAggrWhere() throws imqException {
        Vector<RowTuple> tupleVector = new Vector<RowTuple>(32);
        TableListIterator tblListIter = new TableListIterator(this.fromTableList);
        while (tblListIter.hasNext(0)) {
            this.whereCond.evaluate(tblListIter);
            if (this.whereCond.booleanValue()) {
                RowTuple rowTuple = new RowTuple(1);
                rowTuple.set(0, tblListIter.getCurrentRow(0));
                tupleVector.addElement(rowTuple);
            }
            tblListIter.next(0);
        }
        return tupleVector;
    }

    private void evaluateGroupBy(QueryTable qTable, Vector tupleVector) throws imqException {
        TupleSorter tupleSorter = null;
        GroupTableListIterator gtblIter = null;
        if (this.groupByList != null) {
            tupleSorter = new TupleSorter(this.fromTableList, tupleVector, this.groupByList);
            tupleSorter.mergeSort();
            gtblIter = new GroupTableListIterator(this.fromTableList, tupleSorter);
        } else {
            gtblIter = new GroupTableListIterator(this.fromTableList, tupleVector, true);
        }
        if (gtblIter.hasNextGroup()) {
            while (gtblIter.hasNextGroup()) {
                gtblIter.nextGroup();
                Row row = this.expandedSelectList.evaluate(gtblIter);
                qTable.addRowLast(row);
            }
        } else {
            Row row = this.expandedSelectList.evaluate(gtblIter);
            qTable.addRowLast(row);
        }
    }

    private void evaluateNonGroupBy(QueryTable qTable, Vector tupleVector) throws imqException {
        GroupTableListIterator gtblIter = new GroupTableListIterator(this.fromTableList, tupleVector, false);
        while (gtblIter.hasNextGroup()) {
            gtblIter.nextGroup();
            Row row = this.expandedSelectList.evaluate(gtblIter);
            qTable.addRowLast(row);
        }
    }

    private void evaluateHaving(QueryTable qTable) throws imqException {
        TableList tblList = new TableList();
        tblList.addTableName("ResultTable");
        tblList.setTable(qTable, 0);
        TableListIterator tblListIter = new TableListIterator(tblList, 1);
        while (tblListIter.hasNext(0)) {
            this.havingCond.evaluate(tblListIter);
            if (!this.havingCond.booleanValue()) {
                qTable.removeRow(tblListIter.getCurrentRow(0));
            }
            tblListIter.next(0);
        }
        qTable.resetRowVector();
    }

    private void evaluateDistinct(QueryTable qTable) throws imqException {
        QueryTable imqTbl = qTable;
        int resColCount = this.expandedSelectList.getResultColumnCount();
        imqTbl.sort(resColCount);
        imqTbl.removeDuplicateRows(resColCount);
    }

    private Vector evaluateSimpleJoin() throws imqException {
        Vector<RowTuple> tupleVector = new Vector<RowTuple>(100);
        TableListIterator tblListIter = new TableListIterator(this.fromTableList);
        while (tblListIter.hasNext(0)) {
            tblListIter.reset(1);
            while (tblListIter.hasNext(1)) {
                this.whereCond.evaluate(tblListIter);
                if (this.whereCond.booleanValue()) {
                    RowTuple rowTuple = new RowTuple(2);
                    rowTuple.set(0, tblListIter.getCurrentRow(0));
                    rowTuple.set(1, tblListIter.getCurrentRow(1));
                    tupleVector.addElement(rowTuple);
                }
                tblListIter.next(1);
            }
            tblListIter.next(0);
        }
        return tupleVector;
    }

    private Vector evaluateMergeSortJoin() throws imqException {
        TableList dupFromTableList = new TableList();
        dupFromTableList.count = 2;
        dupFromTableList.setTable(this.fromTableList.getQueryTable(0).getShallowCopy(), 0);
        dupFromTableList.setTable(this.fromTableList.getQueryTable(1).getShallowCopy(), 1);
        imqTable[] table = dupFromTableList.asImqTableArray();
        int[] colId = this.whereCond.getJoinColumnsId();
        table[0].sort(colId[0], true);
        table[1].sort(colId[1], true);
        table[0].resetRowLinks();
        table[1].resetRowLinks();
        Vector<RowTuple> tupleVector = new Vector<RowTuple>(100);
        TableListIterator tblListIter = new TableListIterator(dupFromTableList);
        while (tblListIter.hasNext(0) && tblListIter.hasNext(1)) {
            if (this.whereCond.evaluateSimpleJoin(tblListIter) > 0) {
                tblListIter.next(1);
                continue;
            }
            if (this.whereCond.evaluateSimpleJoin(tblListIter) < 0) {
                tblListIter.next(0);
                continue;
            }
            Row startRow = tblListIter.getCurrentRow(1);
            Row endRow = null;
            while (tblListIter.hasNext(0) && this.whereCond.evaluateSimpleJoin(tblListIter) == 0) {
                while (tblListIter.hasNext(1) && this.whereCond.evaluateSimpleJoin(tblListIter) == 0) {
                    RowTuple rowTuple = new RowTuple(2);
                    rowTuple.set(0, tblListIter.getCurrentRow(0));
                    rowTuple.set(1, tblListIter.getCurrentRow(1));
                    tupleVector.addElement(rowTuple);
                    tblListIter.next(1);
                }
                endRow = tblListIter.getCurrentRow(1);
                tblListIter.reset(1, startRow);
                tblListIter.next(0);
            }
            tblListIter.reset(1, endRow);
        }
        this.fromTableList.getImqTable(0).resetRowLinks();
        this.fromTableList.getImqTable(1).resetRowLinks();
        return tupleVector;
    }

    private Vector evaluateJoin() throws imqException {
        if (this.whereCond.isSimpleJoinCondition()) {
            return this.evaluateMergeSortJoin();
        }
        return this.evaluateSimpleJoin();
    }

    @Override
    void validate() throws imqException {
        if (debugImqStandalone == null || debugImqStandalone.compareToIgnoreCase("standalone") != 0) {
            jdbcConnection jdbcConn = this.getParentStmt().getJdbcStatement().getJdbcConnection();
            this.fromTableList.validate(jdbcConn);
        }
        this.expandedSelectList = new SelectColumnList();
        this.selectList.validate(this.expandedSelectList, this.fromTableList);
        this.expandedSelectList.validateUniqueAliases();
        if (this.whereCond != null) {
            this.whereCond.validate(this.fromTableList);
        }
        this.validateGroupBy();
        if (this.havingCond != null) {
            this.havingCond.validateHaving(this);
        }
        String[] colNames = this.expandedSelectList.getColumnNames();
        for (int i = 0; i < colNames.length; ++i) {
            this.columnNames.add(colNames[i]);
        }
    }

    private void validateGroupBy() throws imqException {
        if (this.groupByList != null || this.havingCond != null || this.expandedSelectList.hasAggrExpr()) {
            this.expandedSelectList.validateGroupBy(this);
        }
        if (this.groupByList != null) {
            this.groupByList.validateGroupBy(this);
        }
    }

    @Override
    void validateOrderBy(OrderByColumnList orderByList) throws imqException {
        rttExprOrderedcolumnref ordcolref;
        List<String> selectColNames = Arrays.asList(this.expandedSelectList.getColumnNames());
        selectColNames.replaceAll(String::toLowerCase);
        int count = this.expandedSelectList.getColumnCount();
        ListIterator iter = orderByList.listIterator();
        while (iter.hasNext()) {
            ordcolref = (rttExprOrderedcolumnref)iter.next();
            ordcolref.validate(this.expandedSelectList, this.fromTableList);
            if (ordcolref.getResultColumnId() != -1) continue;
            ordcolref.setResultColumnId(++count);
        }
        iter = orderByList.listIterator();
        while (iter.hasNext()) {
            ordcolref = (rttExprOrderedcolumnref)iter.next();
            rttExprColumnref exprColumnref = ordcolref.getExprColumnref();
            if (exprColumnref == null || selectColNames.contains(ordcolref.getName().toLowerCase())) continue;
            this.columnNames.add(exprColumnref.getColumnName());
        }
    }
}

