/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.datasource;

import coldfusion.runtime.DatabaseException;
import coldfusion.sql.CFDataSource;
import coldfusion.sql.DataSourceDef;
import coldfusion.sql.DataSourceFactory;
import coldfusion.tagext.GenericTag;
import coldfusion.util.UUIDUtils;
import jakarta.servlet.jsp.tagext.BodyTag;
import java.sql.SQLException;

public class DataSourceTag
extends GenericTag
implements BodyTag {
    private String dsn;
    private String driver;
    private String type;
    private DataSourceDef def = new DataSourceDef();

    @Override
    public void release() {
        this.dsn = null;
        this.def = new DataSourceDef();
    }

    public String getName() {
        return this.dsn;
    }

    public void setName(String dsn) {
        this.dsn = dsn;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (!DataSourceDef.VENDORS.containsKey(type)) {
            throw new NoSuchTypeException(type);
        }
        this.type = type;
    }

    public int doStartTag() {
        this.onTagStart();
        return 1;
    }

    protected DataSourceDef getDSDef() {
        return this.def;
    }

    public void setDatabase(String database) {
        this.def.setDatabase(database);
    }

    public void setIfxsrv(String ifxSrv) {
        this.def.setIfxSrv(ifxSrv);
    }

    public void setSid(String sid) {
        this.def.setSid(sid);
    }

    public void setServer(String server) {
        this.def.setHost(server);
    }

    public void setUsername(String username) {
        this.def.setUsername(username);
    }

    public void setPassword(String password) {
        this.def.setPassword(password);
    }

    public void setDesc(String desc) {
        this.def.setDesc(desc);
    }

    public void setPort(int port) {
        this.def.setPort(port);
    }

    public void setDriver(String driver) {
        this.def.setDriver(driver);
    }

    public int doEndTag() {
        String uuid = UUIDUtils.createUUID(false);
        try {
            this.def.setDynamic(true);
            this.def.setDsn(uuid);
            this.def.setType(this.type);
            CFDataSource ds = DataSourceFactory.getInstance().setDataSource(this.dsn, this.def);
            this.pageContext.removeAttribute(this.dsn);
            this.pageContext.setAttribute(this.dsn, (Object)ds);
        }
        catch (SQLException sqle) {
            throw new DataSourceCreationException(sqle, this.dsn);
        }
        this.onTagEnd();
        return 6;
    }

    public static class NoSuchTypeException
    extends DatabaseException {
        public String type;

        protected NoSuchTypeException(String type) {
            this.type = type;
        }

        @Override
        public String getType() {
            return this.type;
        }
    }

    public static class DataSourceCreationException
    extends DatabaseException {
        public String dsn;

        DataSourceCreationException(Throwable t, String dsn) {
            super(t);
            this.dsn = dsn;
        }

        public String getDsn() {
            return this.dsn;
        }
    }
}

