/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.ajax;

import coldfusion.compiler.ParseException;
import coldfusion.compiler.validation.TagValidationException;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.ProxyFactory;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.server.ServiceFactory;
import coldfusion.server.SystemInfo;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.html.ajax.AjaxImport;
import coldfusion.tagext.html.ajax.AjaxImportTag;
import coldfusion.tagext.html.ajax.AjaxUtils;
import coldfusion.tagext.html.ajax.BindProcessor;
import coldfusion.tagext.html.ajax.HtmlAssembler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.PageContext;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class AjaxProxyTag
extends GenericTag
implements AjaxImport {
    public static final String IMPORT_TAGNAME = "CFAJAXPROXY";
    private static final String INIT_PREFIX = "ColdFusion.AjaxProxy.init('";
    private static final String INIT_INFIX = "','";
    private static final String INIT_SUFFIX = "');";
    private static final String FUNCTION_BODY_1 = ") { return ColdFusion.AjaxProxy.invoke(this, \"";
    private static final String FUNCTION_BODY_2 = "\", {";
    private static final String PROXY_FUNCTION_CLOSE = "});};";
    private static final String EMPTY_FUNCTION = "ColdFusion.empty";
    private static final char DOT = '.';
    private static final char SLASH = '/';
    private static final String CFC_EXT = ".cfc";
    private String bind;
    private String onsuccess;
    private String onerror;
    private String cfc;
    private String jsClassname;

    public void setCfc(String cfc) {
        this.cfc = cfc;
    }

    public void setOnerror(String onerror) {
        this.onerror = onerror;
    }

    public void setOnsuccess(String onsuccess) {
        this.onsuccess = onsuccess;
    }

    public void setBind(String bind) {
        this.bind = bind;
    }

    public void setJsclassname(String jsClassname) {
        this.jsClassname = jsClassname;
    }

    @Override
    public void release() {
        this.cfc = null;
        this.jsClassname = null;
        this.bind = null;
        this.onsuccess = null;
        this.onerror = null;
        super.release();
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        this.validateAttributes();
        if (this.bind != null) {
            AjaxProxyTag.handleBind(this.pageContext, this.bind, this.onsuccess, this.onerror);
        } else {
            AjaxProxyTag.generateAjaxProxy(this.pageContext, this.cfc, this.jsClassname, null, true);
        }
        HtmlAssembler.getInstance(this.pageContext, false).writeHead(this.out, true);
        this.onTagEnd();
        return 6;
    }

    @Override
    public void generateImports(String tagName, HtmlAssembler htmlAssembler) {
        htmlAssembler.importJS("/package/cfajax.js");
    }

    public static void handleBind(PageContext pageContext, String bind, String onsuccess, String onerror) throws JspException {
        BindProcessor bindProcessor = new BindProcessor();
        HtmlAssembler htmlAssembler = HtmlAssembler.getInstance(pageContext, false);
        String bindToFunction = onsuccess;
        if (bindToFunction == null) {
            bindToFunction = EMPTY_FUNCTION;
        }
        bindProcessor.setBindToFunction(true);
        if (onerror != null) {
            bindProcessor.setErrorHandler(onerror);
        }
        bindProcessor.processBind(bindToFunction, "true", null, bind, false, htmlAssembler, -1, pageContext);
    }

    private void validateAttributes() {
        if (this.bind == null && this.cfc == null) {
            throw new AjaxProxyRequiredAttributesException();
        }
        if (this.bind != null) {
            if (this.cfc != null) {
                throw new AjaxProxyInvalidAttributesCombinationException();
            }
            if (this.jsClassname != null) {
                throw new AjaxProxyBindInvalidAttributeException();
            }
            int bindType = BindProcessor.getBindType(this.bind);
            if (bindType != 2 && bindType != 1 && bindType != 3) {
                throw new InvalidAjaxProxyBindTypeException();
            }
            if (bindType == 1 && this.onerror != null) {
                throw new InvalidAjaxProxyOnErrorUsageException();
            }
        } else if (this.cfc != null && (this.onerror != null || this.onsuccess != null)) {
            throw new AjaxProxyCfcInvalidAttributeException();
        }
    }

    public static void generateAjaxProxy(PageContext pageContext, String cfc, String jsClassname, String function, boolean generateFunctions) throws JspException {
        if (jsClassname == null) {
            jsClassname = cfc;
        }
        String cfcPath = AjaxProxyTag.getCFCInvocationPath(cfc, pageContext);
        AttributeCollection metadata = AjaxProxyTag.getCFCMetaData(cfc, pageContext);
        String cfcName = (String)metadata.get("name");
        int dotIdx = cfcName.lastIndexOf(46);
        if (dotIdx != -1) {
            cfcName = cfcName.substring(dotIdx + 1);
        }
        HtmlAssembler htmlAssembler = HtmlAssembler.getInstance(pageContext, false);
        AjaxImportTag.generateImports(IMPORT_TAGNAME, htmlAssembler);
        htmlAssembler.openScriptTag();
        htmlAssembler.appendContent("var ").appendContent("_cf_").appendContent(cfcName).appendContent("=").appendContent(INIT_PREFIX).appendContent(cfcPath).appendContent(INIT_INFIX).appendContent(jsClassname).appendContent(INIT_SUFFIX);
        if (generateFunctions || function != null) {
            boolean functionExists = false;
            Object[] functionsMetadata = (Object[])metadata.get("Functions");
            if (metadata.get("Extends") != null) {
                AttributeCollection parentsMetadata;
                if (functionsMetadata == null) {
                    functionsMetadata = new Object[]{};
                }
                String parentCFCName = parentsMetadata.get("name").toString();
                for (parentsMetadata = (AttributeCollection)metadata.get("Extends"); parentsMetadata != null && !parentCFCName.equalsIgnoreCase("WEB-INF.cftags.component"); parentsMetadata = (AttributeCollection)parentsMetadata.get("Extends")) {
                    Object[] parentFunctionsMetadata = (Object[])parentsMetadata.get("Functions");
                    if (parentFunctionsMetadata != null && parentFunctionsMetadata.length > 0) {
                        Object[] newFunctionsMetadata = new Object[functionsMetadata.length + parentFunctionsMetadata.length];
                        System.arraycopy(functionsMetadata, 0, newFunctionsMetadata, 0, functionsMetadata.length);
                        System.arraycopy(parentFunctionsMetadata, 0, newFunctionsMetadata, functionsMetadata.length, parentFunctionsMetadata.length);
                        functionsMetadata = newFunctionsMetadata;
                    }
                    parentCFCName = parentsMetadata.get("name").toString();
                }
            }
            if (functionsMetadata == null) {
                throw new CFCFunctionNotRemoteException(cfc, function);
            }
            for (int i = 0; i < functionsMetadata.length; ++i) {
                AttributeCollection functionMetadata = (AttributeCollection)functionsMetadata[i];
                String access = (String)functionMetadata.get("access");
                if (access == null || !access.equalsIgnoreCase("REMOTE")) continue;
                String functionName = (String)functionMetadata.get("name");
                if (function != null && function.equalsIgnoreCase(functionName)) {
                    functionExists = true;
                }
                if (!generateFunctions) continue;
                Object[] parameters = (Object[])functionMetadata.get("Parameters");
                htmlAssembler.newLine();
                htmlAssembler.appendContent("_cf_").appendContent(cfcName).appendContent(".prototype.").appendContent(functionName).appendContent("=").appendContent("function(");
                for (int j = 0; j < parameters.length; ++j) {
                    if (j != 0) {
                        htmlAssembler.appendContent(',');
                    }
                    String parameterName = (String)((AttributeCollection)parameters[j]).get("NAME");
                    htmlAssembler.appendContent(parameterName);
                }
                String appname = AjaxUtils.encryptAppName(FusionContext.getCurrent().getApplicationName(), htmlAssembler.getClientId());
                htmlAssembler.appendContent(FUNCTION_BODY_1).appendContent(functionName).appendContent("\",\"").appendContent(appname).appendContent(FUNCTION_BODY_2);
                for (int j = 0; j < parameters.length; ++j) {
                    if (j != 0) {
                        htmlAssembler.appendContent(',');
                    }
                    String parameterName = (String)((AttributeCollection)parameters[j]).get("NAME");
                    htmlAssembler.appendContent(parameterName).appendContent(':').appendContent(parameterName);
                }
                htmlAssembler.appendContent(PROXY_FUNCTION_CLOSE);
            }
            if (function != null && !functionExists) {
                throw new InvalidCFCFunctionException(cfc, function);
            }
        }
        htmlAssembler.closeScriptTag();
    }

    public static final String[] getCallParameters(String cfc, String function, PageContext pageContext) throws JspException {
        String cfcPath = AjaxProxyTag.getCFCInvocationPath(cfc, pageContext);
        AttributeCollection metadata = AjaxProxyTag.getCFCMetaData(cfc, pageContext);
        Object[] cfcArgs = null;
        Object[] functionsMetadata = (Object[])metadata.get("Functions");
        if (functionsMetadata == null) {
            throw new CFCFunctionNotRemoteException(cfc, function);
        }
        for (int i = 0; i < functionsMetadata.length; ++i) {
            AttributeCollection functionMetadata = (AttributeCollection)functionsMetadata[i];
            if (!((String)functionMetadata.get("name")).equalsIgnoreCase(function)) continue;
            String access = (String)functionMetadata.get("access");
            if (access != null && access.equalsIgnoreCase("REMOTE")) {
                cfcArgs = (Object[])functionMetadata.get("Parameters");
                break;
            }
            throw new CFCFunctionNotRemoteException(cfc, function);
        }
        if (cfcArgs == null) {
            throw new InvalidCFCFunctionException(cfc, function);
        }
        String[] result = new String[cfcArgs.length + 1];
        result[0] = cfcPath;
        for (int i = 0; i < cfcArgs.length; ++i) {
            String parameterName;
            result[i + 1] = parameterName = (String)((AttributeCollection)cfcArgs[i]).get("NAME");
        }
        return result;
    }

    private static AttributeCollection getCFCMetaData(String cfc, PageContext pageContext) throws JspException {
        AttributeCollection metadata = null;
        try {
            String importList = ((CFPage)pageContext.getPage()).importList;
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("pageContext", pageContext);
            props.put("importList", importList);
            TemplateProxy tp = (TemplateProxy)ProxyFactory.getProxy("COMPONENT", cfc, props);
            metadata = (AttributeCollection)tp.getRuntimeMetadata();
        }
        catch (RuntimeException r) {
            throw r;
        }
        catch (Throwable t) {
            throw new JspException(t);
        }
        if (metadata == null) {
            throw new InvalidCFCException(cfc);
        }
        return metadata;
    }

    private static String getCFCInvocationPath(String cfc, PageContext pageContext) throws JspException {
        TemplateProxy tp = null;
        try {
            String importList = ((CFPage)pageContext.getPage()).importList;
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("pageContext", pageContext);
            props.put("importList", importList);
            tp = (TemplateProxy)ProxyFactory.getProxy("COMPONENT", cfc, props);
        }
        catch (ParseException pe) {
            throw new InvalidCFCSyntaxException(cfc);
        }
        catch (Throwable pe) {
            // empty catch block
        }
        if (tp == null) {
            throw new InvalidCFCException(cfc);
        }
        String cfcFQ = tp.getCfcFullyQualifiedName();
        String cfcFilePath = cfcFQ.replace('.', '/') + CFC_EXT;
        cfcFilePath = "/" + cfcFilePath;
        File cfcFile = ServiceFactory.getRuntimeService().resolveTemplatePath(cfcFilePath);
        if (cfcFile == null) {
            cfcFilePath = cfc.replace('.', '/') + CFC_EXT;
            cfcFile = ServiceFactory.getRuntimeService().resolveTemplatePath(cfcFilePath);
            if (cfcFile == null) {
                throw new InvalidCFCException(cfc);
            }
        }
        try {
            String root = pageContext.getServletContext().getRealPath("/");
            if (root == null) {
                CFLogs.APPLICATION_LOG.error("root path is coming null; things may not work as expected");
                root = "";
            }
            String cfcCanonicalPath = cfcFile.getCanonicalPath();
            if (SystemInfo.isWindows()) {
                cfcCanonicalPath = cfcCanonicalPath.toLowerCase();
                root = root.toLowerCase();
            }
            if (!cfcCanonicalPath.startsWith(root)) {
                String contextPath = ((HttpServletRequest)pageContext.getRequest()).getContextPath();
                if (contextPath != null && contextPath.length() > 0 && cfcFilePath.startsWith("/")) {
                    cfcFilePath = contextPath + cfcFilePath;
                }
                return cfcFilePath;
            }
        }
        catch (IOException e) {
            throw new InvalidCFCException(cfc);
        }
        String cfcPath = null;
        try {
            cfcPath = TemplateProxyFactory.getFullName(cfcFile, pageContext, true);
        }
        catch (RuntimeException r) {
            throw r;
        }
        catch (Throwable t) {
            throw new JspException(t);
        }
        StringBuffer cfcPathBuffer = new StringBuffer();
        String contextPath = ((HttpServletRequest)pageContext.getRequest()).getContextPath();
        if (contextPath != null && contextPath.length() > 0) {
            cfcPathBuffer.append(contextPath);
        }
        cfcPathBuffer.append('/').append(cfcPath.replace('.', '/')).append(CFC_EXT);
        return cfcPathBuffer.toString();
    }

    public static class AjaxProxyRequiredAttributesException
    extends TagValidationException {
    }

    public static class AjaxProxyInvalidAttributesCombinationException
    extends TagValidationException {
    }

    public static class AjaxProxyBindInvalidAttributeException
    extends TagValidationException {
    }

    public static class InvalidAjaxProxyBindTypeException
    extends TagValidationException {
    }

    public static class InvalidAjaxProxyOnErrorUsageException
    extends TagValidationException {
    }

    public static class AjaxProxyCfcInvalidAttributeException
    extends TagValidationException {
    }

    public static class CFCFunctionNotRemoteException
    extends ApplicationException {
        public String cfc;
        public String function;

        public CFCFunctionNotRemoteException(String cfc, String function) {
            this.cfc = cfc;
            this.function = function;
        }
    }

    public static class InvalidCFCFunctionException
    extends ApplicationException {
        public String cfc;
        public String function;

        public InvalidCFCFunctionException(String cfc, String function) {
            this.cfc = cfc;
            this.function = function;
        }
    }

    public static class InvalidCFCException
    extends ApplicationException {
        public String cfc;

        public InvalidCFCException(String cfc) {
            this.cfc = cfc;
        }
    }

    public static class InvalidCFCSyntaxException
    extends ApplicationException {
        public String cfc;

        public InvalidCFCSyntaxException(String cfc) {
            this.cfc = cfc;
        }
    }
}

