/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.ajax;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationException;
import coldfusion.tagext.html.ajax.AjaxProxyTag;
import coldfusion.tagext.html.ajax.AjaxUtils;
import coldfusion.tagext.html.ajax.HtmlAssembler;
import coldfusion.tagext.html.form.GridTag;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.PageContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BindProcessor {
    private boolean output = true;
    private boolean bindToFunction = false;
    private int bindType = -1;
    private Map bindToParams;
    private List reservedWords;
    private boolean[] reservedWordsMatched;
    private HtmlAssembler htmlAssembler;
    public static final String HTTP_METHOD_GET = "'GET'";
    public static final String HTTP_METHOD_POST = "'POST'";
    public static final String BIND_JAVASCRIPT = "javascript";
    public static final String BIND_CFC = "cfc";
    public static final String BIND_URL = "url";
    public static final int BIND_TYPE_EMBEDDED = -1;
    public static final int BIND_TYPE_PLAIN = 0;
    public static final int BIND_TYPE_JAVASCRIPT = 1;
    public static final int BIND_TYPE_CFC = 2;
    public static final int BIND_TYPE_URL = 3;
    public static final String BIND_URL_CALL = "ColdFusion.Bind.urlBindHandler(null, ";
    public static final String BIND_CFC_CALL = "ColdFusion.Bind.cfcBindHandler(null, ";
    public static final String BIND_JS_CALL = "ColdFusion.Bind.jsBindHandler(null, ";
    private static final String[] BIND_PREFIXES = new String[]{"", "javascript", "cfc", "url"};
    private static final int[] BIND_PREFIX_LEN = new int[]{0, "javascript".length(), "cfc".length(), "url".length()};
    private static final String[] BIND_CALLBACK_FN = new String[]{"ColdFusion.Bind.localBindHandler", "ColdFusion.Bind.jsBindHandler", "ColdFusion.Bind.cfcBindHandler", "ColdFusion.Bind.urlBindHandler"};
    private static final String BIND_PREFIX_SEP = ":";
    private static final String BIND_FN_PREFIX = "bind";
    private static final String BIND_REGISTER = "ColdFusion.Bind.register(";
    private static final char OPEN_BIND = '{';
    private static final char CLOSE_BIND = '}';
    private static final char COLON = ':';
    private static final char DOT = '.';
    private static final char AT = '@';
    private static final char SPACE = ' ';
    private static final char EQUALS = '=';
    private static final char OPEN_BRACKET = '(';
    private static final char CLOSE_BRACKET = ')';
    private static final char COMMA = ',';
    private static final char ESCAPE = '\\';
    private static final String EVENT_DEFAULT = "change";
    private static final String EVENT_NONE = "none";
    private static final String ATTRIBUTE_DEFAULT = "value";
    private static final String BIND_TO = "'bindTo':";
    private static final String BIND_TO_ATTR = "'bindToAttr':'";
    private static final String BIND_EXPR = "'bindExpr':[";
    private static final String BIND_CALL_FN = "'callFunction':";
    private static final String BIND_CFC_URL = "'cfc':'";
    private static final String BIND_CFC_FUNCTION = "'cfcFunction':'";
    private static final String BIND_ENCRYPTED_APPNAME = "'_cf_ajaxproxytoken':'";
    private static final String BIND_TO_PARAMS = "'bindToParams': ";
    private static final String BIND_HTTP_METHOD = "'httpMethod': ";
    private static final String BIND_ERROR_HANDLER = "'errorHandler':";
    private String eventParams;
    private String callbackParams;
    private String callbackHandler;
    private String httpMethod;
    private String jsErrorHandler;

    public String getEventParams() {
        return this.eventParams;
    }

    public String getCallbackParams() {
        return this.callbackParams;
    }

    public String getCallbackHandler() {
        return this.callbackHandler;
    }

    public int getBindType() {
        return this.bindType;
    }

    public void setCallbackHandler(String callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public static boolean isAJAXBind(String bindExpression) {
        return bindExpression.startsWith(BIND_JAVASCRIPT) || bindExpression.startsWith(BIND_CFC) || bindExpression.startsWith(BIND_URL);
    }

    public void setOutput(boolean output) {
        this.output = output;
    }

    public void setBindToFunction(boolean bindToFunction) {
        this.bindToFunction = bindToFunction;
    }

    public void setHTTPMethod(String method) {
        this.httpMethod = method;
    }

    public void setErrorHandler(String jsFunction) {
        this.jsErrorHandler = jsFunction;
    }

    public void addReservedWord(String reservedWord) {
        if (this.reservedWords == null) {
            this.reservedWords = new ArrayList();
        }
        this.reservedWords.add(reservedWord.toLowerCase());
    }

    public List getUnmatchedReservedWords() {
        ArrayList unmatched = new ArrayList();
        for (int i = 0; i < this.reservedWordsMatched.length; ++i) {
            if (this.reservedWordsMatched[i]) continue;
            unmatched.add(this.reservedWords.get(i));
        }
        return unmatched;
    }

    public void addBindToParam(String name, String value) {
        if (this.bindToParams == null) {
            this.bindToParams = new HashMap();
        }
        this.bindToParams.put(name, value);
    }

    public void processBind(String targetId, String targetAttr, String targetContainerId, String bindExpression, boolean bindOnLoad, HtmlAssembler htmlAssembler, int bindType, PageContext pageContext) throws JspException {
        this.htmlAssembler = htmlAssembler;
        this.parseBind(targetId, targetAttr, bindExpression, bindType, targetContainerId, pageContext);
        this.assembleImports(htmlAssembler);
        if (!this.output) {
            return;
        }
        htmlAssembler.openScriptTag();
        String initFn = htmlAssembler.openFunction(BIND_FN_PREFIX, "init", true, true, null);
        htmlAssembler.appendContent(BIND_REGISTER);
        htmlAssembler.appendContent(this.eventParams).appendContent(',').appendContent(this.callbackParams).appendContent(',').appendContent(this.callbackHandler).appendContent(',').appendContent(bindOnLoad).appendContent(");");
        htmlAssembler.closeFunction();
        htmlAssembler.setEventOnLoad(initFn);
        htmlAssembler.closeScriptTag();
    }

    public void generateDirectCall(HtmlAssembler htmlAssembler) throws JspException {
        htmlAssembler.newLine();
        if (this.getBindType() == 2) {
            htmlAssembler.appendContent(BIND_CFC_CALL);
        } else if (this.getBindType() == 1) {
            htmlAssembler.appendContent(BIND_JS_CALL);
        } else if (this.getBindType() == 3) {
            htmlAssembler.appendContent(BIND_URL_CALL);
        }
        htmlAssembler.appendContent(this.callbackParams).appendContent(");");
    }

    public void assembleImports(HtmlAssembler htmlAssembler) {
        htmlAssembler.importJS("/package/cfajax.js");
    }

    public static int getBindType(String bindExpression) {
        int bindType = 0;
        for (int i = 1; i < BIND_PREFIXES.length; ++i) {
            String prefix;
            if (bindExpression.length() < BIND_PREFIX_LEN[i] || !(prefix = bindExpression.substring(0, BIND_PREFIX_LEN[i])).equalsIgnoreCase(BIND_PREFIXES[i])) continue;
            bindType = i;
            break;
        }
        return bindType;
    }

    private void parseBind(String targetId, String targetAttr, String bindExpression, int bindType, String defaultContainer, PageContext pageContext) throws JspException {
        bindExpression = bindExpression.trim();
        bindExpression = bindExpression.replace('\n', ' ');
        bindExpression = bindExpression.replace('\r', ' ');
        if (this.reservedWords != null) {
            this.reservedWordsMatched = new boolean[this.reservedWords.size()];
        }
        int pos = 0;
        if (bindType == -1) {
            bindType = BindProcessor.getBindType(bindExpression);
            pos = BIND_PREFIX_LEN[bindType];
            if (bindType != 0) {
                int bindPrefixSepIndex = bindExpression.indexOf(BIND_PREFIX_SEP, pos);
                if (bindPrefixSepIndex == -1) {
                    throw new MissingBindPrefixSepException();
                }
                pos = bindPrefixSepIndex + 1;
            }
        }
        if (pos == bindExpression.length()) {
            throw new EmptyBindException();
        }
        if (bindType == 3 && (bindExpression.indexOf("<script") > 0 || bindExpression.indexOf("</script>") > 0)) {
            throw new InvalidSourceAttributeValueException(bindExpression);
        }
        this.bindType = bindType;
        StringBuffer callbackArgs = new StringBuffer();
        callbackArgs.append('{');
        callbackArgs.append(BIND_TO);
        if (this.bindToFunction) {
            callbackArgs.append(targetId);
        } else {
            callbackArgs.append(HtmlAssembler.singleQuote(targetId));
        }
        callbackArgs.append(',');
        if (targetAttr != null) {
            callbackArgs.append(BIND_TO_ATTR).append(targetAttr).append("'").append(',');
        }
        if (this.httpMethod != null) {
            callbackArgs.append(BIND_HTTP_METHOD).append(this.httpMethod).append(',');
        }
        if (this.jsErrorHandler != null) {
            callbackArgs.append(BIND_ERROR_HANDLER).append(this.jsErrorHandler).append(',');
        }
        StringBuffer eventArgs = new StringBuffer();
        eventArgs.append('[');
        int bindExprLen = bindExpression.length();
        String[] cfcCallParams = null;
        if (bindType == 1 || bindType == 2) {
            String extraChars;
            int oldPos = pos;
            if ((pos = bindExpression.indexOf(40, pos)) == -1) {
                throw new FunctionNotFoundException(bindExpression, bindType);
            }
            String call = bindExpression.substring(oldPos, pos).trim();
            if (bindType == 1) {
                callbackArgs.append(BIND_CALL_FN).append(call).append(',');
            } else {
                int functionIndex = call.lastIndexOf(46);
                if (functionIndex == -1) {
                    throw new FunctionNotFoundException(bindExpression, bindType);
                }
                String cfc = call.substring(0, functionIndex);
                String function = call.substring(functionIndex + 1);
                cfcCallParams = AjaxProxyTag.getCallParameters(cfc, function, pageContext);
                callbackArgs.append(BIND_CFC_URL).append((Object)cfcCallParams[0]).append("'").append(',');
                callbackArgs.append(BIND_CFC_FUNCTION).append(function).append("'").append(',');
                String appname = AjaxUtils.encryptAppName(FusionContext.getCurrent().getApplicationName(), this.htmlAssembler.getClientId());
                callbackArgs.append(BIND_ENCRYPTED_APPNAME).append(appname).append("'").append(',');
            }
            bindExprLen = bindExpression.lastIndexOf(41);
            if (bindExprLen == -1 || bindExprLen < ++pos) {
                throw new FunctionMissingCloseBracketException(bindExpression);
            }
            if (bindExprLen < bindExpression.length() && (extraChars = bindExpression.substring(bindExprLen + 1)).trim().length() != 0) {
                throw new ExtraCharactersAfterBracketException(bindExpression);
            }
        }
        callbackArgs.append(BIND_EXPR);
        int eventArgsIndex = 0;
        int callbackArgsIndex = 0;
        int cfcArgsIndex = 0;
        int cfcEqualsSyntax = 0;
        while (pos < bindExprLen) {
            String extraChars;
            int openBindIndex = -1;
            if (bindType == 0 || bindType == 3) {
                int oldPos = pos;
                if ((pos = this.findUnescapedChar(bindExpression, '{', pos)) == -1) {
                    pos = bindExprLen;
                } else {
                    openBindIndex = pos;
                }
                if (pos - oldPos > 0) {
                    if (callbackArgsIndex != 0) {
                        callbackArgs.append(',');
                    }
                    String constantToken = this.twiddle(bindExpression.substring(oldPos, pos), true);
                    callbackArgs.append("'").append(constantToken).append("'");
                    ++callbackArgsIndex;
                }
            }
            String argName = null;
            if (bindType == 2 || bindType == 1) {
                int commaIndex = bindExpression.indexOf(44, pos);
                if (commaIndex == -1) {
                    commaIndex = bindExprLen;
                }
                if (commaIndex - pos > 0) {
                    if (bindType == 2) {
                        int equalsIndex = bindExpression.indexOf(61, pos);
                        if (equalsIndex != -1 && equalsIndex < commaIndex) {
                            switch (cfcEqualsSyntax) {
                                case 0: {
                                    cfcEqualsSyntax = 1;
                                    break;
                                }
                                case -1: {
                                    throw new MixedCFCSyntaxException(bindExpression);
                                }
                            }
                            argName = bindExpression.substring(pos, equalsIndex).trim().toUpperCase();
                            pos = equalsIndex + 1;
                        } else {
                            switch (cfcEqualsSyntax) {
                                case 0: {
                                    cfcEqualsSyntax = -1;
                                    break;
                                }
                                case 1: {
                                    throw new MixedCFCSyntaxException(bindExpression);
                                }
                            }
                            if (cfcArgsIndex < cfcCallParams.length - 1) {
                                argName = cfcCallParams[cfcArgsIndex + 1];
                            } else {
                                throw new TooManyCFCArgumentsException(bindExpression);
                            }
                        }
                        ++cfcArgsIndex;
                    }
                    if ((openBindIndex = this.findUnescapedChar(bindExpression, '{', pos)) != -1 && openBindIndex < commaIndex) {
                        String whitespace = bindExpression.substring(pos, openBindIndex);
                        if (whitespace.trim().length() != 0) {
                            throw new InvalidOpenBindException(bindExpression, whitespace);
                        }
                        pos = openBindIndex;
                    } else {
                        String constantToken = this.twiddle(bindExpression.substring(pos, commaIndex), false);
                        if (callbackArgsIndex != 0) {
                            callbackArgs.append(',');
                        }
                        if (bindType == 2) {
                            callbackArgs.append('[');
                            HtmlAssembler.singleQuote(argName, true, callbackArgs);
                            callbackArgs.append(constantToken);
                            callbackArgs.append(']');
                        } else {
                            callbackArgs.append(constantToken);
                        }
                        ++callbackArgsIndex;
                        pos = commaIndex + 1;
                        continue;
                    }
                }
            }
            if (pos >= bindExprLen) break;
            int tokenEnd = this.findUnescapedChar(bindExpression, '}', pos);
            if (tokenEnd == -1) {
                throw new MissingCloseBindException(bindExpression);
            }
            String val = bindExpression.substring(openBindIndex + 1, tokenEnd).trim();
            if (this.findUnescapedChar(val, '{', 0) != -1 || this.findUnescapedChar(val, '}', 0) != -1) {
                throw new IllegalCharacterInBindToken(val);
            }
            int rWordIdx = -1;
            if (this.reservedWords != null && (rWordIdx = this.reservedWords.indexOf(val.toLowerCase())) != -1) {
                this.reservedWordsMatched[rWordIdx] = true;
                if (callbackArgsIndex != 0) {
                    callbackArgs.append(',');
                }
                if (bindType == 2) {
                    callbackArgs.append('[');
                    HtmlAssembler.singleQuote(argName, true, callbackArgs);
                    callbackArgs.append(this.reservedWords.get(rWordIdx));
                    callbackArgs.append(']');
                } else {
                    callbackArgs.append(this.reservedWords.get(rWordIdx));
                }
                ++callbackArgsIndex;
                pos = tokenEnd + 1;
                if (bindType != 1 && bindType != 2 || (pos = bindExpression.indexOf(44, pos) + 1) != 0) continue;
                break;
            }
            int tokenStart = pos;
            String containerId = defaultContainer;
            String elementId = null;
            String attribute = ATTRIBUTE_DEFAULT;
            String event = EVENT_DEFAULT;
            int colonIndex = this.findChar(bindExpression, ':', pos, tokenStart, tokenEnd);
            if (colonIndex != -1) {
                containerId = bindExpression.substring(pos + 1, colonIndex).trim();
                pos = colonIndex;
            }
            int dotIndex = this.findChar(bindExpression, '.', pos, tokenStart, tokenEnd);
            int atInAttrNameIndex = -1;
            if (dotIndex != -1) {
                elementId = bindExpression.substring(pos + 1, dotIndex).trim();
                pos = dotIndex;
                if (bindExpression.charAt(dotIndex + 1) == '@') {
                    atInAttrNameIndex = dotIndex + 1;
                } else {
                    int i = 1;
                    while (bindExpression.charAt(dotIndex + i) == ' ') {
                        ++i;
                    }
                    if (bindExpression.charAt(dotIndex + i) == '@') {
                        atInAttrNameIndex = dotIndex + i;
                    }
                }
            }
            int atIndex = -1;
            atIndex = atInAttrNameIndex != -1 ? this.findChar(bindExpression, '@', pos, atInAttrNameIndex + 1, tokenEnd) : this.findChar(bindExpression, '@', pos, tokenStart, tokenEnd);
            if (atIndex != -1) {
                String tokenEl = bindExpression.substring(pos + 1, atIndex);
                if (elementId == null) {
                    elementId = tokenEl;
                } else {
                    attribute = tokenEl.trim();
                }
                event = bindExpression.substring(atIndex + 1, tokenEnd).trim();
            } else if (dotIndex != -1) {
                attribute = bindExpression.substring(dotIndex + 1, tokenEnd).trim();
            }
            if (elementId == null) {
                elementId = bindExpression.substring(pos + 1, tokenEnd).trim();
            }
            if (!event.equalsIgnoreCase(EVENT_NONE)) {
                if (eventArgsIndex != 0) {
                    eventArgs.append(',');
                }
                eventArgs.append('[');
                HtmlAssembler.singleQuote(elementId, true, eventArgs);
                HtmlAssembler.singleQuote(containerId, true, eventArgs);
                HtmlAssembler.singleQuote(event, false, eventArgs);
                eventArgs.append(']');
                ++eventArgsIndex;
            }
            if (callbackArgsIndex != 0) {
                callbackArgs.append(',');
            }
            callbackArgs.append('[');
            if (bindType == 2) {
                HtmlAssembler.singleQuote(argName, true, callbackArgs);
            }
            HtmlAssembler.singleQuote(elementId, true, callbackArgs);
            HtmlAssembler.singleQuote(containerId, true, callbackArgs);
            HtmlAssembler.singleQuote(attribute, false, callbackArgs);
            callbackArgs.append(']');
            ++callbackArgsIndex;
            pos = tokenEnd + 1;
            if (bindType != 1 && bindType != 2) continue;
            int endPos = pos;
            if ((pos = bindExpression.indexOf(44, pos) + 1) != 0) continue;
            if (endPos >= bindExprLen || (extraChars = bindExpression.substring(endPos, bindExprLen)).trim().length() == 0) break;
            throw new ExtraCharactersBeforeBracketException(bindExpression);
        }
        eventArgs.append(']');
        callbackArgs.append(']');
        this.addBindToParams(callbackArgs);
        callbackArgs.append('}');
        this.eventParams = eventArgs.toString();
        this.callbackParams = callbackArgs.toString();
        if (this.callbackHandler == null) {
            this.callbackHandler = BIND_CALLBACK_FN[bindType];
        }
    }

    public String[] parseBindForGrid(String targetId, String targetAttr, String bindExpression, int bindType, String defaultContainer, PageContext pageContext, GridTag gridTag, HtmlAssembler htmlAssembler) throws JspException {
        Object finalurl = "";
        Object jsfunction = "";
        this.htmlAssembler = htmlAssembler;
        Object bindelems = "";
        bindExpression = bindExpression.trim();
        bindExpression = bindExpression.replace('\n', ' ');
        bindExpression = bindExpression.replace('\r', ' ');
        if (this.reservedWords != null) {
            this.reservedWordsMatched = new boolean[this.reservedWords.size()];
        }
        int pos = 0;
        if (bindType == -1) {
            bindType = BindProcessor.getBindType(bindExpression);
            pos = BIND_PREFIX_LEN[bindType];
            if (bindType != 0) {
                int bindPrefixSepIndex = bindExpression.indexOf(BIND_PREFIX_SEP, pos);
                if (bindPrefixSepIndex == -1) {
                    throw new MissingBindPrefixSepException();
                }
                pos = bindPrefixSepIndex + 1;
            }
        }
        if (pos == bindExpression.length()) {
            throw new EmptyBindException();
        }
        if (bindType == 3 && (bindExpression.indexOf("<script") > 0 || bindExpression.indexOf("</script>") > 0)) {
            throw new InvalidSourceAttributeValueException(bindExpression);
        }
        this.bindType = bindType;
        StringBuffer callbackArgs = new StringBuffer();
        callbackArgs.append('{');
        callbackArgs.append(BIND_TO);
        if (this.bindToFunction) {
            callbackArgs.append(targetId);
        } else {
            callbackArgs.append(HtmlAssembler.singleQuote(targetId));
        }
        callbackArgs.append(',');
        if (targetAttr != null) {
            callbackArgs.append(BIND_TO_ATTR).append(targetAttr).append("'").append(',');
        }
        if (this.httpMethod != null) {
            callbackArgs.append(BIND_HTTP_METHOD).append(this.httpMethod).append(',');
        }
        if (this.jsErrorHandler != null) {
            callbackArgs.append(BIND_ERROR_HANDLER).append(this.jsErrorHandler).append(',');
        }
        StringBuffer eventArgs = new StringBuffer();
        eventArgs.append('[');
        int bindExprLen = bindExpression.length();
        String[] cfcCallParams = null;
        if (bindType == 1 || bindType == 2) {
            String extraChars;
            int oldPos = pos;
            if ((pos = bindExpression.indexOf(40, pos)) == -1) {
                throw new FunctionNotFoundException(bindExpression, bindType);
            }
            String call = bindExpression.substring(oldPos, pos).trim();
            if (bindType == 1) {
                callbackArgs.append(BIND_CALL_FN).append(call).append(',');
                jsfunction = "window['" + call + "'](";
            } else {
                int functionIndex = call.lastIndexOf(46);
                if (functionIndex == -1) {
                    throw new FunctionNotFoundException(bindExpression, bindType);
                }
                String cfc = call.substring(0, functionIndex);
                String function = call.substring(functionIndex + 1);
                cfcCallParams = AjaxProxyTag.getCallParameters(cfc, function, pageContext);
                callbackArgs.append(BIND_CFC_URL).append((Object)cfcCallParams[0]).append("'").append(',');
                finalurl = "";
                finalurl = (String)finalurl + "'" + cfcCallParams[0] + "?";
                finalurl = (String)finalurl + "method=" + function;
                callbackArgs.append(BIND_CFC_FUNCTION).append(function).append("'").append(',');
            }
            bindExprLen = bindExpression.lastIndexOf(41);
            if (bindExprLen == -1 || bindExprLen < ++pos) {
                throw new FunctionMissingCloseBracketException(bindExpression);
            }
            if (bindExprLen < bindExpression.length() && (extraChars = bindExpression.substring(bindExprLen + 1)).trim().length() != 0) {
                throw new ExtraCharactersAfterBracketException(bindExpression);
            }
        }
        callbackArgs.append(BIND_EXPR);
        int eventArgsIndex = 0;
        int callbackArgsIndex = 0;
        int cfcArgsIndex = 0;
        int cfcEqualsSyntax = 0;
        boolean hasExtraParam = false;
        String pageparam = "page";
        String sortparam = "";
        String direactionparam = "ASC";
        Object constantToken = "";
        while (pos < bindExprLen) {
            String extraChars;
            int openBindIndex = -1;
            if (bindType == 0 || bindType == 3) {
                int oldPos = pos;
                if ((pos = this.findUnescapedChar(bindExpression, '{', pos)) == -1) {
                    pos = bindExprLen;
                } else {
                    openBindIndex = pos;
                }
                if (pos - oldPos > 0) {
                    if (callbackArgsIndex != 0) {
                        callbackArgs.append(',');
                    }
                    if (((String)(constantToken = this.twiddle(bindExpression.substring(oldPos, pos), true))).contains("?")) {
                        finalurl = (String)finalurl + "'" + ((String)constantToken).split("\\?")[0] + "?";
                    }
                    callbackArgs.append("'").append((String)constantToken).append("'");
                    ++callbackArgsIndex;
                }
            }
            String argName = null;
            if (bindType == 2 || bindType == 1) {
                int commaIndex = bindExpression.indexOf(44, pos);
                if (commaIndex == -1) {
                    commaIndex = bindExprLen;
                }
                if (commaIndex - pos > 0) {
                    if (bindType == 2) {
                        int equalsIndex = bindExpression.indexOf(61, pos);
                        if (equalsIndex != -1 && equalsIndex < commaIndex) {
                            switch (cfcEqualsSyntax) {
                                case 0: {
                                    cfcEqualsSyntax = 1;
                                    break;
                                }
                                case -1: {
                                    throw new MixedCFCSyntaxException(bindExpression);
                                }
                            }
                            argName = bindExpression.substring(pos, equalsIndex).trim().toUpperCase();
                            pos = equalsIndex + 1;
                        } else {
                            switch (cfcEqualsSyntax) {
                                case 0: {
                                    cfcEqualsSyntax = -1;
                                    break;
                                }
                                case 1: {
                                    throw new MixedCFCSyntaxException(bindExpression);
                                }
                            }
                            if (cfcArgsIndex < cfcCallParams.length - 1) {
                                argName = cfcCallParams[cfcArgsIndex + 1];
                            } else {
                                throw new TooManyCFCArgumentsException(bindExpression);
                            }
                        }
                        ++cfcArgsIndex;
                    }
                    if ((openBindIndex = this.findUnescapedChar(bindExpression, '{', pos)) != -1 && openBindIndex < commaIndex) {
                        String whitespace = bindExpression.substring(pos, openBindIndex);
                        if (whitespace.trim().length() != 0) {
                            throw new InvalidOpenBindException(bindExpression, whitespace);
                        }
                        pos = openBindIndex;
                    } else {
                        constantToken = this.twiddle(bindExpression.substring(pos, commaIndex), false);
                        if (callbackArgsIndex != 0) {
                            callbackArgs.append(',');
                        }
                        if (bindType == 2) {
                            finalurl = (String)finalurl + "&" + argName + "='+" + (String)constantToken + "+'";
                            bindelems = "'" + argName + "," + (String)constantToken + ";";
                        } else {
                            jsfunction = (String)jsfunction + (String)constantToken + ",";
                        }
                        ++callbackArgsIndex;
                        pos = commaIndex + 1;
                        continue;
                    }
                }
            }
            if (pos >= bindExprLen) break;
            int tokenEnd = this.findUnescapedChar(bindExpression, '}', pos);
            if (tokenEnd == -1) {
                throw new MissingCloseBindException(bindExpression);
            }
            String val = bindExpression.substring(openBindIndex + 1, tokenEnd).trim();
            if (this.findUnescapedChar(val, '{', 0) != -1 || this.findUnescapedChar(val, '}', 0) != -1) {
                throw new IllegalCharacterInBindToken(val);
            }
            int rWordIdx = -1;
            if (this.reservedWords != null && (rWordIdx = this.reservedWords.indexOf(val.toLowerCase())) != -1) {
                this.reservedWordsMatched[rWordIdx] = true;
                if (callbackArgsIndex != 0) {
                    callbackArgs.append(',');
                }
                if (bindType == 2) {
                    callbackArgs.append('[');
                    HtmlAssembler.singleQuote(argName, true, callbackArgs);
                    callbackArgs.append(this.reservedWords.get(rWordIdx));
                    callbackArgs.append(']');
                    if ("cfgridpage".equalsIgnoreCase(val)) {
                        pageparam = argName;
                    }
                    if ("cfgridpagesize".equalsIgnoreCase(val)) {
                        finalurl = (String)finalurl + "&" + argName + "=";
                        finalurl = (String)finalurl + gridTag.getPageSize();
                    }
                    if ("cfgridsortdirection".equalsIgnoreCase(val)) {
                        direactionparam = argName;
                    }
                    if ("cfgridsortcolumn".equalsIgnoreCase(val)) {
                        sortparam = argName;
                    }
                } else if (bindType == 3) {
                    String argument = "";
                    if (((String)constantToken).startsWith("&")) {
                        argument = ((String)constantToken).substring(1, ((String)constantToken).length() - 1);
                    } else {
                        argument = ((String)constantToken).split("\\?")[1];
                        argument = argument.substring(0, argument.length() - 1);
                    }
                    if (argument.contains("&")) {
                        finalurl = (String)finalurl + argument.split("&")[0];
                        argument = argument.substring(argument.indexOf("&") + 1, argument.length());
                    }
                    if ("cfgridpage".equalsIgnoreCase(val)) {
                        pageparam = argument;
                    }
                    if ("cfgridpagesize".equalsIgnoreCase(val)) {
                        finalurl = (String)finalurl + "&" + argument + "=";
                        finalurl = (String)finalurl + gridTag.getPageSize();
                    }
                    if ("cfgridsortdirection".equalsIgnoreCase(val)) {
                        direactionparam = argument;
                    }
                    if ("cfgridsortcolumn".equalsIgnoreCase(val)) {
                        sortparam = argument;
                    }
                } else {
                    callbackArgs.append(this.reservedWords.get(rWordIdx));
                    if ("cfgridpage".equalsIgnoreCase(val)) {
                        jsfunction = (String)jsfunction + "op.page,";
                    }
                    if ("cfgridpagesize".equalsIgnoreCase(val)) {
                        jsfunction = (String)jsfunction + gridTag.getPageSize() + ",";
                    }
                    if ("cfgridsortcolumn".equalsIgnoreCase(val)) {
                        jsfunction = (String)jsfunction + "sortcol,";
                    }
                    if ("cfgridsortdirection".equalsIgnoreCase(val)) {
                        jsfunction = (String)jsfunction + "sortdir,";
                    }
                }
                ++callbackArgsIndex;
                pos = tokenEnd + 1;
                if (bindType != 1 && bindType != 2 || (pos = bindExpression.indexOf(44, pos) + 1) != 0) continue;
                break;
            }
            int tokenStart = pos;
            String containerId = defaultContainer;
            String elementId = null;
            String attribute = ATTRIBUTE_DEFAULT;
            String event = EVENT_DEFAULT;
            int colonIndex = this.findChar(bindExpression, ':', pos, tokenStart, tokenEnd);
            if (colonIndex != -1) {
                containerId = bindExpression.substring(pos + 1, colonIndex).trim();
                pos = colonIndex;
            }
            int dotIndex = this.findChar(bindExpression, '.', pos, tokenStart, tokenEnd);
            int atInAttrNameIndex = -1;
            if (dotIndex != -1) {
                elementId = bindExpression.substring(pos + 1, dotIndex).trim();
                pos = dotIndex;
                if (bindExpression.charAt(dotIndex + 1) == '@') {
                    atInAttrNameIndex = dotIndex + 1;
                } else {
                    int i = 1;
                    while (bindExpression.charAt(dotIndex + i) == ' ') {
                        ++i;
                    }
                    if (bindExpression.charAt(dotIndex + i) == '@') {
                        atInAttrNameIndex = dotIndex + i;
                    }
                }
            }
            int atIndex = -1;
            atIndex = atInAttrNameIndex != -1 ? this.findChar(bindExpression, '@', pos, atInAttrNameIndex + 1, tokenEnd) : this.findChar(bindExpression, '@', pos, tokenStart, tokenEnd);
            if (atIndex != -1) {
                String tokenEl = bindExpression.substring(pos + 1, atIndex);
                if (elementId == null) {
                    elementId = tokenEl;
                } else {
                    attribute = tokenEl.trim();
                }
                event = bindExpression.substring(atIndex + 1, tokenEnd).trim();
            } else if (dotIndex != -1) {
                attribute = bindExpression.substring(dotIndex + 1, tokenEnd).trim();
            }
            if (elementId == null) {
                elementId = bindExpression.substring(pos + 1, tokenEnd).trim();
            }
            if (!event.equalsIgnoreCase(EVENT_NONE)) {
                if (eventArgsIndex != 0) {
                    eventArgs.append(',');
                }
                eventArgs.append('[');
                HtmlAssembler.singleQuote(elementId, true, eventArgs);
                HtmlAssembler.singleQuote(containerId, true, eventArgs);
                HtmlAssembler.singleQuote(event, false, eventArgs);
                eventArgs.append(']');
                ++eventArgsIndex;
            }
            if (callbackArgsIndex != 0) {
                callbackArgs.append(',');
            }
            callbackArgs.append('[');
            if (bindType == 2) {
                HtmlAssembler.singleQuote(argName, true, callbackArgs);
            }
            HtmlAssembler.singleQuote(elementId, true, callbackArgs);
            HtmlAssembler.singleQuote(containerId, true, callbackArgs);
            HtmlAssembler.singleQuote(attribute, false, callbackArgs);
            hasExtraParam = true;
            Object bindelem = "";
            if (bindType == 2) {
                finalurl = (String)finalurl + "&" + argName + "=' + ColdFusion.Bind.getBindElementValue(" + HtmlAssembler.singleQuote(elementId) + "," + HtmlAssembler.singleQuote(containerId) + "," + HtmlAssembler.singleQuote(attribute) + ")+'";
            }
            if (((String)bindelems).length() == 0) {
                bindelem = "'";
            }
            if (bindType == 3) {
                if (((String)constantToken).contains("?")) {
                    constantToken = "&" + ((String)constantToken).substring(((String)constantToken).indexOf("?") + 1, ((String)constantToken).length());
                }
                bindelem = (String)bindelem + ((String)constantToken).substring(1, ((String)constantToken).length() - 1) + "," + elementId + "," + containerId + "," + attribute + ";";
                finalurl = (String)finalurl + (String)constantToken + "' + ColdFusion.Bind.getBindElementValue(" + HtmlAssembler.singleQuote(elementId) + "," + HtmlAssembler.singleQuote(containerId) + "," + HtmlAssembler.singleQuote(attribute) + ")+'";
            } else {
                jsfunction = (String)jsfunction + "ColdFusion.Bind.getBindElementValue(" + HtmlAssembler.singleQuote(elementId) + "," + HtmlAssembler.singleQuote(containerId) + "," + HtmlAssembler.singleQuote(attribute) + "),";
            }
            if (bindType == 2 || bindType == 1) {
                bindelem = (String)bindelem + argName + "," + elementId + "," + containerId + "," + attribute + ";";
            }
            bindelems = (String)bindelems + (String)bindelem;
            callbackArgs.append(']');
            ++callbackArgsIndex;
            pos = tokenEnd + 1;
            if (bindType != 1 && bindType != 2) continue;
            int endPos = pos;
            if ((pos = bindExpression.indexOf(44, pos) + 1) != 0) continue;
            if (endPos >= bindExprLen || (extraChars = bindExpression.substring(endPos, bindExprLen)).trim().length() == 0) break;
            throw new ExtraCharactersBeforeBracketException(bindExpression);
        }
        eventArgs.append(']');
        callbackArgs.append(']');
        this.addBindToParams(callbackArgs);
        callbackArgs.append('}');
        this.eventParams = eventArgs.toString();
        this.callbackParams = callbackArgs.toString();
        if (this.callbackHandler == null) {
            this.callbackHandler = BIND_CALLBACK_FN[bindType];
        }
        String appname = AjaxUtils.encryptAppName(FusionContext.getCurrent().getApplicationName(), htmlAssembler.getClientId());
        if (bindType == 2 || bindType == 3) {
            finalurl = (String)finalurl + "&_cf_ajaxproxytoken=" + appname;
            finalurl = (String)finalurl + "&_cf_clientid=' + window._cf_clientid + ";
            finalurl = (String)finalurl + "'&_cf_rc=' + ColdFusion.requestCounter++ +";
            finalurl = (String)finalurl + "'&_cf_nodebug=true&_cf_nocache=true&returnFormat=json'";
            finalurl = (String)finalurl + ",pageParam:'" + pageparam + "'";
            finalurl = (String)finalurl + ",sortParam:'" + sortparam + "'";
            finalurl = (String)finalurl + ",directionParam:'" + direactionparam + "'";
            finalurl = (String)finalurl + ",simpleSortMode:true";
            if (((String)bindelems).endsWith(";")) {
                bindelems = ((String)bindelems).substring(0, ((String)bindelems).length() - 1);
                bindelems = (String)bindelems + "';";
            }
        }
        if (bindType == 1) {
            jsfunction = ((String)jsfunction).substring(0, ((String)jsfunction).length() - 1) + ")";
            finalurl = (String)finalurl + ",jsfunction:\"" + (String)jsfunction + "\"";
        }
        return new String[]{finalurl, bindelems};
    }

    private void addBindToParams(StringBuffer callbackArgs) {
        if (this.bindToParams != null) {
            Map.Entry entry;
            callbackArgs.append(',').append(" ");
            callbackArgs.append(BIND_TO_PARAMS).append('{');
            Iterator setIterator = this.bindToParams.entrySet().iterator();
            if (setIterator.hasNext()) {
                entry = setIterator.next();
                callbackArgs.append(" ");
                callbackArgs.append(HtmlAssembler.singleQuote((String)entry.getKey())).append(':').append((String)entry.getValue());
            }
            while (setIterator.hasNext()) {
                entry = setIterator.next();
                callbackArgs.append(',');
                callbackArgs.append(" ");
                callbackArgs.append(HtmlAssembler.singleQuote((String)entry.getKey())).append(':').append((String)entry.getValue());
            }
            callbackArgs.append(" ").append('}');
        }
    }

    private int findChar(String bindExpression, char c, int pos, int tokenStart, int tokenEnd) {
        int charIndex = bindExpression.indexOf(c, tokenStart);
        if (charIndex != -1) {
            if (charIndex > tokenEnd) {
                charIndex = -1;
            } else {
                int nextChar;
                if (charIndex < pos) {
                    throw new OutOfOrderCharInBindException(bindExpression, c, charIndex);
                }
                if (charIndex < tokenEnd && (nextChar = bindExpression.indexOf(c, charIndex + 1)) < tokenEnd && nextChar != -1) {
                    throw new InvalidBindException(bindExpression, pos);
                }
            }
        }
        return charIndex;
    }

    private int findUnescapedChar(String bindExpression, char c, int pos) {
        int charIndex = bindExpression.indexOf(c, pos);
        boolean escaped = true;
        if (charIndex > 0) {
            while (escaped && charIndex != -1) {
                escaped = bindExpression.charAt(charIndex - 1) == '\\';
                if (!escaped) continue;
                charIndex = bindExpression.indexOf(c, charIndex + 1);
            }
        }
        return charIndex;
    }

    private String twiddle(String bindExpression, boolean escapeEdgeQuotes) {
        StringBuffer twiddled = null;
        char[] chars = bindExpression.trim().toCharArray();
        int from = 0;
        block9: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\\': {
                    if (twiddled == null) {
                        twiddled = new StringBuffer();
                    }
                    int c2 = 65535;
                    if (i < chars.length - 1) {
                        c2 = chars[i + 1];
                        twiddled.append(chars, from, i - from);
                    }
                    if (c2 != 123 && c2 != 125) {
                        twiddled.append('\\').append('\\');
                    }
                    from = i + 1;
                    continue block9;
                }
                case '\'': {
                    if (!escapeEdgeQuotes && (i == 0 || i == chars.length - 1)) continue block9;
                    if (twiddled == null) {
                        twiddled = new StringBuffer();
                    }
                    twiddled.append(chars, from, i - from);
                    twiddled.append('\\').append('\'');
                    from = i + 1;
                    continue block9;
                }
                case '\"': {
                    if (!escapeEdgeQuotes && (i == 0 || i == chars.length - 1)) continue block9;
                    if (twiddled == null) {
                        twiddled = new StringBuffer();
                    }
                    twiddled.append(chars, from, i - from);
                    twiddled.append('\\').append('\"');
                    from = i + 1;
                    continue block9;
                }
                case '\b': {
                    if (twiddled == null) {
                        twiddled = new StringBuffer();
                    }
                    twiddled.append(chars, from, i - from);
                    twiddled.append('\\').append('b');
                    from = i + 1;
                    continue block9;
                }
                case '\f': {
                    if (twiddled == null) {
                        twiddled = new StringBuffer();
                    }
                    twiddled.append(chars, from, i - from);
                    twiddled.append('\\').append('f');
                    from = i + 1;
                    continue block9;
                }
                case '\n': {
                    if (twiddled == null) {
                        twiddled = new StringBuffer();
                    }
                    twiddled.append(chars, from, i - from);
                    twiddled.append('\\').append('n');
                    from = i + 1;
                    continue block9;
                }
                case '\r': {
                    if (twiddled == null) {
                        twiddled = new StringBuffer();
                    }
                    twiddled.append(chars, from, i - from);
                    twiddled.append('\\').append('r');
                    from = i + 1;
                }
            }
        }
        if (twiddled != null) {
            if (from <= chars.length) {
                twiddled.append(chars, from, chars.length - from);
            }
            return twiddled.toString();
        }
        return bindExpression;
    }

    public static class MissingBindPrefixSepException
    extends ApplicationException {
    }

    public class EmptyBindException
    extends ApplicationException {
    }

    public class InvalidSourceAttributeValueException
    extends ApplicationException {
        public String bindExpression;

        InvalidSourceAttributeValueException(String bindExpression) {
            this.bindExpression = bindExpression;
        }
    }

    public static class FunctionNotFoundException
    extends ApplicationException {
        public String bindExpression;
        public String type;

        public FunctionNotFoundException(String bindExpression, int bindType) {
            this.bindExpression = bindExpression;
            this.type = bindType == 2 ? "CFC" : "Javascript";
        }
    }

    public static class FunctionMissingCloseBracketException
    extends ApplicationException {
        public String bindExpression;

        public FunctionMissingCloseBracketException(String bindExpression) {
            this.bindExpression = bindExpression;
        }
    }

    public static class ExtraCharactersAfterBracketException
    extends ApplicationException {
        public String bindExpression;

        public ExtraCharactersAfterBracketException(String bindExpression) {
            this.bindExpression = bindExpression;
        }
    }

    public static class MixedCFCSyntaxException
    extends ApplicationException {
        public String bindExpression;

        public MixedCFCSyntaxException(String bindExpression) {
            this.bindExpression = bindExpression;
        }
    }

    public static class TooManyCFCArgumentsException
    extends ApplicationException {
        public String bindExpression;

        public TooManyCFCArgumentsException(String bindExpression) {
            this.bindExpression = bindExpression;
        }
    }

    public static class InvalidOpenBindException
    extends ApplicationException {
        public String bindExpression;
        public String whitespace;

        public InvalidOpenBindException(String bindExpression, String whitespace) {
            this.bindExpression = bindExpression;
            this.whitespace = whitespace;
        }
    }

    public static class MissingCloseBindException
    extends ApplicationException {
        public String bindExpression;

        public MissingCloseBindException(String bindExpression) {
            this.bindExpression = bindExpression;
        }
    }

    public static class IllegalCharacterInBindToken
    extends ApplicationException {
        public String bindParameter;

        public IllegalCharacterInBindToken(String bindParameter) {
            this.bindParameter = bindParameter;
        }
    }

    public static class ExtraCharactersBeforeBracketException
    extends ApplicationException {
        public String bindExpression;

        public ExtraCharactersBeforeBracketException(String bindExpression) {
            this.bindExpression = bindExpression;
        }
    }

    public static class OutOfOrderCharInBindException
    extends ApplicationException {
        public String bindExpression;
        public char c;
        public int pos;

        public OutOfOrderCharInBindException(String bindExpression, char c, int pos) {
            this.bindExpression = bindExpression;
            this.c = c;
            this.pos = pos;
        }
    }

    public static class InvalidBindException
    extends ApplicationException {
        public String bindExpression;
        public char c;
        public int pos;

        public InvalidBindException(String bindExpression, int pos) {
            this.bindExpression = bindExpression;
            this.pos = pos;
            this.c = bindExpression.charAt(pos);
        }
    }
}

