/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.ajax;

import coldfusion.compiler.validation.TagValidationException;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.OutputException;
import coldfusion.tagext.html.ajax.AjaxContainer;
import coldfusion.tagext.html.ajax.AjaxImport;
import coldfusion.tagext.html.ajax.AjaxImportTag;
import coldfusion.tagext.html.ajax.BindProcessor;
import coldfusion.tagext.html.ajax.HtmlAssembler;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.BodyTag;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DivTag
extends GenericTag
implements BodyTag,
AjaxContainer,
AjaxImport {
    public static final String IMPORT_TAGNAME = "CFDIV";
    private static final String DEFAULT_TAGNAME = "div";
    private static final String IDPREFIX = "cf_div";
    private static final String INNERHTML = "innerHTML";
    private String id;
    private String bind;
    private boolean bindOnLoad = true;
    private String onBindError;
    private String tagName = "div";
    private Map props = new HashMap();

    public String getBind() {
        return this.bind;
    }

    public void setBind(String bind) {
        this.bind = bind;
    }

    public void setBindOnLoad(boolean bindOnLoad) {
        this.bindOnLoad = bindOnLoad;
    }

    public boolean getBindOnLoad() {
        return this.bindOnLoad;
    }

    public String getOnBindError() {
        return this.onBindError;
    }

    public void setOnBindError(String onBindError) {
        this.onBindError = onBindError;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public void setAttributecollection(Map o) {
        o.remove("ID");
        this.props = o;
    }

    public Map getProps() {
        return this.props;
    }

    @Override
    public void generateImports(String tagName, HtmlAssembler htmlAssembler) {
        htmlAssembler.importJS("/package/cfajax.js");
    }

    @Override
    public String getBodyId() {
        return this.id;
    }

    private void validate() {
        if (this.id != null && this.id.trim().length() == 0) {
            throw new EmptyAttributeException("ID");
        }
        if (this.tagName != null && this.tagName.trim().length() == 0) {
            throw new EmptyAttributeException("TAGNAME");
        }
        if (this.onBindError != null && this.onBindError.trim().length() == 0) {
            throw new EmptyAttributeException("ONBINDERROR");
        }
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        this.validate();
        HtmlAssembler htmlAssembler = HtmlAssembler.getInstance(this.pageContext, false);
        AjaxImportTag.generateImports(IMPORT_TAGNAME, htmlAssembler);
        if (this.id == null) {
            this.id = IDPREFIX + htmlAssembler.getId();
        }
        htmlAssembler.setContainerId(this.id);
        if (this.bind != null) {
            htmlAssembler.openScriptTag();
            String bindAttr = null;
            if (BindProcessor.getBindType(this.bind) != 3) {
                bindAttr = INNERHTML;
            }
            BindProcessor bp = new BindProcessor();
            bp.setErrorHandler(this.onBindError);
            bp.processBind(this.id, bindAttr, null, this.bind, this.bindOnLoad, htmlAssembler, -1, this.pageContext);
            htmlAssembler.closeScriptTag();
        }
        htmlAssembler.appendContent('<').appendContent(this.tagName);
        htmlAssembler.appendContent(" id=\"").appendContent(this.id).appendContent("\"");
        Iterator keys = this.props.keySet().iterator();
        while (keys.hasNext()) {
            String thisKey = String.valueOf(keys.next()).toLowerCase();
            String thisValue = String.valueOf(this.props.get(thisKey));
            if (thisValue.length() <= 0) continue;
            htmlAssembler.appendContent(" ").appendContent(thisKey.toLowerCase()).appendContent("=").appendContent("\"").appendContent(thisValue).appendContent("\"");
        }
        htmlAssembler.appendContent('>');
        JspWriter out = this.pageContext.getOut();
        try {
            htmlAssembler.writeHead(out);
            htmlAssembler.writeHtml(out);
        }
        catch (IOException e) {
            throw new OutputException(e);
        }
        return 1;
    }

    @Override
    public int doAfterBody() throws JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        HtmlAssembler htmlAssembler = HtmlAssembler.getInstance(this.pageContext, false);
        htmlAssembler.appendContent('<').appendContent('/').appendContent(this.tagName).appendContent('>');
        JspWriter out = this.pageContext.getOut();
        try {
            htmlAssembler.writeHtml(out);
        }
        catch (IOException e) {
            throw new OutputException(e);
        }
        finally {
            htmlAssembler.resetContainerId();
            this.release();
        }
        this.onTagEnd();
        return 6;
    }

    @Override
    public void release() {
        this.id = null;
        this.bind = null;
        this.bindOnLoad = true;
        this.onBindError = null;
        this.tagName = DEFAULT_TAGNAME;
        this.props = new HashMap();
        super.release();
    }

    public class EmptyAttributeException
    extends TagValidationException {
        public String attributeName;

        EmptyAttributeException(String attributeName) {
            this.attributeName = attributeName;
        }
    }
}

