/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.ajax;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public class JavaScriptCacheObject {
    private byte[] data;
    private long lastMofidiedTime = -1L;
    private File file;
    private long lastCheckedTime;
    private long UPDATE_INTERVAL = 60000L;
    private boolean fileExists = true;

    public JavaScriptCacheObject(File file) throws FileNotFoundException {
        this.file = file;
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        this.readFile();
        this.lastCheckedTime = System.currentTimeMillis();
    }

    public byte[] getData() throws FileNotFoundException {
        this.checkForFileUpdation();
        if (!this.fileExists) {
            throw new FileNotFoundException(this.file.getAbsolutePath());
        }
        return this.data;
    }

    public boolean isModifiedSince(long modifiedSince) throws FileNotFoundException {
        this.checkForFileUpdation();
        if (!this.fileExists) {
            throw new FileNotFoundException(this.file.getAbsolutePath());
        }
        return this.lastMofidiedTime > modifiedSince;
    }

    private void checkForFileUpdation() {
        long currentTime = System.currentTimeMillis();
        if (this.lastCheckedTime + this.UPDATE_INTERVAL > currentTime) {
            this.lastCheckedTime = currentTime;
            long lastModified = this.file.lastModified();
            if (lastModified == 0L) {
                this.data = null;
                this.fileExists = false;
            } else if (lastModified > this.lastMofidiedTime) {
                this.readFile();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile() {
        FileInputStream fis = null;
        ByteArrayOutputStream baos = null;
        DeflaterOutputStream os = null;
        try {
            fis = new FileInputStream(this.file);
            baos = new ByteArrayOutputStream();
            os = new GZIPOutputStream(baos);
            byte[] bytes = new byte[8192];
            int count = fis.read(bytes);
            while (count > 0) {
                ((GZIPOutputStream)os).write(bytes, 0, count);
                count = fis.read(bytes);
            }
            os.flush();
            ((GZIPOutputStream)os).finish();
            fis.close();
            this.data = baos.toByteArray();
        }
        catch (IOException e) {
            this.data = null;
            this.fileExists = false;
        }
        finally {
            try {
                fis.close();
                os.close();
            }
            catch (IOException iOException) {}
        }
    }
}

