/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.ajax;

import coldfusion.compiler.validation.TagValidationException;
import coldfusion.runtime.ArrayUtil;
import coldfusion.runtime.NeoException;
import coldfusion.server.felix.FelixUtil;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.OutputException;
import coldfusion.tagext.html.ajax.AjaxImport;
import coldfusion.tagext.html.ajax.AjaxImportTag;
import coldfusion.tagext.html.ajax.AjaxUtils;
import coldfusion.tagext.html.ajax.BindProcessor;
import coldfusion.tagext.html.ajax.HtmlAssembler;
import coldfusion.tagext.html.ajax.LayoutAreaTag;
import coldfusion.tagext.html.ajax.WindowTag;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class LayoutTag
extends GenericTag
implements AjaxImport {
    public static final String IMPORT_TAG_BORDER = "CFLAYOUT-BORDER";
    public static final String IMPORT_TAG_TAB = "CFLAYOUT-TAB";
    public static final String IMPORT_TAG_ACCORDION = "CFLAYOUT-ACCORDION";
    private static final String DEFAULT_HEIGHT = "600";
    private static final String DEFAULT_WIDTH = "800";
    private String align;
    private String name;
    private String type;
    private String tabPosition;
    private String tabheight;
    private String style;
    private String padding;
    private String height;
    private String width;
    private boolean fitToWindow = false;
    private boolean tabStrip = true;
    private boolean activeOnTop = false;
    private String collapseToggle = null;
    private boolean titleCollapse = true;
    private boolean fillHeight = true;
    private boolean hasFillHeightBeenSet = false;
    private boolean hasTitleCollapseBeenSet = false;
    private boolean hasActiveOnTopBeenSet = false;
    private boolean hasTabStripBeenSet = false;
    private int typeCode = -1;
    private List metaDataList = new ArrayList();
    private boolean child = false;
    private boolean tabChild = false;
    private boolean accordionChild = false;
    private LayoutAreaTag parent = null;
    private boolean windowchild = false;
    private WindowTag windowparent = null;
    private String firstTabName;
    HtmlAssembler htmlAssembler;
    public static final String CONTAINER = "container";
    public static final String LAYOUT = "layout";
    public static final String CHILDLAYOUT = "childlayout";
    public static final String TAB = "tab";
    public static final String BORDER = "border";
    public static final String VBOX = "vbox";
    public static final String HBOX = "hbox";
    public static final String ACCORDION = "accordion";
    public static final int TAB_CODE = 1;
    public static final int BORDER_CODE = 2;
    public static final int VBOX_CODE = 3;
    public static final int HBOX_CODE = 4;
    public static final int ACCORDION_CODE = 5;
    public static final String ALIGN_LEFT = "left";
    public static final String ALIGN_RIGHT = "right";
    public static final String ALIGN_CENTER = "center";
    public static final String ALIGN_JUSTIFY = "justify";
    private static final String INITTABPANEL = "ColdFusion.Layout.initializeTabLayout(";
    private static final String NEWBORDERLAYOUT_INIT = "new Ext.BorderLayout( ";
    private static final String NEWPANEL_INIT = " = new Ext.Panel({";
    private static final String NEWBORDERLAYOUT_END = ", {hideOnLayout: true ";
    private static final String INIT_ACCORDION_PANEL = " ColdFusion.Layout.InitAccordion(";
    private static final String INIT_ACCORDION_CHIELD_PANEL = " ColdFusion.Layout.InitAccordionChildPanel(";
    private static final String EXPAND_ACCORDION_CHIELD_PANEL = " ColdFusion.Layout.expandAccordion(";
    private static final String INIT_VIEWPORT = " ColdFusion.Layout.initViewport(";
    private static final String HIDEONLAYOUT = ", {hideOnLayout: true ";
    private static final String BACKGROUNDIMAGECSS = "{ background-image:url(";
    private static final String CLOSINGBACKGROUNDIMAGECSS = "); }";
    private static final String NEWCHILDBORDERLAYOUT = "new Ext.BorderLayout( ";
    private static final String LAYOUTNAME_PREFIX = "cf_layout";
    private static final String ADDTAB = "ColdFusion.Layout.addTab(";
    private static final String SELECTTAB = "ColdFusion.Layout.selectTab(";
    private static final String HIDETAB = "ColdFusion.Layout.hideTab(";
    private static final String SPLIT_PROP = "split";
    private static final String AUTOSCROLLTRUE_PROP = "autoScroll: true";
    private static final String AUTOSCROLLFALSE_PROP = "autoScroll: false";
    private static final String HIDEWHENEMPTY_PROP = "hideWhenEmpty: true";
    private static final String INITIALSIZE_PROP = "initialSize";
    private static final String MINSIZE_PROP = "minSize";
    private static final String MAXSIZE_PROP = "maxSize";
    private static final String TITLEBAR_PROP = "titlebar";
    private static final String COLLAPSIBLE_PROP = "collapsible";
    private static final String COLLAPSED_PROP = "collapsed";
    private static final String ANIMATE_PROP = "animate";
    private static final String TITLE_PROP = "title";
    private static final String CLOSABLE_PROP = "closable";
    private static final String BEGIN_UPDATE = ".beginUpdate();";
    private static final String END_UPDATE = ".endUpdate();";
    public static final String ADD = ".add(";
    private static final String NEWCONTENT_PANEL = ", new Ext.ContentPanel(";
    public static final String NEWNESTEDLAYOUT_PANEL = ", new Ext.NestedLayoutPanel(";
    private static final String GETREGION = ".getRegion(";
    private static final String SHOWPANEL = ".showPanel(";
    private static final String HIDE = ".hide();";
    private static final String DISABLETAB = "disableTab(";
    private static final String COLLAPSE = ".collapse(false);";
    private static final String POSITION_RELATIVE = "position:relative;";
    private static final String CENTER = "center";
    private static final String BOTTOM = "bottom";
    private List panelList = new ArrayList();
    private static List borderAllowedAttributes = new ArrayList();
    private static List borderNotAllowedAttributes = new ArrayList();
    private static List accordionAllowedAttributes;
    private static List accordionNotAllowedAttributes;
    private static List tabAllowedAttributes;
    private static List tabNotAllowedAttributes;
    private static List boxAllowedAttributes;
    private static List boxNotAllowedAttributes;

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type = type.trim();
        if (type.equalsIgnoreCase(TAB)) {
            this.typeCode = 1;
        } else if (type.equalsIgnoreCase(BORDER)) {
            this.typeCode = 2;
        } else if (type.equalsIgnoreCase(VBOX)) {
            this.typeCode = 3;
        } else if (type.equalsIgnoreCase(HBOX)) {
            this.typeCode = 4;
        } else if (type.equalsIgnoreCase(ACCORDION)) {
            this.typeCode = 5;
        }
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public void setTabPosition(String tabPosition) {
        this.tabPosition = tabPosition;
    }

    public void setTabheight(String tabheight) {
        this.tabheight = tabheight;
    }

    public String getTabheight() {
        return this.tabheight;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyle() {
        return this.style;
    }

    public void setPadding(String padding) {
        this.padding = padding;
    }

    public String getType() {
        return this.type;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public String getAlign() {
        return this.align;
    }

    public String getPadding() {
        return this.padding;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public boolean isActiveOnTop() {
        return this.activeOnTop;
    }

    public void setActiveOnTop(boolean activeOnTop) {
        this.activeOnTop = activeOnTop;
        this.hasActiveOnTopBeenSet = true;
    }

    public String getCollapseToggle() {
        return this.collapseToggle;
    }

    public void setCollapseToggle(String collapseToggle) {
        this.collapseToggle = collapseToggle;
    }

    public boolean isTitleCollapse() {
        return this.titleCollapse;
    }

    public void setTitleCollapse(boolean titleCollapse) {
        this.titleCollapse = titleCollapse;
        this.hasTitleCollapseBeenSet = true;
    }

    public boolean isFillHeight() {
        return this.fillHeight;
    }

    public void setFillHeight(boolean fillHeight) {
        this.fillHeight = fillHeight;
        this.hasFillHeightBeenSet = true;
    }

    public boolean getFitToWindow() {
        return this.fitToWindow;
    }

    public void setFitToWindow(boolean fitToWindow) {
        this.fitToWindow = fitToWindow;
    }

    public boolean isTabStrip() {
        return this.tabStrip;
    }

    public void setTabStrip(boolean tabStrip) {
        this.tabStrip = tabStrip;
        this.hasTabStripBeenSet = true;
    }

    private void checkIfChild() {
        for (Tag t = this.getParent(); t != null; t = t.getParent()) {
            if (t instanceof LayoutAreaTag && !this.child) {
                if (((LayoutAreaTag)t).getTypeCode() == 2) {
                    this.child = true;
                    this.parent = (LayoutAreaTag)t;
                    break;
                }
                if (((LayoutAreaTag)t).getTypeCode() == 1) {
                    this.tabChild = true;
                    this.parent = (LayoutAreaTag)t;
                    break;
                }
                if (((LayoutAreaTag)t).getTypeCode() != 5) break;
                this.accordionChild = true;
                this.parent = (LayoutAreaTag)t;
                break;
            }
            if (this.child || !(t instanceof WindowTag)) continue;
            this.windowchild = true;
            this.windowparent = (WindowTag)t;
        }
    }

    private void validateAttributes() {
        if (this.width != null && this.width.trim().endsWith("%") || this.height != null && this.height.trim().endsWith("%")) {
            throw new HeightWidthInPercentageNotSupportedException();
        }
        if (this.typeCode != 1) {
            if (this.tabheight != null) {
                throw new InvalidTabHeightUsageException();
            }
            if (this.tabStrip && this.hasTabStripBeenSet) {
                throw new InvalidTabStripUsageException();
            }
        }
        if (this.typeCode != 2 && this.fitToWindow) {
            throw new InvalidFitToWindowUsageException();
        }
        if (this.name != null && this.name.trim().length() == 0) {
            throw new EmptyNameException();
        }
        if (this.height != null && this.height.trim().length() > 0) {
            this.height = AjaxUtils.checkValidCSSUnits(this.height);
        }
        if (this.width != null && this.width.trim().length() > 0) {
            this.width = AjaxUtils.checkValidCSSUnits(this.width);
        }
        switch (this.typeCode) {
            case -1: {
                throw new InvalidTypeException();
            }
            case 2: {
                if (this.tabPosition == null && this.padding == null && !this.hasActiveOnTopBeenSet && !this.hasFillHeightBeenSet && !this.hasTitleCollapseBeenSet) break;
                throw new InvalidAttributeLayoutException(this.type, borderNotAllowedAttributes, borderAllowedAttributes);
            }
            case 1: {
                if (this.padding != null || this.hasActiveOnTopBeenSet || this.hasFillHeightBeenSet || this.hasTitleCollapseBeenSet) {
                    throw new InvalidAttributeLayoutException(this.type, tabNotAllowedAttributes, tabAllowedAttributes);
                }
                if (this.tabheight == null) break;
                this.tabheight = AjaxUtils.checkValidCSSUnits(this.tabheight);
                if (this.tabheight != null) break;
                throw new InvalidTabHeightAttributeException();
            }
            case 3: 
            case 4: {
                if (this.tabPosition != null || this.hasActiveOnTopBeenSet || this.hasFillHeightBeenSet || this.hasTitleCollapseBeenSet) {
                    throw new InvalidAttributeLayoutException(this.type, boxNotAllowedAttributes, boxAllowedAttributes);
                }
                if (this.padding == null) break;
                this.padding = AjaxUtils.checkValidCSSUnits(this.padding);
                if (this.padding != null) break;
                throw new InvalidBoxPaddingAttributeException();
            }
        }
        if (this.align != null) {
            this.align = this.align.toLowerCase();
            if (!(this.align.equals(ALIGN_LEFT) || this.align.equals(ALIGN_RIGHT) || this.align.equals("center") || this.align.equals(ALIGN_JUSTIFY))) {
                throw new InvalidBoxAlignAttributeException();
            }
        }
    }

    @Override
    public void generateImports(String tagName, HtmlAssembler htmlAssembler) {
        htmlAssembler.setAjaxComponent(true);
        htmlAssembler.importStylesheet("/resources/ext/css/ext-all.css");
        htmlAssembler.importJS("/package/cfajax.js");
        htmlAssembler.importJS("/ext/ext-all.js");
        htmlAssembler.importJS("/package/cflayout.js");
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        FelixUtil.checkAjaxEnabled();
        this.htmlAssembler = HtmlAssembler.getInstance(this.pageContext, true);
        this.validateAttributes();
        if (this.name == null) {
            this.name = LAYOUTNAME_PREFIX + this.htmlAssembler.getId();
        }
        switch (this.typeCode) {
            case 3: 
            case 4: {
                int commaIndex;
                Object tempStyle = "";
                if (this.align != null && this.align.trim().length() != 0) {
                    tempStyle = (String)tempStyle + "text-align:" + this.align + ";";
                }
                if (this.height != null && this.height.trim().length() != 0) {
                    int heightIndex = -1;
                    if (this.style != null && this.style.trim().length() > 0) {
                        heightIndex = this.style.toLowerCase().indexOf("height");
                    }
                    if (heightIndex < 0) {
                        tempStyle = (String)tempStyle + "height:" + this.height + ";";
                    } else {
                        commaIndex = this.style.indexOf(";", heightIndex + 7);
                        this.style = commaIndex > heightIndex ? this.style.substring(0, heightIndex + 7) + this.height + this.style.substring(commaIndex) : this.style.substring(0, heightIndex + 7) + this.height;
                    }
                }
                if (this.width != null && this.width.trim().length() != 0) {
                    int widthIndex = -1;
                    if (this.style != null && this.style.trim().length() > 0) {
                        widthIndex = this.style.toLowerCase().indexOf("width");
                    }
                    if (widthIndex < 0) {
                        tempStyle = (String)tempStyle + "width:" + this.width + ";";
                    } else {
                        commaIndex = this.style.indexOf(";", widthIndex + 6);
                        this.style = commaIndex > widthIndex ? this.style.substring(0, widthIndex + 6) + this.width + this.style.substring(commaIndex) : this.style.substring(0, widthIndex + 6) + this.width;
                    }
                }
                this.style = this.style != null ? (String)tempStyle + this.style : tempStyle;
                this.htmlAssembler.openDivTag(this.name, null, this.style);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                String classname = null;
                this.checkIfChild();
                if (this.typeCode == 1) {
                    AjaxImportTag.generateImports(IMPORT_TAG_TAB, this.htmlAssembler);
                    this.htmlAssembler.openDivTag(this.name, classname, this.style);
                    break;
                }
                if (this.typeCode == 5) {
                    AjaxImportTag.generateImports(IMPORT_TAG_ACCORDION, this.htmlAssembler);
                    HashMap<String, String> extraAttributeMap = new HashMap<String, String>();
                    if (this.align != null) {
                        extraAttributeMap.put("align", this.align);
                        this.style = this.style != null ? "text-align:" + this.align + ";" + this.style : "text-align:" + this.align + ";";
                    }
                    this.htmlAssembler.openDivTag(this.name, classname, this.style, extraAttributeMap);
                    break;
                }
                if (this.typeCode != 2) break;
                AjaxImportTag.generateImports(IMPORT_TAG_BORDER, this.htmlAssembler);
                classname = CONTAINER;
                if (this.child) {
                    this.parent.setChildId(this.name);
                    this.parent.setChildLayout(true);
                } else if (this.windowchild) {
                    this.windowparent.setChildLayoutPresent(true);
                    this.windowparent.setChildLayoutId(this.name);
                }
                this.style = this.style != null ? POSITION_RELATIVE + this.style : POSITION_RELATIVE;
                this.htmlAssembler.openDivTag(this.name, classname, this.style);
                if (this.child || this.windowchild) {
                    this.htmlAssembler.closeDivTag();
                }
                if (this.htmlAssembler.isTopPage() && !this.child) break;
                this.fitToWindow = false;
                break;
            }
        }
        this.htmlAssembler.newLine();
        JspWriter out = this.pageContext.getOut();
        try {
            this.htmlAssembler.writeHtml(out);
        }
        catch (IOException e) {
            throw new OutputException(e);
        }
        return 1;
    }

    @Override
    public int doAfterBody() throws JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        switch (this.typeCode) {
            case 3: 
            case 4: {
                this.htmlAssembler.closeDivTag();
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                if (this.typeCode == 5) {
                    this.generateIconClass();
                }
                this.htmlAssembler.openScriptTag();
                this.htmlAssembler.appendContent("Ext.onReady(function(){");
                this.htmlAssembler.appendContent("var ");
                String functionName = this.htmlAssembler.openFunction(LAYOUT, "init", true, true, null);
                if (this.typeCode == 1) {
                    this.htmlAssembler.appendContent("var ").appendContent("_cf_").appendContent(LAYOUT);
                    this.htmlAssembler.appendContent("=").appendContent(INITTABPANEL).appendContent(HtmlAssembler.doubleQuote(this.name));
                    if (this.tabPosition != null && this.tabPosition.equalsIgnoreCase(BOTTOM)) {
                        this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("true");
                    } else {
                        this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("false");
                    }
                    String string = this.height = this.height == null ? this.tabheight : this.height;
                    if (this.height == null) {
                        this.height = this.extractHeightFromStyle(this.style);
                    }
                    if (this.width == null) {
                        this.width = this.extractWidthFromStyle(this.style);
                    }
                    this.height = this.stripUnitFromSize(this.height);
                    this.width = this.stripUnitFromSize(this.width);
                    this.htmlAssembler.appendContent(',').appendContent(" ").appendContent(this.height);
                    this.htmlAssembler.appendContent(',').appendContent(" ").appendContent(this.width);
                    this.htmlAssembler.appendContent(',').appendContent(" ").appendContent(this.tabStrip ? "true" : "false");
                    this.htmlAssembler.appendContent(");");
                    this.handleTabLayoutMetaData();
                    this.htmlAssembler.newLine();
                } else if (this.typeCode == 2) {
                    this.handleBorderLayoutMetaData();
                    this.htmlAssembler.newLine();
                    this.constructMainBorderPanel();
                } else if (this.typeCode == 5) {
                    this.handleAccordionLayoutMetaData();
                    this.htmlAssembler.newLine();
                    this.constructMainAccordionPanel();
                }
                this.htmlAssembler.closeFunction();
                if (functionName != null) {
                    this.htmlAssembler.setEventOnLoad(functionName);
                }
                this.htmlAssembler.appendContent("});");
                this.htmlAssembler.closeScriptTag();
                if (this.child && this.windowchild) break;
                this.htmlAssembler.closeDivTag();
                break;
            }
        }
        JspWriter out = this.pageContext.getOut();
        try {
            this.htmlAssembler.writeHead(out);
            this.htmlAssembler.writeHtml(out);
        }
        catch (IOException e) {
            throw new OutputException(e);
        }
        finally {
            this.release();
        }
        this.onTagEnd();
        return 6;
    }

    @Override
    public void release() {
        this.align = null;
        this.name = null;
        this.type = null;
        this.tabPosition = null;
        this.tabheight = null;
        this.style = null;
        this.padding = null;
        this.height = null;
        this.width = null;
        this.typeCode = -1;
        this.metaDataList = new ArrayList();
        this.child = false;
        this.parent = null;
        this.windowchild = false;
        this.child = false;
        this.accordionChild = false;
        this.tabChild = false;
        this.windowparent = null;
        this.firstTabName = null;
        this.htmlAssembler = null;
        this.fitToWindow = false;
        this.hasTabStripBeenSet = false;
        super.release();
    }

    public void appendMetaData(LayoutAreaTag.LayoutMetaData layoutMetaData) {
        LayoutAreaTag.LayoutMetaData obj = layoutMetaData;
        this.metaDataList.add(obj);
    }

    private void constructMainBorderPanel() {
        StringBuffer items = new StringBuffer("[");
        for (int i = 0; i < this.panelList.size(); ++i) {
            items.append((String)this.panelList.get(i));
            if (i >= this.panelList.size() - 1) continue;
            items.append(',');
        }
        items.append(']');
        String parsedName = this.name.replace('-', '_');
        this.htmlAssembler.newLine();
        if (this.windowchild) {
            this.htmlAssembler.appendContent("var " + parsedName + "_items = ").appendContent(items).appendContent(';');
            this.htmlAssembler.newLine();
            this.htmlAssembler.addToObjectCache(this.name, parsedName + "_items");
            return;
        }
        String panelVarName = "_cf_" + parsedName + LAYOUT;
        this.htmlAssembler.appendContent("var ").appendContent(panelVarName).appendContent("= Ext.getCmp('" + panelVarName + "')");
        this.htmlAssembler.newLine();
        this.htmlAssembler.appendContent("if(!" + panelVarName + ")");
        this.htmlAssembler.newLine();
        this.htmlAssembler.appendContent(panelVarName).appendContent(NEWPANEL_INIT);
        if (!this.child) {
            this.htmlAssembler.appendContent("renderTo").appendContent(':').appendContent(this.name, true).appendContent(',');
        }
        if (this.height == null) {
            this.height = this.extractHeightFromStyle(this.style);
        }
        String string = this.height = this.height == null ? DEFAULT_HEIGHT : this.height;
        if (this.width == null) {
            this.width = this.extractWidthFromStyle(this.style);
        }
        this.width = this.stripUnitFromSize(this.width);
        this.height = this.stripUnitFromSize(this.height);
        this.htmlAssembler.appendContent("height").appendContent(':').appendContent(this.height);
        if (this.width != null) {
            this.htmlAssembler.appendContent(',').appendContent("width").appendContent(':').appendContent(this.width);
        }
        this.htmlAssembler.appendContent(',');
        this.htmlAssembler.appendContent(LAYOUT).appendContent(':').appendContent(BORDER, true).appendContent(',').appendContent("items").appendContent(':').appendContent(items);
        this.htmlAssembler.appendContent("});");
        this.htmlAssembler.newLine();
        this.htmlAssembler.addToObjectCache(this.name, "_cf_" + parsedName + LAYOUT);
        if (this.fitToWindow) {
            this.htmlAssembler.newLine();
            this.htmlAssembler.appendContent(INIT_VIEWPORT).appendContent(this.name, true).appendContent(',').appendContent("_cf_" + parsedName + LAYOUT).appendContent(");");
        }
    }

    private void constructMainAccordionPanel() {
        StringBuffer items = null;
        if (this.panelList.size() > 0) {
            items = new StringBuffer("[");
            for (int i = 0; i < this.panelList.size(); ++i) {
                items.append((String)this.panelList.get(i)).append(" ");
                if (i >= this.panelList.size() - 1) continue;
                items.append(',');
            }
            items.append(']');
        }
        String parsedName = this.name.replace('-', '_');
        this.htmlAssembler.newLine();
        String itemVar = "items_" + parsedName;
        this.htmlAssembler.appendContent("var " + itemVar + " = ").appendContent(items).appendContent(';');
        this.htmlAssembler.newLine();
        this.htmlAssembler.appendContent("var ").appendContent("_cf_").appendContent(parsedName).appendContent(LAYOUT);
        this.htmlAssembler.appendContent("=").appendContent(INIT_ACCORDION_PANEL);
        this.htmlAssembler.appendContent(this.name, true);
        this.htmlAssembler.appendContent(',').appendContent(this.activeOnTop ? "true" : "false");
        this.htmlAssembler.appendContent(',').appendContent(this.collapseToggle, true);
        this.htmlAssembler.appendContent(',').appendContent(this.titleCollapse ? "true" : "false");
        this.htmlAssembler.appendContent(',').appendContent(this.fillHeight ? "true" : "false");
        if (this.height == null) {
            this.height = this.extractHeightFromStyle(this.style);
        }
        if (this.width == null) {
            this.width = this.extractWidthFromStyle(this.style);
        }
        this.width = this.stripUnitFromSize(this.width);
        this.height = this.stripUnitFromSize(this.height);
        this.htmlAssembler.appendContent(',').appendContent(this.height);
        this.htmlAssembler.appendContent(',').appendContent(this.width);
        this.htmlAssembler.appendContent(',').appendContent((String)(itemVar == null ? "null" : itemVar));
        this.htmlAssembler.appendContent(");");
        this.htmlAssembler.newLine();
        this.htmlAssembler.addToObjectCache(this.name, "_cf_" + parsedName + LAYOUT);
        String selectedChildPanelName = null;
        for (LayoutAreaTag.LayoutMetaData layoutMetaData : this.metaDataList) {
            if (!layoutMetaData.isSelected()) continue;
            selectedChildPanelName = layoutMetaData.getName();
        }
        if (selectedChildPanelName != null) {
            this.htmlAssembler.newLine();
            this.htmlAssembler.appendContent(EXPAND_ACCORDION_CHIELD_PANEL).appendContent(HtmlAssembler.singleQuote(this.name)).appendContent(',').appendContent(HtmlAssembler.singleQuote(selectedChildPanelName)).appendContent(");");
        }
    }

    private void handleTabLayoutMetaData() throws JspException {
        Iterator itselected = this.metaDataList.iterator();
        boolean isAnyPanelSelected = false;
        while (itselected.hasNext()) {
            LayoutAreaTag.LayoutMetaData layoutmetadata = (LayoutAreaTag.LayoutMetaData)itselected.next();
            if (!layoutmetadata.isSelected()) continue;
            isAnyPanelSelected = true;
            break;
        }
        boolean isFirstPanel = true;
        for (LayoutAreaTag.LayoutMetaData layoutMetaData : this.metaDataList) {
            boolean enablesScroll;
            boolean bindOnLoad = layoutMetaData.isBindOnLoad();
            if (!bindOnLoad && !isAnyPanelSelected && isFirstPanel) {
                bindOnLoad = true;
            }
            this.firstTabName = layoutMetaData.getDivId();
            String divId = layoutMetaData.getDivId();
            String name = layoutMetaData.getName();
            String source = layoutMetaData.getSource();
            String title = layoutMetaData.getTitle();
            String tabTip = layoutMetaData.getTabTip();
            boolean selected = layoutMetaData.isSelected();
            boolean hide = layoutMetaData.isHide();
            boolean disabled = layoutMetaData.isDisabled();
            boolean bl = enablesScroll = !layoutMetaData.getOverflow().equalsIgnoreCase("hidden");
            if (name != null) {
                this.addTab(divId, name, title, tabTip, layoutMetaData.isClosable(), layoutMetaData.isRefreshOnActivate(), disabled, enablesScroll);
            }
            if (selected || !isAnyPanelSelected && isFirstPanel) {
                this.setSelected(name);
            }
            if (hide) {
                this.setHide(name);
            }
            if (source != null) {
                this.htmlAssembler.newLine();
                BindProcessor bp = new BindProcessor();
                bp.setErrorHandler(layoutMetaData.getOnBindError());
                bp.processBind(divId, null, null, source, bindOnLoad, this.htmlAssembler, 3, this.pageContext);
            }
            if (!isFirstPanel) continue;
            isFirstPanel = false;
        }
    }

    private void handleBorderLayoutMetaData() throws JspException {
        this.htmlAssembler.newLine();
        Iterator it = this.metaDataList.iterator();
        boolean[] directions = new boolean[5];
        String mainPanelName = this.name.replace('-', '_');
        Object panelName = "";
        while (it.hasNext()) {
            Object width;
            this.htmlAssembler.newLine();
            LayoutAreaTag.LayoutMetaData layoutMetaData = (LayoutAreaTag.LayoutMetaData)it.next();
            int direction = layoutMetaData.getDirectionCode();
            panelName = mainPanelName + "_" + LayoutAreaTag.directions[direction];
            if (directions[direction]) {
                throw new InvalidPositionAttributeException(LayoutAreaTag.positions[direction]);
            }
            directions[direction] = true;
            this.htmlAssembler.appendContent("var ").appendContent((String)panelName).appendContent(" = Ext.getCmp('" + layoutMetaData.getName() + "')");
            this.htmlAssembler.newLine();
            this.htmlAssembler.appendContent("if(!" + (String)panelName + ")");
            this.htmlAssembler.newLine();
            this.htmlAssembler.appendContent((String)panelName).appendContent(NEWPANEL_INIT).appendContent("region").appendContent(':').appendContent(LayoutAreaTag.directions[direction], true);
            this.htmlAssembler.newLine();
            if (layoutMetaData.getDivId() != null) {
                this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("contentEl").appendContent(':').appendContent(layoutMetaData.getDivId(), true);
                this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("_cf_body").appendContent(':').appendContent(layoutMetaData.getDivId(), true);
            }
            if (layoutMetaData.getName() != null) {
                this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("id").appendContent(':').appendContent(layoutMetaData.getName(), true);
            }
            if (layoutMetaData.isSplitter()) {
                this.htmlAssembler.appendContent(',').appendContent(" ").appendContent(SPLIT_PROP).appendContent(':').appendContent(" ").appendContent("true");
            } else {
                this.htmlAssembler.appendContent(',').appendContent(" ").appendContent(SPLIT_PROP).appendContent(':').appendContent(" ").appendContent("false");
            }
            if (layoutMetaData.getChildId() != null && layoutMetaData.getSizeNum() <= 0 && direction == 0) {
                throw new SizeRequiredForNestedBorder();
            }
            if (layoutMetaData.getSizeNum() > 0) {
                if (direction < 2) {
                    this.htmlAssembler.newLine();
                    this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("height").appendContent(':').appendContent(" ").appendContent(new Integer(layoutMetaData.getSizeNum()).toString());
                } else if (direction > 2) {
                    this.htmlAssembler.newLine();
                    this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("width").appendContent(':').appendContent(" ").appendContent(new Integer(layoutMetaData.getSizeNum()).toString());
                }
            }
            if (layoutMetaData.getTitle() != null || layoutMetaData.isCollapsible() || layoutMetaData.isClosable()) {
                String title = layoutMetaData.getTitle();
                if (title == null) {
                    title = "  ";
                }
                this.htmlAssembler.newLine();
                this.htmlAssembler.appendContent(',').appendContent(" ").appendContent(TITLE_PROP).appendContent(':').appendContent(" ").appendContent(title, true);
            }
            if (layoutMetaData.getMinsize() > 0) {
                this.htmlAssembler.newLine();
                this.htmlAssembler.appendContent(',').appendContent(" ").appendContent(MINSIZE_PROP).appendContent(':').appendContent(" ").appendContent(new Integer(layoutMetaData.getMinsize()).toString());
            }
            if (layoutMetaData.getMaxsize() > 0) {
                this.htmlAssembler.newLine();
                this.htmlAssembler.appendContent(',').appendContent(" ").appendContent(MAXSIZE_PROP).appendContent(':').appendContent(" ").appendContent(new Integer(layoutMetaData.getMaxsize()).toString());
            }
            if (layoutMetaData.isCollapsible()) {
                this.htmlAssembler.newLine();
                this.htmlAssembler.appendContent(',').appendContent(" ").appendContent(COLLAPSIBLE_PROP).appendContent(':').appendContent(" ").appendContent("true");
                this.htmlAssembler.newLine();
                this.htmlAssembler.appendContent(',').appendContent(" ").appendContent(ANIMATE_PROP).appendContent(':').appendContent(" ").appendContent("true");
            }
            if (layoutMetaData.isInitcollapsed()) {
                this.htmlAssembler.newLine();
                this.htmlAssembler.appendContent(',').appendContent(" ").appendContent(COLLAPSED_PROP).appendContent(':').appendContent(" ").appendContent("true");
            }
            if (layoutMetaData.isClosable()) {
                this.htmlAssembler.newLine();
                this.htmlAssembler.appendContent(',').appendContent(" ").appendContent(CLOSABLE_PROP).appendContent(':').appendContent(" ").appendContent("true");
            }
            if (layoutMetaData.getOverflow().equalsIgnoreCase("hidden")) {
                this.htmlAssembler.newLine();
                this.htmlAssembler.appendContent(',').appendContent(" ").appendContent(AUTOSCROLLFALSE_PROP);
            } else {
                this.htmlAssembler.newLine();
                this.htmlAssembler.appendContent(',').appendContent(" ").appendContent(AUTOSCROLLTRUE_PROP);
            }
            String layoutareaStyle = layoutMetaData.getStyle();
            if (layoutareaStyle != null && (width = this.extractWidthFromStyle(layoutareaStyle)) != null) {
                try {
                    width = "" + (Integer.parseInt((String)width) + 2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.htmlAssembler.newLine();
                if (!((String)width).trim().endsWith("%")) {
                    this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("width: ").appendContent((String)width);
                }
            }
            this.htmlAssembler.newLine();
            this.htmlAssembler.appendContent(',').appendContent(" ").appendContent(HIDEWHENEMPTY_PROP);
            this.htmlAssembler.newLine();
            this.htmlAssembler.appendContent('}').appendContent(");");
            this.panelList.add(panelName);
            this.htmlAssembler.newLine();
            this.htmlAssembler.appendContent("ColdFusion.objectCache[").appendContent(layoutMetaData.getName(), true).appendContent("] = ");
            this.htmlAssembler.appendContent((String)panelName + ";");
            if (layoutMetaData.getChildId() == null) continue;
            this.htmlAssembler.newLine();
            this.htmlAssembler.appendContent("var itemPanel = ColdFusion.objectCache['" + layoutMetaData.getChildId() + "'];");
            this.htmlAssembler.newLine();
            this.htmlAssembler.appendContent((String)panelName).appendContent(".add(itemPanel);");
        }
        if (!directions[2]) {
            panelName = this.name + "_CENTER";
            this.htmlAssembler.newLine();
            this.htmlAssembler.appendContent("var ").appendContent((String)panelName).appendContent("= Ext.getCmp('" + (String)panelName + "')");
            this.htmlAssembler.newLine();
            this.htmlAssembler.appendContent("if(!" + (String)panelName + ")");
            this.htmlAssembler.newLine();
            this.htmlAssembler.appendContent((String)panelName).appendContent(NEWPANEL_INIT).appendContent("region").appendContent(':').appendContent(LayoutAreaTag.directions[2], true);
            this.htmlAssembler.appendContent(',').appendContent(" ").appendContent(AUTOSCROLLTRUE_PROP).appendContent("});");
            this.panelList.add(panelName);
        }
        Iterator itnew = this.metaDataList.iterator();
        while (itnew.hasNext()) {
            this.addBorderLayoutArea((LayoutAreaTag.LayoutMetaData)itnew.next());
        }
    }

    private void generateIconClass() throws JspException {
        Iterator itIconclass = this.metaDataList.iterator();
        StringBuffer styleContent = new StringBuffer();
        while (itIconclass.hasNext()) {
            LayoutAreaTag.LayoutMetaData layoutMetaData = (LayoutAreaTag.LayoutMetaData)itIconclass.next();
            if (layoutMetaData.getTitleIcon() == null) continue;
            styleContent.append(" .").append(layoutMetaData.getDivId()).append(" ");
            styleContent.append(BACKGROUNDIMAGECSS).append(layoutMetaData.getTitleIcon()).append(CLOSINGBACKGROUNDIMAGECSS);
            styleContent.append('\n');
        }
        String iconStyle = styleContent.toString().trim();
        if (iconStyle.length() > 0) {
            this.htmlAssembler.openStyle(iconStyle);
            this.htmlAssembler.closeStyle();
        }
    }

    private void handleAccordionLayoutMetaData() throws JspException {
        this.htmlAssembler.newLine();
        Iterator it = this.metaDataList.iterator();
        while (it.hasNext()) {
            this.htmlAssembler.newLine();
            LayoutAreaTag.LayoutMetaData layoutMetaData = (LayoutAreaTag.LayoutMetaData)it.next();
            if (!(this.fillHeight || layoutMetaData.getOverflow().equalsIgnoreCase("scroll") || layoutMetaData.getOverflow().equalsIgnoreCase("auto"))) {
                throw new InvalidFillHeightAttributeException();
            }
            String panelName = this.name.replace('-', '_') + "_" + this.htmlAssembler.getId();
            this.htmlAssembler.appendContent("var ").appendContent(panelName + " ").appendContent("=").appendContent(INIT_ACCORDION_CHIELD_PANEL);
            this.htmlAssembler.appendContent(layoutMetaData.getDivId(), true);
            this.htmlAssembler.appendContent(',').appendContent(layoutMetaData.getName(), true);
            this.htmlAssembler.appendContent(',').appendContent(layoutMetaData.getTitle(), layoutMetaData.getTitle() != null);
            this.htmlAssembler.appendContent(',').appendContent(layoutMetaData.isCollapsible() ? "true" : "false");
            this.htmlAssembler.appendContent(',').appendContent(layoutMetaData.isClosable() ? "true" : "false");
            this.htmlAssembler.appendContent(',').appendContent(layoutMetaData.getOverflow().equalsIgnoreCase("hidden") ? "false" : "true");
            this.htmlAssembler.appendContent(',').appendContent(layoutMetaData.getTitleIcon() != null ? HtmlAssembler.singleQuote(layoutMetaData.getDivId()) : "null");
            this.htmlAssembler.appendContent(',').appendContent(layoutMetaData.isRefreshOnActivate() ? "true" : "false");
            this.htmlAssembler.appendContent(");");
            this.panelList.add(panelName);
        }
        Iterator itselected = this.metaDataList.iterator();
        boolean isAnypanelSelected = false;
        while (itselected.hasNext()) {
            LayoutAreaTag.LayoutMetaData layoutMetaData = (LayoutAreaTag.LayoutMetaData)itselected.next();
            if (!layoutMetaData.isSelected()) continue;
            isAnypanelSelected = true;
            break;
        }
        boolean isFirstPanel = true;
        for (LayoutAreaTag.LayoutMetaData layoutMetaData : this.metaDataList) {
            String source = layoutMetaData.getSource();
            boolean bindOnLoad = layoutMetaData.isBindOnLoad();
            if (!bindOnLoad && !isAnypanelSelected && isFirstPanel) {
                bindOnLoad = true;
            }
            String layoutAreaName = layoutMetaData.getDivId();
            if (source != null) {
                this.htmlAssembler.newLine();
                BindProcessor bp = new BindProcessor();
                bp.setErrorHandler(layoutMetaData.getOnBindError());
                bp.processBind(layoutAreaName, null, null, source, bindOnLoad, this.htmlAssembler, 3, this.pageContext);
            }
            isFirstPanel = false;
            this.htmlAssembler.newLine();
        }
    }

    private String extractHeightFromStyle(String style) {
        String heightValue = null;
        if (style == null || style.length() == 0) {
            return heightValue;
        }
        int index = style.indexOf("height");
        if (index < 0) {
            index = style.indexOf("Height");
        }
        if (index >= 0) {
            int indexOfSemicolon = style.indexOf(59, index);
            int indexOfColon = style.indexOf(58, index);
            if (indexOfColon > 0) {
                if (indexOfSemicolon <= 0) {
                    indexOfSemicolon = style.length();
                }
                heightValue = style.substring(indexOfColon + 1, indexOfSemicolon);
                if ((heightValue = heightValue.trim()).endsWith("px") || heightValue.endsWith("pt")) {
                    heightValue = heightValue.substring(0, heightValue.length() - 2);
                }
            }
        }
        return heightValue;
    }

    private String extractWidthFromStyle(String style) {
        String widthValue = null;
        if (style == null || style.length() == 0) {
            return widthValue;
        }
        int index = style.indexOf("width");
        if (index < 0) {
            index = style.indexOf("Width");
        }
        if (index >= 0) {
            int indexOfSemicolon = style.indexOf(59, index);
            int indexOfColon = style.indexOf(58, index);
            if (indexOfColon > 0) {
                if (indexOfSemicolon <= 0) {
                    indexOfSemicolon = style.length();
                }
                widthValue = style.substring(indexOfColon + 1, indexOfSemicolon);
                if ((widthValue = widthValue.trim()).endsWith("px") || widthValue.endsWith("pt")) {
                    widthValue = widthValue.substring(0, widthValue.length() - 2);
                }
            }
        }
        return widthValue;
    }

    private String stripUnitFromSize(String size) {
        if (size == null || size.trim().length() == 0) {
            return null;
        }
        char lastSizeChar = size.charAt(size.length() - 1);
        if (!Character.isDigit(lastSizeChar)) {
            if (lastSizeChar == '%') {
                return size.substring(0, size.length() - 1);
            }
            String sizeUnits = size.substring(size.length() - 2).toLowerCase();
            if (!(sizeUnits.equals("px") || sizeUnits.equals("em") || sizeUnits.equals("ex") || sizeUnits.equals("in") || sizeUnits.equals("cm") || sizeUnits.equals("mm") || sizeUnits.equals("pt") || sizeUnits.equals("pc"))) {
                return size;
            }
            return size.substring(0, size.length() - 2);
        }
        return size;
    }

    private void addBorderLayoutArea(LayoutAreaTag.LayoutMetaData layoutMetaData) throws JspException {
        String source = layoutMetaData.getSource();
        String layoutAreaName = layoutMetaData.getDivId();
        if (source != null) {
            this.htmlAssembler.newLine();
            BindProcessor bp = new BindProcessor();
            bp.setErrorHandler(layoutMetaData.getOnBindError());
            bp.processBind(layoutAreaName, null, null, source, true, this.htmlAssembler, 3, this.pageContext);
        }
        this.htmlAssembler.newLine();
    }

    private void addTab(String divId, String name, String displaytext, String tabTip, boolean closable, boolean refreshOnActivate, boolean disabled, boolean enableScroll) {
        this.htmlAssembler.newLine();
        this.htmlAssembler.appendContent(ADDTAB).appendContent("_cf_").appendContent(LAYOUT).appendContent(',').appendContent(HtmlAssembler.doubleQuote(divId)).appendContent(',').appendContent(HtmlAssembler.doubleQuote(name)).appendContent(',').appendContent(HtmlAssembler.doubleQuote(displaytext)).appendContent(',').appendContent(tabTip == null ? "null" : HtmlAssembler.singleQuote(tabTip)).appendContent(',').appendContent(closable ? "true" : "false").appendContent(',').appendContent(refreshOnActivate ? "true" : "false").appendContent(',').appendContent(disabled ? "true" : "false").appendContent(',').appendContent(enableScroll ? "true" : "false").appendContent(");");
    }

    private void setSelected(String name) {
        this.htmlAssembler.newLine();
        this.htmlAssembler.appendContent(SELECTTAB).appendContent(HtmlAssembler.singleQuote(this.name)).appendContent(',').appendContent(HtmlAssembler.singleQuote(name)).appendContent(");");
    }

    private void setHide(String name) {
        this.htmlAssembler.newLine();
        this.htmlAssembler.appendContent(HIDETAB).appendContent(HtmlAssembler.singleQuote(this.name)).appendContent(',').appendContent(HtmlAssembler.singleQuote(name)).appendContent(");");
    }

    static {
        borderNotAllowedAttributes.add("TABPOSITION");
        borderNotAllowedAttributes.add("PADDING");
        borderNotAllowedAttributes.add("ACTIVEONTOP");
        borderNotAllowedAttributes.add("COLLAPSETOGGLE");
        borderNotAllowedAttributes.add("TITLECOLLAPSE");
        borderNotAllowedAttributes.add("FILLHEIGHT");
        borderNotAllowedAttributes.add("TABSTRIP");
        borderAllowedAttributes.add("NAME");
        borderAllowedAttributes.add("STYLE");
        borderAllowedAttributes.add("TYPE");
        borderAllowedAttributes.add("HEIGHT");
        borderAllowedAttributes.add("WIDTH");
        accordionAllowedAttributes = new ArrayList();
        accordionNotAllowedAttributes = new ArrayList();
        accordionNotAllowedAttributes.add("TABPOSITION");
        accordionNotAllowedAttributes.add("PADDING");
        accordionNotAllowedAttributes.add("TABSTRIP");
        accordionAllowedAttributes.add("NAME");
        accordionAllowedAttributes.add("STYLE");
        accordionAllowedAttributes.add("TYPE");
        accordionAllowedAttributes.add("ACTIVEONTOP");
        accordionAllowedAttributes.add("COLLAPSETOGGLE");
        accordionAllowedAttributes.add("TITLECOLLAPSE");
        accordionAllowedAttributes.add("FILLHEIGHT");
        accordionAllowedAttributes.add("HEIGHT");
        accordionAllowedAttributes.add("WIDTH");
        tabAllowedAttributes = new ArrayList();
        tabNotAllowedAttributes = new ArrayList();
        tabNotAllowedAttributes.add("PADDING");
        tabNotAllowedAttributes.add("ACTIVEONTOP");
        tabNotAllowedAttributes.add("COLLAPSETOGGLE");
        tabNotAllowedAttributes.add("TITLECOLLAPSE");
        tabNotAllowedAttributes.add("FILLHEIGHT");
        tabAllowedAttributes.add("NAME");
        tabAllowedAttributes.add("STYLE");
        tabAllowedAttributes.add("TYPE");
        tabAllowedAttributes.add("TABPOSITION");
        tabAllowedAttributes.add("HEIGHT");
        tabAllowedAttributes.add("WIDTH");
        tabAllowedAttributes.add("TABSTRIP");
        boxAllowedAttributes = new ArrayList();
        boxNotAllowedAttributes = new ArrayList();
        boxNotAllowedAttributes.add("TABPOSITION");
        boxNotAllowedAttributes.add("ACTIVEONTOP");
        boxNotAllowedAttributes.add("COLLAPSETOGGLE");
        boxNotAllowedAttributes.add("TITLECOLLAPSE");
        boxNotAllowedAttributes.add("FILLHEIGHT");
        boxNotAllowedAttributes.add("TABSTRIP");
        boxAllowedAttributes.add("NAME");
        boxAllowedAttributes.add("STYLE");
        boxAllowedAttributes.add("TYPE");
        boxAllowedAttributes.add("PADDING");
        boxAllowedAttributes.add("ALIGN");
        boxAllowedAttributes.add("HEIGHT");
        boxAllowedAttributes.add("WIDTH");
    }

    public static class HeightWidthInPercentageNotSupportedException
    extends TagValidationException {
    }

    public class InvalidTabHeightUsageException
    extends TagValidationException {
    }

    public class InvalidTabStripUsageException
    extends TagValidationException {
    }

    public class InvalidFitToWindowUsageException
    extends TagValidationException {
    }

    public class EmptyNameException
    extends TagValidationException {
    }

    public class InvalidTypeException
    extends TagValidationException {
    }

    public class InvalidAttributeLayoutException
    extends TagValidationException {
        public String layoutType;
        public String allowed;
        public String notAllowed;

        public InvalidAttributeLayoutException(String layoutType, List notAllowed, List allowed) {
            this.layoutType = layoutType;
            this.notAllowed = ArrayUtil.ArrayToList(notAllowed, ",").toUpperCase();
            this.allowed = ArrayUtil.ArrayToList(allowed, ",").toUpperCase();
        }
    }

    public class InvalidTabHeightAttributeException
    extends TagValidationException {
    }

    public class InvalidBoxPaddingAttributeException
    extends TagValidationException {
    }

    public class InvalidBoxAlignAttributeException
    extends TagValidationException {
    }

    public class InvalidPositionAttributeException
    extends NeoException {
        public String value;

        InvalidPositionAttributeException(String value) {
            this.value = value;
        }
    }

    public class SizeRequiredForNestedBorder
    extends TagValidationException {
    }

    public class InvalidFillHeightAttributeException
    extends TagValidationException {
    }

    public class InvalidLayoutNestingException
    extends NeoException {
    }

    public static class InvalidParentTagException
    extends NeoException {
        public String child;
        public String parent;

        InvalidParentTagException(String child, String parent) {
            this.child = child;
            this.parent = parent;
        }
    }
}

