/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.ajax;

import coldfusion.compiler.validation.TagValidationException;
import coldfusion.tagext.ChildTag;
import coldfusion.tagext.html.ajax.AjaxUtils;
import coldfusion.tagext.html.ajax.MapItemData;
import coldfusion.tagext.html.ajax.MapTag;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.Tag;

public class MapItemTag
extends ChildTag {
    public static final String IMPORT_TAGNAME = "CFMAPITEM";
    public static final String CFMAPITEM = "cf_mapitem";
    protected String address = null;
    protected String latitude = null;
    protected String longitude = null;
    protected String name = null;
    protected String tip = null;
    protected String markerColor = null;
    protected String markerIcon = null;
    protected String markerWindowContent = null;
    protected boolean showMarkerWindow = false;
    private boolean isShowMarkerSetThruTag = false;
    protected boolean showUser = false;
    protected MapTag _parentMapTag;

    public MapItemTag() {
        super(MapTag.class);
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTip() {
        return this.tip;
    }

    public void setTip(String tip) {
        this.tip = tip;
    }

    public String getMarkerIcon() {
        return this.markerIcon;
    }

    public void setMarkerIcon(String markerIcon) {
        this.markerIcon = markerIcon;
    }

    public String getMarkerColor() {
        return this.markerColor;
    }

    public void setMarkerColor(String markerColor) {
        this.markerColor = markerColor;
    }

    public String getMarkerWindowContent() {
        return this.markerWindowContent;
    }

    public void setMarkerWindowContent(String markerWindowContent) {
        this.markerWindowContent = markerWindowContent;
    }

    public boolean isShowMarkerWindow() {
        return this.showMarkerWindow;
    }

    public void setShowMarkerWindow(boolean showMarkerWindow) {
        this.showMarkerWindow = showMarkerWindow;
        this.isShowMarkerSetThruTag = true;
    }

    public void setShowUser(boolean showUser) {
        this.showUser = showUser;
    }

    @Override
    protected void setAncestor(Tag ancestor) {
        this._parentMapTag = (MapTag)ancestor;
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        if (!this.isShowMarkerSetThruTag) {
            this.showMarkerWindow = this.markerWindowContent != null ? true : this._parentMapTag.isShowMarkerWindow();
        }
        this.validateAttribute();
        MapItemData mapItemData = new MapItemData(this);
        this._parentMapTag.addMapMarker(mapItemData);
        if (this.showUser) {
            this._parentMapTag.setChildShowUserSet(this.showUser);
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        this.onTagEnd();
        return 6;
    }

    private void validateAttribute() {
        if (this.address != null && this.address.trim().length() == 0) {
            throw new EmptyAddressException();
        }
        if (this.latitude != null && this.latitude.trim().length() == 0 || this.longitude != null && this.longitude.trim().length() == 0) {
            throw new EmptyLatitudeLongitudeException();
        }
        if (this.markerColor != null && this.markerIcon != null) {
            throw new InvalidMarkerColorAndIconException();
        }
        if (this.markerColor != null) {
            if (AjaxUtils.checkHexaColorFormat(this.markerColor)) {
                this.markerColor = "#" + this.markerColor;
            } else {
                throw new InvalidMarkerColorFormatException();
            }
        }
        if (this.latitude != null || this.longitude != null) {
            float lat = Float.parseFloat(this.latitude);
            float lng = Float.parseFloat(this.longitude);
            if ((double)lat < -90.0 || (double)lat > 90.0) {
                throw new LatitudeOutOfRangeException(this.latitude);
            }
            if ((double)lng < -180.0 || (double)lng > 180.0) {
                throw new LongitudeOutOfRangeException(this.longitude);
            }
        }
    }

    @Override
    public void release() {
        super.release();
        this.address = null;
        this.latitude = null;
        this.longitude = null;
        this.name = null;
        this.tip = null;
        this.markerColor = null;
        this.markerIcon = null;
        this.markerWindowContent = null;
        this.showMarkerWindow = false;
        this.showUser = false;
    }

    public class EmptyAddressException
    extends TagValidationException {
    }

    public class EmptyLatitudeLongitudeException
    extends TagValidationException {
    }

    public class InvalidMarkerColorAndIconException
    extends TagValidationException {
    }

    public class InvalidMarkerColorFormatException
    extends TagValidationException {
    }

    public class LatitudeOutOfRangeException
    extends TagValidationException {
        public String latitude;

        public LatitudeOutOfRangeException(String latitude) {
            this.latitude = latitude;
        }
    }

    public class LongitudeOutOfRangeException
    extends TagValidationException {
        public String longitude;

        public LongitudeOutOfRangeException(String longitude) {
            this.longitude = longitude;
        }
    }
}

