/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.ajax;

import coldfusion.compiler.validation.TagValidationException;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.OutputException;
import coldfusion.tagext.html.ajax.AjaxContainer;
import coldfusion.tagext.html.ajax.AjaxImport;
import coldfusion.tagext.html.ajax.AjaxImportTag;
import coldfusion.tagext.html.ajax.AjaxUtils;
import coldfusion.tagext.html.ajax.BindProcessor;
import coldfusion.tagext.html.ajax.HtmlAssembler;
import coldfusion.tagext.html.ajax.LayoutTag;
import coldfusion.tagext.html.form.FormTag;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.BodyTag;
import jakarta.servlet.jsp.tagext.Tag;
import java.io.IOException;

public class PodTag
extends GenericTag
implements BodyTag,
AjaxContainer,
AjaxImport {
    public static final String IMPORT_TAGNAME = "CFPOD";
    private String name;
    private int height = 100;
    private int width = 500;
    private String source;
    private String title;
    private String bodystyle;
    private String headerstyle;
    private String onBindError;
    private String overflow = "auto";
    HtmlAssembler htmlAssembler;
    private String bodyName;
    private static final String PODNAME_PREFIX = "cf_pod";
    private static final String BODY_SUFFIX = "_body";
    private static final String TITLE_SUFFIX = "_title";
    private static final String POD = "pod";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String PIXEL = "px";
    private static final String BACKGROUND_COLOR = "background-color";
    private static final String OPEN_BTAG = "<B ";
    private static final String CLOSE_BTAG = "</B>";
    private static final String SET_INNERHTML_INIT = "document.getElementById(";
    private static final String SET_INNERHTML_END = ").innerHTML = \"\";";
    private static final String INIT_PODFUNCTION = "ColdFusion.Pod.init(";
    private static final int DEFAULT_HEIGHT = 100;
    private static final int DEFAULT_WIDTH = 500;

    public void setName(String name) {
        this.name = name;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setBodystyle(String bodystyle) {
        this.bodystyle = bodystyle;
    }

    public void setHeaderstyle(String headerstyle) {
        this.headerstyle = headerstyle;
    }

    public void setOverflow(String overflow) {
        this.overflow = overflow;
    }

    public void setOnBindError(String onBindError) {
        this.onBindError = onBindError;
    }

    private void checkIfChild() {
        for (Tag t = this.getParent(); t != null; t = t.getParent()) {
            if (!(t instanceof FormTag)) continue;
            throw new LayoutTag.InvalidParentTagException(IMPORT_TAGNAME, "CFFORM");
        }
    }

    private void validateAttributes() {
        if (this.name != null && this.name.trim().equals("")) {
            throw new PodTagAttributeEmptyException("NAME");
        }
        AjaxUtils.validateOverFlowValues(this.overflow, "cfpod");
    }

    @Override
    public void generateImports(String tagName, HtmlAssembler htmlAssembler) {
        htmlAssembler.setAjaxComponent(true);
        htmlAssembler.importStylesheet("/resources/cf/cf.css");
        htmlAssembler.importJS("/package/cfajax.js");
    }

    public int doStartTag() throws JspException {
        String tempheaderstyle;
        int indexofBgColor;
        this.onTagStart();
        this.htmlAssembler = HtmlAssembler.getInstance(this.pageContext, true);
        this.validateAttributes();
        AjaxImportTag.generateImports(IMPORT_TAGNAME, this.htmlAssembler);
        if (this.name == null) {
            this.name = PODNAME_PREFIX + this.htmlAssembler.getId();
        }
        this.htmlAssembler.setContainerId(this.name + BODY_SUFFIX);
        this.checkIfChild();
        StringBuffer style = new StringBuffer();
        style.append(WIDTH).append(':').append(" ").append(new Integer(this.width).toString()).append(PIXEL).append(';');
        style.append("overflow:").append(" ").append("visible");
        String classname = "ypod";
        this.htmlAssembler.openDivTag(this.name, classname, style.toString());
        this.htmlAssembler.newLine();
        boolean backgroundColorPresent = false;
        if (this.headerstyle != null && (indexofBgColor = (tempheaderstyle = this.headerstyle.toLowerCase()).indexOf(BACKGROUND_COLOR)) >= 0) {
            backgroundColorPresent = true;
        }
        if (backgroundColorPresent) {
            this.openBTag("corner", null);
            for (int i = 1; i <= 4; ++i) {
                this.openBTag("filler" + i, this.headerstyle);
                this.closeBTag();
            }
            this.closeBTag();
            classname = "ypod-bgcolor-hd";
            this.htmlAssembler.openDivTag(this.name + TITLE_SUFFIX, classname, this.headerstyle);
        } else {
            classname = "ypod-hd-left";
            this.htmlAssembler.openDivTag(null, classname, null);
            classname = "ypod-hd-right";
            this.htmlAssembler.openDivTag(null, classname, null);
            classname = "ypod-hd";
            this.htmlAssembler.openDivTag(this.name + TITLE_SUFFIX, classname, this.headerstyle);
        }
        if (this.title != null) {
            this.htmlAssembler.appendContent(this.title);
        } else {
            this.htmlAssembler.appendContent("&nbsp;");
        }
        this.htmlAssembler.closeDivTag();
        if (!backgroundColorPresent) {
            this.htmlAssembler.closeDivTag();
            this.htmlAssembler.closeDivTag();
        }
        this.htmlAssembler.newLine();
        this.bodyName = this.name + BODY_SUFFIX;
        classname = "ypod-dlg-body";
        style = new StringBuffer();
        style.append(HEIGHT).append(':').append(" ").append(new Integer(this.height).toString()).append(PIXEL).append(';').append("overflow:").append(this.overflow).append(';');
        if (this.bodystyle != null) {
            style.append(this.bodystyle);
        }
        this.htmlAssembler.openDivTag(this.bodyName, classname, style.toString());
        this.htmlAssembler.newLine();
        JspWriter out = this.pageContext.getOut();
        try {
            this.htmlAssembler.writeHtml(out);
        }
        catch (IOException e) {
            throw new OutputException(e);
        }
        return 1;
    }

    private void openBTag(String classname, String style) {
        this.htmlAssembler.appendContent(OPEN_BTAG).appendContent(" ");
        if (classname != null) {
            this.htmlAssembler.appendContent(" class=\"").appendContent(classname).appendContent("\"");
        }
        if (style != null) {
            this.htmlAssembler.appendContent(" style=\"").appendContent(style).appendContent("\"");
        }
        this.htmlAssembler.appendContent('>');
    }

    private void closeBTag() {
        this.htmlAssembler.appendContent(CLOSE_BTAG);
    }

    @Override
    public int doAfterBody() throws JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        this.htmlAssembler.closeDivTag();
        this.htmlAssembler.closeDivTag();
        this.htmlAssembler.openScriptTag();
        this.htmlAssembler.appendContent("var ");
        String functionName = this.htmlAssembler.openFunction(POD, "init", true, true, null);
        this.htmlAssembler.newLine();
        this.htmlAssembler.appendContent(INIT_PODFUNCTION).appendContent(HtmlAssembler.singleQuote(this.name)).appendContent(");");
        this.htmlAssembler.newLine();
        if (this.source != null) {
            this.htmlAssembler.appendContent(SET_INNERHTML_INIT).appendContent(HtmlAssembler.singleQuote(this.bodyName)).appendContent(SET_INNERHTML_END);
            BindProcessor bp = new BindProcessor();
            bp.setErrorHandler(this.onBindError);
            bp.processBind(this.bodyName, null, null, this.source, true, this.htmlAssembler, 3, this.pageContext);
        }
        this.htmlAssembler.newLine();
        this.htmlAssembler.closeFunction();
        if (functionName != null) {
            this.htmlAssembler.setEventOnLoad(functionName);
        }
        this.htmlAssembler.closeScriptTag();
        JspWriter out = this.pageContext.getOut();
        try {
            this.htmlAssembler.writeHead(out);
            this.htmlAssembler.writeHtml(out);
        }
        catch (IOException e) {
            throw new OutputException(e);
        }
        finally {
            this.htmlAssembler.resetContainerId();
            this.release();
        }
        this.onTagEnd();
        return 6;
    }

    @Override
    public void release() {
        this.name = null;
        this.height = 100;
        this.width = 500;
        this.source = null;
        this.title = null;
        this.bodystyle = null;
        this.headerstyle = null;
        this.onBindError = null;
        this.overflow = "auto";
        this.htmlAssembler = null;
        this.bodyName = null;
        super.release();
    }

    @Override
    public String getBodyId() {
        return this.bodyName;
    }

    public class PodTagAttributeEmptyException
    extends TagValidationException {
        public String attribute;

        PodTagAttributeEmptyException(String attribute) {
            this.attribute = attribute;
        }
    }
}

