/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.ajax;

import coldfusion.compiler.validation.TagValidationException;
import coldfusion.runtime.ApplicationException;
import coldfusion.server.felix.FelixUtil;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.OutputException;
import coldfusion.tagext.html.ajax.AjaxImport;
import coldfusion.tagext.html.ajax.AjaxImportTag;
import coldfusion.tagext.html.ajax.AjaxUtils;
import coldfusion.tagext.html.ajax.BindProcessor;
import coldfusion.tagext.html.ajax.HtmlAssembler;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import java.io.IOException;
import java.util.StringTokenizer;

public class ProgressBarTag
extends GenericTag
implements AjaxImport {
    public static final String IMPORT_TAGNAME = "CFPROGRESSBAR";
    private static final String BGCOLOR = "bgcolor";
    private static final String TEXT_COLOR = "textcolor";
    private static final String PROGRESS_COLOR = "progresscolor";
    private static final String TEMPLATE_PROGRESSBAR_BGCLOR = " .x-progress-default { background-image: none; background-color: _BGCOLOR_;}";
    private static final String TEMPLATE_PROGRESSBAR_TEXTCLOR = " .x-progress-text { color: _TEXTCOLOR_;}";
    private static final String TEMPLATE_PROGRESSBAR_PROGRESSCOLOR = ".x-progress-bar { background-image: none; background-color: _PROGRESSCOLOR_;}";
    private boolean autodisplay = true;
    private String bind = null;
    private String onComplete = null;
    private String onError = null;
    private String duration = null;
    private String height = null;
    private String interval = "1000";
    private String name = null;
    private String width = null;
    private String style = null;
    private String bgcolor = null;
    private String textcolor = null;
    private String progresscolor = null;
    private boolean customColorStyleSet = false;
    private HtmlAssembler htmlAssembler;
    private static final String PROGRESSBAR = "progressbar";
    private static final String CFPROGRESSBAR = "cf_progressbar";
    private static final String PROGRESSBARINIT = "ColdFusion.ProgressBar.create(";
    private static final String FN_ERROR_HANDLER = "_cf_progessbar_errorhandler";
    private static final String LOAD_STATUS_FN = "ColdFusion.ProgressBar.loadStatus";
    private static final String ERROR_HANDLER_FN = "ColdFusion.ProgressBar.errorHandler";
    private static final String STATUS_FN = "getStatus";
    private static final String ONFINISH_CALLBACK_FN = "OnFinishCallBack";
    private static final String[] STATUS_FN_PARAM = new String[]{"_cf_progressBarId"};

    public boolean isAutodisplay() {
        return this.autodisplay;
    }

    public void setAutodisplay(boolean autodisplay) {
        this.autodisplay = autodisplay;
    }

    public String getBind() {
        return this.bind;
    }

    public void setBind(String bind) {
        this.bind = bind;
    }

    public String getOnComplete() {
        return this.onComplete;
    }

    public void setOnComplete(String onComplete) {
        this.onComplete = onComplete;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getOnError() {
        return this.onError;
    }

    public void setOnError(String onError) {
        this.onError = onError;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    @Override
    public void generateImports(String tagName, HtmlAssembler htmlAssembler) {
        htmlAssembler.setAjaxComponent(true);
        htmlAssembler.importStylesheet("/resources/ext/css/ext-all.css");
        htmlAssembler.importStylesheet("/resources/cf/cf.css");
        htmlAssembler.importJS("/package/cfajax.js");
        htmlAssembler.importJS("/ext/ext-all.js");
        htmlAssembler.importJS("/package/cfprogressbar.js");
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        FelixUtil.checkAjaxEnabled();
        this.htmlAssembler = HtmlAssembler.getInstance(this.pageContext, true);
        this.validateAttribute();
        AjaxImportTag.generateImports(IMPORT_TAGNAME, this.htmlAssembler);
        String styleStr = "";
        this.htmlAssembler.openDivTag(this.name, null, null);
        JspWriter out = this.pageContext.getOut();
        try {
            this.htmlAssembler.writeHtml(out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 6;
    }

    public int doEndTag() throws JspException {
        this.htmlAssembler.closeDivTag();
        this.generateStyleCustomCSSClass(this.name);
        this.htmlAssembler.openScriptTag();
        this.htmlAssembler.appendContent("var ");
        String bindFunction = null;
        String callBackFunction = null;
        if (this.bind != null) {
            bindFunction = this.generateBindFunction();
        }
        if (this.onComplete != null) {
            callBackFunction = this.onComplete;
        }
        String functionName = this.htmlAssembler.openFunction(PROGRESSBAR, "init", true, true, null);
        this.htmlAssembler.appendContent("var ").appendContent("_cf_").appendContent(PROGRESSBAR);
        this.htmlAssembler.appendContent("=");
        this.htmlAssembler.appendContent(PROGRESSBARINIT).appendContent(HtmlAssembler.singleQuote(this.name)).appendContent(',').appendContent(bindFunction == null ? "null" : bindFunction).appendContent(',').appendContent(this.duration).appendContent(',').appendContent(this.interval).appendContent(',').appendContent(this.height).appendContent(',').appendContent(this.width).appendContent(',').appendContent(this.autodisplay ? "true" : "false").appendContent(',').appendContent(callBackFunction == null ? "null" : callBackFunction).appendContent(',').appendContent(this.customColorStyleSet ? HtmlAssembler.singleQuote(this.name) : "null").appendContent(',').appendContent(this.onError == null ? "null" : this.onError).appendContent(");");
        this.htmlAssembler.closeFunction();
        if (functionName != null) {
            this.htmlAssembler.setEventOnLoad(functionName);
        }
        this.htmlAssembler.closeScriptTag();
        JspWriter out = this.pageContext.getOut();
        try {
            this.htmlAssembler.writeHead(out);
            this.htmlAssembler.writeHtml(out);
        }
        catch (IOException e) {
            throw new OutputException(e);
        }
        finally {
            this.release();
        }
        this.onTagEnd();
        return 6;
    }

    private String generateBindFunction() throws JspException {
        BindProcessor bindProcessor = new BindProcessor();
        bindProcessor.addBindToParam("_cf_progressbarid", "'" + this.name + "'");
        bindProcessor.setOutput(false);
        bindProcessor.setBindToFunction(true);
        bindProcessor.setErrorHandler(ERROR_HANDLER_FN);
        bindProcessor.processBind(LOAD_STATUS_FN, "true", null, this.bind, false, this.htmlAssembler, -1, this.pageContext);
        if (bindProcessor.getBindType() != 2 && bindProcessor.getBindType() != 1 && bindProcessor.getBindType() != 3) {
            throw new InvalidBindTypeException();
        }
        bindProcessor.assembleImports(this.htmlAssembler);
        String bindFunction = this.htmlAssembler.openFunction(CFPROGRESSBAR, STATUS_FN, true, true, STATUS_FN_PARAM);
        bindProcessor.generateDirectCall(this.htmlAssembler);
        this.htmlAssembler.closeFunction();
        this.htmlAssembler.newLine();
        return bindFunction;
    }

    private void generateStyleCustomCSSClass(String cssclass) {
        String bgcss = null;
        Object customStyleCss = "";
        if (this.bgcolor != null) {
            bgcss = "#" + cssclass + " " + TEMPLATE_PROGRESSBAR_BGCLOR.replace("_BGCOLOR_", this.bgcolor);
            customStyleCss = (String)customStyleCss + bgcss;
        }
        String textcolorcss = null;
        if (this.textcolor != null) {
            textcolorcss = "#" + cssclass + " " + TEMPLATE_PROGRESSBAR_TEXTCLOR.replace("_TEXTCOLOR_", this.textcolor);
            customStyleCss = (String)customStyleCss + textcolorcss;
        }
        String progresscolorcss = null;
        if (this.progresscolor != null) {
            progresscolorcss = " #" + cssclass + "  " + TEMPLATE_PROGRESSBAR_PROGRESSCOLOR.replace("_PROGRESSCOLOR_", this.progresscolor);
            customStyleCss = (String)customStyleCss + progresscolorcss;
        }
        if (((String)customStyleCss).length() > 0) {
            this.htmlAssembler.openStyle((String)customStyleCss);
            this.htmlAssembler.closeStyle();
            this.customColorStyleSet = true;
        }
    }

    private void validateAttribute() {
        if (this.name.trim().equals("")) {
            throw new EmptyProgressNameException();
        }
        if (this.bind == null && this.duration == null) {
            throw new BindOrDurationRequiredException();
        }
        if (this.bind != null && this.duration != null) {
            throw new InvalidPBAttributeCombinationException();
        }
        if (this.onComplete != null && this.onComplete.trim().length() == 0) {
            throw new InvalidCallbackHandlerException();
        }
        if (this.duration != null && (this.duration.trim().length() == 0 || this.duration.trim().equals("0"))) {
            throw new InvalidDurationException();
        }
        this.bgcolor = this.extractStyleProperty(BGCOLOR);
        this.textcolor = this.extractStyleProperty(TEXT_COLOR);
        this.progresscolor = this.extractStyleProperty(PROGRESS_COLOR);
        if (AjaxUtils.checkHexaColorFormat(this.bgcolor)) {
            this.bgcolor = "#" + this.bgcolor;
        }
        if (AjaxUtils.checkHexaColorFormat(this.textcolor)) {
            this.textcolor = "#" + this.textcolor;
        }
        if (AjaxUtils.checkHexaColorFormat(this.progresscolor)) {
            this.progresscolor = "#" + this.progresscolor;
        }
    }

    private String generateCallBackFunction() throws JspException {
        BindProcessor bindProcessor = new BindProcessor();
        bindProcessor.setOutput(false);
        bindProcessor.setBindToFunction(false);
        bindProcessor.processBind(null, "true", null, this.onComplete, false, this.htmlAssembler, 1, this.pageContext);
        bindProcessor.assembleImports(this.htmlAssembler);
        String callBackFunction = this.htmlAssembler.openFunction(CFPROGRESSBAR, ONFINISH_CALLBACK_FN, true, true, null);
        bindProcessor.generateDirectCall(this.htmlAssembler);
        this.htmlAssembler.closeFunction();
        this.htmlAssembler.newLine();
        return callBackFunction;
    }

    private String extractStyleProperty(String propertyname) {
        String value = null;
        if (this.style == null || this.style.length() == 0) {
            return value;
        }
        StringTokenizer st = new StringTokenizer(this.style, ";");
        while (st.hasMoreTokens()) {
            String s1 = st.nextToken().trim();
            int colonIndex = s1.indexOf(58);
            if (colonIndex <= 0) continue;
            String pname = s1.substring(0, colonIndex);
            String pvalue = s1.substring(colonIndex + 1, s1.length());
            if (!pname.equalsIgnoreCase(propertyname)) continue;
            value = pvalue;
            break;
        }
        return value;
    }

    @Override
    public void release() {
        this.autodisplay = true;
        this.bind = null;
        this.onComplete = null;
        this.duration = null;
        this.height = null;
        this.interval = "1000";
        this.name = null;
        this.width = null;
        this.onError = null;
        this.style = null;
        this.bgcolor = null;
        this.textcolor = null;
        this.progresscolor = null;
        this.customColorStyleSet = false;
    }

    public static class InvalidBindTypeException
    extends ApplicationException {
    }

    public class EmptyProgressNameException
    extends TagValidationException {
    }

    public class BindOrDurationRequiredException
    extends TagValidationException {
    }

    public class InvalidPBAttributeCombinationException
    extends TagValidationException {
    }

    public class InvalidCallbackHandlerException
    extends TagValidationException {
    }

    public class InvalidDurationException
    extends TagValidationException {
    }

    public class IntervalNotDefinedException
    extends TagValidationException {
    }
}

