/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.form;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.Array;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.html.ajax.AjaxImportTag;
import coldfusion.tagext.html.ajax.HtmlAssembler;
import coldfusion.tagext.html.form.FormChildTag;
import coldfusion.tagext.html.form.FormField;
import coldfusion.tagext.html.form.FormParent;
import coldfusion.tagext.html.form.FormTag;
import coldfusion.tagext.html.form.InputTagData;
import coldfusion.tagext.validation.CFNumberValidator;
import coldfusion.util.Utils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;

public class JavascriptHelper {
    private StringBuffer jsString = new StringBuffer();
    private static final int BOOLEAN = 0;
    private static final int CREDITCARD = 1;
    private static final int DATE = 2;
    private static final int EMAIL = 3;
    private static final int EURODATE = 4;
    private static final int FLOAT = 5;
    private static final int GUID = 6;
    private static final int INTEGER = 7;
    private static final int NOBLANKS = 8;
    private static final int NUMERIC = 9;
    private static final int RANGE = 10;
    private static final int REGEX = 11;
    private static final int REQUIRED = 12;
    private static final int SOCIAL_SECURITY_NUMBER = 13;
    private static final int SSN = 14;
    private static final int TELEPHONE = 15;
    private static final int TIME = 16;
    private static final int URL = 17;
    private static final int UUID = 18;
    private static final int ZIPCODE = 19;
    private static final int REGULAR_EXPRESSION = 20;
    private static final int MAXLENGTH = 21;
    private static final int USDATE = 22;
    private static final int SUBMITONCE = 23;
    public static final ArrayList validationTypes = new ArrayList(24);
    private static final String CF_RunActiveContent = "//v1.0  Copyright 2006 Adobe Systems, Inc. All rights reserved.\nfunction CF_RunContent(src){document.write(src);}";

    public JavascriptHelper() {
    }

    public JavascriptHelper(FormTag thisForm) {
        if (thisForm.fsncntx.includeJavascriptLib) {
            this.includeJSFiles(thisForm);
        }
        this.jsString.append("<script type=\"text/javascript\" " + Utils.getCSPNonceString() + ">\n");
        this.jsString.append("<!--\n");
        if (thisForm.submitOnce) {
            this.jsString.append("    _CF_submit_status[\"").append(thisForm.name).append("\"]=null;\n");
        }
        this.jsString.append("    _CF_check").append(thisForm.nameForFunction).append(" = function(_CF_this)\n");
        this.jsString.append("    {\n");
        if (thisForm.submitOnce) {
            this.jsString.append("        //return false if form submit button has already been pressed once\n");
            this.jsString.append("        if( _CF_submit_status[_CF_this.name] == \"submitting\" ) return false;\n");
        }
        this.jsString.append("        //reset on submit\n");
        if (thisForm.submitOnce) {
            this.jsString.append("        _CF_submit_status[_CF_this.name] = \"submitting\";\n");
        }
        this.jsString.append("        _CF_error_exists = false;\n");
        this.jsString.append("        _CF_error_messages = new Array();\n");
        this.jsString.append("        _CF_error_fields = new Object();\n");
        this.jsString.append("        _CF_FirstErrorField = null;\n\n");
        this.generateJSValidation(this.jsString, thisForm);
        this.jsString.append("\n");
        this.jsString.append("        //display error messages and return success\n");
        this.jsString.append("        if( _CF_error_exists )\n");
        this.jsString.append("        {\n");
        this.jsString.append("            if( _CF_error_messages.length > 0 )\n");
        this.jsString.append("            {\n");
        this.jsString.append("                // show alert() message\n");
        this.jsString.append("                _CF_onErrorAlert(_CF_error_messages);\n");
        this.jsString.append("                // set focus to first form error, if the field supports js focus().\n");
        this.jsString.append("                if( _CF_this[_CF_FirstErrorField].type == \"text\" )\n");
        this.jsString.append("                { _CF_this[_CF_FirstErrorField].focus(); }\n\n");
        if (thisForm.submitOnce) {
            this.jsString.append("                _CF_submit_status[_CF_this.name] = null;\n");
        }
        this.jsString.append("            }\n");
        this.jsString.append("            return false;\n");
        this.jsString.append("        }else {\n");
        if (thisForm.onSubmit != null) {
            this.jsString.append("            // run userdefined onSubmit javascript. \n");
            this.jsString.append("            ").append(thisForm.onSubmit).append("\n");
        }
        this.jsString.append("            return true;\n");
        this.jsString.append("        }\n");
        this.jsString.append("    }\n");
        this.jsString.append("//-->\n");
        this.jsString.append("</script>\n");
    }

    protected void includeJSFiles(FormTag thisForm) {
        HtmlAssembler htmlAssembler;
        if (thisForm.scriptSrc != null && thisForm.scriptSrc.endsWith("/")) {
            thisForm.scriptSrc = thisForm.scriptSrc.substring(0, thisForm.scriptSrc.length() - 1);
        }
        if ((htmlAssembler = HtmlAssembler.getInstance(thisForm.pgcontxt, false)).isTopPage()) {
            String scriptSrc = thisForm.scriptSrc;
            if (!thisForm.isScriptSrcSet && htmlAssembler.isScriptSrcSet()) {
                scriptSrc = null;
            }
            htmlAssembler.importJS("/cfform.js", scriptSrc, false);
            htmlAssembler.importJS("/masks.js", scriptSrc, false);
        } else {
            AjaxImportTag.generateCheckImportFn("CFFORM", htmlAssembler);
        }
        htmlAssembler.writeHead(thisForm.pgcontxt.getOut());
        thisForm.fsncntx.includeJavascriptLib = false;
    }

    public String getJSString() {
        return this.jsString.toString();
    }

    protected String generateJSMasks(Object thisForm) {
        StringBuffer fullString = new StringBuffer();
        StringBuffer jsString = new StringBuffer();
        this.generateJSMasks(jsString, thisForm);
        if (jsString.length() > 0) {
            fullString.append("<script type=\"text/javascript\" " + Utils.getCSPNonceString() + ">\n");
            fullString.append("<!--\n");
            fullString.append(jsString.toString());
            fullString.append("//-->\n");
            fullString.append("</script>\n\n");
        }
        return fullString.toString();
    }

    private void generateJSMasks(StringBuffer jsString, Object thisForm) {
        block4: {
            block5: {
                block3: {
                    if (!(thisForm instanceof FormTag)) break block3;
                    for (int i = 0; i < ((FormParent)thisForm).getChildren().size(); ++i) {
                        this.generateJSMasks(jsString, ((FormParent)thisForm).getChildren().get(i));
                    }
                    break block4;
                }
                if (!(thisForm instanceof FormField)) break block5;
                if (!(thisForm instanceof InputTagData) || ((InputTagData)thisForm).mask == null) break block4;
                jsString.append(((InputTagData)thisForm).name).append("Mask = new Mask('").append(((InputTagData)thisForm).mask).append("');\n");
                jsString.append(((InputTagData)thisForm).name).append("Mask.attach(document.all['").append(((InputTagData)thisForm)._parentFormTag.name).append("']['").append(((InputTagData)thisForm).name).append("']);\n");
                break block4;
            }
            if (thisForm instanceof FormParent) {
                for (int i = 0; i < ((FormParent)thisForm).getChildren().size(); ++i) {
                    this.generateJSMasks(jsString, ((FormParent)thisForm).getChildren().get(i));
                }
            }
        }
    }

    private void generateJSValidation(StringBuffer jsString, Object thisForm) {
        block31: {
            block29: {
                Array validateTypes;
                FormField item;
                String pad;
                block30: {
                    pad = "        ";
                    if (!(thisForm instanceof FormField)) break block29;
                    item = (FormField)thisForm;
                    validateTypes = item.getValidate();
                    if (item instanceof FormField && item.getValidateAt_onSubmit() && item.getRequired() && (validateTypes != null && validateTypes.size() > 0 || item.getOnValidate() != null) && (validateTypes.indexOf("NOBLANKS") != -1 && validateTypes.size() > 1 || validateTypes.indexOf("NOBLANKS") == -1)) {
                        jsString.append(pad).append("//form element ").append(item.getName()).append(" required check").append("\n");
                        if (validateTypes != null && validateTypes.indexOf("NOBLANKS") != -1) {
                            jsString.append(pad).append("if( _CF_hasValue(_CF_this['").append(item.getName()).append("'], \"").append(item.getType().toUpperCase()).append("\", true ) )\n");
                        } else {
                            jsString.append(pad).append("if( _CF_hasValue(_CF_this['").append(item.getName()).append("'], \"").append(item.getType().toUpperCase()).append("\", false ) )\n");
                        }
                        jsString.append(pad).append("{\n");
                        pad = "            ";
                    }
                    boolean strictNumberValidation = CFNumberValidator.getStrictNumberValidation();
                    for (int i = 0; i < validateTypes.size(); ++i) {
                        boolean required = item.getRequired();
                        String thisType = (String)validateTypes.get(i);
                        if (!item.getValidateAt_onSubmit() || thisType == null || validationTypes.indexOf(thisType.toUpperCase()) == -1 || thisType.toUpperCase().equals("SUBMITONCE") || thisType.toUpperCase().equals("NOBLANKS") || thisType.toUpperCase().equals("REQUIRED")) continue;
                        jsString.append(pad).append("//form element ").append(item.getName()).append(" '").append(thisType.toUpperCase()).append("' validation checks").append("\n");
                        switch (validationTypes.indexOf(thisType.toUpperCase())) {
                            case 0: {
                                jsString.append(pad).append("if (!_CF_checkBoolean(_CF_this['").append(item.getName()).append("'].value, ").append(required).append("))\n");
                                break;
                            }
                            case 1: {
                                jsString.append(pad).append("if (!_CF_checkcreditcard(_CF_this['").append(item.getName()).append("'].value, ").append(required).append("))\n");
                                break;
                            }
                            case 2: 
                            case 22: {
                                jsString.append(pad).append("if (!_CF_checkdate(_CF_this['").append(item.getName()).append("'].value, ").append(required).append("))\n");
                                break;
                            }
                            case 3: {
                                jsString.append(pad).append("if (!_CF_checkEmail(_CF_this['").append(item.getName()).append("'].value, ").append(required).append("))\n");
                                break;
                            }
                            case 4: {
                                jsString.append(pad).append("if (!_CF_checkeurodate(_CF_this['").append(item.getName()).append("'].value, ").append(required).append("))\n");
                                break;
                            }
                            case 5: {
                                jsString.append(pad).append("if (!_CF_checknumber(_CF_this['").append(item.getName()).append("'].value, ").append(required).append(",").append(strictNumberValidation).append("))\n");
                                break;
                            }
                            case 6: {
                                jsString.append(pad).append("if (!_CF_checkGUID(_CF_this['").append(item.getName()).append("'].value, ").append(required).append("))\n");
                                break;
                            }
                            case 7: {
                                jsString.append(pad).append("if (!_CF_checkinteger(_CF_this['").append(item.getName()).append("'].value, ").append(required).append(",").append(strictNumberValidation).append("))\n");
                                break;
                            }
                            case 21: {
                                jsString.append(pad).append("if( _CF_this['").append(item.getName()).append("'].value.length > ").append(item.getMaxLength()).append(" )\n");
                                break;
                            }
                            case 9: {
                                jsString.append(pad).append("if (!_CF_checknumber(_CF_this['").append(item.getName()).append("'].value, ").append(required).append(",").append(strictNumberValidation).append("))\n");
                                break;
                            }
                            case 10: {
                                String min = item.getMin() == null ? "null" : String.valueOf(item.getMin().toString());
                                String max = item.getMax() == null ? "null" : String.valueOf(item.getMax().toString());
                                jsString.append(pad).append("if  (!_CF_checkrange(_CF_this['").append(item.getName()).append("'].value, ").append(min).append(",").append(max).append(", ").append(required).append("))\n");
                                break;
                            }
                            case 11: 
                            case 20: {
                                jsString.append(pad).append("if (!_CF_checkregex(_CF_this['").append(item.getName()).append("'].value, /").append(item.getPattern()).append("/, ").append(required).append("))\n");
                                break;
                            }
                            case 13: 
                            case 14: {
                                jsString.append(pad).append("if (!_CF_checkssn(_CF_this['").append(item.getName()).append("'].value, ").append(required).append("))\n");
                                break;
                            }
                            case 15: {
                                jsString.append(pad).append("if (!_CF_checkphone(_CF_this['").append(item.getName()).append("'].value, ").append(required).append("))\n");
                                break;
                            }
                            case 16: {
                                jsString.append(pad).append("if (!_CF_checktime(_CF_this['").append(item.getName()).append("'].value, ").append(required).append("))\n");
                                break;
                            }
                            case 17: {
                                jsString.append(pad).append("if (!_CF_checkURL(_CF_this['").append(item.getName()).append("'].value, ").append(required).append("))\n");
                                break;
                            }
                            case 18: {
                                jsString.append(pad).append("if (!_CF_checkUUID(_CF_this['").append(item.getName()).append("'].value, ").append(required).append("))\n");
                                break;
                            }
                            case 19: {
                                jsString.append(pad).append("if (!_CF_checkzip(_CF_this['").append(item.getName()).append("'].value, ").append(required).append("))\n");
                            }
                        }
                        jsString.append(pad).append("{\n");
                        jsString.append(pad).append("    ").append(item.getOnError()).append("(_CF_this, \"").append(item.getName()).append("\", _CF_this['").append(item.getName()).append("'].value, \"").append(item.getMessage()).append("\");\n");
                        jsString.append(pad).append("    _CF_error_exists = true;\n");
                        jsString.append(pad).append("}\n\n");
                    }
                    if (item.getOnValidate() != null) {
                        jsString.append(pad).append("//form element ").append(item.getName()).append("  custom validation check").append("\n");
                        jsString.append(pad).append("if (!").append(item.getOnValidate()).append("(_CF_this, _CF_this['").append(item.getName()).append("'], _CF_this['").append(item.getName()).append("'].value))\n");
                        jsString.append(pad).append("{\n");
                        jsString.append(pad).append("    ").append(item.getOnError()).append("(_CF_this, \"").append(item.getName()).append("\", _CF_this['").append(item.getName()).append("'].value, \"").append(item.getMessage()).append("\");\n");
                        jsString.append(pad).append("    _CF_error_exists = true;\n");
                        jsString.append(pad).append("}\n\n");
                    }
                    pad = "        ";
                    if (!(item instanceof FormField) || !item.getValidateAt_onSubmit() || !item.getRequired() || (validateTypes == null || validateTypes.size() <= 0) && item.getOnValidate() == null || (validateTypes.indexOf("NOBLANKS") == -1 || validateTypes.size() <= 1) && validateTypes.indexOf("NOBLANKS") != -1) break block30;
                    jsString.append(pad).append("}else {\n");
                    jsString.append(pad).append("    ").append(item.getOnError()).append("(_CF_this, \"").append(item.getName()).append("\", _CF_this['").append(item.getName()).append("'].value, \"").append(item.getMessage()).append("\");\n");
                    jsString.append(pad).append("    _CF_error_exists = true;\n");
                    jsString.append(pad).append("}\n\n");
                    break block31;
                }
                if (!(item instanceof FormField) || !item.getValidateAt_onSubmit() || !item.getRequired()) break block31;
                jsString.append(pad).append("//form element ").append(item.getName()).append(" required check").append("\n");
                if (validateTypes != null && validateTypes.indexOf("NOBLANKS") != -1) {
                    jsString.append(pad).append("if( !_CF_hasValue(_CF_this['").append(item.getName()).append("'], \"").append(item.getType()).append("\", true ) )\n");
                } else {
                    jsString.append(pad).append("if( !_CF_hasValue(_CF_this['").append(item.getName()).append("'], \"").append(item.getType()).append("\", false ) )\n");
                }
                jsString.append(pad).append("{\n");
                jsString.append(pad).append("    ").append(item.getOnError()).append("(_CF_this, \"").append(item.getName()).append("\", _CF_this['").append(item.getName()).append("'].value, \"").append(item.getMessage()).append("\");\n");
                jsString.append(pad).append("    _CF_error_exists = true;\n");
                jsString.append(pad).append("}\n\n");
                break block31;
            }
            if (thisForm instanceof FormParent) {
                for (int i = 0; i < ((FormParent)thisForm).getChildren().size(); ++i) {
                    this.generateJSValidation(jsString, ((FormParent)thisForm).getChildren().get(i));
                }
            }
        }
    }

    protected static String getOnBlur(FormChildTag obj, Array types, String message, String pattern, String min, String max, String maxlength, boolean required) {
        StringBuffer sb = new StringBuffer();
        types.remove("SUBMITONCE");
        if (types.size() > 0 || obj.required) {
            sb.append("if( ");
            if (obj.required) {
                sb.append("!_CF_hasValue(this, '").append(obj.getType().toUpperCase()).append("', ").append(types.indexOf("NOBLANKS") != -1 ? "true" : "false").append(")");
                if (types.size() > 0) {
                    sb.append(" && ");
                }
            }
            for (int i = 0; i < types.size(); ++i) {
                boolean success = true;
                switch (validationTypes.indexOf(((String)types.get(i)).toUpperCase())) {
                    case 0: {
                        sb.append("!_CF_checkBoolean(this.value, ").append(required).append(")");
                        break;
                    }
                    case 1: {
                        sb.append("!_CF_checkcreditcard(this.value, ").append(required).append(")");
                        break;
                    }
                    case 2: 
                    case 22: {
                        sb.append("!_CF_checkdate(this.value, ").append(required).append(")");
                        break;
                    }
                    case 3: {
                        sb.append("!_CF_checkEmail(this.value, ").append(required).append(")");
                        break;
                    }
                    case 4: {
                        sb.append("!_CF_checkeurodate(this.value, ").append(required).append(")");
                        break;
                    }
                    case 5: {
                        sb.append("!_CF_checknumber(this.value, ").append(required).append(")");
                        break;
                    }
                    case 6: {
                        sb.append("!_CF_checkGUID(this.value, ").append(required).append(")");
                        break;
                    }
                    case 7: {
                        sb.append("!_CF_checkinteger(this.value, ").append(required).append(")");
                        break;
                    }
                    case 21: {
                        sb.append("( this.value.length > ").append(maxlength).append(")");
                        break;
                    }
                    case 8: {
                        sb.append(" true ");
                        break;
                    }
                    case 9: {
                        sb.append("!_CF_checknumber(this.value, ").append(required).append(")");
                        break;
                    }
                    case 10: {
                        if (min != null || max != null) {
                            sb.append("!_CF_checkrange(this.value,").append(min).append(",").append(max).append(", ").append(required).append(")");
                            break;
                        }
                        success = false;
                        break;
                    }
                    case 11: 
                    case 20: {
                        if (pattern != null) {
                            sb.append("!_CF_checkregex(this.value,").append("/").append(pattern).append("/, ").append(required).append(")");
                            break;
                        }
                        success = false;
                        break;
                    }
                    case 13: 
                    case 14: {
                        sb.append("!_CF_checkssn(this.value, ").append(required).append(")");
                        break;
                    }
                    case 15: {
                        sb.append("!_CF_checkphone(this.value, ").append(required).append(")");
                        break;
                    }
                    case 16: {
                        sb.append("!_CF_checktime(this.value, ").append(required).append(")");
                        break;
                    }
                    case 17: {
                        sb.append("!_CF_checkURL(this.value, ").append(required).append(")");
                        break;
                    }
                    case 18: {
                        sb.append("!_CF_checkUUID(this.value, ").append(required).append(")");
                        break;
                    }
                    case 19: {
                        sb.append("!_CF_checkzip(this.value, ").append(required).append(")");
                    }
                }
                if (!success || i >= types.size() - 1) continue;
                sb.append(" || ");
            }
            sb.append(" ){ _CF_onErrorAlert(new Array('").append(message).append("')); }");
        }
        return sb.toString();
    }

    private static StringBuffer escapeActiveContent(StringBuffer txt) {
        for (int i = 0; i < txt.length(); ++i) {
            char c = txt.charAt(i);
            if (c == '\'' || c == '\\') {
                txt.insert(i, '\\');
                ++i;
            }
            if (c == '\n') {
                txt.insert(i, '\\');
                txt.setCharAt(i + 1, 'n');
                ++i;
            }
            if (c == '\t') {
                txt.insert(i, '\\');
                txt.setCharAt(i + 1, 't');
                ++i;
            }
            if (c == '\f') {
                txt.insert(i, '\\');
                txt.setCharAt(i + 1, 'f');
                ++i;
            }
            if (c != '\r') continue;
            txt.insert(i, '\\');
            txt.setCharAt(i + 1, 'r');
            ++i;
        }
        return txt;
    }

    public static String getScriptSrc() {
        Object temp = ((RuntimeServiceImpl)ServiceFactory.getRuntimeService()).getCFFormScriptSrc();
        if (temp == null || ((String)temp).trim().length() == 0) {
            HttpServletRequest req;
            String contextRoot = "";
            if (FusionContext.getCurrent() != null && (req = FusionContext.getCurrent().getRequest()) != null) {
                contextRoot = req.getContextPath();
            }
            temp = contextRoot + "/cf_scripts/scripts/";
        } else if (!((String)temp).endsWith("/")) {
            temp = (String)temp + "/";
        }
        return temp;
    }

    public static String wrapActiveContent(String t, String parentForm_scriptSrc) {
        Object scriptSrc = parentForm_scriptSrc;
        if (scriptSrc == null || ((String)scriptSrc).length() == 0) {
            scriptSrc = JavascriptHelper.getScriptSrc();
        }
        if (((String)scriptSrc).charAt(((String)scriptSrc).length() - 1) != '/') {
            scriptSrc = (String)scriptSrc + "/";
        }
        return "<script type=\"text/javascript\" charset='utf-8' src='" + (String)scriptSrc + "CF_RunActiveContent.js' " + Utils.getCSPNonceString() + "></script>\n<script type=\"text/javascript\" charset='utf-8'>\nCF_RunContent('" + JavascriptHelper.escapeActiveContent(new StringBuffer(t)) + "');\n</script>\n";
    }

    static {
        validationTypes.add(0, "BOOLEAN");
        validationTypes.add(1, "CREDITCARD");
        validationTypes.add(2, "DATE");
        validationTypes.add(3, "EMAIL");
        validationTypes.add(4, "EURODATE");
        validationTypes.add(5, "FLOAT");
        validationTypes.add(6, "GUID");
        validationTypes.add(7, "INTEGER");
        validationTypes.add(8, "NOBLANKS");
        validationTypes.add(9, "NUMERIC");
        validationTypes.add(10, "RANGE");
        validationTypes.add(11, "REGEX");
        validationTypes.add(12, "REQUIRED");
        validationTypes.add(13, "SOCIAL_SECURITY_NUMBER");
        validationTypes.add(14, "SSN");
        validationTypes.add(15, "TELEPHONE");
        validationTypes.add(16, "TIME");
        validationTypes.add(17, "URL");
        validationTypes.add(18, "UUID");
        validationTypes.add(19, "ZIPCODE");
        validationTypes.add(20, "REGULAR_EXPRESSION");
        validationTypes.add(21, "MAXLENGTH");
        validationTypes.add(22, "USDATE");
        validationTypes.add(23, "SUBMITONCE");
    }
}

