/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.form;

import coldfusion.compiler.validation.TagValidationException;
import coldfusion.runtime.ArrayUtil;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.server.felix.FelixUtil;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.html.ajax.AjaxSliderHelper;
import coldfusion.tagext.html.ajax.HtmlAssembler;
import coldfusion.tagext.html.form.FormParent;
import coldfusion.tagext.html.form.FormTag;
import coldfusion.tagext.validation.IllegalRangeException;
import jakarta.servlet.jsp.JspException;
import java.io.IOException;
import java.util.List;

public class SliderTag
extends GenericTag {
    protected int MINIMUM_WIDTH = 50;
    protected int MAXIMUM_WIDTH = 100;
    protected Double min;
    protected Double max;
    protected String name;
    protected String value = "";
    protected String width;
    protected String height;
    protected String validate = "";
    protected String onError = "_CF_onError";
    protected FormParent _parent;
    protected FormTag _parentFormTag;
    private static final String DEFAULT_FORMAT = "html";
    protected String labelPrefix = "";
    protected String labelSuffix = "";
    protected Double scale = this.min;
    protected boolean vertical = false;
    protected String body;
    protected String format = "html";
    protected String onChange;
    protected String onDrag;
    private boolean clickToChange = false;
    private String increment;
    private boolean tip = true;
    protected String range = "";
    protected AjaxSliderHelper ajaxSliderHelper;

    public SliderTag() {
        this.setMin(new Double("0"));
        this.setMax(new Double("100"));
    }

    public void setDefValue() {
        this.value = Cast._String(this.min);
    }

    public void setName(String s) {
        this.name = s.trim();
    }

    public String getFormat() {
        return this.format;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setFormat(String format) {
        this.format = format = format.trim();
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String s) {
        this.value = s;
    }

    public void setOnerror(String s) {
        this.onError = s;
    }

    public void setOnChange(String s) {
        this.onChange = s;
    }

    public String getOnChange() {
        return this.onChange;
    }

    public void setOnDrag(String s) {
        this.onDrag = s;
    }

    public String getOnDrag() {
        return this.onDrag;
    }

    public void setMax(double m) {
        this.max = m;
    }

    public void setMin(double m) {
        this.min = m;
    }

    public boolean getClickToChange() {
        return this.clickToChange;
    }

    public String getIncrement() {
        return this.increment;
    }

    public void setIncrement(String inc) {
        this.increment = inc;
    }

    public boolean getTip() {
        return this.tip;
    }

    public void setTip(boolean tip) {
        this.tip = tip;
    }

    public void setScale(double i) {
        this.scale = i;
    }

    public void setHeight(String h) {
        this.height = h;
    }

    public void setWidth(String w) {
        this.width = w;
    }

    public void setVertical(boolean b) {
        this.vertical = b;
    }

    public String getRange() {
        return this.range;
    }

    public void setRange(String range) {
        this.range = range;
    }

    public Double getMin() {
        return this.min;
    }

    public Double getMax() {
        return this.max;
    }

    public String getHeight() {
        return this.height;
    }

    public String getValue() {
        return this.value;
    }

    public String getWidth() {
        return this.width;
    }

    public String getValidate() {
        return this.validate;
    }

    public void setValidate(String validate) {
        this.validate = validate;
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        FelixUtil.checkAjaxEnabled();
        if (this.format.equalsIgnoreCase(DEFAULT_FORMAT)) {
            if (this.range != null && this.range.length() > 0) {
                this.parseRange();
            }
            this.ajaxSliderHelper = new AjaxSliderHelper(this, this.pageContext);
            HtmlAssembler htmlAssembler = HtmlAssembler.getInstance(this.pageContext, true);
            this.ajaxSliderHelper = new AjaxSliderHelper(this, this.pageContext);
            htmlAssembler.newLine();
            if (this.vertical) {
                if (this.width != null) {
                    throw new InvalidVerticalAttribException("Width", this.isVertical());
                }
                this.setWidth(String.valueOf(20));
                if (this.height != null) {
                    this.height = this.height.trim();
                    ptIndex = this.height.indexOf("pt");
                    int pxIndex = this.height.indexOf("px");
                    if (ptIndex > 0 || pxIndex > 0) {
                        this.height = this.height.substring(0, this.height.length() - 2);
                    }
                    int h = 0;
                    try {
                        h = Integer.parseInt(this.height);
                    }
                    catch (NumberFormatException e) {
                        throw new InvalidSliderSizeException("HEIGHT");
                    }
                    if (h <= 0) {
                        throw new InvalidSliderSizeException("HEIGHT");
                    }
                }
            } else {
                if (this.height != null) {
                    throw new InvalidVerticalAttribException("Height", this.isVertical());
                }
                this.setHeight(String.valueOf(20));
                if (this.width != null) {
                    this.width = this.width.trim();
                    ptIndex = this.width.indexOf("pt");
                    int pxIndex = this.width.indexOf("px");
                    if (ptIndex > 0 || pxIndex > 0) {
                        this.width = this.width.substring(0, this.width.length() - 2);
                    }
                    int w = 0;
                    try {
                        w = Integer.parseInt(this.width);
                    }
                    catch (NumberFormatException e) {
                        throw new InvalidSliderSizeException("WIDTH");
                    }
                    if (w <= 0) {
                        throw new InvalidSliderSizeException("WIDTH");
                    }
                }
            }
            htmlAssembler.openDivTag(this.ajaxSliderHelper.getDivId(), null, this.ajaxSliderHelper.getStyle());
            htmlAssembler.closeDivTag();
            try {
                htmlAssembler.writeHtml(this.out);
            }
            catch (IOException ioEx) {
                throw new JspException((Throwable)ioEx);
            }
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        if (this.ajaxSliderHelper != null) {
            try {
                this.ajaxSliderHelper.generate(this.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.onTagEnd();
        return 6;
    }

    public void parseRange() {
        String rangeStr = CFPage.ReplaceList(this.range, "(,)", " , ");
        int sep = this.range.lastIndexOf(",");
        try {
            if (sep == -1) {
                this.min = new Double(rangeStr.trim());
            } else if (sep == 0) {
                this.max = new Double(this.range.substring(sep + 1, this.range.length()).trim());
            } else if (sep + 1 == this.range.length()) {
                this.min = new Double(this.range.substring(0, sep).trim());
            } else {
                this.min = new Double(this.range.substring(0, sep).trim());
                this.max = new Double(this.range.substring(sep + 1, this.range.length()).trim());
            }
        }
        catch (Exception ex) {
            throw new IllegalRangeException(this.range, "Range", "CFInput");
        }
    }

    @Override
    public void release() {
        super.release();
        this.min = 0.0;
        this.max = 0.0;
        this.name = null;
        this.value = "";
        this.width = null;
        this.height = null;
        this.validate = "";
        this.labelPrefix = "";
        this.labelSuffix = "";
        this.scale = this.min;
        this.vertical = false;
        this.body = null;
        this.onChange = null;
        this.onDrag = null;
        this.clickToChange = false;
        this.increment = "0";
        this.tip = true;
        this.range = "";
    }

    public class InvalidVerticalAttribException
    extends TagValidationException {
        public String attribName;
        public boolean vv;

        public InvalidVerticalAttribException(String attributeName, boolean vertval) {
            this.attribName = attributeName;
            this.vv = vertval;
        }
    }

    public class InvalidSliderSizeException
    extends TagValidationException {
        public String attribName;

        public InvalidSliderSizeException(String attributeName) {
            this.attribName = attributeName;
        }
    }

    public class InvalidHtmlSliderAttributeException
    extends TagValidationException {
        public String allowed;
        public String notAllowed;

        public InvalidHtmlSliderAttributeException(List allowed, List notAllowed) {
            this.notAllowed = ArrayUtil.ArrayToList(notAllowed, ",").toLowerCase();
            this.allowed = ArrayUtil.ArrayToList(allowed, ",").toLowerCase();
        }
    }
}

