/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.io;

import coldfusion.sql.QueryTable;
import coldfusion.sql.QueryTableMetaData;
import coldfusion.tagext.io.DirFileUtils;
import java.io.File;
import java.nio.file.Files;
import java.util.Date;

public class FileListTable
extends QueryTable {
    private String dirPath;
    private boolean recurse;

    public FileListTable(String dirPath, boolean recurse) {
        this.recurse = recurse;
        char lastChar = ((String)dirPath).charAt(((String)dirPath).length() - 1);
        if (lastChar != File.separatorChar && lastChar != '/') {
            dirPath = (String)dirPath + "/";
        }
        this.dirPath = dirPath;
    }

    public void populate(File[] files, boolean listNamesOnly, int filetype) {
        this.meta = new FileListMetaData(listNamesOnly);
        this.col_count = this.meta.getColumnCount();
        this.col_names = this.meta.getColumnLabels();
        if (files == null) {
            this.row_count = 0;
            return;
        }
        int numCol = listNamesOnly ? 1 : 8;
        this.ensureCapacity(files.length);
        for (int i = 0; i < files.length; ++i) {
            if (filetype != 0 && (filetype == 1 && !files[i].isDirectory() || filetype == 2 && !files[i].isFile())) continue;
            Object[] col_data = new Object[numCol];
            if (listNamesOnly) {
                col_data[0] = this.recurse ? this.getRelativePath(files[i]) : files[i].getName();
            } else {
                col_data[0] = files[i].getName();
                col_data[1] = new Long(files[i].length());
                col_data[2] = files[i].isDirectory() ? "Dir" : "File";
                long date = files[i].lastModified();
                col_data[3] = date > 0L ? new Date(date) : "";
                col_data[4] = DirFileUtils.getFileAttribString(files[i]);
                col_data[5] = "";
                col_data[6] = files[i].getParent();
                col_data[7] = Files.isSymbolicLink(files[i].toPath());
            }
            this.addRow(col_data);
        }
    }

    private String getRelativePath(File file) {
        String path = file.getAbsolutePath();
        return path.substring(this.dirPath.length()).replace('\\', '/');
    }

    private static class FileListMetaData
    extends QueryTableMetaData {
        protected FileListMetaData(boolean listNamesOnly) {
            this.column_count = listNamesOnly ? 1 : 8;
            this.column_label = new String[this.column_count];
            this.column_label[0] = "Name";
            if (!listNamesOnly) {
                this.column_label[1] = "Size";
                this.column_label[2] = "Type";
                this.column_label[3] = "DateLastModified";
                this.column_label[4] = "Attributes";
                this.column_label[5] = "Mode";
                this.column_label[6] = "Directory";
                this.column_label[7] = "Link";
            }
            this.column_type = new int[this.column_count];
            this.column_type[0] = 12;
            if (!listNamesOnly) {
                this.column_type[1] = -5;
                this.column_type[2] = 12;
                this.column_type[3] = 91;
                this.column_type[4] = 12;
                this.column_type[5] = 12;
                this.column_type[6] = 12;
                this.column_type[7] = 12;
            }
            this.column_case = new boolean[this.column_count];
            for (int i = 0; i < this.column_count; ++i) {
                this.column_case[i] = false;
            }
            this.column_type_names = new String[this.column_count];
            this.column_type_names[0] = "VARCHAR";
            if (!listNamesOnly) {
                this.column_type_names[1] = "BIGINT";
                this.column_type_names[2] = "VARCHAR";
                this.column_type_names[3] = "DATE";
                this.column_type_names[4] = "VARCHAR";
                this.column_type_names[5] = "VARCHAR";
                this.column_type_names[6] = "VARCHAR";
                this.column_type_names[7] = "VARCHAR";
            }
        }

        @Override
        public boolean isCaseSensitive(int column) {
            return false;
        }
    }
}

