/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.io;

import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Cast;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.Struct;
import coldfusion.tagext.io.FileUtils;
import coldfusion.util.CFDumpable;
import coldfusion.vfs.VFSFileFactory;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Date;

public class FileStreamWrapper
implements CFDumpable {
    private static final int DEFAULT_BUFF_SIZE = 2048;
    public static final String READ = "read";
    public static final String READ_BINARY = "readbinary";
    public static final String WRITE = "write";
    public static final String APPEND = "append";
    public static final String READ_WRITE = "readwrite";
    private File file;
    private String mode;
    private String charset;
    private BufferedReader reader;
    private InputStream inputStream;
    private OutputStream outputStream;
    private RandomAccessFile raf;
    private char[] charBuf;
    private byte[] byteBuf;
    private boolean closed;
    private boolean seekable;

    public FileStreamWrapper(String file, String mode, String charset, boolean seekable) {
        this(VFSFileFactory.getFileObject(file), mode, charset, seekable);
    }

    public FileStreamWrapper(File file, String mode, String charset, boolean seekable) {
        block14: {
            this.file = file;
            if (charset == null || charset.length() == 0) {
                charset = FileUtils.DEFAULT_CHARSET;
            }
            this.charset = charset;
            this.mode = mode = mode.trim().toLowerCase();
            this.seekable = seekable;
            this.validate();
            try {
                if (seekable) {
                    if (mode.equals(READ) || mode.equals(READ_BINARY)) {
                        this.raf = new RandomAccessFile(file, "r");
                    } else if (mode.equals(WRITE) || mode.equals(READ_WRITE)) {
                        this.raf = new RandomAccessFile(file, "rw");
                    } else if (mode.equals(APPEND)) {
                        this.raf = new RandomAccessFile(file, "rw");
                        this.raf.seek(file.length());
                    } else {
                        throw new InvalidModeException(mode, true);
                    }
                    this.byteBuf = new byte[2048];
                    break block14;
                }
                if (mode.equals(READ)) {
                    this.reader = new BufferedReader(new InputStreamReader(VFSFileFactory.getInputStream(file.getPath()), charset));
                    this.charBuf = new char[2048];
                    break block14;
                }
                if (mode.equals(READ_BINARY)) {
                    this.inputStream = new BufferedInputStream(VFSFileFactory.getInputStream(file.getPath()));
                    this.byteBuf = new byte[2048];
                    break block14;
                }
                if (mode.equals(WRITE)) {
                    this.outputStream = VFSFileFactory.getOutputStream(file.getPath());
                    break block14;
                }
                if (mode.equals(APPEND)) {
                    this.outputStream = VFSFileFactory.getOutputStream(file.getPath(), true);
                    break block14;
                }
                throw new InvalidModeException(mode, false);
            }
            catch (IOException e) {
                throw new GeneralIOException("fileopen", e);
            }
        }
    }

    private void validate() {
        if (this.mode.equals(READ) || this.mode.equals(READ_BINARY)) {
            if (!this.file.exists()) {
                throw new FileUtils.FileNotFoundException(this.file.getAbsolutePath());
            }
            if (this.file.isDirectory() || !this.file.canRead()) {
                throw new FileUtils.InvalidFileException(this.file.getAbsolutePath());
            }
        } else if (this.mode.equals(WRITE) || this.mode.equals(APPEND)) {
            File parent = this.file.getParentFile();
            if (parent != null && !parent.exists()) {
                throw new FileUtils.FileNotFoundException(parent.getAbsolutePath());
            }
            if (!this.file.canWrite() && this.file.exists()) {
                throw new FileUtils.InvalidFileException(this.file.getAbsolutePath());
            }
        }
    }

    public String readLine() {
        if (!this.seekable && !this.mode.equals(READ)) {
            throw new InvalidFileOperationException("readline", this.mode);
        }
        this.ensureOpen();
        try {
            String line;
            String string = line = this.raf == null ? this.reader.readLine() : this.raf.readLine();
            if (line == null) {
                throw new FileUtils.EndOfFileException();
            }
            return line;
        }
        catch (IOException e) {
            throw new GeneralIOException("readline", e);
        }
    }

    public Object read(int size) {
        if (size <= 0) {
            throw new IllegalBufferSizeException(size);
        }
        if (this.mode.equals(READ)) {
            return this.readChars(size);
        }
        if (this.mode.equals(READ_BINARY) || this.mode.equals(READ_WRITE)) {
            return this.readBytes(size);
        }
        throw new InvalidFileOperationException(READ, this.mode);
    }

    private String readChars(int size) {
        this.ensureOpen();
        try {
            if (this.reader != null) {
                char[] buff = size <= 2048 ? this.charBuf : new char[size];
                int read = this.reader.read(buff, 0, size);
                if (read == -1) {
                    throw new FileUtils.EndOfFileException();
                }
                return new String(buff, 0, read);
            }
            if (this.raf != null) {
                byte[] buff = size <= 2048 ? this.byteBuf : new byte[size];
                int read = this.raf.read(buff, 0, size);
                if (read == -1) {
                    throw new FileUtils.EndOfFileException();
                }
                return new String(buff, 0, read, this.charset);
            }
            throw new IllegalStateException();
        }
        catch (IOException e) {
            throw new GeneralIOException(READ, e);
        }
    }

    private byte[] readBytes(int size) {
        this.ensureOpen();
        byte[] buff = size <= 2048 ? this.byteBuf : new byte[size];
        try {
            int read;
            int n = read = this.raf == null ? this.inputStream.read(buff, 0, size) : this.raf.read(buff, 0, size);
            if (read == -1) {
                throw new FileUtils.EndOfFileException();
            }
            byte[] returnBytes = new byte[read];
            System.arraycopy(buff, 0, returnBytes, 0, read);
            return returnBytes;
        }
        catch (IOException e) {
            throw new GeneralIOException(READ, e);
        }
    }

    public boolean isEndOfFile() {
        this.ensureOpen();
        try {
            if (this.raf != null && (this.mode.equals(READ) || this.mode.equals(READ_BINARY) || this.mode.equals(READ_WRITE))) {
                long filePointer = this.raf.getFilePointer();
                if (this.raf.read() == -1) {
                    return true;
                }
                this.raf.seek(filePointer);
            } else if (this.mode.equals(READ)) {
                this.reader.mark(1024);
                int read = this.reader.read();
                if (read == -1) {
                    return true;
                }
                this.reader.reset();
            } else if (this.mode.equals(READ_BINARY)) {
                this.inputStream.mark(1024);
                int read = this.inputStream.read();
                if (read == -1) {
                    return true;
                }
                this.inputStream.reset();
            }
        }
        catch (IOException e) {
            throw new GeneralIOException("isEndOfFile", e);
        }
        return false;
    }

    public void write(Object content) {
        if (!(this.mode.equals(WRITE) || this.mode.equals(APPEND) || this.mode.equals(READ_WRITE))) {
            throw new InvalidFileOperationException(WRITE, this.mode);
        }
        this.ensureOpen();
        try {
            byte[] bytes = content instanceof byte[] ? (byte[])content : Cast._String(content).getBytes(this.charset);
            if (this.raf != null) {
                this.raf.write(bytes, 0, bytes.length);
            } else {
                this.outputStream.write(bytes, 0, bytes.length);
            }
        }
        catch (IOException e) {
            throw new GeneralIOException(WRITE, e);
        }
    }

    public void seek(long pos) {
        this.ensureOpen();
        if (this.raf == null) {
            throw new InvalidFileOperationException("seek", null);
        }
        try {
            this.raf.seek(pos);
        }
        catch (IOException e) {
            throw new GeneralIOException("seek", e);
        }
    }

    public void skip(int n) {
        this.ensureOpen();
        if (this.raf == null) {
            throw new InvalidFileOperationException("skip", null);
        }
        try {
            this.raf.skipBytes(n);
        }
        catch (IOException e) {
            throw new GeneralIOException("skip", e);
        }
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new FileClosedException();
        }
    }

    public void close() {
        try {
            if (this.raf != null) {
                this.raf.close();
            } else if (this.mode.equals(READ)) {
                this.reader.close();
            } else if (this.mode.equals(READ_BINARY)) {
                this.inputStream.close();
            } else {
                this.outputStream.close();
            }
        }
        catch (IOException e) {
            throw new GeneralIOException("close", e);
        }
        this.closed = true;
    }

    @Override
    public String getLabel() {
        return "File : " + this.file.getName();
    }

    @Override
    public Object getMetadata() {
        Struct map = new Struct();
        map.put("name", (Object)this.file.getName());
        map.put("path", (Object)this.file.getAbsolutePath());
        map.put("size", (Object)String.valueOf(this.getSize()));
        map.put("lastmodified", (Object)this.getLastmodified());
        map.put("mode", (Object)this.mode);
        map.put("status", (Object)this.getStatus());
        return map;
    }

    public long getSize() {
        try {
            if (this.raf != null) {
                return this.raf.length();
            }
            if (this.outputStream != null && !this.closed && this.outputStream instanceof FileOutputStream) {
                ((FileOutputStream)this.outputStream).getFD().sync();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.file.length();
    }

    public Date getLastmodified() {
        return new OleDateTime(this.file.lastModified());
    }

    public String getFilename() {
        return this.file.getName();
    }

    public String getFilepath() {
        return this.file.getAbsolutePath();
    }

    public String getMode() {
        return this.mode;
    }

    public String getStatus() {
        return this.closed ? "closed" : "open";
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.closed) {
                this.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    public static class InvalidModeException
    extends ApplicationException {
        public String mode;
        private boolean seekable;

        public InvalidModeException(String mode, boolean random) {
            this.mode = mode;
            this.seekable = random;
        }

        @Override
        public String getDetail() {
            if (this.detail == null) {
                this.detail = this.seekable ? InvalidModeException.getString(this, "detailRAF", this.locale) : InvalidModeException.getString(this, "detail", this.locale);
            }
            return this.detail;
        }
    }

    public static class GeneralIOException
    extends ApplicationException {
        public String operation;

        public GeneralIOException(String operation, IOException th) {
            super(th);
            this.operation = operation;
        }
    }

    public static class InvalidFileOperationException
    extends ApplicationException {
        public String operation;
        public String mode;

        public InvalidFileOperationException(String operation, String mode) {
            this.operation = operation;
            this.mode = mode;
        }

        @Override
        public String getMessage() {
            if (this.msg == null) {
                this.msg = this.mode != null ? InvalidFileOperationException.getString(this, "message", this.locale) : InvalidFileOperationException.getString(this, "messageSeekable", this.locale);
            }
            return this.msg;
        }
    }

    public static class IllegalBufferSizeException
    extends ApplicationException {
        public int size;

        public IllegalBufferSizeException(int size) {
            this.size = size;
        }
    }

    public static class FileClosedException
    extends ApplicationException {
    }
}

