/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.io;

import coldfusion.log.CFLogs;
import coldfusion.monitor.beans.TagAttribute;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Array;
import coldfusion.runtime.Cast;
import coldfusion.runtime.LocalScope;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.RequestMonitor;
import coldfusion.runtime.RequestTimedOutException;
import coldfusion.runtime.Struct;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.InvalidTagAttributeException;
import coldfusion.tagext.io.DirFileUtils;
import coldfusion.tagext.io.FileUtils;
import coldfusion.util.RuntimeWrapper;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import coldfusion.vfs.VFile;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.BodyTag;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class FileTag
extends GenericTag
implements BodyTag {
    private static final GenericTagPermission tp = new GenericTagPermission("cffile");
    protected static final int DEF_MODE = -1;
    protected String action;
    protected String accept = "";
    protected String allowedExtensions = null;
    protected String block = "";
    protected String destination;
    protected String filefield;
    protected String nameconflict = "Error";
    protected int mode = -1;
    protected String attributes;
    protected String source;
    protected String file;
    protected String variable;
    protected Object output;
    protected boolean addnewline = true;
    protected boolean fixnewline = false;
    protected boolean strict = true;
    protected String charset;
    protected String result = null;
    private String content = null;
    private boolean modePresent = false;
    private String errors = null;
    private boolean continueOnError = false;
    public static final String UPLOADALL_RESULTS_KEY = "UPLOADALLRESULTS";
    public static final String UPLOADALL_ERRORS_KEY = "UPLOADALLERRORS";

    @Override
    protected Permission getPermission() {
        return tp;
    }

    public void setAction(String o) {
        this.action = o;
    }

    public void setBlock(String o) {
        this.block = o;
    }

    public String getAllowedExtensions() {
        return this.allowedExtensions;
    }

    public void setAllowedExtensions(String allowedExtensions) {
        this.allowedExtensions = allowedExtensions;
    }

    public void setCharset(String o) {
        this.charset = o;
    }

    public void setAccept(String o) {
        this.accept = o;
    }

    public void setDestination(String o) {
        this.destination = o;
    }

    public void setFilefield(String o) {
        this.filefield = o;
    }

    public void setNameconflict(String o) {
        this.nameconflict = o;
    }

    public void setMode(int o) {
        this.modePresent = true;
        this.mode = o;
    }

    public void setAttributes(String o) {
        this.attributes = o;
    }

    public void setSource(String o) {
        this.source = Utils.getFileFullPath(o, this.pageContext);
    }

    public void setFile(String o) {
        this.file = Utils.getFileFullPath(o, this.pageContext);
    }

    public void setVariable(String o) {
        this.variable = o;
    }

    public void setOutput(Object o) {
        this.output = o;
    }

    public void setAddnewline(boolean o) {
        this.addnewline = o;
    }

    public void setStrict(boolean o) {
        this.strict = o;
    }

    public void setResult(String s) {
        this.result = s;
    }

    public boolean isFixnewline() {
        return this.fixnewline;
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public String getErrors() {
        return this.errors;
    }

    public void setErrors(String errors) {
        this.errors = errors;
    }

    public void setFixnewline(boolean fixnewline) {
        this.fixnewline = fixnewline;
    }

    @Override
    public void release() {
        this.action = null;
        this.accept = "";
        this.destination = null;
        this.filefield = null;
        this.nameconflict = "Error";
        this.mode = -1;
        this.attributes = null;
        this.source = null;
        this.file = null;
        this.variable = null;
        this.output = null;
        this.addnewline = true;
        this.strict = true;
        this.charset = null;
        this.result = null;
        this.continueOnError = false;
        this.errors = null;
        this.fixnewline = false;
        this.allowedExtensions = null;
        super.release();
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        if ("Upload".equalsIgnoreCase(this.action)) {
            this.validateAttributes(this.filefield);
            Array errorsArray = new Array();
            boolean populateErrorsAttribte = false;
            if (this.errors != null) {
                populateErrorsAttribte = true;
            }
            try {
                this.upload(0, false);
            }
            catch (FileUtils.EmptyFileUploadException e) {
                if (this.continueOnError) {
                    errorsArray.add(e.getAsStruct());
                }
            }
            catch (FileUtils.FileUploadException e) {
                if (!this.continueOnError || !e.canSkip()) {
                    throw e;
                }
                errorsArray.add(e.getAsStruct());
            }
            catch (FileUtils.InvalidDestinationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeWrapper(e);
            }
            if (populateErrorsAttribte) {
                this.pageContext.setAttribute(this.errors, (Object)errorsArray);
            }
        } else if ("Move".equalsIgnoreCase(this.action)) {
            this.validateAttributes(this.destination);
            this.move();
        } else if ("Rename".equalsIgnoreCase(this.action)) {
            this.validateAttributes(this.destination);
            this.rename();
        } else if ("Copy".equalsIgnoreCase(this.action)) {
            this.validateAttributes(this.destination);
            this.copy();
        } else if ("Delete".equalsIgnoreCase(this.action)) {
            this.delete();
        } else if ("Read".equalsIgnoreCase(this.action)) {
            this.read();
        } else if ("ReadBinary".equalsIgnoreCase(this.action)) {
            this.readBinary();
        } else {
            if ("Write".equalsIgnoreCase(this.action)) {
                this.validateAttributes(this.file);
                return 2;
            }
            if ("Append".equalsIgnoreCase(this.action)) {
                this.validateAttributes(this.file);
                return 2;
            }
            if ("Uploadall".equalsIgnoreCase(this.action)) {
                this.uploadAll();
            }
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        if (this.bodyContent != null) {
            this.content = this.bodyContent.getString();
            this.bodyContent.clearBody();
        }
        if ("Write".equalsIgnoreCase(this.action)) {
            this.write();
        } else if ("Append".equalsIgnoreCase(this.action)) {
            this.append();
        }
        List<TagAttribute> tagAttributes = this.captureAttributes(Arrays.asList("action"), Arrays.asList(this.convertUpperCase(this.action)));
        this.onTagEnd(tagAttributes);
        return 6;
    }

    private void validateAttributes(String path) {
        if (path != null && VFSFileFactory.checkIfVFile(path)) {
            if (this.attributes != null) {
                throw new AttributesNotSupportedException();
            }
            if (this.modePresent) {
                throw new ModeNotSupportedException();
            }
        }
    }

    private void append() {
        this.checkFilePermission("write", this.file);
        File f = VFSFileFactory.getFileObject(this.file);
        if (!VFSFileFactory.exists(f)) {
            try {
                if (this.content != null && this.content.length() > 0) {
                    this.createNewFile(this.file, this.content, this.addnewline, this.fixnewline, this.charset);
                } else {
                    if (this.output == null) {
                        throw new AttributeRequiredException("CFFILE", "ACTION", "APPEND", "OUTPUT");
                    }
                    this.createNewFile(this.file, this.output, this.addnewline, this.fixnewline, this.charset);
                }
                this.checkTimeout();
                File tmp = VFSFileFactory.getFileObject(this.file);
                FileUtils.setFileAttributes(tmp, this.attributes);
                FileUtils.setUnixModes(this.file, this.mode);
                this.checkTimeout();
            }
            catch (IOException ex) {
                throw new SingleFileOperationException(this.action, ex, this.file);
            }
        }
        if (DirFileUtils.isReadOnly(f)) {
            throw new DirFileIsReadOnlyException(f.getAbsolutePath(), "Append", "Destination");
        }
        try {
            if (this.content != null && this.content.length() > 0) {
                FileTag.appendToFile(this.file, this.content, this.addnewline, this.charset);
            } else {
                if (this.output == null) {
                    throw new AttributeRequiredException("CFFILE", "ACTION", "APPEND", "OUTPUT");
                }
                FileTag.appendToFile(this.file, this.output, this.addnewline, this.charset);
            }
            this.checkTimeout();
            if (!VFSFileFactory.checkIfVFile(this.file)) {
                FileUtils.setFileAttributes(new File(this.file), this.attributes);
                FileUtils.setUnixModes(this.file, this.mode);
            }
            this.checkTimeout();
        }
        catch (IOException ex) {
            throw new SingleFileOperationException(this.action, ex, this.file);
        }
    }

    private void write() {
        if (this.output != null && this.content != null && !this.content.trim().equals("")) {
            throw new IllegalAttributeCombinationException();
        }
        this.checkFilePermission("write", this.file);
        try {
            File tmp = VFSFileFactory.getFileObject(this.file);
            if (DirFileUtils.isReadOnly(tmp)) {
                throw new DirFileIsReadOnlyException(tmp.getAbsolutePath(), "Write", "Destination");
            }
            if (this.content != null && this.content.length() > 0) {
                this.createNewFile(this.file, this.content, this.addnewline, this.fixnewline, this.charset);
            } else {
                if (this.output == null) {
                    throw new AttributeRequiredException("CFFILE", "ACTION", "WRITE", "OUTPUT");
                }
                this.createNewFile(this.file, this.output, this.addnewline, this.fixnewline, this.charset);
            }
            this.checkTimeout();
            FileUtils.setFileAttributes(tmp, this.attributes);
            FileUtils.setUnixModes(this.file, this.mode);
            this.checkTimeout();
        }
        catch (IOException ex) {
            throw new SingleFileOperationException(this.action, ex, this.file);
        }
    }

    private void readBinary() {
        this.checkFilePermission("read", this.file);
        byte[] contents = FileUtils.readBinaryFile(this.file);
        this.checkTimeout();
        ((NeoPageContext)this.pageContext).setArrayAttribute(this.variable, contents);
    }

    private void read() {
        this.checkFilePermission("read", this.file);
        String contents = FileUtils.readFile(this.file, this.charset);
        this.checkTimeout();
        ((NeoPageContext)this.pageContext).setArrayAttribute(this.variable, contents);
    }

    private void delete() {
        this.checkFilePermission("delete", this.file);
        FileUtils.delete(this.file);
    }

    private void copy() {
        this.checkFilePermission("read,write", this.file);
        if (this.source.equalsIgnoreCase(this.destination)) {
            throw new SourceEqualsDestinationException(this.source);
        }
        try {
            FileUtils.copyFile(this.source, this.destination);
            this.checkTimeout();
            File s = VFSFileFactory.getFileObject(this.source);
            final File d = VFSFileFactory.getFileObject(this.destination);
            boolean isDir = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return d.isDirectory();
                }
            });
            File new_file = isDir ? VFSFileFactory.getFileObject(this.destination, s.getName()) : VFSFileFactory.getFileObject(this.destination);
            if (this.attributes != null && this.attributes.trim().length() != 0) {
                this.checkTimeout();
                FileUtils.setFileAttributes(new_file, this.attributes);
                this.checkTimeout();
            }
            FileUtils.setUnixModes(new_file.getAbsolutePath(), this.mode);
        }
        catch (IOException ex) {
            throw new MultipleFileOperationException(this.action, (Throwable)ex, this.source, this.destination);
        }
    }

    private void rename() {
        this.checkFilePermission("write", this.file);
        File s = VFSFileFactory.getFileObject(this.source);
        try {
            FileUtils.setFileAttributes(s, this.attributes);
            FileUtils.setUnixModes(this.source, this.mode);
        }
        catch (IOException e) {
            throw new FilePermissionException(this.source);
        }
        this.checkTimeout();
        if (!VFSFileFactory.exists(s)) {
            throw new InvalidTagAttributeException("CFFILE", "source", this.source);
        }
        File new_file = FileUtils.determineDest(this.destination, s.getParent(), s.getName());
        if (!s.renameTo(new_file)) {
            FileUtils.delete(new_file);
            if (!s.renameTo(new_file)) {
                throw new InvalidTagAttributeException("CFFILE", "source", this.source);
            }
        }
    }

    private void move() {
        this.checkFilePermission("delete,write", this.file);
        this.checkTimeout();
        File s = VFSFileFactory.getFileObject(this.source);
        try {
            FileUtils.setFileAttributes(s, this.attributes);
            FileUtils.setUnixModes(this.source, this.mode);
        }
        catch (IOException E) {
            throw new FilePermissionException(this.source);
        }
        this.checkTimeout();
        FileUtils.move(this.source, this.destination);
        this.checkTimeout();
    }

    /*
     * Exception decompiling
     */
    private void uploadAll() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Struct upload(int tmpFileIndex, boolean returnStruct) {
        this.checkFilePermission("write", this.file);
        try {
            String fileName;
            String serverDirectory;
            File new_file;
            Struct resultStruct = FileUtils.uploadFile(this.destination, this.filefield, this.accept, this.block, this.nameconflict, this.pageContext, this.strict, tmpFileIndex, this.allowedExtensions);
            this.checkTimeout();
            if (this.filefield == null && this.out != null) {
                try {
                    this.out.write(" ");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if ((new_file = VFSFileFactory.getFileObject(serverDirectory = (String)resultStruct.get("SERVERDIRECTORY"), fileName = (String)resultStruct.get("SERVERFILE"))) != null) {
                this.checkTimeout();
                try {
                    resultStruct.put("FILEATTRIBSET", (Object)FileUtils.setFileAttributes(new_file, this.attributes));
                }
                catch (FileUtils.FileUploadException e) {
                    CFLogs.APPLICATION_LOG.info(e);
                    resultStruct.put("FILEATTRIBSET", (Object)false);
                }
                try {
                    resultStruct.put("FILEMODESET", (Object)FileUtils.setUnixModes(new_file.getPath(), this.mode));
                }
                catch (Exception e) {
                    CFLogs.APPLICATION_LOG.info(e);
                    resultStruct.put("FILEMODESET", (Object)false);
                }
                this.checkTimeout();
            }
            if (!returnStruct) {
                if (this.result != null) {
                    this.pageContext.setAttribute(this.result, (Object)resultStruct);
                } else {
                    LocalScope outputVars = this.fContext.fileScope;
                    outputVars.putAll((Map)resultStruct);
                }
            }
            return resultStruct;
        }
        catch (IOException ex) {
            throw new SingleFileOperationException(this.action, ex, this.destination);
        }
    }

    protected static File uniqueFile(File dir, String fname, String ext) {
        String parentDir = !dir.isFile() ? dir.getPath() : dir.getParent();
        String extSeparator = ".";
        if (ext.trim().length() > 0 && fname.endsWith(ext)) {
            fname = fname.substring(0, fname.indexOf("." + ext));
        }
        if (ext.trim().length() == 0) {
            extSeparator = "";
        }
        File f = VFSFileFactory.getFileObject(parentDir, fname + extSeparator + ext);
        int num = 0;
        while (VFSFileFactory.exists(f)) {
            f = VFSFileFactory.getFileObject(parentDir, fname + ++num + extSeparator + ext);
        }
        return f;
    }

    protected static void appendToFile(String file, Object obj, boolean addnewline, String charset) throws IOException {
        FileUtils.appendFile(file, obj, addnewline, charset);
    }

    public void checkTimeout() throws RequestTimedOutException {
        if (RequestMonitor.isRequestTimedOut()) {
            throw new RequestTimedOutException(this.tagNameFromClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createNewFile(String file, Object str, boolean addNewLine, boolean fixnewline, String charset) throws IOException {
        block21: {
            BufferedWriter out = null;
            OutputStream os = null;
            try {
                if (str != null && str instanceof byte[]) {
                    os = VFSFileFactory.getOutputStream(file);
                } else {
                    out = charset != null ? new BufferedWriter(new OutputStreamWriter(VFSFileFactory.getOutputStream(file), charset)) : new BufferedWriter(new OutputStreamWriter(VFSFileFactory.getOutputStream(file)));
                }
                if (str == null) break block21;
                if (str instanceof byte[]) {
                    byte[] bArr = (byte[])str;
                    os.write(bArr);
                    break block21;
                }
                if (str instanceof String && fixnewline) {
                    boolean mlines = false;
                    BufferedReader in = null;
                    try {
                        String s;
                        in = new BufferedReader(new StringReader((String)str));
                        while ((s = in.readLine()) != null) {
                            if (mlines) {
                                out.newLine();
                            }
                            mlines = true;
                            out.write(s);
                            out.flush();
                        }
                        if (addNewLine) {
                            out.newLine();
                        }
                        break block21;
                    }
                    finally {
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
                out.write(Cast._String(str));
                if (addNewLine) {
                    out.newLine();
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (os != null) {
                    os.close();
                }
            }
        }
    }

    private static String getFriendlyPath(String path) {
        File f = VFSFileFactory.getFileObject(path);
        return f instanceof VFile ? ((VFile)f).getFriendlyName() : path;
    }

    public static class AttributesNotSupportedException
    extends ApplicationException {
    }

    public static class ModeNotSupportedException
    extends ApplicationException {
    }

    public static class AttributeRequiredException
    extends ApplicationException {
        public String tagName;
        public String required;
        public String switchAttr;
        public String switchValue;

        public AttributeRequiredException(String tagName, String switchAttr, String switchValue, String required) {
            this.tagName = tagName;
            this.required = required.toUpperCase();
            this.switchAttr = switchAttr.toUpperCase();
            this.switchValue = switchValue.toUpperCase();
        }
    }

    public static class SingleFileOperationException
    extends ApplicationException {
        public String file;
        public String action;

        public SingleFileOperationException(String a, Throwable ex, String file) {
            super(ex);
            this.action = a;
            this.file = this.action.equals("create") ? file : FileTag.getFriendlyPath(file);
        }
    }

    public static class DirFileIsReadOnlyException
    extends ApplicationException {
        private String file;
        private String action;
        private String method;

        public DirFileIsReadOnlyException(String file, String action, String method) {
            this.file = FileTag.getFriendlyPath(file);
            this.action = action;
            this.method = method;
        }

        public String getFile() {
            return this.file;
        }

        public String getAction() {
            return this.action;
        }

        public String getMethod() {
            return this.method;
        }
    }

    public static class IllegalAttributeCombinationException
    extends ApplicationException {
    }

    public static class SourceEqualsDestinationException
    extends ApplicationException {
        private String source;

        public SourceEqualsDestinationException(String source) {
            this.source = FileTag.getFriendlyPath(source);
        }

        public String getSource() {
            return this.source;
        }
    }

    public static class MultipleFileOperationException
    extends ApplicationException {
        public String source;
        public String dest;
        public String action;

        MultipleFileOperationException(String a, Throwable ex, String source, String dest) {
            super(ex);
            this.action = a;
            this.source = FileTag.getFriendlyPath(source);
            this.dest = FileTag.getFriendlyPath(dest);
        }
    }

    public class FilePermissionException
    extends ApplicationException {
        private String file;

        FilePermissionException(String file) {
            this.file = FileTag.getFriendlyPath(file);
        }

        public String getFile() {
            return this.file;
        }
    }

    public static class InvalidSourceException
    extends ApplicationException {
        private String source;

        InvalidSourceException(String source) {
            this.source = FileTag.getFriendlyPath(source);
        }

        public String getSource() {
            return this.source;
        }
    }
}

