/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.io.cache;

import coldfusion.runtime.ApplicationException;
import coldfusion.tagext.io.cache.CacheException;
import java.util.Objects;

public class CacheExceptions {
    private static CacheExceptions attribExceptions = new CacheExceptions();

    public static void throwInvalidProtocolException(String attribName) throws InvalidProtocolException {
        CacheExceptions cacheExceptions = attribExceptions;
        Objects.requireNonNull(cacheExceptions);
        throw cacheExceptions.new InvalidProtocolException(attribName);
    }

    public static void throwDirectoryNotFoundException(String attr, String value) throws DirectoryNotFoundException {
        CacheExceptions cacheExceptions = attribExceptions;
        Objects.requireNonNull(cacheExceptions);
        throw cacheExceptions.new DirectoryNotFoundException(attr, value);
    }

    public static void throwEmptyAttributeException(String attr) throws EmptyAttributeException {
        CacheExceptions cacheExceptions = attribExceptions;
        Objects.requireNonNull(cacheExceptions);
        throw cacheExceptions.new EmptyAttributeException(attr);
    }

    public static void throwIllegalMetadataException(String attr) throws EmptyAttributeException {
        CacheExceptions cacheExceptions = attribExceptions;
        Objects.requireNonNull(cacheExceptions);
        throw cacheExceptions.new IllegalMetadataException(attr);
    }

    public static void throwInvalidEndTagException(String attr) throws InvalidEndTagException {
        CacheExceptions cacheExceptions = attribExceptions;
        Objects.requireNonNull(cacheExceptions);
        throw cacheExceptions.new InvalidEndTagException(attr);
    }

    public static void throwInvalidAttributeException(String attrName, String value, String name) throws InvalidAttributeException {
        CacheExceptions cacheExceptions = attribExceptions;
        Objects.requireNonNull(cacheExceptions);
        throw cacheExceptions.new InvalidAttributeException(attrName, value, name);
    }

    public static void throwExpireUrlIdDefinedException(String attr) throws ExpireUrlIdDefinedException {
        CacheExceptions cacheExceptions = attribExceptions;
        Objects.requireNonNull(cacheExceptions);
        throw cacheExceptions.new ExpireUrlIdDefinedException(attr);
    }

    public static void throwInvalidCacheSettingsException(Exception ex) throws InvalidCacheSettingsException {
        CacheExceptions cacheExceptions = attribExceptions;
        Objects.requireNonNull(cacheExceptions);
        throw cacheExceptions.new InvalidCacheSettingsException(ex);
    }

    public static void throwInvalidObjectTypeException(String attr) throws InvalidObjectTypeException {
        CacheExceptions cacheExceptions = attribExceptions;
        Objects.requireNonNull(cacheExceptions);
        throw cacheExceptions.new InvalidObjectTypeException(attr);
    }

    public static void throwNotRemovedIDException(String attr) throws InvalidObjectTypeException {
        CacheExceptions cacheExceptions = attribExceptions;
        Objects.requireNonNull(cacheExceptions);
        throw cacheExceptions.new NotRemovedIDException(attr);
    }

    public class InvalidProtocolException
    extends CacheException {
        public String recurrenceType;

        public InvalidProtocolException(String attribName) {
            this.recurrenceType = attribName;
        }
    }

    public class DirectoryNotFoundException
    extends CacheException {
        public String attrName;
        public String attrValue;

        public DirectoryNotFoundException(String attr, String value) {
            this.attrName = attr;
            this.attrValue = value;
        }
    }

    public class EmptyAttributeException
    extends CacheException {
        public String attrName = null;

        public EmptyAttributeException(String attrName) {
            this.attrName = attrName;
        }
    }

    public class IllegalMetadataException
    extends CacheException {
        public String attrName = null;

        public IllegalMetadataException(String attrName) {
            this.attrName = attrName;
        }
    }

    public class InvalidEndTagException
    extends CacheException {
        public String attrName = null;

        public InvalidEndTagException(String attrName) {
            this.attrName = attrName;
        }
    }

    public class InvalidAttributeException
    extends CacheException {
        public String attrName = null;
        public String value = null;
        public String name = "CFCACHE tag";

        public InvalidAttributeException(String attrName, String value, String name) {
            this.attrName = attrName;
            this.value = value;
            if (name != null) {
                this.name = name;
            }
        }
    }

    public class ExpireUrlIdDefinedException
    extends CacheException {
        public String attrName = null;

        public ExpireUrlIdDefinedException(String attrName) {
            this.attrName = attrName;
        }
    }

    public class InvalidCacheSettingsException
    extends CacheException {
        public String rootCause = null;

        public InvalidCacheSettingsException(Exception ex) {
            this.rootCause = ex.getLocalizedMessage();
        }
    }

    public class InvalidObjectTypeException
    extends CacheException {
        public String attrName = null;

        public InvalidObjectTypeException(String attrName) {
            this.attrName = attrName;
        }
    }

    public class NotRemovedIDException
    extends CacheException {
        public String attrName = null;

        public NotRemovedIDException(String attrName) {
            this.attrName = attrName;
        }
    }

    public static class InvalidCacheTagException
    extends ApplicationException {
    }

    public static class InvalidCacheNameException
    extends ApplicationException {
    }

    public static class CacheInitializationException
    extends ApplicationException {
        public final String message;

        public CacheInitializationException(String message) {
            this.message = message;
        }
    }

    public static class InvalidAttributeCombinationException
    extends ApplicationException {
    }

    public static class ImpicitCacheRegionDeletionException
    extends ApplicationException {
        public final String cache;

        public ImpicitCacheRegionDeletionException(String cache) {
            this.cache = cache;
        }
    }

    public static class CustomCacheNotFoundException
    extends ApplicationException {
        public final String cache;

        public CustomCacheNotFoundException(String cache) {
            this.cache = cache;
        }
    }

    public static class CacheNotFoundException
    extends ApplicationException {
        public final String cache;

        public CacheNotFoundException(String cache) {
            this.cache = cache;
        }
    }

    public static class InvalidCacheConfigFileException
    extends ApplicationException {
    }

    public static class CacheConfigFileNotFoundException
    extends ApplicationException {
        public final String file;

        public CacheConfigFileNotFoundException(String file) {
            this.file = file;
        }
    }

    public static class CacheAlreadyExistsException
    extends CacheException {
        public final String name;

        public CacheAlreadyExistsException(String name) {
            this.name = name;
        }
    }

    public static class IllegalArgumentException
    extends CacheException {
        public String attrName = null;
        public Object value = null;

        public IllegalArgumentException(String attrName, Object value) {
            this.attrName = attrName;
            this.value = value;
        }
    }
}

