/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.io.cache;

import coldfusion.centralconfig.client.CentralConfigClientUtil;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.Cast;
import coldfusion.runtime.MetadataUtils;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.runtime.StringFunc;
import coldfusion.runtime.Struct;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.CFDataSource;
import coldfusion.sql.CacheDetails;
import coldfusion.sql.DataSourceFactory;
import coldfusion.sql.QueryDetails;
import coldfusion.tagext.io.cache.CacheConfig;
import coldfusion.tagext.io.cache.CacheException;
import coldfusion.tagext.io.cache.CacheExceptions;
import coldfusion.tagext.io.cache.CacheTO;
import coldfusion.tagext.io.cache.CacheTag;
import coldfusion.tagext.io.cache.CachingConstants;
import coldfusion.tagext.io.cache.GenericCache;
import coldfusion.tagext.io.cache.GenericCacheFactory;
import coldfusion.tagext.io.cache.ehcache.EHcachePageInfo;
import coldfusion.util.CaseInsensitiveHashtable;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.tagext.BodyContent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class CacheTagHelper
implements CachingConstants {
    public static String JCSDSNNAME;
    public static final String EVENTHANDLER_IFC = "ICustomCache";

    static boolean checkFromTemplateCache(CacheTag tag) {
        boolean evaluate = true;
        GenericCache templateCache = GenericCacheFactory.getCache();
        CacheTO cacheTO = new CacheTO();
        cacheTO.setAppname(tag.getAppName());
        cacheTO.setObjecttype("TEMPLATE");
        cacheTO.setId(tag.getKey());
        cacheTO.setKey(tag.getCacheKey());
        Object cacheval = templateCache.get(cacheTO, false);
        if (cacheval != null) {
            try {
                if (cacheval instanceof String) {
                    tag.getPageWriter().write((String)cacheval);
                } else if (cacheval instanceof EHcachePageInfo) {
                    CacheTagHelper.writeResponse(tag.getRequest(), tag.getResponse(), (EHcachePageInfo)cacheval);
                    tag.getOut().clear();
                }
            }
            catch (Exception e) {
                return true;
            }
            evaluate = false;
        }
        return evaluate;
    }

    private static void writeResponse(HttpServletRequest request, HttpServletResponse response, EHcachePageInfo pageInfo) throws Exception {
        CacheTagHelper.setStatus(response, pageInfo);
        CacheTagHelper.setContentType(response, pageInfo);
        CacheTagHelper.setHeaders(pageInfo, response);
        CacheTagHelper.writeContent(request, response, pageInfo);
    }

    private static boolean acceptsGzipEncoding(HttpServletRequest request) {
        return CacheTagHelper.acceptsEncoding(request, "gzip");
    }

    private static boolean acceptsEncoding(HttpServletRequest request, String name) {
        return CacheTagHelper.headerContains(request, "Accept-Encoding", name);
    }

    private static boolean headerContains(HttpServletRequest request, String header, String value) {
        Enumeration accepted = request.getHeaders(header);
        while (accepted.hasMoreElements()) {
            String headerValue = (String)accepted.nextElement();
            if (headerValue.indexOf(value) == -1) continue;
            return true;
        }
        return false;
    }

    private static void setStatus(HttpServletResponse response, EHcachePageInfo pageInfo) {
        response.setStatus(pageInfo.getStatusCode());
    }

    private static void setHeaders(EHcachePageInfo pageInfo, HttpServletResponse response) {
        List headers = pageInfo.getHeaders();
        boolean header = false;
        boolean value = true;
        for (String[] headerPair : headers) {
            response.addHeader(headerPair[0], headerPair[1]);
        }
    }

    private static void setContentType(HttpServletResponse response, EHcachePageInfo pageInfo) {
        response.setContentType(pageInfo.getContentType());
    }

    private static void writeContent(HttpServletRequest request, HttpServletResponse response, EHcachePageInfo pageInfo) throws Exception {
        ServiceFactory.getCachingService().writeContent(request, response, pageInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addToTemplateCache(CacheTag tag) {
        String body = null;
        BodyContent bodyContent = tag.getBodyContent();
        if (bodyContent != null) {
            body = bodyContent.getString();
        }
        if (body != null) {
            try {
                GenericCache templateCache = GenericCacheFactory.getCache();
                if (tag.getStripWhiteSpace()) {
                    body = CacheTagHelper.stripWhiteSpaces(body);
                }
                CacheTO transferObj = new CacheTO(tag, "TEMPLATE", body);
                templateCache.put(transferObj, false);
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    tag.getOut().print(body);
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void addToObjectCache(Object id, Object value, String key, Object timeSpan, Object idleTime, boolean throwOnError) {
        long timeSpanLong = 0L;
        try {
            if (timeSpan == null) {
                throw new CacheExceptions.IllegalArgumentException("timespan", timeSpan);
            }
            timeSpanLong = timeSpan instanceof String && ((String)timeSpan).trim().equals("") ? -1L : (long)(Cast._double(timeSpan) * 86400.0);
        }
        catch (Exception e) {
            throw new CacheExceptions.IllegalArgumentException("timespan", timeSpan);
        }
        long idleTimeLong = 0L;
        try {
            if (idleTime == null) {
                throw new CacheExceptions.IllegalArgumentException("idletime", idleTime);
            }
            idleTimeLong = idleTime instanceof String && ((String)idleTime).trim().equals("") ? -1L : (long)(Cast._double(idleTime) * 86400.0);
        }
        catch (Exception e) {
            throw new CacheExceptions.IllegalArgumentException("idletime", idleTime);
        }
        CacheTagHelper.addToObjectCacheIntr(id, value, key, timeSpanLong, idleTimeLong, "CACHEPUT function", throwOnError);
    }

    private static void addToObjectCacheIntr(Object id, Object value, String key, long timeSpan, long idleTime, String name, boolean throwOnError) {
        id = CacheTagHelper.validateID(id, name);
        FusionContext current = FusionContext.getCurrent();
        String appName = null;
        if (current != null) {
            appName = current.getApplicationName();
        }
        GenericCache templateCache = GenericCacheFactory.getCache();
        CacheTO cacheTO = new CacheTO(appName, "OBJECT", id, value, timeSpan, idleTime, key, false, null);
        templateCache.put(cacheTO, throwOnError);
    }

    public static void addToObjectCache(CacheTag tag) {
        CacheTagHelper.addToObjectCacheIntr(tag.getCacheid(), tag.getValue(), tag.getCacheKey(), tag.getTimespanForCache(), tag.getIdleTime(), "CFCACHE tag", false);
    }

    public static Object getFromCache(Object id, String objectType, String funcName, String key, boolean throwErorr) {
        return CacheTagHelper.getFromCache(id, objectType, funcName, key, throwErorr, false);
    }

    public static Object getFromCache(Object id, String objectType, String funcName, String key, boolean throwErorr, boolean getMetadata) {
        id = CacheTagHelper.validateID(id, funcName);
        GenericCache objCache = GenericCacheFactory.getCache();
        CacheTO cacheTO = new CacheTO();
        cacheTO.setAppname(CacheTagHelper.getCurrentApplicationName());
        cacheTO.setObjecttype(objectType);
        cacheTO.setId(id);
        cacheTO.setKey(key);
        return objCache.get(cacheTO, throwErorr);
    }

    public static String getCurrentApplicationName() {
        String appName = null;
        FusionContext current = FusionContext.getCurrent();
        if (current != null) {
            appName = current.getApplicationName();
        }
        return appName;
    }

    public static Map getCacheMetadata(Object id, String key) {
        return CacheTagHelper.getCacheMetadata(id, key, "OBJECT");
    }

    public static Map getCacheMetadata(Object id, String region, String objType) {
        if (!(objType == null || "OBJECT".equalsIgnoreCase(objType = objType.trim().toUpperCase()) || "TEMPLATE".equalsIgnoreCase(objType) || "QUERY".equalsIgnoreCase(objType) || region != null && objType.equals(""))) {
            CacheExceptions.throwInvalidAttributeException("OBJECTTYPE", objType, "CACHEGETMETADATA function");
        }
        id = CacheTagHelper.validateID(id, "CACHEGETMETADATA function");
        GenericCache templateCache = GenericCacheFactory.getCache();
        CacheTO cacheTO = new CacheTO();
        cacheTO.setAppname(CacheTagHelper.getCurrentApplicationName());
        cacheTO.setObjecttype(objType);
        cacheTO.setId(id);
        cacheTO.setKey(region);
        return templateCache.getMetadata(cacheTO);
    }

    public static Object getCacheSession(String objType, boolean isKey) {
        GenericCache cache = GenericCacheFactory.getCache();
        if (!isKey) {
            if (objType != null && !"OBJECT".equalsIgnoreCase(objType = objType.trim().toUpperCase()) && !"TEMPLATE".equalsIgnoreCase(objType)) {
                CacheExceptions.throwInvalidAttributeException("OBJECTTYPE", objType, "CACHEGETSESSION function");
            }
            return cache.getCache(CacheTagHelper.getCurrentApplicationName(), objType, null);
        }
        return cache.getCache(null, null, objType);
    }

    public static Map getTemplateCacheMetadata(CacheTag tag) {
        GenericCache templateCache = GenericCacheFactory.getCache();
        CacheTO cacheTO = new CacheTO(tag, "TEMPLATE", null);
        return templateCache.getMetadata(cacheTO);
    }

    public static List getAllCacheIds(String type, String key, boolean accurate) {
        GenericCache objCache = GenericCacheFactory.getCache();
        CacheTO cacheTO = new CacheTO();
        cacheTO.setKey(key);
        cacheTO.setAppname(CacheTagHelper.getCurrentApplicationName());
        cacheTO.setObjecttype(type);
        return objCache.getAllCacheIds(cacheTO, accurate);
    }

    public static String stripWhiteSpaces(String body) {
        body = StringFunc.REReplace(body, "[\n\r\t]{2,}", "\r", "ALL", true);
        return body;
    }

    static void deleteFromCache(CacheTag tag) {
        if (tag.getExpireURL() != null && tag.getCacheid() != null) {
            CacheExceptions.throwExpireUrlIdDefinedException("FLUSH");
        }
        if (tag.getCacheid() != null) {
            CacheTagHelper.deleteFromObjectCache(tag.getCacheid(), tag.isThrowOnError(), null, tag.getCacheKey(), true);
        } else {
            CacheTagHelper.deleteFromTemplateCache(tag);
        }
    }

    private static void deleteFromTemplateCache(CacheTag tag) {
        CacheTO cacheTO = new CacheTO();
        cacheTO.setAppname(tag.getAppName());
        cacheTO.setObjecttype("TEMPLATE");
        cacheTO.setId(tag.getExpireURL());
        cacheTO.setKey(tag.getCacheKey());
        cacheTO.setExact(false);
        GenericCache templateCache = GenericCacheFactory.getCache();
        templateCache.remove(cacheTO);
    }

    public static void deleteFromObjectCache(Object id, boolean throwError, String functionName, String key, boolean exact) {
        GenericCache objCache = GenericCacheFactory.getCache();
        if (id != null) {
            StringBuilder failedIDs = new StringBuilder();
            if (id instanceof String) {
                String[] ids = ((String)id).split(",");
                for (int i = 0; i < ids.length; ++i) {
                    CacheTagHelper.removeStringId(ids[i].trim(), throwError, functionName, key, exact, objCache, failedIDs);
                }
                if (throwError && failedIDs.length() != 0) {
                    CacheExceptions.throwNotRemovedIDException(failedIDs.toString());
                }
            } else if (id instanceof List) {
                List idList = (List)id;
                Object temp = null;
                for (int i = 0; i < idList.size(); ++i) {
                    temp = idList.get(i);
                    if (temp instanceof String) {
                        CacheTagHelper.removeStringId(((String)temp).trim(), throwError, functionName, key, exact, objCache, failedIDs);
                        continue;
                    }
                    if (!(temp instanceof QueryDetails)) continue;
                    CacheTagHelper.removeQueryDetailsId(temp, key, exact, objCache, failedIDs);
                }
                if (throwError && failedIDs.length() != 0) {
                    CacheExceptions.throwNotRemovedIDException(failedIDs.toString());
                }
            } else if (id instanceof QueryDetails) {
                CacheTagHelper.removeQueryDetailsId(id, key, exact, objCache, null);
            } else {
                CacheExceptions.throwInvalidAttributeException("ID", id.toString(), functionName);
            }
        } else {
            CacheTO cacheTO = new CacheTO();
            cacheTO.setAppname(CacheTagHelper.getCurrentApplicationName());
            cacheTO.setObjecttype("OBJECT");
            cacheTO.setId(null);
            cacheTO.setExact(true);
            objCache.remove(cacheTO);
        }
    }

    public static void removeQueryDetailsId(Object id, String key, boolean exact, GenericCache objCache, StringBuilder failedIDs) {
        CacheTO cacheTO = new CacheTO();
        cacheTO.setKey(key);
        cacheTO.setAppname(CacheTagHelper.getCurrentApplicationName());
        cacheTO.setObjecttype("QUERY");
        cacheTO.setId(id);
        cacheTO.setExact(exact);
        if (!objCache.remove(cacheTO) && failedIDs != null) {
            failedIDs.append(cacheTO.id);
        }
    }

    public static void removeStringId(String id, boolean throwError, String functionName, String key, boolean exact, GenericCache objCache, StringBuilder failedIDs) {
        if (id != null && !id.equals("")) {
            CacheTO cacheTO = new CacheTO();
            cacheTO.setKey(key);
            cacheTO.setAppname(CacheTagHelper.getCurrentApplicationName());
            cacheTO.setObjecttype("OBJECT");
            cacheTO.setId(id);
            cacheTO.setExact(exact);
            if (!objCache.remove(cacheTO)) {
                failedIDs.append(cacheTO.id);
            }
        } else if (throwError) {
            CacheExceptions.throwInvalidAttributeException("ID", id.toString(), functionName);
        }
    }

    private static Object validateID(Object id, String functionName) {
        if (id == null) {
            CacheExceptions.throwInvalidAttributeException("ID", null, functionName);
        }
        if (id instanceof String) {
            String temp = (String)id;
            if (temp.trim().equals("")) {
                CacheExceptions.throwInvalidAttributeException("ID", id.toString(), functionName);
            }
            return temp.trim();
        }
        if (id instanceof Number) {
            return Cast._String(((Number)id).doubleValue());
        }
        if (id instanceof Boolean) {
            return Cast._String((Boolean)id);
        }
        return id;
    }

    public static List getObjectCacheMetadata(String appName) {
        GenericCache templateCache = GenericCacheFactory.getCache();
        return templateCache.getObjectCacheMetadata(appName);
    }

    public static List getTemplateCacheMetadata(String appName) {
        GenericCache templateCache = GenericCacheFactory.getCache();
        return templateCache.getTemplateCacheMetadata(appName);
    }

    public static void setCacheProperties(Map prop, String region) {
        GenericCache templateCache = GenericCacheFactory.getCache();
        templateCache.setCacheProperties(prop, region);
    }

    public static List getCacheProperties(String region) {
        GenericCache templateCache = GenericCacheFactory.getCache();
        return templateCache.getCacheProperties(region);
    }

    public static List getAllServerCacheMetatdata() {
        return GenericCacheFactory.getAllServerCacheMetadata();
    }

    public static List getApplicationCacheMetadata(String appName) {
        ArrayList<Struct> result = null;
        Map<String, GenericCache> appMap = GenericCacheFactory.getCacheManagerMap();
        if (appMap != null && appMap.containsKey(appName)) {
            result = new ArrayList<Struct>();
            GenericCache gecache = appMap.get(appName);
            ArrayList appr = gecache.getAllCacheMetadataForMonitoring(false);
            Struct r = new Struct();
            r.put("APPNAME", (Object)appName);
            r.put("CACHEREGIONLIST", (Object)appr);
            result.add(r);
        }
        return result;
    }

    public static List getAllApplicationCacheMetadata() {
        ArrayList<Struct> result = new ArrayList<Struct>();
        Map<String, GenericCache> appMap = GenericCacheFactory.getCacheManagerMap();
        if (appMap != null) {
            for (Map.Entry<String, GenericCache> namecache : appMap.entrySet()) {
                String appName = namecache.getKey().toString();
                GenericCache gecache = namecache.getValue();
                ArrayList appr = gecache.getAllCacheMetadataForMonitoring(false);
                Struct r = new Struct();
                r.put("APPNAME", (Object)appName);
                r.put("CACHEREGIONLIST", (Object)appr);
                result.add(r);
            }
        }
        return result;
    }

    public static List getAllApplicationList() {
        ArrayList<String> result = new ArrayList<String>();
        Map<String, GenericCache> appMap = GenericCacheFactory.getCacheManagerMap();
        if (appMap != null) {
            for (Map.Entry<String, GenericCache> namecache : appMap.entrySet()) {
                String appName = namecache.getKey().toString();
                boolean isApp = namecache.getValue().isApplicationSpecificCache();
                boolean isAdmin = "cfadmin".equals(appName);
                if (isAdmin || !isApp) continue;
                result.add(appName);
            }
        }
        Collections.sort(result);
        return result;
    }

    public static boolean cacheExists(Object id, String region) {
        if (id != null) {
            GenericCache cache = GenericCacheFactory.getCache();
            CacheTO cacheTO = new CacheTO(CacheTagHelper.getCurrentApplicationName(), "OBJECT", id, null, -1L, -1L, region, false, null);
            cacheTO.getQuiet = true;
            Object obj = cache.get(cacheTO, true);
            return obj != null;
        }
        return false;
    }

    public static void purgeAllQueryCache(Map<Integer, CacheDetails> cachedQueryMap) {
        Map<String, GenericCache> appCachemanagerMap = GenericCacheFactory.getCacheManagerMap();
        if (appCachemanagerMap != null) {
            Iterator<Map.Entry<String, GenericCache>> itr = appCachemanagerMap.entrySet().iterator();
            Object cacheNames = null;
            CacheTO queryTO = new CacheTO();
            queryTO.setObjecttype("QUERY");
            queryTO.setKey("QUERY");
            GenericCache cache = null;
            while (itr.hasNext()) {
                Map.Entry<String, GenericCache> entry = itr.next();
                cache = entry.getValue();
                if (cache == null) continue;
                try {
                    CacheTagHelper.clearQueryCache(cache);
                }
                catch (Throwable throwable) {}
            }
        }
        CacheTagHelper.clearQueryCache(GenericCacheFactory.getServerWideCache());
        CacheTagHelper.remove(cachedQueryMap);
    }

    public static void clearCache(String region, String objType) {
        CacheTO cacheTo = new CacheTO();
        cacheTo.setKey(region);
        cacheTo.setObjecttype(objType);
        cacheTo.setAppname(CacheTagHelper.getCurrentApplicationName());
        cacheTo.setExact(false);
        GenericCacheFactory.getCache().remove(cacheTo);
    }

    private static void clearQueryCache(GenericCache cache) {
        if (cache != null) {
            cache.clearCache("QUERY");
        }
    }

    public static void remove(Map<Integer, CacheDetails> cachedQueryMap) {
        if (cachedQueryMap != null) {
            String appName = CacheTagHelper.getCurrentApplicationName();
            appName = appName == null ? "" : appName;
            Iterator<CacheDetails> itr = cachedQueryMap.values().iterator();
            GenericCache cacheMgr = null;
            while (itr.hasNext()) {
                Map<String, GenericCache> cacheManagerMap;
                CacheDetails details = itr.next();
                if ((details.getApplicationName() != null || details.getApplicationName().equals("")) && (cacheManagerMap = GenericCacheFactory.getCacheManagerMap()) != null) {
                    cacheMgr = cacheManagerMap.get(details.getApplicationName());
                }
                if (cacheMgr == null) {
                    cacheMgr = GenericCacheFactory.getServerWideCache();
                }
                if (cacheMgr == null) continue;
                CacheTO xObj = new CacheTO();
                xObj.setId(details.getCacheId());
                xObj.setKey(details.getCacheRegion());
                xObj.setObjecttype("QUERY");
                xObj.setAppname(details.getApplicationName());
                if (null == cacheMgr.get(xObj, false)) continue;
                cacheMgr.remove(xObj);
            }
        }
    }

    public static String getCacheKey(String region, String appName, String objType, String configFilePath) {
        FusionContext context = FusionContext.getCurrent();
        if (appName == null && context != null && (appName = context.getApplicationName()) == null && context.cacheConfig != null) {
            appName = context.cacheConfig.applicationName;
        }
        String string = appName = appName != null ? appName : "";
        if (region != null) {
            if (CacheTagHelper.isStandardCacheRegion((String)region)) {
                region = ((String)region).toUpperCase();
                if (!CacheTagHelper.isApplicationSpecificCache(configFilePath)) {
                    region = appName + (String)region;
                }
            }
            return region;
        }
        if (CacheTagHelper.isApplicationSpecificCache(configFilePath)) {
            return objType.toUpperCase();
        }
        return appName + objType.toUpperCase();
    }

    public static String getCacheKey2(String region, String appName, String objType, String configFilePath) {
        FusionContext context = FusionContext.getCurrent();
        if (appName == null && context != null && (appName = context.getApplicationName()) == null && context.cacheConfig != null) {
            appName = context.cacheConfig.applicationName;
        }
        String string = appName = appName != null ? appName : "";
        if (region != null) {
            if (CacheTagHelper.isStandardCacheRegion((String)region)) {
                region = ((String)region).toUpperCase();
                if (!CacheTagHelper.isApplicationSpecificCache(configFilePath)) {
                    region = appName.length() > 0 ? "servercache___" + appName + "___" + (String)region : "servercache___" + (String)region;
                }
            }
            return region;
        }
        if (CacheTagHelper.isApplicationSpecificCache(configFilePath)) {
            return objType.toUpperCase();
        }
        if (appName.length() > 0) {
            return "servercache___" + appName + "___" + objType.toUpperCase();
        }
        return "servercache___" + objType.toUpperCase();
    }

    public static String getCacheKey(String region, String appName, String objType, boolean isApplicationSpecificCache) {
        String string = appName = appName != null ? appName : "";
        if (region != null) {
            if (CacheTagHelper.isStandardCacheRegion((String)region)) {
                region = ((String)region).toUpperCase();
                if (!isApplicationSpecificCache) {
                    region = appName + (String)region;
                }
            }
            return region;
        }
        if (isApplicationSpecificCache) {
            return objType.toUpperCase();
        }
        return appName + objType.toUpperCase();
    }

    public static boolean isApplicationSpecificCache(String configFilePath) {
        return configFilePath != null;
    }

    public static boolean isStandardCacheRegion(String region) {
        return region != null && (region.equalsIgnoreCase("OBJECT") || region.equalsIgnoreCase("QUERY") || region.equalsIgnoreCase("TEMPLATE") || region.equalsIgnoreCase("NOSQL_QUERY"));
    }

    public static String resolveConfigFilePath(final String p) {
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    String baseDir;
                    String path = p;
                    File configFile = new File(path);
                    if (configFile.exists()) {
                        return path;
                    }
                    String appName = CacheTagHelper.getCurrentApplicationName();
                    ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(appName);
                    if (appScope != null && (baseDir = appScope.getApplicationPath()) != null && baseDir.length() > 0) {
                        String resolvedPath;
                        if ((baseDir.endsWith(".cfc") || baseDir.endsWith(".cfm")) && baseDir.length() > 16) {
                            baseDir = baseDir.substring(0, baseDir.length() - 16);
                        }
                        if (path.startsWith("/") || path.startsWith("\\")) {
                            path = path.substring(1, path.length());
                        }
                        if ((configFile = new File(resolvedPath = baseDir + File.separator + path)).exists()) {
                            return resolvedPath;
                        }
                        throw new CacheExceptions.CacheConfigFileNotFoundException(path);
                    }
                    return path;
                }
            });
        }
        catch (PrivilegedActionException e) {
            CFLogs.APPLICATION_LOG.error("Error reading application level properties from file : " + p, e);
            return p;
        }
    }

    public static String createMatchCriteria(String criteria) {
        criteria = StringFunc.REReplace(criteria, "([+?])", "_query_", "ALL", true);
        criteria = StringFunc.Replace(criteria, "*", ".*", "ALL");
        return criteria;
    }

    public static String calculateKeyHash(Object key) {
        return ((String)key).replaceAll("/", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getSerializedSize(Object obj) {
        if (!CacheTagHelper.isSerializable(obj)) {
            return 0L;
        }
        if (obj instanceof String) {
            return ((String)obj).getBytes().length;
        }
        if (obj instanceof Long) {
            return 8L;
        }
        if (obj instanceof Integer) {
            return 4L;
        }
        long size = 0L;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(bout);
            oos.writeObject(obj);
            long l = size = (long)bout.size();
            return l;
        }
        catch (IOException e) {
            try {
                long l = ServiceFactory.getCachingService().getObjectSize(obj);
                return l;
            }
            catch (Throwable t) {
                CFLogs.APPLICATION_LOG.error(t);
                long l = 0L;
                return l;
            }
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static final boolean isSerializable(Object value) {
        return CacheTagHelper.isKeySerializable(value) && (value instanceof Serializable || value == null);
    }

    public static final boolean isKeySerializable(Object key) {
        return key instanceof Serializable || key == null;
    }

    public static void setJCSClusterDsnName(String dsn, boolean override) throws Exception {
        String temp = JCSDSNNAME;
        JCSDSNNAME = dsn;
        try {
            CacheTagHelper.createTablesForJCSCluster(override);
        }
        catch (Exception e) {
            JCSDSNNAME = temp;
            CFLogs.APPLICATION_LOG.error(e);
            throw e;
        }
        GenericCacheFactory.resetCache(1);
    }

    public static void createTablesForJCSCluster(boolean override) throws Exception {
        if (!override && CacheTagHelper.isJCSClusterTablesCreated()) {
            return;
        }
        CFDataSource datasource = CacheTagHelper.getDatasource();
        Connection con = datasource.getConnection();
        String[] commands = new String[]{"drop TABLE JCS_STORE;", "CREATE TABLE JCS_STORE( CACHE_KEY VARCHAR(250) NOT NULL, REGION VARCHAR(250) NOT NULL, ELEMENT  BLOB, CREATE_TIME   DATETIME, CREATE_TIME_SECONDS         BIGINT, MAX_LIFE_SECONDS  BIGINT, SYSTEM_EXPIRE_TIME_SECONDS  BIGINT,UPDATE_TIME_SECONDS  BIGINT, IS_ETERNAL  CHAR(1), PRIMARY KEY (CACHE_KEY, REGION));", "alter table JCS_STORE MAX_ROWS = 10000000;", "alter table JCS_STORE AVG_ROW_LENGTH = 2100;", "create index JCS_STORE_DELETE_IDX on JCS_STORE (SYSTEM_EXPIRE_TIME_SECONDS,IS_ETERNAL,REGION);"};
        Statement st = con.createStatement();
        for (String command : commands) {
            try {
                st.executeUpdate(command);
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.error(e);
            }
        }
    }

    private static CFDataSource getDatasource() throws Exception {
        Class[] paramclass = new Class[]{String.class};
        Method m = DataSourceFactory.getInstance().getClass().getDeclaredMethod("getDataSource", paramclass);
        m.setAccessible(true);
        Object[] params = new Object[]{JCSDSNNAME};
        CFDataSource datasource = (CFDataSource)m.invoke((Object)DataSourceFactory.getInstance(), params);
        m.setAccessible(false);
        return datasource;
    }

    public static boolean isJCSClusterTablesCreated() {
        JCSDSNNAME = ((RuntimeServiceImpl)ServiceFactory.getRuntimeService()).getJCSClusterDsnName();
        if (null == JCSDSNNAME) {
            return false;
        }
        try {
            CFDataSource datasource = CacheTagHelper.getDatasource();
            Connection con = datasource.getConnection();
            String command = "select count(*) from jcs_store";
            Statement st = con.createStatement();
            st.executeQuery(command);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String objectToString(Object o) {
        String string;
        if (!(o instanceof Serializable)) {
            return o.toString();
        }
        if (o instanceof String) {
            Object str = (String)o;
            if (((String)str).endsWith(":")) {
                str = ((String)str).substring(0, ((String)str).length() - 1) + "$";
            }
            return str;
        }
        o.hashCode();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(o);
            string = Base64.getEncoder().encodeToString(baos.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    oos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                CFLogs.APPLICATION_LOG.error("Not able to serialize", e);
                return o.toString();
            }
        }
        oos.close();
        return string;
    }

    public static Object stringToObject(String s) {
        Object object;
        byte[] data = Base64.getDecoder().decode(s);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
        try {
            Object o = ois.readObject();
            ois.close();
            object = o;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                return s;
            }
        }
        ois.close();
        return object;
    }

    public static Map getCachingEngines() throws IOException {
        HashMap<String, Integer> engines = new HashMap<String, Integer>();
        try {
            String dir = ServiceFactory.getRuntimeService().getWebRoot() + File.separator + "CFIDE" + File.separator + "cache" + File.separator;
            int count = engines.size();
            List files = Files.list(Paths.get(dir, new String[0])).map(Path::getFileName).collect(Collectors.toList());
            for (Path file : files) {
                String fileName = file.normalize().toString();
                if (!CacheTagHelper.validateCustomCacheImpl("CFIDE.cache." + fileName + ".cache.cfc")) continue;
                engines.put(fileName, ++count);
            }
            return engines;
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error(e);
            return engines;
        }
    }

    public static boolean validateCustomCacheImpl(String eventhandler) {
        if (!eventhandler.toLowerCase().endsWith(".cfc") || eventhandler.contains("ICustomCache.cfc")) {
            return false;
        }
        eventhandler = eventhandler.substring(0, eventhandler.length() - 4);
        FusionContext fusionContext = FusionContext.getCurrent();
        NeoPageContext pageContext = fusionContext.pageContext;
        AttributeCollection metaData = null;
        String cfc = eventhandler;
        try {
            File cfcFile = TemplateProxyFactory.getResolvedFile(eventhandler, pageContext);
            eventhandler = cfcFile.getAbsolutePath();
            metaData = (AttributeCollection)MetadataUtils.getComponentMetadata(new File(eventhandler), pageContext, eventhandler, true);
        }
        catch (Throwable t) {
            CFLogs.APPLICATION_LOG.error(t);
            return false;
        }
        Object implement = metaData.get("IMPLEMENTS");
        boolean isImplemented = false;
        if (null != implement) {
            if (implement instanceof String) {
                if (((String)implement).toLowerCase().indexOf(EVENTHANDLER_IFC.toLowerCase()) >= 0) {
                    isImplemented = true;
                }
            } else if (implement instanceof AttributeCollection) {
                isImplemented = ((AttributeCollection)implement).containsKey(EVENTHANDLER_IFC);
            }
        }
        if (!isImplemented) {
            CFLogs.APPLICATION_LOG.error(eventhandler + " does not implement ICustomCache");
            return false;
        }
        return true;
    }

    public static void createDefaultCache(GenericCache cache, CacheConfig cacheConfig) {
        CaseInsensitiveHashtable prop = new CaseInsensitiveHashtable();
        if (!cache.isApplicationSpecificCache()) {
            prop.put("TIMETOIDLESECONDS", "720");
            prop.put("TIMETOLIVESECONDS", "720");
            prop.put("ETERNAL", "false");
            prop.put("MAXELEMENTSINMEMORY", "1000");
        } else {
            prop.put("TIMETOIDLESECONDS", "" + cacheConfig.getCacheIdleTime());
            prop.put("TIMETOLIVESECONDS", "" + cacheConfig.getCacheTimeSpan());
            prop.put("ETERNAL", "" + cacheConfig.isCacheEternal());
            prop.put("MAXELEMENTSINMEMORY", "" + cacheConfig.getCacheMaxElements());
        }
        try {
            cache.createCache("customcache", "OBJECT", null, prop);
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error("Error creating default cache", e);
        }
    }

    public static void readApplicationLevelProperties(String configFilePath, CacheConfig cacheConfig) {
        CacheTagHelper.readApplicationLevelProperties(configFilePath, cacheConfig, null);
    }

    public static void readApplicationLevelProperties(final String configFilePath, CacheConfig cacheConfig, Map config) {
        final Properties p = new Properties();
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    try (FileInputStream fis = new FileInputStream(configFilePath);){
                        p.load(fis);
                    }
                    catch (Exception e) {
                        throw new CacheExceptions.InvalidCacheConfigFileException();
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error("Error reading application level properties from file : " + configFilePath, e);
        }
        CaseInsensitiveHashtable props = new CaseInsensitiveHashtable((Map)p);
        try {
            if (props.containsKey("TIMETOIDLESECONDS")) {
                cacheConfig.setCacheIdleTime(Long.valueOf((String)props.get("TIMETOIDLESECONDS")));
            }
            try {
                if (config != null && config.containsKey("TIMETOIDLESECONDS")) {
                    cacheConfig.setCacheIdleTime(Long.valueOf((String)config.get("TIMETOIDLESECONDS")));
                }
            }
            catch (Exception e) {
                CFLogs.APPLICATION_LOG.error("Error reading TIMETOIDLESECONDS defined in application config settings ");
                CFLogs.APPLICATION_LOG.error(e);
                cacheConfig.setCacheIdleTime(86400L);
            }
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error("Error reading TIMETOIDLESECONDS in file " + configFilePath);
            CFLogs.APPLICATION_LOG.error(e);
            cacheConfig.setCacheIdleTime(86400L);
        }
        try {
            if (props.containsKey("TIMETOLIVESECONDS")) {
                cacheConfig.setCacheTimeSpan(Long.valueOf((String)props.get("TIMETOLIVESECONDS")));
            }
            try {
                if (config != null && config.containsKey("TIMETOLIVESECONDS")) {
                    cacheConfig.setCacheTimeSpan(Long.valueOf((String)config.get("TIMETOLIVESECONDS")));
                }
            }
            catch (Exception e) {
                CFLogs.APPLICATION_LOG.error("Error reading TIMETOLIVESECONDS defined in application config settings ");
                CFLogs.APPLICATION_LOG.error(e);
                cacheConfig.setCacheTimeSpan(86400L);
            }
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error("Error reading TIMETOLIVESECONDS in file " + configFilePath);
            CFLogs.APPLICATION_LOG.error(e);
            cacheConfig.setCacheTimeSpan(86400L);
        }
        try {
            if (props.containsKey("ETERNAL")) {
                cacheConfig.setCacheEternal(Cast._boolean(props.get("ETERNAL")));
            }
            try {
                if (config != null && config.containsKey("ETERNAL")) {
                    cacheConfig.setCacheEternal(Cast._boolean(config.get("ETERNAL")));
                }
            }
            catch (Exception e) {
                CFLogs.APPLICATION_LOG.error("Error reading ETERNAL defined in application config settings ");
                CFLogs.APPLICATION_LOG.error(e);
                cacheConfig.setCacheEternal(false);
            }
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error("Error reading ETERNAL in file " + configFilePath);
            CFLogs.APPLICATION_LOG.error(e);
            cacheConfig.setCacheEternal(false);
        }
        try {
            if (props.containsKey("MAXELEMENTSINMEMORY")) {
                cacheConfig.setCacheMaxElements(Integer.valueOf((String)props.get("MAXELEMENTSINMEMORY")));
            }
            try {
                if (config != null && config.containsKey("MAXELEMENTSINMEMORY")) {
                    cacheConfig.setCacheMaxElements(Integer.valueOf((String)config.get("MAXELEMENTSINMEMORY")));
                }
            }
            catch (Exception e) {
                CFLogs.APPLICATION_LOG.error("Error reading MAXELEMENTSINMEMORY defined in application config settings ");
                CFLogs.APPLICATION_LOG.error(e);
                cacheConfig.setCacheMaxElements(10000);
            }
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error("Error reading MAXELEMENTSINMEMORY in file " + configFilePath);
            CFLogs.APPLICATION_LOG.error(e);
            cacheConfig.setCacheMaxElements(10000);
        }
        try {
            if (props.containsKey("EVICTIONCHUNKSIZE")) {
                cacheConfig.setCacheSpoolChunkSize(Integer.valueOf((String)props.get("EVICTIONCHUNKSIZE")));
            }
            try {
                if (config != null && config.containsKey("EVICTIONCHUNKSIZE")) {
                    cacheConfig.setCacheSpoolChunkSize(Integer.valueOf((String)config.get("EVICTIONCHUNKSIZE")));
                }
            }
            catch (Exception e) {
                CFLogs.APPLICATION_LOG.error("Error reading EVICTIONCHUNKSIZE defined in application config settings ");
                CFLogs.APPLICATION_LOG.error(e);
                cacheConfig.setCacheSpoolChunkSize(100);
            }
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error("Error reading EVICTIONCHUNKSIZE in file " + configFilePath);
            CFLogs.APPLICATION_LOG.error(e);
            cacheConfig.setCacheSpoolChunkSize(100);
        }
        try {
            if (props.containsKey("METADATA")) {
                cacheConfig.setCacheMetadata(Cast._boolean(props.get("METADATA")));
            }
            try {
                if (config != null && config.containsKey("METADATA")) {
                    cacheConfig.setCacheMetadata(Cast._boolean(config.get("METADATA")));
                }
            }
            catch (Exception e) {
                CFLogs.APPLICATION_LOG.error("Error reading METADATA defined in application config settings ");
                CFLogs.APPLICATION_LOG.error(e);
                cacheConfig.setCacheMetadata(true);
            }
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error("Error reading METADATA in file " + configFilePath);
            CFLogs.APPLICATION_LOG.error(e);
            cacheConfig.setCacheMetadata(true);
        }
        try {
            if (props.containsKey("MAXIDLELAZYEVICTION")) {
                cacheConfig.setCacheMaxIdleLazyEviction(Cast._boolean(props.get("MAXIDLELAZYEVICTION")));
            }
            try {
                if (config != null && config.containsKey("MAXIDLELAZYEVICTION")) {
                    cacheConfig.setCacheMaxIdleLazyEviction(Cast._boolean(config.get("MAXIDLELAZYEVICTION")));
                }
            }
            catch (Exception e) {
                CFLogs.APPLICATION_LOG.error("Error reading MAXIDLELAZYEVICTION defined in application config settings ");
                CFLogs.APPLICATION_LOG.error(e);
                cacheConfig.setCacheMaxIdleLazyEviction(true);
            }
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error("Error reading MAXIDLELAZYEVICTION in file " + configFilePath);
            CFLogs.APPLICATION_LOG.error(e);
            cacheConfig.setCacheMaxIdleLazyEviction(true);
        }
        try {
            if (props.containsKey("MAXELEMENTSCHECK")) {
                cacheConfig.setCacheMaxElementsCheck(Cast._boolean(props.get("MAXELEMENTSCHECK")));
            }
            try {
                if (config != null && config.containsKey("MAXELEMENTSCHECK")) {
                    cacheConfig.setCacheMaxElementsCheck(Cast._boolean(config.get("MAXELEMENTSCHECK")));
                }
            }
            catch (Exception e) {
                CFLogs.APPLICATION_LOG.error("Error reading MAXELEMENTSCHECK defined in application config settings ");
                CFLogs.APPLICATION_LOG.error(e);
                cacheConfig.setCacheMaxElementsCheck(true);
            }
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error("Error reading MAXELEMENTSCHECK in file " + configFilePath);
            CFLogs.APPLICATION_LOG.error(e);
            cacheConfig.setCacheMaxElementsCheck(true);
        }
    }

    public static String getTrimmedCacheName(String cacheName, String appname) {
        if (cacheName.startsWith("servercache___")) {
            cacheName = cacheName.substring(cacheName.indexOf("servercache") + "servercache".length() + "___".length());
        }
        if (appname != null && appname.length() > 0 && cacheName.startsWith(appname)) {
            cacheName = cacheName.substring(cacheName.indexOf(appname) + appname.length() + "___".length());
        }
        return cacheName;
    }

    public static boolean skipRegionForMonitoring(String region, String confgiFile, String applicationName, boolean server) {
        if (region.endsWith("stats_region")) {
            return true;
        }
        if (region.endsWith("authtokenmappingcache") || region.endsWith("authcache")) {
            return true;
        }
        if (applicationName != null && applicationName.equals("cfadmin")) {
            return true;
        }
        if (region.startsWith("servercache___") && !server) {
            return true;
        }
        if (server && !region.startsWith("servercache___")) {
            return true;
        }
        if (server && applicationName != null && !region.contains(applicationName)) {
            return true;
        }
        if (confgiFile == null && !region.startsWith("servercache___")) {
            return true;
        }
        if (confgiFile == null && applicationName == null && region.split("___").length > 2) {
            return true;
        }
        return confgiFile != null && !region.startsWith(applicationName);
    }

    public static String getRegionNameForMonitoring(String region, String applicationName, GenericCache cache, boolean server) {
        Object metaname = region;
        if (!cache.isApplicationSpecificCache()) {
            metaname = region.substring("servercache".length() + "___".length(), region.length());
        }
        if (applicationName != null && applicationName.length() > 0 && ((String)metaname).startsWith(applicationName)) {
            metaname = ((String)metaname).substring(applicationName.length() + "___".length(), ((String)metaname).length());
        }
        if (server && applicationName != null) {
            metaname = applicationName + (String)metaname;
        }
        return metaname;
    }

    public static String getServerSetting(String key, String type) {
        Object fileName = type + "cache.properties";
        String file = ServiceFactory.getRuntimeService().getLibDir() + "/" + type + "cache.properties";
        if (type.equalsIgnoreCase("jcs")) {
            file = ServiceFactory.getRuntimeService().getLibDir() + "/cache.ccf";
            fileName = "cache.ccf";
            if (key.equalsIgnoreCase("timeToIdleSeconds")) {
                key = "jcs.default.elementattributes.IdleTime";
            }
            if (key.equalsIgnoreCase("timeToLiveSeconds")) {
                key = "jcs.default.elementattributes.MaxLife";
            }
            if (key.equalsIgnoreCase("eternal")) {
                key = "jcs.default.elementattributes.IsEternal";
            }
            if (key.equalsIgnoreCase("maxElementsInMemory")) {
                key = "jcs.default.cacheattributes.MaxObjects";
            }
        }
        final String finalFile = file;
        final String finalFileName = fileName;
        final Properties prop = new Properties();
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    try {
                        File fileFromCCS = CentralConfigClientUtil.pullFromCCSFile(finalFileName);
                        if (fileFromCCS != null) {
                            prop.load(new FileInputStream(fileFromCCS));
                        } else {
                            prop.load(new FileInputStream(finalFile));
                        }
                    }
                    catch (Exception e) {
                        throw new CacheException();
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error("Error reading server level properties for cache engine : " + type, e);
        }
        return prop.getProperty(key);
    }

    public static void setServerSetting(String key, String type, Object value) {
        Object fileName = type + "cache.properties";
        String file = ServiceFactory.getRuntimeService().getLibDir() + "/" + type + "cache.properties";
        if (type.equalsIgnoreCase("jcs")) {
            file = ServiceFactory.getRuntimeService().getLibDir() + "/cache.ccf";
            fileName = "cache.ccf";
            if (key.equalsIgnoreCase("timeToIdleSeconds")) {
                key = "jcs.default.elementattributes.IdleTime";
            }
            if (key.equalsIgnoreCase("timeToLiveSeconds")) {
                key = "jcs.default.elementattributes.MaxLife";
            }
            if (key.equalsIgnoreCase("eternal")) {
                key = "jcs.default.elementattributes.IsEternal";
            }
            if (key.equalsIgnoreCase("maxElementsInMemory")) {
                key = "jcs.default.cacheattributes.MaxObjects";
            }
        }
        Properties prop = new Properties();
        final String finalFile = file;
        Object finalFileName = fileName;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){
                final /* synthetic */ String val$finalFileName;
                final /* synthetic */ Properties val$prop;
                final /* synthetic */ String val$finalFile;
                {
                    this.val$finalFileName = string;
                    this.val$prop = properties;
                    this.val$finalFile = string2;
                }

                public Object run() {
                    try {
                        File fileFromCCS = CentralConfigClientUtil.pullFromCCSFile(this.val$finalFileName);
                        if (fileFromCCS != null) {
                            this.val$prop.load(new FileInputStream(fileFromCCS));
                        } else {
                            this.val$prop.load(new FileInputStream(this.val$finalFile));
                        }
                    }
                    catch (Exception e) {
                        throw new CacheException();
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error("Error setting server level properties for cache engine : " + type, e);
        }
        try {
            prop.put(key, "" + value);
            final Properties tmp = new Properties(){

                @Override
                public synchronized Enumeration<Object> keys() {
                    return Collections.enumeration(new TreeSet<Object>(super.keySet()));
                }
            };
            tmp.putAll((Map<?, ?>)prop);
            AccessController.doPrivileged(new PrivilegedExceptionAction(){
                final /* synthetic */ String val$finalFileName;
                {
                    this.val$finalFileName = string2;
                }

                public Object run() {
                    try (FileOutputStream fos = new FileOutputStream(finalFile);){
                        tmp.store(fos, null);
                    }
                    catch (Exception e) {
                        CFLogs.APPLICATION_LOG.error(e);
                    }
                    CentralConfigClientUtil.modifyFileMetadata(new File(finalFile));
                    try {
                        CentralConfigClientUtil.pushToCCS(this.val$finalFileName, tmp);
                    }
                    catch (Exception e) {
                        CFLogs.APPLICATION_LOG.error(e);
                    }
                    return null;
                }
            });
        }
        catch (Exception ex) {
            CFLogs.APPLICATION_LOG.error(ex);
        }
    }

    public static Struct getCacheServerSettings(String engine) {
        final Properties p = new Properties();
        final String serverPropFile = ServiceFactory.getRuntimeService().getLibDir() + "/" + engine + "cache.properties";
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    try (FileInputStream fis = new FileInputStream(serverPropFile);){
                        p.load(fis);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            });
            CaseInsensitiveHashtable props = new CaseInsensitiveHashtable((Map)p);
            Struct s = new Struct();
            if (props.containsKey("MAXIDLELAZYEVICTION")) {
                s.put("MAXIDLELAZYEVICTION", (Object)Cast._boolean(props.get("MAXIDLELAZYEVICTION")));
            }
            if (props.containsKey("MAXELEMENTSCHECK")) {
                s.put("MAXELEMENTSCHECK", (Object)Cast._boolean(props.get("MAXELEMENTSCHECK")));
            }
            if (props.containsKey("METADATA")) {
                s.put("METADATA", (Object)Cast._boolean(props.get("METADATA")));
            }
            if (props.containsKey("EVICTIONCHUNKSIZE")) {
                s.put("EVICTIONCHUNKSIZE", (Object)Cast._int(props.get("EVICTIONCHUNKSIZE")));
            }
            if (props.containsKey("IDLETIMECHECKTHREADINTERVAL")) {
                s.put("IDLETIMECHECKTHREADINTERVAL", (Object)Cast._int(props.get("IDLETIMECHECKTHREADINTERVAL")));
            }
            return s;
        }
        catch (Exception e) {
            throw new CacheException();
        }
    }

    public static String verifyMemcachedConnection(String server) {
        return ServiceFactory.getCachingService().verifyMemcachedConnection(server);
    }
}

