/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.io.cache;

import coldfusion.featurerouter.EFRConstants;
import coldfusion.featurerouter.FeatureRouter;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.runtime.Struct;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.io.cache.GenericCache;
import coldfusion.util.CaseInsensitiveHashtable;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class GenericCacheFactory {
    private static final int CACHETYPE_UNKNOWN = -1;
    public static final int EHCACHE_TYPE = 0;
    public static final int JCS_TYPE = 1;
    public static final int REDIS_TYPE = 2;
    public static final int MEMCACHED_TYPE = 3;
    public static CaseInsensitiveHashtable cacheEngineMap = new CaseInsensitiveHashtable();
    public static final String CACHE_SETTINGS = "cache";
    private static final String CACHE_CONFIG = "configfile";
    private static final String CACHE_ENGINE = "engine";
    public static final String CACHE_QUERY_SIZE = "querysize";
    public static final String USE_INTERNAL_QUERY_CACHE = "useinternalquerycache";
    private static int currentCacheType;
    private static GenericCache currentCacheImpl;
    private static GenericCache currentCacheImplCFLogin;
    private static Map<String, GenericCache> cacheManagerMap;
    protected static Logger logger;

    public static ArrayList getAllServerCacheMetadata() {
        ArrayList list = new ArrayList();
        if (cacheManagerMap != null) {
            for (Map.Entry<String, GenericCache> entry : cacheManagerMap.entrySet()) {
                GenericCache cache = entry.getValue();
                try {
                    list.addAll(cache.getAllCacheMetadataForMonitoring(true));
                }
                catch (Throwable th) {
                    logger.error(th);
                }
            }
        }
        try {
            list.addAll(GenericCacheFactory.getServerWideCache().getAllCacheMetadataForMonitoring(true));
        }
        catch (Throwable th) {
            logger.error(th);
        }
        Iterator iter = list.iterator();
        ArrayList<Struct> finalList = new ArrayList<Struct>();
        HashSet<String> regions = new HashSet<String>();
        while (iter.hasNext()) {
            Struct s = (Struct)iter.next();
            String region = (String)s.get("APPLICATIONNAME");
            if (region != null && regions.contains(region)) continue;
            regions.add(region);
            finalList.add(s);
        }
        finalList.sort(new Comparator<Struct>(){

            @Override
            public int compare(Struct o1, Struct o2) {
                return ((String)o1.get("APPLICATIONNAME")).compareTo((String)o2.get("APPLICATIONNAME"));
            }
        });
        return finalList;
    }

    public static GenericCache getCFLoginRedisSessionStorage() {
        return GenericCacheFactory.getCache(true);
    }

    public static GenericCache getCache() {
        return GenericCacheFactory.getCache(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static GenericCache getCache(boolean isCFLoginRedisSessionStorage) {
        GenericCache temp;
        if (isCFLoginRedisSessionStorage) {
            return GenericCacheFactory.getRedisForCFLogin();
        }
        FusionContext context = FusionContext.getCurrent();
        String appName = "";
        boolean cacheType = false;
        if (context == null) return GenericCacheFactory.getServerWideCache();
        if (appName == null || appName.length() == 0) {
            appName = context.getApplicationName();
        }
        if (appName == null && context.cacheConfig.applicationName != null) {
            appName = context.cacheConfig.applicationName;
        }
        if (appName == null) return GenericCacheFactory.getServerWideCache();
        if (appName.equals("")) return GenericCacheFactory.getServerWideCache();
        if (cacheManagerMap == null) {
            Class<GenericCacheFactory> clazz = GenericCacheFactory.class;
            // MONITORENTER : coldfusion.tagext.io.cache.GenericCacheFactory.class
            if (cacheManagerMap == null) {
                cacheManagerMap = new HashMap<String, GenericCache>();
            }
            // MONITOREXIT : clazz
        }
        if ((temp = cacheManagerMap.get(appName)) != null) {
            return temp;
        }
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(appName);
        if (appScope == null) return GenericCacheFactory.getServerWideCache();
        Map settingsMap = appScope.getApplicationSettingsMap();
        Map cacheSettings = (Map)settingsMap.get(CACHE_SETTINGS);
        String cacheConfigPath = null;
        String engine = null;
        Map configMap = null;
        if (cacheSettings != null) {
            cacheConfigPath = (String)cacheSettings.get(CACHE_CONFIG);
            if (null == cacheConfigPath) {
                cacheConfigPath = (String)cacheSettings.get("config");
            }
            engine = (String)cacheSettings.get(CACHE_ENGINE);
            Object config = cacheSettings.get("config");
            if (null != config && config instanceof Map) {
                configMap = (Map)config;
            }
        }
        int ct = 0;
        if (isCFLoginRedisSessionStorage) {
            ct = 2;
        } else if (engine == null) {
            GenericCacheFactory.getCacheType();
            ct = currentCacheType;
        } else {
            ct = null == cacheEngineMap.get(engine) ? -1 : (Integer)cacheEngineMap.get(engine);
        }
        temp = ServiceFactory.getCachingService().getCachingEngineImpl(ct, cacheConfigPath, appName, configMap, engine, isCFLoginRedisSessionStorage);
        cacheManagerMap.put(appName, temp);
        return temp;
    }

    private static void checkForEnterpriseAccess() {
        if (!FeatureRouter.getInstance().isFeatureAllowed(EFRConstants.cache_new_engines)) {
            throw new CachingFeatureNotAvailableException(EFRConstants.cache_new_engines);
        }
    }

    public static synchronized void setCacheType(int type) {
        if (type != 0 && type != 1) {
            GenericCacheFactory.checkForEnterpriseAccess();
        }
        currentCacheImpl = null;
        currentCacheType = type;
        if (null != cacheManagerMap) {
            ArrayList<String> serverApps = new ArrayList<String>();
            for (Map.Entry<String, GenericCache> entry : cacheManagerMap.entrySet()) {
                GenericCache value = entry.getValue();
                if (value.isApplicationSpecificCache()) continue;
                serverApps.add(entry.getKey());
            }
            for (String app : serverApps) {
                cacheManagerMap.remove(app);
            }
        }
    }

    public static synchronized int getCacheType() {
        currentCacheType = ((RuntimeServiceImpl)ServiceFactory.getRuntimeService()).getServerCacheType();
        return currentCacheType;
    }

    public static Map<String, GenericCache> getCacheManagerMap() {
        return cacheManagerMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GenericCache getServerWideCache() {
        if (currentCacheImpl != null) return currentCacheImpl;
        Class<GenericCacheFactory> clazz = GenericCacheFactory.class;
        synchronized (GenericCacheFactory.class) {
            if (currentCacheImpl != null) return currentCacheImpl;
            currentCacheImpl = ServiceFactory.getCachingService().getServerCachingEngineImpl(GenericCacheFactory.getCacheType());
            // ** MonitorExit[var0] (shouldn't be in output)
            return currentCacheImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GenericCache getRedisForCFLogin() {
        if (currentCacheImplCFLogin != null) return currentCacheImplCFLogin;
        Class<GenericCacheFactory> clazz = GenericCacheFactory.class;
        synchronized (GenericCacheFactory.class) {
            if (currentCacheImplCFLogin != null) return currentCacheImplCFLogin;
            currentCacheImplCFLogin = ServiceFactory.getCachingService().getRedisForCFLogin();
            // ** MonitorExit[var0] (shouldn't be in output)
            return currentCacheImplCFLogin;
        }
    }

    public static void stopCacheManager(String application) {
        if (application != null && cacheManagerMap != null) {
            GenericCache cacheManager = cacheManagerMap.get(application);
            if (cacheManager != null && ServiceFactory.getCachingService(false) != null) {
                ServiceFactory.getCachingService().stopCacheManager(cacheManager);
            }
            cacheManagerMap.remove(application);
        }
    }

    public static void resetCache(int cacheType) {
        if (null == cacheManagerMap) {
            return;
        }
        for (Map.Entry<String, GenericCache> entry : cacheManagerMap.entrySet()) {
            GenericCache cache = entry.getValue();
            GenericCacheFactory.resetCache(cache, cacheType);
        }
        GenericCacheFactory.resetCache(currentCacheImpl, cacheType);
    }

    private static void resetCache(GenericCache cache, int cacheType) {
        ServiceFactory.getCachingService().resetCache(cache, cacheType);
    }

    static {
        cacheEngineMap.put("jcs", (Object)1);
        cacheEngineMap.put("ehcache", (Object)0);
        cacheEngineMap.put("redis", (Object)2);
        cacheEngineMap.put("memcached", (Object)3);
        currentCacheType = -1;
        currentCacheImpl = null;
        currentCacheImplCFLogin = null;
        cacheManagerMap = null;
        logger = CFLogs.MONITOR_LOG;
        try {
            URL url = GenericCacheFactory.class.getProtectionDomain().getCodeSource().getLocation();
            String jarPath = URLDecoder.decode(url.getFile(), "UTF-8");
            System.setProperty("net.sf.ehcache.sizeof.filter", "jar:file:" + jarPath + "!/coldfusion/tagext/io/cache/ehcache/cf-sizeof.filter");
        }
        catch (Exception e) {
            logger.error("CF Built-in sizeof filter could not be loaded", e);
        }
    }

    public static class CachingFeatureNotAvailableException
    extends ApplicationException {
        public String featureName;

        public CachingFeatureNotAvailableException(int featureCode) {
            this.featureName = EFRConstants.getFeatureName(featureCode);
        }
    }
}

