/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.lang;

import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.CustomException;
import coldfusion.runtime.DatabaseException;
import coldfusion.runtime.LockException;
import coldfusion.runtime.MissingIncludeException;
import coldfusion.runtime.ObjectException;
import coldfusion.runtime.TemplateException;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.InvalidTagAttributeException;
import coldfusion.util.Utils;
import jakarta.servlet.jsp.JspException;
import java.io.File;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;

public class ErrorTag
extends GenericTag {
    private String type = "request";
    private String template;
    private String mailto = "";
    private String exceptionType = "any";

    public void setType(String s) {
        this.type = s;
    }

    public void setTemplate(String s) {
        this.template = s;
    }

    public void setMailto(String s) {
        this.mailto = s;
    }

    public void setException(String s) {
        this.exceptionType = s;
    }

    public int doStartTag() throws JspException {
        String sTemp;
        File file;
        this.onTagStart();
        Object resolvedTemplate = null;
        String fullPath = this.fContext.getPagePath();
        fullPath = Utils.getCanonicalPath(fullPath);
        int separatorPos = fullPath.lastIndexOf(File.separatorChar);
        String dir = "";
        if (separatorPos != -1) {
            dir = fullPath.substring(0, separatorPos + 1);
        }
        if ((file = new File(dir + this.template)).exists()) {
            resolvedTemplate = dir + this.template;
        }
        if (resolvedTemplate == null && (this.template.startsWith("/") || this.template.startsWith("\\")) && (file = new File(sTemp = this.fContext.getRealPath(this.template))).exists()) {
            resolvedTemplate = sTemp;
        }
        if (resolvedTemplate == null) {
            throw new InvalidErrorTemplateException(this.template);
        }
        if (this.type.equalsIgnoreCase("validation")) {
            this.fContext.setValidationErrorHandler((String)resolvedTemplate);
        } else if (this.type.equalsIgnoreCase("exception")) {
            if ("Application".equalsIgnoreCase(this.exceptionType)) {
                this.fContext.addExceptionHandler((String)resolvedTemplate, ApplicationException.class, this.mailto);
            } else if ("Database".equalsIgnoreCase(this.exceptionType)) {
                this.fContext.addExceptionHandler((String)resolvedTemplate, DatabaseException.class, this.mailto);
            } else if ("Lock".equalsIgnoreCase(this.exceptionType)) {
                this.fContext.addExceptionHandler((String)resolvedTemplate, LockException.class, this.mailto);
            } else if ("Object".equalsIgnoreCase(this.exceptionType)) {
                this.fContext.addExceptionHandler((String)resolvedTemplate, ObjectException.class, this.mailto);
            } else if ("MissingInclude".equalsIgnoreCase(this.exceptionType)) {
                this.fContext.addExceptionHandler((String)resolvedTemplate, MissingIncludeException.class, this.mailto);
            } else if ("Template".equalsIgnoreCase(this.exceptionType)) {
                this.fContext.addExceptionHandler((String)resolvedTemplate, TemplateException.class, this.mailto);
            } else if ("Security".equalsIgnoreCase(this.exceptionType)) {
                this.fContext.addExceptionHandler((String)resolvedTemplate, AccessControlException.class, this.mailto);
            } else if ("Expression".equalsIgnoreCase(this.exceptionType)) {
                this.fContext.addExceptionHandler((String)resolvedTemplate, RuntimeException.class, this.mailto);
            } else if ("Any".equalsIgnoreCase(this.exceptionType)) {
                this.fContext.addExceptionHandler((String)resolvedTemplate, Throwable.class, this.mailto);
            } else {
                try {
                    Class<?> c = null;
                    if (System.getSecurityManager() == null) {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        c = cl.loadClass(this.exceptionType);
                    } else {
                        c = (Class<?>)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return Thread.currentThread().getContextClassLoader().loadClass(ErrorTag.this.exceptionType);
                            }
                        });
                    }
                    this.fContext.addExceptionHandler((String)resolvedTemplate, c, this.mailto);
                }
                catch (Exception ex) {
                    this.fContext.addExceptionHandler((String)resolvedTemplate, CustomException.class, this.mailto);
                }
            }
        } else if (this.type.equalsIgnoreCase("request")) {
            this.fContext.setRequestErrorHandler((String)resolvedTemplate, this.mailto);
        } else {
            throw new InvalidTagAttributeException("CFERROR", "type", this.type);
        }
        this.doEndTag();
        return 0;
    }

    public static final class InvalidErrorTemplateException
    extends MissingIncludeException {
        public InvalidErrorTemplateException(String template) {
            super(template);
        }
    }
}

