/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.lang;

import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Cast;
import coldfusion.runtime.NeoPageContext;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.lang.ProcessExecutor;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import coldfusion.vfs.VFile;
import jakarta.servlet.jsp.JspException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Vector;

public class ExecuteTag
extends GenericTag {
    private static final GenericTagPermission tp = new GenericTagPermission("cfexecute");
    protected String name;
    protected Object args;
    protected String outFile = null;
    protected String errFile = null;
    protected int timeout = 0;
    protected String sVarName;
    protected String eVarName;

    @Override
    protected Permission getPermission() {
        return tp;
    }

    @Override
    public void release() {
        this.name = null;
        this.args = null;
        this.outFile = null;
        this.timeout = 0;
        this.errFile = null;
        this.sVarName = null;
        this.eVarName = null;
        super.release();
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public void setArguments(Object a) {
        this.args = a;
    }

    public Object getArguments() {
        return this.args;
    }

    public void setOutputfile(String f) {
        this.outFile = Utils.getFileFullPath(f, this.pageContext);
    }

    public String getOutputfile() {
        return this.outFile;
    }

    public void setErrorfile(String f) {
        this.errFile = Utils.getFileFullPath(f, this.pageContext);
    }

    public String getErrorfile() {
        return this.errFile;
    }

    public void setTimeout(int s) {
        this.timeout = s * 1000;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setVariable(String varName) {
        this.sVarName = varName;
    }

    public String getVariable() {
        return this.sVarName;
    }

    public void setErrorVariable(String varName) {
        this.eVarName = varName;
    }

    public String getErrorVariable() {
        return this.eVarName;
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        String[] cmd = this.getProcessCommand();
        ProcessExecutor executor = new ProcessExecutor(cmd, this.outFile, this.errFile);
        executor.setTimeout(this.timeout);
        try {
            executor.execute();
        }
        catch (ProcessExecutor.ProcessTimedOutException timedOutException) {
            throw new TimeoutException(this.name);
        }
        catch (ProcessExecutor.OutFileNotFoundException fne) {
            throw new FileNotFoundException(fne, fne.getFile());
        }
        catch (IOException e) {
            throw new ProcessException((Throwable)e);
        }
        catch (SecurityException se) {
            throw new ProcessException((Throwable)se);
        }
        String result = executor.getResult();
        if (result != null) {
            if (this.sVarName != null) {
                ((NeoPageContext)this.pageContext).setArrayAttribute(this.sVarName, result);
            } else if (this.outFile == null) {
                try {
                    this.pageContext.getOut().print(result);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (this.eVarName != null) {
            ((NeoPageContext)this.pageContext).setArrayAttribute(this.eVarName, executor.getError());
        }
        this.onTagEnd();
        return 0;
    }

    private String[] getProcessCommand() {
        ArrayList<String> al = new ArrayList<String>();
        al.add(this.name);
        if (this.args != null) {
            if (this.args instanceof Vector) {
                Vector v = (Vector)this.args;
                int size = v.size();
                for (int i = 0; i < size; ++i) {
                    al.add(Cast._String(v.elementAt(i)));
                }
            } else if (this.args instanceof ArrayList) {
                ArrayList a = (ArrayList)this.args;
                for (int i = 0; i < a.size(); ++i) {
                    al.add(Cast._String(a.get(i)));
                }
            } else if (this.args.getClass().isArray()) {
                int length = Array.getLength(this.args);
                for (int i = 0; i < length; ++i) {
                    al.add(Cast._String(Array.get(this.args, i)));
                }
            } else if (this.args instanceof String) {
                StringBuffer argument = new StringBuffer();
                boolean quoting = false;
                StringBuffer CmdBuffer = new StringBuffer((String)this.args);
                for (int i = 0; i < CmdBuffer.length(); ++i) {
                    char argChar = CmdBuffer.charAt(i);
                    if (argChar == '\"' && (argument.length() == 0 || quoting)) {
                        if (quoting) {
                            al.add(argument.toString());
                            argument = new StringBuffer();
                        }
                        quoting = !quoting;
                        continue;
                    }
                    if (argChar == ' ' && !quoting) {
                        if (argument.length() <= 0) continue;
                        al.add(argument.toString());
                        argument = new StringBuffer();
                        continue;
                    }
                    argument.append(argChar);
                }
                if (argument.length() > 0) {
                    al.add(argument.toString());
                }
            } else {
                al.add(Cast._String(this.args));
            }
        }
        return al.toArray(new String[0]);
    }

    public class TimeoutException
    extends ApplicationException {
        public String Application = null;

        TimeoutException(String application) {
            this.Application = application;
        }
    }

    public class FileNotFoundException
    extends ApplicationException {
        public String outFile;

        public FileNotFoundException(Throwable e, String outFile) {
            super(e);
            this.outFile = this.getFriendlyPath(outFile);
        }

        private String getFriendlyPath(String path) {
            File f = VFSFileFactory.getFileObject(path);
            return f instanceof VFile ? ((VFile)f).getFriendlyName() : path;
        }
    }

    public class ProcessException
    extends ApplicationException {
        ProcessException(Throwable ex) {
            super(ex);
        }
    }
}

