/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.lang;

import coldfusion.monitor.beans.TagAttribute;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Array;
import coldfusion.runtime.CFPage;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.util.RuntimeWrapper;
import jakarta.servlet.jsp.JspException;
import java.security.Permission;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ObjectTag
extends GenericTag {
    private static final GenericTagPermission tp = new GenericTagPermission("cfobject");
    private String type = "component";
    private String action = "Create";
    private String className;
    private String name;
    private String context = null;
    private String server = null;
    private String domain = null;
    private String locale = null;
    private String assembly = null;
    private String protocol = "tcp";
    private boolean secure = false;
    private int port;
    private String wsportName = null;
    private String wsdl2javaArgs = null;
    private String wsversion = null;
    private String username = null;
    private String password = null;
    private String proxyServer = null;
    private String proxyPort = null;
    private String proxyUser = null;
    private String proxyPassword = null;
    private boolean refreshwsdl = false;
    private String workstation;
    private String ntlmdomain;
    private String authtype;
    private List<String> loadPaths = null;
    protected static final String BASIC_AUTH = "BASIC";
    protected static final String NTLM_AUTH = "NTLM";

    @Override
    protected Permission getPermission() {
        return tp;
    }

    public void setType(String s) {
        this.type = s.trim();
    }

    public String getType() {
        return this.type;
    }

    public void setAction(String s) {
        this.action = s.trim();
    }

    public String getAction() {
        return this.action;
    }

    public void setClass(String s) {
        this.className = s.trim();
    }

    public String getObjectTagClass() {
        return this.className;
    }

    public void setComponent(String s) {
        this.type = "component";
        this.action = "create";
        this.className = s.trim();
    }

    public String getComponent() {
        return this.className;
    }

    public void setWebservice(String s) {
        this.type = "webservice";
        this.action = "create";
        this.className = s.trim();
    }

    public String getWebservice() {
        return this.className;
    }

    public void setName(String s) {
        this.name = s.trim();
        if (this.name.length() == 0) {
            throw new InvalidNameException();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setContext(String c) {
        this.context = c.trim();
    }

    public String getContext() {
        return this.context;
    }

    public void setServer(String s) {
        this.server = s.trim();
    }

    public String getServer() {
        return this.server;
    }

    public void setDomain(String s) {
        this.domain = s.trim();
    }

    public String getDomain() {
        return this.domain;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setLocale(String s) {
        this.locale = s.trim();
    }

    public String getLocale() {
        return this.locale;
    }

    public String getAssembly() {
        return this.assembly;
    }

    public void setAssembly(String assembly) {
        this.assembly = assembly.trim();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        if (!(protocol = protocol.trim()).equalsIgnoreCase("tcp") && !protocol.equalsIgnoreCase("http")) {
            throw new InvalidProtocolException(protocol);
        }
        this.protocol = protocol;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setWsportName(String wsportName) {
        this.wsportName = wsportName.trim();
    }

    public void setWsversion(String wsversion) {
        this.wsversion = wsversion;
    }

    public void setWsdl2javaArgs(String wsdl2javaArgs) {
        this.wsdl2javaArgs = wsdl2javaArgs;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setProxyServer(String proxyServer) {
        this.proxyServer = proxyServer;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void setRefreshwsdl(boolean refreshwsdl) {
        this.refreshwsdl = refreshwsdl;
    }

    public String getWorkstation() {
        return this.workstation;
    }

    public void setWorkstation(String workstation) {
        this.workstation = workstation;
    }

    public String getAuthtype() {
        return this.authtype;
    }

    public void setAuthtype(String authtype) {
        if (!(authtype == null || authtype.equalsIgnoreCase("none") || authtype.equalsIgnoreCase(BASIC_AUTH) || authtype.equalsIgnoreCase(NTLM_AUTH))) {
            throw new UnsupportedAuthenticationTypeException();
        }
        this.authtype = authtype;
    }

    public String getNtlmdomain() {
        return this.ntlmdomain;
    }

    public void setNtlmdomain(String ntlmdomain) {
        this.ntlmdomain = ntlmdomain;
    }

    public void setLoadPaths(Array loadPaths) {
        try {
            this.loadPaths = loadPaths;
        }
        catch (ClassCastException ex) {
            throw new InvalidLoadPathsException();
        }
    }

    @Override
    public void release() {
        this.type = "component";
        this.action = "Create";
        this.className = null;
        this.name = null;
        this.context = null;
        this.server = null;
        this.locale = null;
        this.assembly = null;
        this.protocol = null;
        this.secure = false;
        this.port = 0;
        this.wsportName = null;
        this.wsversion = null;
        this.wsdl2javaArgs = null;
        this.username = null;
        this.password = null;
        this.proxyServer = null;
        this.proxyPort = null;
        this.proxyUser = null;
        this.proxyPassword = null;
        this.refreshwsdl = false;
        super.release();
        this.workstation = null;
        this.ntlmdomain = null;
        this.authtype = null;
        this.loadPaths = null;
        this.onTagEnd();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int doStartTag() throws JspException {
        int n;
        this.onTagStart();
        if (this.className.length() == 0) {
            throw new InvalidClassException();
        }
        this.validateParams();
        CFPage page = (CFPage)this.pageContext.getPage();
        try {
            HashMap<String, Object> props = new HashMap<String, Object>();
            if (this.type.equalsIgnoreCase("DOTNET") || this.type.equalsIgnoreCase(".NET")) {
                props.put("ASSEMBLY", this.assembly);
                props.put("server", this.server);
                this.port = this.port == 0 ? ServiceFactory.getDotNetService(true).getLocalDotnetPort() : this.port;
                props.put("port", "" + this.port);
                props.put("protocol", this.protocol);
                props.put("secure", this.secure);
            } else if (this.type.equalsIgnoreCase("webservice")) {
                props.put("username", this.username);
                props.put("password", this.password);
                props.put("port", this.wsportName);
                props.put("wsversion", this.wsversion);
                props.put("wsdl2javaargs", this.wsdl2javaArgs);
                props.put("refreshwsdl", this.refreshwsdl);
                props.put("proxyserver", this.proxyServer);
                props.put("proxyport", this.proxyPort);
                props.put("proxyuser", this.proxyUser);
                props.put("proxypassword", this.proxyPassword);
                props.put("authtype", this.authtype);
                props.put("ntlmdomain", this.ntlmdomain);
                props.put("workstation", this.workstation);
            } else if (this.type.equalsIgnoreCase("CORBA")) {
                props.put("context", this.context);
                props.put("protocol", this.locale);
            } else {
                if (this.type.equalsIgnoreCase("COM")) {
                    throw new ServiceFactory.FeatureIsRemovedException("COM");
                }
                if (this.type.equalsIgnoreCase("JAVA")) {
                    props.put("classpath", this.loadPaths);
                }
            }
            Object proxy = page.createObjectProxy(this.type, this.className, props);
            this.pageContext.setAttribute(this.name, proxy);
            n = 0;
        }
        catch (RuntimeException ex) {
            try {
                throw ex;
                catch (Error ex2) {
                    throw ex2;
                }
                catch (Throwable ex3) {
                    throw new RuntimeWrapper(ex3);
                }
            }
            catch (Throwable throwable) {
                List<TagAttribute> tagAttributes = this.captureAttributes(Arrays.asList("object_type", "component"), Arrays.asList(this.convertUpperCase(this.type), this.convertUpperCase(this.className)));
                this.onTagEnd(tagAttributes);
                throw throwable;
            }
        }
        List<TagAttribute> tagAttributes = this.captureAttributes(Arrays.asList("object_type", "component"), Arrays.asList(this.convertUpperCase(this.type), this.convertUpperCase(this.className)));
        this.onTagEnd(tagAttributes);
        return n;
    }

    private void validateParams() {
        if (this.authtype != null && BASIC_AUTH.equalsIgnoreCase(this.authtype) && (this.ntlmdomain != null || this.workstation != null)) {
            throw new UnsupportedAttributeException();
        }
    }

    public static class InvalidNameException
    extends ApplicationException {
    }

    public static class InvalidProtocolException
    extends ApplicationException {
        private String protocol;

        public InvalidProtocolException(String protocol) {
            this.protocol = protocol;
        }

        public String getProtocol() {
            return this.protocol;
        }
    }

    public class UnsupportedAuthenticationTypeException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class InvalidLoadPathsException
    extends ApplicationException {
    }

    public static class InvalidClassException
    extends ApplicationException {
    }

    public class UnsupportedAttributeException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class ServerMonitorNotEnabledException
    extends ApplicationException {
    }
}

