/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.lang;

import coldfusion.runtime.CFPage;
import coldfusion.runtime.ExpressionException;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.validation.CFNumberValidator;
import coldfusion.tagext.validation.CFStringValidator;
import coldfusion.tagext.validation.CFTypeValidationException;
import coldfusion.tagext.validation.CFTypeValidator;
import coldfusion.tagext.validation.CFTypeValidatorFactory;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.PageContext;

public final class ParamTag
extends GenericTag {
    private String name;
    private String type;
    private Object defaultVal;
    private String pattern = "";
    private Double min = null;
    private Double max = null;
    private CFPage page;
    private int maxlength = 0;

    @Override
    public void setPageContext(PageContext pc) {
        super.setPageContext(pc);
        this.page = (CFPage)pc.getPage();
    }

    public void setMaxlength(int maxlength) {
        this.maxlength = maxlength;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDefault(Object defaultVal) {
        this.defaultVal = defaultVal;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setMin(String min) {
        this.min = new Double(min);
    }

    public void setMax(String max) {
        this.max = new Double(max);
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        this.sanitizeData();
        Object value = CFPage._checkParam(this.name, this.defaultVal, this.page);
        if (this.type != null && !this.type.equalsIgnoreCase("any")) {
            CFTypeValidator validator;
            if (this.type.equalsIgnoreCase("regex") && this.pattern.trim().length() > 0) {
                try {
                    CFTypeValidator validator2 = CFTypeValidatorFactory.getRegExValidator(this.pattern);
                    validator2.validate(value);
                }
                catch (CFTypeValidationException ex) {
                    throw new InvalidParamTypeException(ex.getMessage() + ex.getDetail());
                }
            }
            if (this.type.equalsIgnoreCase("range") && (this.min != null || this.max != null)) {
                try {
                    CFNumberValidator validator3 = new CFNumberValidator();
                    if (this.min != null) {
                        validator3.setLowerBound(false, this.min);
                    }
                    if (this.max != null) {
                        validator3.setUpperBound(false, this.max);
                    }
                    validator3.validate(value);
                }
                catch (CFTypeValidationException ex) {
                    throw new InvalidParamTypeException(ex.getMessage() + ex.getDetail());
                }
            }
            if (this.maxlength != 0 && (this.type.equalsIgnoreCase("string") || this.type.equalsIgnoreCase("email") || this.type.equalsIgnoreCase("url"))) {
                validator = new CFStringValidator();
                ((CFStringValidator)validator).setUpperBound(this.maxlength);
                ((CFStringValidator)validator).validate(value);
            }
            if ((validator = CFTypeValidatorFactory.getExtendedValidator(this.type.trim())) == null) {
                throw new IllegalParamTypeException();
            }
            try {
                validator.validate(value);
            }
            catch (CFTypeValidationException ex) {
                throw new InvalidParamTypeException(ex.getMessage() + ex.getDetail());
            }
        }
        return 0;
    }

    @Override
    public void release() {
        this.name = null;
        this.type = null;
        this.defaultVal = null;
        this.pattern = "";
        this.min = null;
        this.max = null;
        this.onTagEnd();
    }

    private void sanitizeData() {
        if ("ssn".equalsIgnoreCase(this.type) && this.defaultVal != null) {
            this.defaultVal = ((String)this.defaultVal).trim();
        }
    }

    public class InvalidParamTypeException
    extends ExpressionException {
        public String detailMessage;

        InvalidParamTypeException(String detailMsg) {
            this.detailMessage = detailMsg;
        }
    }

    public class IllegalParamTypeException
    extends ExpressionException {
    }
}

