/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.lang;

import coldfusion.log.CFLogs;
import coldfusion.vfs.VFSFileFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ProcessExecutor {
    private String[] cmd;
    private String outFile;
    private String errFile;
    private OutputStream outStream;
    private OutputStream errorStream;
    private int timeout = -1;
    private boolean blocking = false;
    private String result;
    private String error;
    private Process process;

    public ProcessExecutor(String[] cmd, String outFile, String errFile) {
        this.cmd = cmd;
        this.outFile = outFile;
        this.errFile = errFile;
    }

    public ProcessExecutor(String[] cmd, OutputStream outStream, OutputStream errorStream) {
        this.cmd = cmd;
        this.outStream = outStream;
        this.errorStream = errorStream;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public void execute() throws IOException {
        this.process = Runtime.getRuntime().exec(this.cmd);
        OutputStream outFileOS = this.getOutputStream();
        OutputStream errorFileOS = this.errorStream;
        if (errorFileOS == null && this.errFile != null) {
            try {
                errorFileOS = new BufferedOutputStream(VFSFileFactory.getOutputStream(this.errFile));
            }
            catch (FileNotFoundException e) {
                try {
                    if (outFileOS != null) {
                        outFileOS.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new OutFileNotFoundException(this.errFile, e);
            }
        }
        ProcessReaderThread inputReaderThread = new ProcessReaderThread(this.process.getInputStream(), outFileOS);
        inputReaderThread.setName("ProcessInputReaderThread");
        inputReaderThread.start();
        ProcessReaderThread errorReaderThread = new ProcessReaderThread(this.process.getErrorStream(), errorFileOS);
        errorReaderThread.setName("ProcessErrorReaderThread");
        errorReaderThread.start();
        if (this.blocking && this.timeout == -1) {
            try {
                this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {}
        } else if (this.timeout > 0) {
            try {
                inputReaderThread.join(this.timeout);
                errorReaderThread.join(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!inputReaderThread.IsProcessDone()) {
                inputReaderThread.SetTimedOut();
            }
            if (!errorReaderThread.IsProcessDone()) {
                errorReaderThread.SetTimedOut();
            }
            if (inputReaderThread.isTimedOut() || errorReaderThread.isTimedOut()) {
                throw new ProcessTimedOutException();
            }
        }
        this.result = inputReaderThread.getData();
        this.error = errorReaderThread.getData();
    }

    private OutputStream getOutputStream() throws OutFileNotFoundException {
        if (this.outStream != null) {
            return this.outStream;
        }
        try {
            if (this.outFile != null) {
                return new BufferedOutputStream(VFSFileFactory.getOutputStream(this.outFile));
            }
        }
        catch (FileNotFoundException e) {
            throw new OutFileNotFoundException(this.outFile, e);
        }
        return null;
    }

    public String getResult() {
        return this.result;
    }

    public String getError() {
        return this.error;
    }

    public void terminate() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public static class OutFileNotFoundException
    extends IOException {
        private String file;

        public OutFileNotFoundException(String file, Throwable throwable) {
            super(throwable);
            this.file = file;
        }

        public String getFile() {
            return this.file;
        }
    }

    private class ProcessReaderThread
    extends Thread {
        private InputStream stream;
        private static final int BUFFER_SIZE = 4096;
        private boolean timedOut = false;
        private boolean processDone = false;
        private OutputStream outStream = null;
        private String data;

        ProcessReaderThread(InputStream stream, OutputStream outStream) {
            this.stream = stream;
            this.outStream = outStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedOutputStream out;
            ByteArrayOutputStream baos = null;
            if (this.outStream == null) {
                baos = new ByteArrayOutputStream();
                out = new BufferedOutputStream(baos);
            } else {
                out = new BufferedOutputStream(this.outStream);
            }
            BufferedInputStream in = new BufferedInputStream(this.stream);
            try {
                int num;
                byte[] buffer = new byte[4096];
                while ((num = in.read(buffer, 0, 4096)) != -1) {
                    out.write(buffer, 0, num);
                }
                out.flush();
            }
            catch (IOException e) {
                CFLogs.APPLICATION_LOG.error(e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    CFLogs.APPLICATION_LOG.error(e);
                }
                try {
                    out.close();
                }
                catch (IOException e) {
                    CFLogs.APPLICATION_LOG.error(e);
                }
            }
            if (baos != null) {
                this.data = baos.toString();
            }
            this.processDone = true;
        }

        public String getData() {
            return this.data;
        }

        public boolean IsProcessDone() {
            return this.processDone;
        }

        public void SetTimedOut() {
            this.timedOut = true;
        }

        public boolean isTimedOut() {
            return this.timedOut;
        }
    }

    public static class ProcessTimedOutException
    extends IOException {
    }
}

