/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.lang;

import coldfusion.sql.QueryTable;
import coldfusion.tagext.lang.RegMetaData;
import coldfusion.tagext.lang.RegNode;
import java.util.Map;
import java.util.TreeMap;

class RegTable
extends QueryTable {
    public void populate(Map m) {
        this.meta = new RegMetaData();
        this.col_count = this.meta.getColumnCount();
        this.col_names = this.meta.getColumnLabels();
        if (m == null) {
            this.row_count = 0;
            return;
        }
        this.ensureCapacity(m.size());
        for (Map.Entry entry : m.entrySet()) {
            String key = (String)entry.getKey();
            Object mval = entry.getValue();
            Object val = ((Map.Entry)mval).getValue();
            Object[] col_data = new Object[3];
            if (val instanceof RegNode) {
                col_data[1] = "KEY";
                col_data[2] = "";
            } else if (val instanceof RegNode.Pair) {
                RegNode.Pair p = (RegNode.Pair)val;
                col_data[1] = p.getType().equalsIgnoreCase("REG_DWORD") ? "DWORD" : "STRING";
                col_data[2] = p.getValue();
            }
            col_data[0] = key;
            this.addRow(col_data);
        }
    }

    public Map filter(Map m, String filter) {
        TreeMap nm = new TreeMap();
        for (Map.Entry entry : m.entrySet()) {
            Object val = entry.getValue();
            if (val instanceof RegNode.Pair) {
                RegNode.Pair p = (RegNode.Pair)val;
                if (filter.equalsIgnoreCase("string") && p.getType().equalsIgnoreCase("REG_SZ") || filter.equalsIgnoreCase("any")) {
                    nm.put(entry.getKey(), entry);
                    continue;
                }
                if ((!filter.equalsIgnoreCase("dword") || !p.getType().equalsIgnoreCase("REG_DWORD")) && !filter.equalsIgnoreCase("any")) continue;
                nm.put(entry.getKey(), entry);
                continue;
            }
            if (!(val instanceof RegNode) || !filter.equalsIgnoreCase("key") && !filter.equalsIgnoreCase("any")) continue;
            nm.put(entry.getKey(), entry);
        }
        return nm;
    }
}

